var jqGridJsonReader = {
	root: "data",
	records: "totalSize",
	page: "page",
	total: "total",
    repeatitems: false
};
var jqGridParams = {
	mtype:'post',
	datatype:'json',
	autowidth:true,
	height:'auto',
	viewrecords: true, 
	multiselect:true,
	multiboxonly:true,
	sortorder:'desc',
    rowNum:10, 
	rowList:[5,10,15,20],
	toolbar:[true,"top"],
	hidegrid:false
};
var navGridParams = {
	edit:false,add:false,del:false,search:false
};
var jqGridTopStyles = {
	"padding-top": "5px",
	"padding-bottom": "10px",
	"border-top": "none",
	"background": "#eee",
	"text-align": "left"
};
function afficheActFormatter(cell,opt,data){
	return $('#afficheActFormatterDiv').html();
}
function checkBeforeDeleteGrid(grid, deleteMethod) {
	

	
	var rowIds = $(grid).getGridParam('selarrrow');
	if(rowIds=='')
	{
		$.messager.alert(i18n['msg_msg'],'<br/>'+i18n['msg_atLeastChooseOneData'],'info');
	}
	else
	{
		$.messager.confirm(i18n['msg_msg'],'<br/>'+i18n['msg_confirmDelete'],function(r){
			if(r){
				deleteMethod(rowIds);
			}
		});
	}
}

function checkBeforeEditGrid(grid, editMethod) {
	var rowId = $(grid).getGridParam('selrow');
	if(rowId==null)
	{
		$.messager.alert(i18n['msg_msg'],'<br/>'+i18n['msg_atLeastChooseOneData'],'info');
	}
	else
	{
		var rowData=$(grid).getRowData(rowId);
		//open edit window
		editMethod(rowData);
	}
}


/**
 * @description  自适应大小
 */
function setGridWidth(grid,panelId,fitchSize){

		var wid=document.getElementById(panelId).style.width;
		var wid=wid.substring(0,wid.length-2);
		$(grid).setGridWidth(wid-fitchSize); 

}

/**
 * @description  行内删除
 */
function checkBeforeDeleteGridInLine(grid,deleteMethod){
	
	var rowId = $(grid).getGridParam('selrow');
	

	$.messager.confirm(i18n['msg_msg'],'<br/>'+i18n['msg_confirmDelete'],function(r){
		if(r){
			
			deleteMethod(rowId);
		}
	});

}

function confirmBeforeDelete(method){
	
	$.messager.confirm(i18n['msg_msg'],'<br/>'+i18n['msg_confirmDelete'],function(r){
		if(r){
			
			method();
		}
	});
}



/**
 * @description  搜索方法
 */
function searchGridWithForm(grid,form,submitUrl){
	
	var sdata = $(form+' form').getForm();
	var postData = $(grid).jqGrid("getGridParam", "postData");       
	$.extend(postData, sdata);
	$(grid).jqGrid('setGridParam',{url:submitUrl}).trigger('reloadGrid');
	
	
}


/**
 * @description  提交form方法
 */
function submitFormCommon(divId,url,method){
	
	 var frm = $(divId+' form').serialize();
	 $.post(url,frm, function(r){
		 method(r);
	 });
}


this.timeFormatter=function(cell,opt,data){
	if(cell!=null){
		return cell.replace("T"," ").replace('.0','')
;
	}else{
		return '';
	}
}

/**
 * @description  验证用户是否存在
 */
this.checkUserByName=function(userName,func){
	
	var url='user!findByUserName.action';
	var param='userName='+userName;
	
	$.post(url,param, function(res){

		if(res!=null){
			func(res.userId);
		}else{
			msgAlert(i18n['msg_msg_userNotExist'],'error');
		}
	});
}

/**
 * @description  验证表单
 */
this.vaildateForm=function(formId,method){

	
	 if($(formId).form('validate')){ 
		 method();
	 }
}



/**
 * @description 选择请求分类.
 */
this.commonSelectRequestCategory=function(func){
	$('#commonSelectRequestCategory').window('open');
	selectRequestCategoryTreeView(func);
}

/**
 * @description 请求分类树加载.
 */
this.selectRequestCategoryTreeView=function(func){
	
	$("#commonSelectRequestCategoryTree").jstree({
		json_data: {
			
			ajax: {
				type:"post",
				url : "event!getCategoryTree.action",
				dataType: 'json',
				data: {'types': 'Request'}
			}
		},
		plugins : ["themes", "json_data", "ui", "crrm"]
	})
	.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
	.bind('select_node.jstree',func);
}

this.importCSV=function(p_url,callback){
	
	$.ajaxFileUpload({
        url:p_url,
        secureuri:false,
        fileElementId:'importFile', 
        dataType:'json',
        success: function(data,status){
			callback();
        }
  });
	
}

this.readyImportCSV=function(callback){
	$('#index_import_excel_window').window('open');
	$("#index_import_confirm").unbind(); //清空事件      				
	$('#index_import_confirm').click(callback);
}
