#include "stdafx.h"
#include "namepipe.h"

DWORD WINAPI FUNCreatePipes(LPVOID lpParameter)
{
	BOOL   fConnected = FALSE; 
	LPTSTR lpszPipename = _T("\\\\.\\pipe\\MyPipe"); 

	HANDLE hPipeServer;
	HANDLE hThreadListenPipes;        
	while(TRUE)
	{                
		hPipeServer = CreateNamedPipe( 
			lpszPipename,             // pipe name 
			PIPE_ACCESS_DUPLEX,       // read/write access 
			PIPE_TYPE_MESSAGE |       // message type pipe 
			PIPE_READMODE_MESSAGE |   // message-read mode 
			PIPE_WAIT,                // blocking mode 
			PIPE_UNLIMITED_INSTANCES, // max. instances  
			BUFSIZ,                   // output buffer size 
			BUFSIZ,                   // input buffer size 
			0,                        // client time-out 
			NULL);                    // default security attribute 

		if (hPipeServer == INVALID_HANDLE_VALUE) 
		{
			return -1;
		}

		// Wait for the client to connect; if it succeeds, 
		// the function returns a nonzero value. If the function
		// returns zero, GetLastError returns ERROR_PIPE_CONNECTED.         
		fConnected = ConnectNamedPipe(hPipeServer, NULL);
		if (fConnected) 
		{
			// Create listen pipes thread. 
			hThreadListenPipes = CreateThread( 
				NULL,              // no security attribute 
				0,                 // default stack size 
				FunListenPipes,    // thread proc
				hPipeServer,       // thread parameter 
				0,                 // not suspended 
				NULL);             // returns thread ID 

			// Close handle.
			CloseHandle(hThreadListenPipes); 
			// Set handle null.
			hThreadListenPipes = NULL;
		}
		else 
		{
			// Close handle.
			CloseHandle(hPipeServer); 
			// Set handle null.
			hPipeServer = NULL;
		}
	}
	return 0;
}


DWORD WINAPI FunListenPipes(LPVOID lpParameter)
{
	HANDLE hPipe = (HANDLE)lpParameter;

	HANDLE hHeap      = GetProcessHeap();
	TCHAR* pchRequest = (TCHAR*)HeapAlloc(hHeap, 0, BUFSIZ*sizeof(TCHAR));
	TCHAR* pchReply   = (TCHAR*)HeapAlloc(hHeap, 0, BUFSIZ*sizeof(TCHAR));

	DWORD cbBytesRead = 0, cbReplyBytes = 0, cbWritten = 0; 
	BOOL fSuccess = FALSE;

	CString strRequest = _T("");
	CString strReply = _T("");
	while (TRUE) 
	{                   
		fSuccess = ReadFile( 
			hPipe,                                // handle to pipe 
			pchRequest,                           // buffer to receive data 
			BUFSIZ*sizeof(TCHAR),                 // size of buffer 
			&cbBytesRead,                         // number of bytes read 
			NULL);                                // not overlapped I/O 

		if (!fSuccess || cbBytesRead == 0)
		{   
			break;
		}

		// Process the incoming message.
		GetAnswerToRequest(pchRequest, pchReply, &cbReplyBytes); 

		/*
		// Write the reply to the pipe. 
		fSuccess = WriteFile( 
		hPipe,        // handle to pipe 
		pchReply,     // buffer to write from 
		cbReplyBytes, // number of bytes to write 
		&cbWritten,   // number of bytes written 
		NULL);        // not overlapped I/O 

		if (!fSuccess || cbReplyBytes != cbWritten)
		{ 
		break;
		}
		*/
		strRequest = pchRequest;
		strReply = pchReply;
	}

	// Flush the pipe to allow the client to read the pipe's contents 
	// before disconnecting. Then disconnect the pipe, and close the 
	// handle to this pipe instance. 
	FlushFileBuffers(hPipe); 
	DisconnectNamedPipe(hPipe); 
	CloseHandle(hPipe); 
	hPipe = NULL;

	HeapFree(hHeap, 0, pchRequest);
	HeapFree(hHeap, 0, pchReply);

	return 1;
}


extern GuaJiCallBack guajicallback;
extern BonusCallBack bonuscallback;

VOID GetAnswerToRequest( LPTSTR pchRequest, LPTSTR pchReply, LPDWORD pchBytes )
{
	if((unsigned char)pchRequest[0] == S_SENDGUAJIFLAG)
	{
		guajicallback(pchRequest[1]);
	}
	if((unsigned char)pchRequest[0] == S_SENDBONUSSTATUS)
	{
		bonuscallback(pchRequest[1]);
	}
	// Check the outgoing message to make sure it's not too long for the buffer.
	/*	if (FAILED(strcpy(pchReply, pchRequest)))
	{
	*pchBytes = 0;
	pchReply[0] = 0;
	return;
	}
	*pchBytes = (lstrlen(pchReply)+1)*sizeof(TCHAR);
	*/
}