/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.prefs;

import com.sun.javaws.Resources;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.security.CertificatePanel;
import com.sun.javaws.ui.general.Subcontroller;
import com.sun.javaws.ui.prefs.AdvancedPanel;
import com.sun.javaws.ui.prefs.GeneralPanel;
import com.sun.javaws.ui.prefs.InstallPanel;
import com.sun.javaws.ui.prefs.JREPanel;
import com.sun.javaws.ui.prefs.SubcontrollerCreator;

public class WinSubcontrollerCreator
extends SubcontrollerCreator {
    private Subcontroller[] _controllers = new Subcontroller[5];

    public int getSubcontrollerCount() {
        return this._controllers.length;
    }

    public WinSubcontrollerCreator() {
        int n = this._controllers.length - 1;
        while (n >= 0) {
            this._controllers[n] = null;
            --n;
        }
    }

    public Subcontroller getSubcontroller(boolean bl, int n) {
        if (n < 0 || n >= this._controllers.length) {
            Debug.fatal("Invalid Subcontroller index: " + n);
        }
        if (this._controllers[n] == null && bl) {
            switch (n) {
                case 0: {
                    this._controllers[0] = new GeneralPanel();
                    break;
                }
                case 1: {
                    this._controllers[1] = new InstallPanel();
                    break;
                }
                case 2: {
                    this._controllers[2] = new JREPanel();
                    break;
                }
                case 3: {
                    this._controllers[3] = new AdvancedPanel();
                    break;
                }
                case 4: {
                    this._controllers[4] = new CertificatePanel();
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid index!");
                }
            }
        }
        return this._controllers[n];
    }

    public String getSubcontrollerTitle(int n) {
        if (n < 0 || n >= this._controllers.length) {
            Debug.fatal("Invalid Subcontroller index: " + n);
        }
        switch (n) {
            case 0: {
                return Resources.getString("controlpanel.general.tabTitle");
            }
            case 1: {
                return Resources.getString("controlpanel.install.tabTitle");
            }
            case 2: {
                return Resources.getString("controlpanel.jre.tabTitle");
            }
            case 3: {
                return Resources.getString("controlpanel.advanced.tabTitle");
            }
            case 4: {
                return Resources.getString("controlpanel.certs.tabTitle");
            }
        }
        return null;
    }
}

