/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.faceless.pdf2.Form;
import org.faceless.pdf2.FormCheckbox;
import org.faceless.pdf2.FormChoice;
import org.faceless.pdf2.FormElement;
import org.faceless.pdf2.FormRadioButton;
import org.faceless.pdf2.FormSignature;
import org.faceless.pdf2.FormText;
import org.faceless.pdf2.OutputProfile;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFCanvas;
import org.faceless.pdf2.PDFImage;
import org.faceless.pdf2.PDFImageSet;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.PDFParser;
import org.faceless.pdf2.PDFReader;
import org.faceless.pdf2.PKCS7SignatureHandler;
import org.xml.sax.SAXException;

public class PDFTool {
    private static final String VERSION = "$Revision: 1.8 $";

    public static void main(String[] args) throws Exception {
        PDFTool.setLicense();
        PDF pdf = null;
        OutputStream out = System.out;
        OutputProfile profile = null;
        ListIterator<String> i = Arrays.asList(args).listIterator();
        while (i.hasNext()) {
            String cmd = i.next();
            if (cmd.equals("--join")) {
                pdf = PDFTool.join(i, pdf);
                continue;
            }
            if (cmd.startsWith("--output=")) {
                out = new FileOutputStream(cmd.substring(9));
                continue;
            }
            if (cmd.equals("--profile=nocompression")) {
                profile = OutputProfile.NoCompression;
                continue;
            }
            if (cmd.equals("--profile=acrobat4")) {
                profile = OutputProfile.Acrobat4Compatible;
                continue;
            }
            if (cmd.equals("--profile=acrobat5")) {
                profile = OutputProfile.Acrobat5Compatible;
                continue;
            }
            if (cmd.equals("--profile=acrobat6")) {
                profile = OutputProfile.Acrobat6Compatible;
                continue;
            }
            if (cmd.equals("--profile=acrobat7")) {
                profile = OutputProfile.Acrobat7Compatible;
                continue;
            }
            if (cmd.equals("--form")) {
                pdf = PDFTool.form(i, pdf);
                continue;
            }
            if (cmd.equals("--sign")) {
                pdf = PDFTool.sign(i, pdf);
                continue;
            }
            if (cmd.equals("--help")) {
                PDFTool.help();
                System.exit(0);
                continue;
            }
            if (cmd.equals("--toimage")) {
                PDFTool.toimage(i, pdf, out);
                pdf = null;
                continue;
            }
            if (!cmd.startsWith("--")) {
                pdf = new PDF(new PDFReader((InputStream)new FileInputStream(cmd)));
                continue;
            }
            System.err.println("Unknown argument \"" + cmd + "\"");
            System.err.println("  Run pdftool --help for options");
            System.exit(1);
        }
        if (args.length == 0) {
            PDFTool.usage();
        } else if (pdf != null) {
            if (profile != null) {
                pdf.setOutputProfile(profile);
            }
            pdf.render(out);
            ((OutputStream)out).close();
        }
    }

    private static final String getValue(String in) {
        return in.substring(in.indexOf("=") + 1);
    }

    protected static void setLicense() {
    }

    static PDF join(ListIterator i, PDF pdf) throws IOException {
        int dpi = 0;
        boolean flatten = true;
        String pages = null;
        String pagesize = null;
        if (pdf == null) {
            pdf = new PDF();
        }
        List outpages = pdf.getPages();
        while (i.hasNext()) {
            String opt = (String)i.next();
            if (opt.startsWith("--dpi=")) {
                dpi = Integer.parseInt(PDFTool.getValue(opt));
                if (dpi >= 0 && dpi <= 600) continue;
                throw new IllegalArgumentException("DPI must be betweeen 0 and 600");
            }
            if (opt.startsWith("--pages=")) {
                pages = PDFTool.getValue(opt);
                continue;
            }
            if (opt.startsWith("--pagesize=")) {
                pagesize = PDFTool.getValue(opt);
                if (!pagesize.equals("auto")) continue;
                pagesize = null;
                continue;
            }
            if (opt.startsWith("--")) {
                i.previous();
                return pdf;
            }
            try {
                FileInputStream in = new FileInputStream(opt);
                PDF pdf2 = new PDF(new PDFReader((InputStream)in));
                ((InputStream)in).close();
                if (flatten) {
                    pdf2.getForm().flatten();
                }
                PDFPage outpage = pagesize == null ? null : new PDFPage(pagesize);
                List inpages = pdf2.getPages();
                int[] pagelist = PDFTool.parsePages(pages, inpages.size());
                int j = 0;
                while (j < pagelist.length) {
                    PDFPage inpage = (PDFPage)inpages.get(pagelist[j]);
                    PDFPage pDFPage = outpage = pagesize == null ? null : new PDFPage(pagesize);
                    if (outpage != null && (inpage.getWidth() != outpage.getWidth() || inpage.getHeight() != outpage.getHeight())) {
                        PDFCanvas can = new PDFCanvas(inpage);
                        outpage.drawCanvas(can, 0.0f, 0.0f, (float)outpage.getWidth(), (float)outpage.getHeight());
                        outpages.add(outpage);
                        outpage = new PDFPage(pagesize);
                    } else {
                        outpages.add(inpage);
                    }
                    ++j;
                }
            }
            catch (IOException e1) {
                try {
                    FileInputStream in = new FileInputStream(opt);
                    PDFImageSet images = new PDFImageSet((InputStream)in);
                    ((InputStream)in).close();
                    int[] pagelist = PDFTool.parsePages(pages, images.getNumImages());
                    int j = 0;
                    while (j < pagelist.length) {
                        PDFPage page;
                        PDFImage image = images.getImage(pagelist[j]);
                        if (pagesize != null) {
                            page = new PDFPage(pagesize);
                        } else {
                            double iw = dpi == 0 ? (double)image.getWidth() : (double)image.getWidth() * image.getDPIX() / (double)dpi;
                            double ih = dpi == 0 ? (double)image.getHeight() : (double)image.getHeight() * image.getDPIY() / (double)dpi;
                            page = new PDFPage((int)iw, (int)ih);
                        }
                        page.drawImage(image, 0.0f, 0.0f, (float)page.getWidth(), (float)page.getHeight());
                        outpages.add(page);
                        ++j;
                    }
                }
                catch (IOException e2) {
                    throw e1;
                }
            }
            pages = null;
        }
        return pdf;
    }

    private static int[] parsePages(String pages, int num) {
        int[] out;
        if (pages == null || pages.equals("all")) {
            out = new int[num];
            int i = 0;
            while (i < out.length) {
                out[i] = i;
                ++i;
            }
        } else if (pages.equals("reverse")) {
            out = new int[num];
            int i = 0;
            while (i < out.length) {
                out[i] = num - i - 1;
                ++i;
            }
        } else {
            if (pages.charAt(0) == '-') {
                pages = "1" + pages;
            }
            if (pages.charAt(pages.length() - 1) == '-') {
                pages = String.valueOf(pages) + (num + 1);
            }
            ArrayList<Integer> t = new ArrayList<Integer>();
            StringTokenizer st = new StringTokenizer(pages, ",");
            while (st.hasMoreTokens()) {
                int i;
                int end;
                String s1 = st.nextToken();
                int k = s1.indexOf(45);
                if (k < 0) {
                    t.add(new Integer(PDFTool.getPage(s1, num) - 1));
                    continue;
                }
                int start = PDFTool.getPage(s1.substring(0, k), num);
                if (start < (end = PDFTool.getPage(s1.substring(k + 1), num))) {
                    i = start;
                    while (i <= end) {
                        t.add(new Integer(i - 1));
                        ++i;
                    }
                    continue;
                }
                i = end;
                while (i >= start) {
                    t.add(new Integer(i - 1));
                    --i;
                }
            }
            out = new int[t.size()];
            int i = 0;
            while (i < out.length) {
                out[i] = (Integer)t.get(i);
                ++i;
            }
        }
        return out;
    }

    private static int getPage(String val, int num) {
        if (val.equals("end")) {
            return num;
        }
        try {
            int i = Integer.parseInt(val);
            if (i < 1 || i > num) {
                throw new IllegalArgumentException("Page " + i + " outside range 1-" + num);
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid page '" + val + "'");
        }
    }

    private static PDF form(ListIterator i, PDF pdf) throws IOException, SAXException {
        HashMap<String, String> fields = new HashMap<String, String>();
        boolean flatten = false;
        String xfa = null;
        while (i.hasNext()) {
            String filename;
            String opt = (String)i.next();
            if (opt.startsWith("--properties=")) {
                filename = PDFTool.getValue(opt);
                Properties p = new Properties();
                p.load(new FileInputStream(filename));
                Enumeration<?> e = p.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = p.getProperty(key);
                    fields.put(key, value);
                }
                continue;
            }
            if (opt.startsWith("--xfa=")) {
                int c;
                filename = PDFTool.getValue(opt);
                InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8");
                StringWriter w = new StringWriter();
                while ((c = ((Reader)in).read()) >= 0) {
                    w.write(c);
                }
                xfa = w.toString();
                continue;
            }
            if (opt.startsWith("--field=")) {
                String val = PDFTool.getValue(opt);
                int x = val.indexOf(61);
                if (x < 0) {
                    throw new IllegalArgumentException("\"" + opt + "\" is invalid");
                }
                fields.put(val.substring(0, x), val.substring(x + 1));
                continue;
            }
            if (opt.equals("--flatten") || opt.equals("--flatten=true")) {
                flatten = true;
                continue;
            }
            if (opt.equals("--flatten=false")) {
                flatten = false;
                continue;
            }
            if (opt.startsWith("--")) {
                i.previous();
                break;
            }
            pdf = new PDF(new PDFReader((InputStream)new FileInputStream(opt)));
        }
        if (pdf != null) {
            Form form = pdf.getForm();
            if (xfa != null) {
                form.setXFADatasets(xfa);
            } else {
                Iterator j = fields.entrySet().iterator();
                while (j.hasNext()) {
                    Map.Entry e = j.next();
                    String key = (String)e.getKey();
                    String val = (String)e.getValue();
                    FormElement elt = form.getElement(key);
                    if (elt == null) {
                        System.err.println("Unknown field: \"" + key + "\"");
                        continue;
                    }
                    if (elt instanceof FormText) {
                        ((FormText)elt).setValue(val);
                        continue;
                    }
                    if (elt instanceof FormRadioButton) {
                        ((FormRadioButton)elt).setValue(val);
                        continue;
                    }
                    if (elt instanceof FormCheckbox) {
                        ((FormCheckbox)elt).setValue(val);
                        continue;
                    }
                    if (elt instanceof FormChoice) {
                        ((FormChoice)elt).setValue(val);
                        continue;
                    }
                    System.err.println("Unable to set " + elt.getClass() + " element");
                }
                fields.clear();
            }
            if (flatten) {
                form.flatten();
            }
        }
        return pdf;
    }

    private static PDF sign(ListIterator i, PDF pdf) throws IOException, GeneralSecurityException {
        String keypassword = null;
        String password = null;
        String reason = null;
        String location = null;
        String alias = null;
        String keystorefile = null;
        String field = null;
        String name = null;
        String keystoretype = "JKS";
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        int page = 0;
        while (i.hasNext()) {
            String opt = (String)i.next();
            if (opt.startsWith("--keypassword=")) {
                keypassword = PDFTool.getValue(opt);
                continue;
            }
            if (opt.startsWith("--password=")) {
                password = PDFTool.getValue(opt);
                continue;
            }
            if (opt.startsWith("--reason=")) {
                reason = PDFTool.getValue(opt);
                continue;
            }
            if (opt.startsWith("--location=")) {
                location = PDFTool.getValue(opt);
                continue;
            }
            if (opt.startsWith("--alias=")) {
                alias = PDFTool.getValue(opt);
                continue;
            }
            if (opt.startsWith("--name=")) {
                name = PDFTool.getValue(opt);
                continue;
            }
            if (opt.startsWith("--keystore=")) {
                keystorefile = PDFTool.getValue(opt);
                continue;
            }
            if (opt.startsWith("--keystoretype=")) {
                keystoretype = PDFTool.getValue(opt);
                continue;
            }
            if (opt.startsWith("--field=")) {
                field = PDFTool.getValue(opt);
                continue;
            }
            if (opt.startsWith("--left=")) {
                left = Integer.parseInt(PDFTool.getValue(opt));
                continue;
            }
            if (opt.startsWith("--top=")) {
                top = Integer.parseInt(PDFTool.getValue(opt));
                continue;
            }
            if (opt.startsWith("--right=")) {
                right = Integer.parseInt(PDFTool.getValue(opt));
                continue;
            }
            if (opt.startsWith("--bottom=")) {
                bottom = Integer.parseInt(PDFTool.getValue(opt));
                continue;
            }
            if (opt.startsWith("--page=")) {
                page = Integer.parseInt(PDFTool.getValue(opt)) - 1;
                continue;
            }
            if (opt.startsWith("--")) {
                i.previous();
                break;
            }
            pdf = new PDF(new PDFReader((InputStream)new FileInputStream(opt)));
        }
        if (pdf != null) {
            Form form = pdf.getForm();
            FormSignature sig = null;
            if (field != null) {
                sig = (FormSignature)form.getElement(field);
            }
            if (sig == null) {
                if (field == null) {
                    field = "Signature";
                }
                sig = new FormSignature();
                if (left != right && top != bottom) {
                    sig.addAnnotation(pdf.getPage(page), (float)left, (float)top, (float)right, (float)bottom);
                }
                pdf.getForm().addElement(field, (FormElement)sig);
            }
            if (keypassword == null) {
                keypassword = password;
            }
            KeyStore keystore = KeyStore.getInstance(keystoretype);
            keystore.load(new FileInputStream(keystorefile), password.toCharArray());
            sig.sign(keystore, alias, keypassword.toCharArray(), FormSignature.HANDLER_ACROBATSIX);
            sig.setReason(reason);
            sig.setLocation(location);
            if (name == null) {
                PKCS7SignatureHandler pkcs7 = (PKCS7SignatureHandler)sig.getSignatureHandler();
                name = FormSignature.getSubjectField((X509Certificate)pkcs7.getCertificates()[0], (String)"CN");
            }
            sig.setName(name);
        }
        return pdf;
    }

    private static void toimage(ListIterator i, PDF pdf, OutputStream out) throws IOException {
        ColorModel cm = PDFParser.BLACKANDWHITE;
        int dpi = 200;
        String pages = null;
        String format = "tiff";
        while (i.hasNext()) {
            String opt = (String)i.next();
            if (opt.startsWith("--dpi=")) {
                dpi = Integer.parseInt(PDFTool.getValue(opt));
                if (dpi > 0 && dpi <= 600) continue;
                throw new IllegalArgumentException("DPI must be betweeen 1 and 600");
            }
            if (opt.equals("--model=bw")) {
                cm = PDFParser.BLACKANDWHITE;
                continue;
            }
            if (opt.equals("--model=rgb")) {
                cm = PDFParser.RGB;
                continue;
            }
            if (opt.equals("--model=rgba")) {
                cm = PDFParser.RGBA;
                continue;
            }
            if (opt.equals("--model=cmyk")) {
                cm = PDFParser.CMYK;
                continue;
            }
            if (opt.equals("--model=gray")) {
                cm = PDFParser.GRAYSCALE;
                continue;
            }
            if (opt.equals("--format=tiff")) {
                format = "tiff";
                continue;
            }
            if (opt.equals("--format=png")) {
                format = "PNG";
                continue;
            }
            if (opt.equals("--format=jpeg")) {
                format = "JPEG";
                continue;
            }
            if (opt.startsWith("--pages=")) {
                pages = PDFTool.getValue(opt);
                continue;
            }
            if (opt.startsWith("--output=")) {
                out = new FileOutputStream(PDFTool.getValue(opt));
                continue;
            }
            if (opt.startsWith("--")) {
                i.previous();
                return;
            }
            pdf = new PDF(new PDFReader((InputStream)new FileInputStream(opt)));
        }
        if (pdf != null) {
            PDFParser parser = new PDFParser(pdf);
            if (format == "tiff") {
                parser.writeAsTIFF(out, dpi, cm);
            } else {
                BufferedImage image = parser.getPagePainter(0).getImage((float)dpi, cm);
                ImageIO.write((RenderedImage)image, format, out);
            }
            out.close();
        }
    }

    private static void usage() {
        Package p = Package.getPackage("org.faceless.pdf2");
        String PDFVERSION = p == null ? VERSION : "$Revision: 1.8 $ (library " + p.getImplementationVersion() + ")";
        System.err.println("pdftool " + PDFVERSION);
        System.err.println("  Run pdftool --help for more information");
        System.err.println();
    }

    private static void help() {
        System.out.println("Usage: pdftool [ --output=<outfile> | <infile> | <command> ] *");
        System.out.println("  This program runs a pipeline of one or more operations on a PDF. The");
        System.out.println("  initial PDF can be loaded (<infile> in the argument list above) and");
        System.out.println("  operations performed on it, after which it is written to standard out or");
        System.out.println("  <outfile> if it's specified.");
        System.out.println();
        System.out.println("  General arguments are:");
        System.out.println("     --output=<outfile>");
        System.out.println("       Set the file to write to. If not specified the default is standard out");
        System.out.println();
        System.out.println("     --profile=<profile>");
        System.out.println("       Set the output profile to use when rendering the PDF. Valid values are");
        System.out.println("       'nocompression', 'acrobat4', 'acrobat5', 'acrobat6' or 'acrobat7'");
        System.out.println();
        System.out.println("     <infile>");
        System.out.println("       The PDF to work on. Must be specified somewhere in the parameter list");
        System.out.println("       unless the <filename> parameter is used with the join command.");
        System.out.println();
        System.out.println("  Command sequences can be one of the following:");
        System.out.println();
        System.out.println("     --join [ [--pages=<list>] [--pagesize=<size>] [--dpi=<dpi>] <filename> ] *");
        System.out.println();
        System.out.println("       To concatenate a sequence of PDFs: Arguments are:");
        System.out.println();
        System.out.println("         --pagesize=<size>");
        System.out.println("           Set the size of the output pages. Valid values include A4, letter");
        System.out.println("           a4-landscape, 8.5x11in, 210x297mm and so on. The pagesize values is");
        System.out.println("           kept across input documents");
        System.out.println();
        System.out.println("         --dpi=<dpi>");
        System.out.println("           For input files that are bitmap images, this is an alternative way");
        System.out.println("           to set the output page size - by setting the DPI of the input");
        System.out.println("           image. Value values are 1 to 600 (or 0 to use the default)");
        System.out.println();
        System.out.println("         --pages=<list>");
        System.out.println("           Set which pages from the next input file to use. List may be the");
        System.out.println("           value 'all' for all pages, 'reverse' to reverse the list or a");
        System.out.println("           comma-seperated list of values, eg '1,2-5'. The value 'end' means");
        System.out.println("           the last page, and sequences may be backwards - eg. 'reverse' is");
        System.out.println("           equivalent to 'end-1'.");
        System.out.println();
        System.out.println("         <filename>");
        System.out.println("           The file to join to the existing PDF. May be a PDF, TIFF, JPEG, GIF");
        System.out.println("           PNG or PNM file");
        System.out.println();
        System.out.println("    --form [--flatten] [--xfa=<xfafile>]");
        System.out.println("             [ [--properties=<propfile>] [--field=key=value] ] *");
        System.out.println();
        System.out.println("       To complete a PDF form: Arguments are:");
        System.out.println();
        System.out.println("         --properties=<propfile>");
        System.out.println("           Load the field values from the specified properties file. The keys");
        System.out.println("           in the file are the field names, the values the value to use");
        System.out.println();
        System.out.println("         --field=<key>=<value>");
        System.out.println("           Set the specified field to the specified value.");
        System.out.println();
        System.out.println("         --xfa=<xfafile>");
        System.out.println("           For a document containing an XFA form, set the form using the");
        System.out.println("           \"datasets\" object from the specified file. If this parameter is");
        System.out.println("           used any \"fields\" or \"properties\" parameters will be ignored.");
        System.out.println();
        System.out.println("         --flatten");
        System.out.println("           Flatten the form after completion");
        System.out.println("");
        System.out.println("    --sign --keystore=<keystore> --alias=<alias> --password=<password>");
        System.out.println("             [--keypassword=<keypassword>] [--keystoretype=<keystoretype>]");
        System.out.println("             [--location=<location>] [--name=<name>] [--reason=<reason>]");
        System.out.println("             [--bottom=<bottom>] [--left=<left>] [--right=<right>] [--top=<top>]");
        System.out.println("             [--page=<page>] [--field=<field>");
        System.out.println();
        System.out.println("       Digitally sign a PDF file: Arguments are:");
        System.out.println();
        System.out.println("         --keystore=<keystore>");
        System.out.println("           The filename to load the keystore from. Must be specified.");
        System.out.println();
        System.out.println("         --alias=<alias>");
        System.out.println("           The alias to use from the keystore. Must be specified.");
        System.out.println();
        System.out.println("         --password=<password>");
        System.out.println("           The password to unlock the keystore. Must be specified.");
        System.out.println();
        System.out.println("         --keystoretype=<keystoretype>");
        System.out.println("           The type of keystore. The default is 'JKS', 'pkcs7' is also common");
        System.out.println();
        System.out.println("         --reason=<reason>");
        System.out.println("           The reason for signing");
        System.out.println();
        System.out.println("         --location=<location>");
        System.out.println("           The location the document is signed at");
        System.out.println();
        System.out.println("         --name=<name>");
        System.out.println("           The name of the person who is signing the document");
        System.out.println();
        System.out.println("         --field=<field>");
        System.out.println("           The name of the signature field. If it doesn't already exist in");
        System.out.println("           the PDF a new field is created with this name");
        System.out.println();
        System.out.println("         --page=<page>");
        System.out.println("           The page number to put the signature appearance on, if required.");
        System.out.println();
        System.out.println("         --left, top, right, bottom");
        System.out.println("           The location on the page to add the new field. The default is not");
        System.out.println("           to create a visible appearance for the signature");
        System.out.println();
        System.out.println("    --toimage [--format=<format>} [--model=<model>] [--dpi=<dpi>]");
        System.out.println();
        System.out.println("       To convert a PDF to a bitmap image - this must be the last command in");
        System.out.println("       the sequence (once a PDF is a TIFF there's nothing more you can do with");
        System.out.println("       it). Arguments are:");
        System.out.println();
        System.out.println("         --format=<format>");
        System.out.println("           Set the output file format. Values are 'tiff', 'png', 'jpeg'. The");
        System.out.println("           default is 'tiff', which will produce a multi-page document. 'png'");
        System.out.println("           and 'jpeg' will result in a single page document only");
        System.out.println();
        System.out.println("         --model=<model>");
        System.out.println("           Set the ColorModel. Values are 'bw', 'gray', 'rgb', 'rgba', 'cmyk'");
        System.out.println("           The default is 'bw'");
        System.out.println();
        System.out.println("         --dpi=<dpi>");
        System.out.println("           Set the DPI of the final file. Valid values are 1 to 600. The");
        System.out.println("           default is 200dpi");
        System.out.println();
        System.out.println("  Some examples:");
        System.out.println("  1. To join two files then save them uncompressed");
        System.out.println("     pdftool --profile=nocompression --join file1.pdf file2.tif > output.pdf");
        System.out.println();
        System.out.println("  2. To complete a form");
        System.out.println("     pdftool in.pdf --form --field=name=John --field=date='20 May' > out.pdf");
        System.out.println();
        System.out.println("  3. To reverse a PDF then convert it to a TIFF");
        System.out.println("     pdftool --join --pages=reverse file.pdf --outfile=out.tif --toimage");
        System.out.println();
        System.out.println("  4. To use only some pages from a source PDF");
        System.out.println("     pdftool --join --pages=1,3-7,10-end file1.pdf > out.pdf");
    }
}

