/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing;

import com.office.swing.OpenSwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;

public class JCloseableTabbedPane
extends JTabbedPane
implements Serializable {
    public static final String ON_TAB_CLOSE = "ON_TAB_CLOSE";
    public static final String ON_TAB_DOUBLECLICK = "ON_TAB_DOUBLECLICK";
    private JPopupMenu popup = null;
    protected EventListenerList closeListenerList = new EventListenerList();
    static /* synthetic */ Class class$0;

    public JCloseableTabbedPane() {
        this.init();
    }

    public JCloseableTabbedPane(int tabPlacement) {
        super(tabPlacement);
        this.init();
    }

    public JCloseableTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.init();
    }

    protected void init() {
        this.addMouseListener(new DefaultMouseAdapter());
    }

    public void setPopup(JPopupMenu popup) {
        this.popup = popup;
    }

    public void setIconDrawCenter(int index, boolean drawCenter) {
        ((CloseIcon)this.getIconAt(index)).setDrawCenter(drawCenter);
        this.repaint();
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public boolean isDrawCenter(int index) {
        return ((CloseIcon)this.getIconAt(index)).isDrawCenter();
    }

    public void addCloseListener(ActionListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.closeListenerList.add(clazz, l);
    }

    public void removeCloseListener(ActionListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.closeListenerList.remove(clazz, l);
    }

    protected void fireClosed(ActionEvent e) {
        Object[] listeners = this.closeListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.awt.event.ActionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((ActionListener)listeners[i + 1]).actionPerformed(e);
            }
            i -= 2;
        }
    }

    public Icon getIconAt(int index) {
        Icon icon = super.getIconAt(index);
        if (icon == null || !(icon instanceof CloseIcon)) {
            super.setIconAt(index, new CloseIcon());
        }
        return super.getIconAt(index);
    }

    public static void main(String[] args) {
        JFrame frame = OpenSwingUtil.createDemoFrame("JCloseableTabbedPane Demo");
        frame.getContentPane().setLayout(new BorderLayout());
        JCloseableTabbedPane tab = new JCloseableTabbedPane();
        tab.add((Component)new JPanel(), "TabbedPane");
        tab.add((Component)new JPanel(), "Has");
        tab.add((Component)new JPanel(), "Popup");
        tab.add((Component)new JPanel(), "PopupMenu");
        tab.setIconDrawCenter(1, false);
        tab.addCloseListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(JCloseableTabbedPane.ON_TAB_CLOSE)) {
                    JCloseableTabbedPane.this.removeTabAt(JCloseableTabbedPane.this.getSelectedIndex());
                }
            }
        });
        JPopupMenu menu = new JPopupMenu();
        int i = 0;
        while (i < 10) {
            menu.add(new JMenuItem("item " + i));
            ++i;
        }
        tab.setPopup(menu);
        frame.getContentPane().add((Component)tab, "Center");
        frame.setVisible(true);
    }

    class CloseIcon
    implements Icon {
        Rectangle rec = new Rectangle(0, 0, 15, 16);
        private boolean pressed = false;
        private boolean drawCenter = true;

        CloseIcon() {
        }

        public synchronized void paintIcon(Component c, Graphics g, int x1, int y1) {
            int x = x1;
            int y = y1;
            if (this.pressed) {
                ++x;
                ++y;
            }
            this.rec.x = x;
            this.rec.y = y;
            Color oldColor = g.getColor();
            g.setColor(UIManager.getColor("TabbedPane.highlight"));
            g.drawLine(x, y, x, y + this.rec.height);
            g.drawLine(x, y, x + this.rec.width, y);
            g.setColor(UIManager.getColor("TabbedPane.shadow"));
            g.drawLine(x, y + this.rec.height, x + this.rec.width, y + this.rec.height);
            g.drawLine(x + this.rec.width, y, x + this.rec.width, y + this.rec.height);
            g.setColor(UIManager.getColor("TabbedPane.foreground"));
            g.drawRect(x + 4, y + 4, 1, 1);
            g.drawRect(x + 5, y + 5, 1, 1);
            g.drawRect(x + 5, y + 9, 1, 1);
            g.drawRect(x + 4, y + 10, 1, 1);
            if (this.drawCenter) {
                g.drawRect(x + 6, y + 6, 1, 1);
                g.drawRect(x + 8, y + 6, 1, 1);
                g.drawRect(x + 6, y + 8, 1, 1);
                g.drawRect(x + 8, y + 8, 1, 1);
            }
            g.drawRect(x + 10, y + 4, 1, 1);
            g.drawRect(x + 9, y + 5, 1, 1);
            g.drawRect(x + 9, y + 9, 1, 1);
            g.drawRect(x + 10, y + 10, 1, 1);
            g.setColor(oldColor);
        }

        private void drawRec(Graphics g, int x, int y) {
            g.drawRect(x, y, 1, 1);
        }

        public Rectangle getBounds() {
            return this.rec;
        }

        public void setBounds(Rectangle rec) {
            this.rec = rec;
        }

        public int getIconWidth() {
            return this.rec.width;
        }

        public int getIconHeight() {
            return this.rec.height;
        }

        public void setPressed(boolean pressed) {
            this.pressed = pressed;
        }

        public void setDrawCenter(boolean drawCenter) {
            this.drawCenter = drawCenter;
        }

        public boolean isPressed() {
            return this.pressed;
        }

        public boolean isDrawCenter() {
            return this.drawCenter;
        }
    }

    class DefaultMouseAdapter
    extends MouseAdapter {
        CloseIcon icon;

        DefaultMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            int index = JCloseableTabbedPane.this.indexAtLocation(e.getX(), e.getY());
            if (index != -1) {
                this.icon = (CloseIcon)JCloseableTabbedPane.this.getIconAt(index);
                if (this.icon.getBounds().contains(e.getPoint())) {
                    this.icon.setPressed(true);
                    JCloseableTabbedPane.this.fireClosed(new ActionEvent(e.getComponent(), 1001, JCloseableTabbedPane.ON_TAB_CLOSE));
                } else if (e.getClickCount() == 2) {
                    JCloseableTabbedPane.this.fireClosed(new ActionEvent(e.getComponent(), 1001, JCloseableTabbedPane.ON_TAB_DOUBLECLICK));
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.icon != null) {
                this.icon.setPressed(false);
                this.icon = null;
                JCloseableTabbedPane.this.repaint();
            }
            if (JCloseableTabbedPane.this.popup != null) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                if (JCloseableTabbedPane.this.indexAtLocation(e.getX(), e.getY()) != -1) {
                    JCloseableTabbedPane.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

