/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing;

import com.office.swing.JCalendarPanel;
import com.office.swing.OpenSwingUtil;
import com.office.swing.refer.JDateDocument;
import com.office.swing.refer.SingleObjectComboBoxModel;
import com.sun.java.swing.plaf.motif.MotifComboBoxUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class JDatePicker
extends JComboBox
implements Serializable {
    public static final int STYLE_CN_DATE = 0;
    public static final int STYLE_CN_DATE1 = 1;
    public static final int STYLE_CN_DATETIME = 2;
    public static final int STYLE_CN_DATETIME1 = 3;
    private int formatStyle = 0;
    private SimpleDateFormat dateFormat = null;
    private SingleObjectComboBoxModel model = new SingleObjectComboBoxModel();
    JDateDocument dateDocument = null;
    static /* synthetic */ Class class$0;

    public JDatePicker() throws UnsupportedOperationException {
        this(0);
    }

    public JDatePicker(int formatStyle) throws UnsupportedOperationException {
        this(formatStyle, new Date());
    }

    public JDatePicker(int formatStyle, Date initialDatetime) throws UnsupportedOperationException {
        this.setStyle(formatStyle);
        this.setEditable(true);
        JTextField textField = (JTextField)this.getEditor().getEditorComponent();
        textField.setHorizontalAlignment(0);
        this.dateDocument = new JDateDocument(textField, this.dateFormat);
        textField.setDocument(this.dateDocument);
        this.setModel(this.model);
        this.setSelectedItem(initialDatetime == null ? new Date() : initialDatetime);
    }

    public void setStyle(int formatStyle) throws UnsupportedOperationException {
        this.formatStyle = formatStyle;
        this.dateFormat = JDatePicker.getDateFormat(formatStyle);
        this.model.setDateFormat(this.dateFormat);
        if (this.dateDocument != null) {
            this.dateDocument.setDateFormat(this.dateFormat);
        }
    }

    private static SimpleDateFormat getDateFormat(int formatStyle) throws UnsupportedOperationException {
        switch (formatStyle) {
            case 0: {
                return new SimpleDateFormat("yyyy/MM/dd");
            }
            case 1: {
                return new SimpleDateFormat("yyyy-MM-dd");
            }
            case 2: {
                return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            }
            case 3: {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            }
        }
        throw new UnsupportedOperationException("invalid formatStyle parameter!");
    }

    public int getStyle() {
        return this.formatStyle;
    }

    public Date getSelectedDate() throws ParseException {
        return this.dateFormat.parse(this.getSelectedItem().toString());
    }

    public void setSelectedDate(Date date) throws ParseException {
        this.setSelectedItem(this.dateFormat.format(date));
    }

    public void setSelectedItem(Object anObject) {
        this.model.setSelectedItem(anObject);
        super.setSelectedItem(anObject);
    }

    public void updateUI() {
        Object cui = (ComboBoxUI)UIManager.getUI(this);
        cui = cui instanceof MetalComboBoxUI ? new MetalDateComboBoxUI() : (cui instanceof MotifComboBoxUI ? new MotifDateComboBoxUI() : new WindowsDateComboBoxUI());
        this.setUI((ComboBoxUI)cui);
    }

    public static void main(String[] args) {
        JFrame f = OpenSwingUtil.createDemoFrame("JDatePicker Demo");
        JPanel c = new JPanel();
        c.add(new JLabel("From:"));
        JDatePicker datePickerFrom = new JDatePicker(2);
        c.add(datePickerFrom);
        c.add(new JLabel("To:"));
        Date d = new Date();
        d.setTime(d.getTime() + 10000000000L);
        JDatePicker datePickerTo = new JDatePicker(0, d);
        datePickerTo.setEditable(false);
        c.add(datePickerTo);
        f.getContentPane().add((Component)c, "North");
        f.getContentPane().add((Component)new JDatePicker(), "South");
        JTable table = new JTable(20, 10);
        JDatePicker editor = new JDatePicker();
        editor.setBorder(null);
        table.setAutoResizeMode(0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        table.setDefaultEditor(clazz, new DefaultCellEditor(editor));
        JScrollPane sp = new JScrollPane(table);
        f.getContentPane().add((Component)sp, "Center");
        f.setVisible(true);
    }

    class DatePopup
    extends BasicComboPopup
    implements ChangeListener {
        JCalendarPanel calendarPanel = null;

        public DatePopup(JComboBox box) {
            super(box);
            this.setLayout(new BorderLayout());
            this.calendarPanel = new JCalendarPanel();
            this.calendarPanel.addDateChangeListener(this);
            this.add((Component)this.calendarPanel, "Center");
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName.equals("visible")) {
                if (oldValue.equals(Boolean.FALSE) && newValue.equals(Boolean.TRUE)) {
                    try {
                        String strDate = this.comboBox.getSelectedItem().toString();
                        Date selectionDate = JDatePicker.this.dateFormat.parse(strDate);
                        this.calendarPanel.setSelectedDate(selectionDate);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (oldValue.equals(Boolean.TRUE)) {
                    newValue.equals(Boolean.FALSE);
                }
            }
            super.firePropertyChange(propertyName, oldValue, newValue);
        }

        public void stateChanged(ChangeEvent e) {
            Date selectedDate = (Date)e.getSource();
            String strDate = JDatePicker.this.dateFormat.format(selectedDate);
            if (this.comboBox.isEditable() && this.comboBox.getEditor() != null) {
                this.comboBox.configureEditor(this.comboBox.getEditor(), strDate);
            }
            this.comboBox.setSelectedItem(strDate);
            this.comboBox.setPopupVisible(false);
        }
    }

    class MetalDateComboBoxUI
    extends MetalComboBoxUI {
        MetalDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    class MotifDateComboBoxUI
    extends MotifComboBoxUI {
        MotifDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    class WindowsDateComboBoxUI
    extends WindowsComboBoxUI {
        WindowsDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }
}

