/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class JGroupPanel
extends JPanel {
    private JPanel pNorth = new JPanel(){
        private static final long serialVersionUID = 1L;
    };
    private JPanel pCenter = new JPanel();
    private JPanel pSouth = new JPanel();
    private ArrayList groupList = new ArrayList();
    private boolean forbidFlag = false;
    private JGroupContainer activeGroup = null;
    transient ActionListener al = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JButton bttTitle = (JButton)e.getSource();
            JGroupPanel.this.expandGroup((JGroupContainer)bttTitle.getParent());
        }
    };
    private boolean hasCreateDefaultGroup = false;

    public JGroupPanel() {
        this.initComponents();
        this.createDefaultGroup();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.pNorth, "North");
        this.add((Component)this.pCenter, "Center");
        this.add((Component)this.pSouth, "South");
        this.pNorth.setLayout(new GroupLayout());
        this.pCenter.setLayout(new BorderLayout());
        this.pSouth.setLayout(new GroupLayout());
        this.forbidFlag = true;
    }

    private void createDefaultGroup() {
        Color[] bg = new Color[]{Color.black, Color.red, Color.orange, Color.yellow, Color.green, Color.cyan, Color.blue, Color.white};
        int i = 1;
        while (i <= bg.length) {
            this.insertGroup(i - 1, "Group " + i, bg[i - 1]);
            Color mc = new Color(255 - bg[i - 1].getRed(), 255 - bg[i - 1].getGreen(), 255 - bg[i - 1].getBlue());
            int j = 1;
            while (j <= 5) {
                JButton bttMember = new JButton("Member " + j + " of " + i);
                this.addMember(i - 1, bttMember);
                bttMember.setPreferredSize(new Dimension(1, 40));
                bttMember.setOpaque(false);
                bttMember.setForeground(mc);
                ++j;
            }
            this.getGroup(i - 1).setMemberGap(20, 5);
            this.getGroup(i - 1).getTitleButton().setForeground(bg[i - 1]);
            ++i;
        }
        this.expandGroup(0);
        this.hasCreateDefaultGroup = true;
    }

    public JGroupPanel(String[] groupNames) {
        this.initComponents();
        this.addGroup(groupNames);
    }

    public void expandGroup(String name) {
        int i = this.getGroupCount() - 1;
        while (i >= 0) {
            if (this.getGroupName(i).equals(name)) {
                this.expandGroup(i);
            }
            --i;
        }
    }

    public void expandGroup(int index) {
        this.expandGroup(this.getGroup(index));
    }

    protected void expandGroup(JGroupContainer group) {
        this.pNorth.removeAll();
        this.pCenter.removeAll();
        this.pSouth.removeAll();
        boolean hasAddCenter = false;
        int i = 0;
        while (i < this.groupList.size()) {
            Component c = (Component)this.groupList.get(i);
            if (hasAddCenter) {
                this.pSouth.add(c);
            } else if (c == group) {
                this.pCenter.add(c, "Center");
                hasAddCenter = true;
            } else {
                this.pNorth.add(c);
            }
            ++i;
        }
        if (this.activeGroup != null) {
            this.activeGroup.collapse();
        }
        this.activeGroup = group;
        this.activeGroup.expand();
        this.pNorth.doLayout();
        this.pCenter.doLayout();
        this.pSouth.doLayout();
        this.doLayout();
    }

    public void collapseGroup(String name) {
        int i = this.getGroupCount() - 1;
        while (i >= 0) {
            if (this.getGroupName(i).equals(name)) {
                this.collapseGroup(i);
            }
            --i;
        }
    }

    public void collapseGroup(int index) {
        this.collapseGroup(this.getGroup(index));
    }

    protected void collapseGroup(JGroupContainer group) {
        if (group == this.activeGroup) {
            this.activeGroup.collapse();
            this.activeGroup = null;
        }
    }

    public void addGroup(String name) {
        this.insertGroup(this.getGroupCount(), name);
    }

    public void addGroup(String[] names) {
        int i = 0;
        while (i < names.length) {
            this.addGroup(names[i]);
            ++i;
        }
    }

    public void insertGroup(int index, String name, Color bg) {
        if (index < 0 || index > this.groupList.size()) {
            throw new ArrayIndexOutOfBoundsException("index:" + index + " >count:" + this.groupList.size());
        }
        if (this.hasCreateDefaultGroup) {
            while (this.getGroupCount() > 0) {
                this.removeGroup(0);
            }
            this.hasCreateDefaultGroup = false;
        }
        int countNorth = this.pNorth.getComponentCount();
        int countCenter = this.pCenter.getComponentCount();
        int countSouth = this.pSouth.getComponentCount();
        JGroupContainer group = index <= countNorth ? this.insertGroup(this.pNorth, index, name, bg) : (index <= countNorth + countCenter ? this.insertGroup(this.pCenter, index - countNorth, name, bg) : (index <= countNorth + countCenter + countSouth ? this.insertGroup(this.pSouth, index - countNorth - countCenter, name, bg) : this.insertGroup(this.pSouth, countSouth, name, bg)));
        group.getTitleButton().addActionListener(this.al);
        this.groupList.add(index, group);
    }

    public void insertGroup(int index, String name) {
        this.insertGroup(index, name, UIManager.getColor("Desktop.background"));
    }

    private JGroupContainer insertGroup(JPanel p, int index, String name, Color bg) {
        JGroupContainer group = new JGroupContainer(name, bg);
        p.add(group);
        return group;
    }

    public void removeGroup(int index) {
        JGroupContainer c = (JGroupContainer)this.groupList.get(index);
        c.getParent().remove(c);
        c.getTitleButton().removeActionListener(this.al);
    }

    public void removeGroup(String name) {
        int i = this.getGroupCount() - 1;
        while (i >= 0) {
            if (this.getGroupName(i).equals(name)) {
                this.removeGroup(i);
            }
            --i;
        }
    }

    public void setGroupName(int index, String name) {
        this.getGroup(index).setName(name);
    }

    public String getGroupName(int groupIndex) {
        return this.getGroup(groupIndex).getName();
    }

    public String[] getGroupNames() {
        String[] sResult = new String[this.getGroupCount()];
        int i = 0;
        while (i < this.getGroupCount()) {
            sResult[i] = this.getGroupName(i);
            ++i;
        }
        return sResult;
    }

    public int getGroupCount() {
        return this.groupList.size();
    }

    public void addMember(int groupIndex, Component member) {
        this.getGroup(groupIndex).addMember(this.getGroup(groupIndex).getMemberCount(), member);
    }

    public void insertMember(int groupIndex, int memberIndex, Component member) {
        this.getGroup(groupIndex).addMember(memberIndex, member);
    }

    public void removeMember(int groupIndex, int memberIndex) {
        this.getGroup(groupIndex).removeMember(memberIndex);
    }

    public Component getMember(int groupIndex, int memberIndex) {
        return this.getGroup(groupIndex).getMember(memberIndex);
    }

    public Component[] getMembers(int groupIndex) {
        return this.getGroup(groupIndex).getMembers();
    }

    public int getMemberCount(int groupIndex) {
        return this.getGroup(groupIndex).getMemberCount();
    }

    protected JGroupContainer getGroup(int index) {
        return (JGroupContainer)this.groupList.get(index);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.forbidFlag) {
            if (!(comp instanceof JGroupContainer)) {
                throw new UnsupportedOperationException("JGroupPane can't add component!");
            }
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("JGroupPanel Demo");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)new JGroupPanel(), "Center");
        frame.setSize(150, 600);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(d.width - frame.getSize().width - 10, 10);
        frame.setVisible(true);
    }

    class GroupLayout
    implements LayoutManager,
    Serializable {
        int vgap = 0;
        int hgap = 0;

        public GroupLayout() {
        }

        public GroupLayout(int hg, int vg) {
            this.hgap = hg;
            this.vgap = vg;
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                int ncomponents = parent.getComponentCount();
                int w = 0;
                int h = 0;
                int i = 0;
                while (i < ncomponents) {
                    Component comp = parent.getComponent(i);
                    Dimension d = comp.getPreferredSize();
                    if (w < d.width) {
                        w = d.width;
                    }
                    h += d.height + this.vgap;
                    ++i;
                }
                return new Dimension(insets.left + insets.right + w + 2 * this.hgap, insets.top + insets.bottom + h + 2 * this.vgap);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                int ncomponents = parent.getComponentCount();
                if (ncomponents == 0) {
                    return;
                }
                int y = insets.top + this.vgap;
                int c = 0;
                while (c < ncomponents) {
                    int h = parent.getComponent((int)c).getPreferredSize().height;
                    parent.getComponent(c).setBounds(insets.left + this.hgap, y, parent.getWidth() - insets.left - insets.right - 2 * this.hgap, h);
                    y += h + this.vgap;
                    ++c;
                }
            }
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    class JGroupContainer
    extends JPanel {
        private JButton bttGroupTitle = new JButton();
        private JPanel pMembers = new JPanel();
        private JScrollPane sp;

        public JGroupContainer() {
            this("");
        }

        public JGroupContainer(String name) {
            this(name, UIManager.getColor("Desktop.background"));
        }

        public JGroupContainer(String name, Color background) {
            this.bttGroupTitle.setText(name);
            this.bttGroupTitle.setFocusable(false);
            this.pMembers.setLayout(new GroupLayout(5, 5));
            this.setLayout(new BorderLayout());
            this.add((Component)this.bttGroupTitle, "North");
            this.pMembers.setBackground(background);
            Color thumbColor = UIManager.getColor("ScrollBar.thumb");
            Color trackColor = UIManager.getColor("ScrollBar.track");
            Color trackHighlightColor = UIManager.getColor("ScrollBar.trackHighlight");
            UIManager.put("ScrollBar.thumb", background);
            UIManager.put("ScrollBar.track", background);
            UIManager.put("ScrollBar.trackHighlight", background);
            this.sp = new JScrollPane(this.pMembers);
            this.sp.setHorizontalScrollBarPolicy(31);
            this.add((Component)this.sp, "Center");
            this.collapse();
            UIManager.put("ScrollBar.thumb", thumbColor);
            UIManager.put("ScrollBar.track", trackColor);
            UIManager.put("ScrollBar.trackHighlight", trackHighlightColor);
        }

        public void setMemberGap(int hgap, int vgap) {
            this.pMembers.setLayout(new GroupLayout(hgap, vgap));
        }

        public JButton getTitleButton() {
            return this.bttGroupTitle;
        }

        public JPanel getMembersContainer() {
            return this.pMembers;
        }

        public void collapse() {
            this.sp.setVisible(false);
            this.revalidate();
        }

        public void expand() {
            this.sp.setVisible(true);
            this.revalidate();
        }

        public void setName(String name) {
            this.bttGroupTitle.setText(name);
        }

        public String getName() {
            return this.bttGroupTitle.getText();
        }

        public void addMember(int index, Component c) {
            this.pMembers.add(c, index);
            this.pMembers.doLayout();
        }

        public void removeMember(int index) {
            this.pMembers.remove(index);
            this.pMembers.doLayout();
        }

        public Component getMember(int index) {
            return this.pMembers.getComponent(index);
        }

        public Component[] getMembers() {
            Component[] coms = new Component[this.getMemberCount()];
            int i = 0;
            while (i < coms.length) {
                coms[i] = this.pMembers.getComponent(i);
                ++i;
            }
            return coms;
        }

        public int getMemberCount() {
            return this.pMembers.getComponentCount();
        }

        public String toString() {
            return this.getName();
        }
    }
}

