/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing;

import com.office.swing.JNumberField;
import com.office.swing.OpenSwingUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class JIpAddressField
extends JTextField
implements Serializable {
    JNumberField ip1 = new JNumberField(3, 0, 0.0, 255.0, true);
    JNumberField ip2 = new JNumberField(3, 0, 0.0, 255.0, true);
    JNumberField ip3 = new JNumberField(3, 0, 0.0, 255.0, true);
    JNumberField ip4 = new JNumberField(3, 0, 0.0, 255.0, true);

    public JIpAddressField() {
        this("0.0.0.0");
    }

    public JIpAddressField(String strIpAddress) {
        this.setPreferredSize(new Dimension(250, 25));
        this.setLayout(new GridLayout(1, 9, 0, 0));
        this.ip1.setBorder(null);
        this.ip2.setBorder(null);
        this.ip3.setBorder(null);
        this.ip4.setBorder(null);
        this.add(this.createDot(""));
        this.add(this.ip1);
        this.add(this.createDot("."));
        this.add(this.ip2);
        this.add(this.createDot("."));
        this.add(this.ip3);
        this.add(this.createDot("."));
        this.add(this.ip4);
        this.add(this.createDot(""));
        this.setFocusable(false);
        this.setIpAddress(strIpAddress);
        LeftRightKeyListener lrKeyl = new LeftRightKeyListener();
        this.ip1.addKeyListener(lrKeyl);
        this.ip2.addKeyListener(lrKeyl);
        this.ip3.addKeyListener(lrKeyl);
        this.ip4.addKeyListener(lrKeyl);
        this.ip1.addPropertyChangeListener(new LRTransListener(null, this.ip2));
        this.ip2.addPropertyChangeListener(new LRTransListener(this.ip1, this.ip3));
        this.ip3.addPropertyChangeListener(new LRTransListener(this.ip2, this.ip4));
        this.ip4.addPropertyChangeListener(new LRTransListener(this.ip3, null));
    }

    private JLabel createDot(String dot) {
        JLabel lb = new JLabel(dot);
        lb.setOpaque(false);
        return lb;
    }

    public void setIpAddress(String strIpAddress) {
        if (strIpAddress != null && strIpAddress.equals("")) {
            this.ip1.setText("");
            this.ip2.setText("");
            this.ip3.setText("");
            this.ip4.setText("");
        } else {
            if (strIpAddress == null || strIpAddress.indexOf(".") == -1 || strIpAddress.split("\\.").length != 4) {
                throw new UnsupportedOperationException("Invalid IP Address:" + strIpAddress);
            }
            String[] strIp = strIpAddress.split("\\.");
            this.ip1.setText(strIp[0]);
            this.ip2.setText(strIp[1]);
            this.ip3.setText(strIp[2]);
            this.ip4.setText(strIp[3]);
        }
    }

    public String getIpAddress() {
        String strIp1 = this.ip1.getText().trim();
        String strIp2 = this.ip2.getText().trim();
        String strIp3 = this.ip3.getText().trim();
        String strIp4 = this.ip4.getText().trim();
        return String.valueOf(strIp1.equals("") ? "0" : strIp1) + "." + (strIp2.equals("") ? "0" : strIp2) + "." + (strIp3.equals("") ? "0" : strIp3) + "." + (strIp4.equals("") ? "0" : strIp4);
    }

    public String getText() {
        return this.getIpAddress();
    }

    public static void main(String[] args) {
        JFrame frame = OpenSwingUtil.createDemoFrame("JIPAddressField Demo");
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(new JIpAddressField());
        frame.getContentPane().add(new JIpAddressField("255.255.255.255"));
        JIpAddressField ip = new JIpAddressField();
        ip.setIpAddress("192.168.0.122");
        frame.getContentPane().add(ip);
        frame.setVisible(true);
    }

    class LRTransListener
    implements PropertyChangeListener {
        private Component leftComponent;
        private Component rightComponent;

        public LRTransListener(Component leftComponent, Component rightComponent) {
            this.leftComponent = leftComponent;
            this.rightComponent = rightComponent;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "LEFT_TRAN") {
                if (this.leftComponent != null) {
                    this.leftComponent.requestFocus();
                }
            } else if (evt.getPropertyName() == "RIGHT_TRAN" && this.rightComponent != null) {
                this.rightComponent.requestFocus();
            }
        }
    }

    class LeftRightKeyListener
    extends KeyAdapter {
        public static final String LEFT_TRAN = "LEFT_TRAN";
        public static final String RIGHT_TRAN = "RIGHT_TRAN";

        LeftRightKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            JTextComponent txt = (JTextComponent)e.getComponent();
            if (e.getKeyCode() == 37) {
                if (txt.getCaretPosition() == 0) {
                    txt.firePropertyChange(LEFT_TRAN, 0, 1);
                }
            } else if ((e.getKeyCode() == 39 || e.getKeyChar() == '.') && txt.getCaretPosition() == txt.getText().length()) {
                txt.firePropertyChange(RIGHT_TRAN, 0, 1);
            }
        }
    }
}

