/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing;

import com.office.swing.FlowLayout2;
import com.office.swing.JFontDialog;
import com.office.swing.OpenSwingUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class JListChooser
extends JDialog
implements ActionListener,
MouseListener {
    JPanel pCenter = new JPanel();
    JPanel pSouth = new JPanel();
    JButton bttOk = new JButton();
    JButton bttCancel = new JButton();
    DefaultListModel modelSource = new DefaultListModel();
    DefaultListModel modelTarget = new DefaultListModel();
    JList listSource = new JList(this.modelSource);
    JList listTarget = new JList(this.modelTarget);
    JScrollPane spLeft = new JScrollPane(this.listSource);
    JScrollPane spRight = new JScrollPane(this.listTarget);
    JPanel pOptions = new JPanel();
    JButton bttRemoveAll = new JButton();
    JButton bttRemove = new JButton();
    JButton bttAddAll = new JButton();
    JButton bttAdd = new JButton();
    boolean isOkButtonClicked = false;
    FlowLayout2 flowLayout2 = new FlowLayout2();

    public static String[] showDialog(Component c, String title, boolean modal, String[] initResources) {
        JListChooser dialog;
        Window owner = JFontDialog.getRootWindow(c);
        if (owner instanceof Dialog) {
            dialog = new JListChooser((Dialog)owner, title, modal);
        } else if (owner instanceof Frame) {
            dialog = new JListChooser((Frame)owner, title, modal);
        } else {
            dialog = new JListChooser((Frame)owner, title, modal);
            dialog.setTitle(title);
        }
        if (initResources != null) {
            dialog.setResource(initResources);
        }
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation((d.width - dialog.getSize().width) / 2, (d.height - dialog.getSize().height) / 2);
        dialog.show();
        return dialog.getResource();
    }

    public JListChooser(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JListChooser(Dialog frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JListChooser() {
        this((Frame)null, "", false);
    }

    private void jbInit() throws Exception {
        this.setSize(400, 320);
        this.bttOk.setText(OpenSwingUtil.getOpenResource("OK"));
        this.bttCancel.setText(OpenSwingUtil.getOpenResource("Cancel"));
        this.bttCancel.setMnemonic('C');
        this.bttRemoveAll.setText("<<");
        this.bttRemove.setPreferredSize(new Dimension(47, 25));
        this.bttRemove.setText("<");
        this.bttAddAll.setText(">>");
        this.bttAdd.setPreferredSize(new Dimension(47, 25));
        this.bttAdd.setText(">");
        this.pOptions.setSize(60, 1);
        this.pOptions.add(this.bttAdd);
        this.pOptions.add(this.bttAddAll);
        this.pOptions.add(this.bttRemove);
        this.pOptions.add(this.bttRemoveAll);
        this.pSouth.add(this.bttOk);
        this.pSouth.add(this.bttCancel);
        this.pCenter.setLayout(this.flowLayout2);
        this.pCenter.add((Component)this.spLeft, "LEFT");
        this.pCenter.add((Component)this.pOptions, "CENTER");
        this.pCenter.add((Component)this.spRight, "RIGHT");
        this.getContentPane().add((Component)this.pCenter, "Center");
        this.getContentPane().add((Component)this.pSouth, "South");
        this.bttAdd.addActionListener(this);
        this.bttAddAll.addActionListener(this);
        this.bttRemove.addActionListener(this);
        this.bttRemoveAll.addActionListener(this);
        this.bttOk.addActionListener(this);
        this.bttCancel.addActionListener(this);
        this.listSource.addMouseListener(this);
        this.listTarget.addMouseListener(this);
        this.bttAdd.setFocusable(false);
        this.bttAddAll.setFocusable(false);
        this.bttRemove.setFocusable(false);
        this.bttRemoveAll.setFocusable(false);
        this.bttRemove.setEnabled(false);
        this.bttRemoveAll.setEnabled(false);
        this.listSource.setSelectionMode(0);
        this.listTarget.setSelectionMode(0);
        this.getRootPane().setDefaultButton(this.bttOk);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (!JListChooser.this.isOkButtonClicked) {
                    JListChooser.this.modelTarget.removeAllElements();
                }
            }
        });
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        if (e.getSource() == this.listSource) {
            this.bttAdd.doClick();
        } else if (e.getSource() == this.listTarget) {
            this.bttRemove.doClick();
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void setResource(String[] str) {
        this.modelSource.clear();
        int i = 0;
        while (i < str.length) {
            this.modelSource.addElement(str[i]);
            ++i;
        }
        this.listSource.setSelectedIndex(0);
    }

    public String[] getResource() {
        String[] s = new String[this.modelTarget.getSize()];
        int i = 0;
        while (i < s.length) {
            s[i] = this.modelTarget.getElementAt(i).toString();
            ++i;
        }
        return s;
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.bttAdd) {
            int index = this.listSource.getSelectedIndex();
            if (index == -1) {
                return;
            }
            this.modelTarget.addElement(this.listSource.getSelectedValue());
            this.modelSource.remove(index);
            this.listSource.setSelectedIndex(Math.max(0, Math.min(index, this.modelSource.size() - 1)));
            this.listTarget.setSelectedIndex(this.modelTarget.size() - 1);
        } else if (obj == this.bttAddAll) {
            while (this.modelSource.size() != 0) {
                this.modelTarget.addElement(this.modelSource.get(0));
                this.modelSource.remove(0);
            }
            this.listTarget.setSelectedIndex(this.modelTarget.size() - 1);
        } else if (obj == this.bttRemove) {
            int index = this.listTarget.getSelectedIndex();
            if (index == -1) {
                return;
            }
            this.modelSource.addElement(this.listTarget.getSelectedValue());
            this.modelTarget.remove(index);
            this.listTarget.setSelectedIndex(Math.max(0, Math.min(index, this.modelTarget.size() - 1)));
            this.listSource.setSelectedIndex(this.modelSource.size() - 1);
        } else if (obj == this.bttRemoveAll) {
            while (this.modelTarget.size() != 0) {
                this.modelSource.addElement(this.modelTarget.get(0));
                this.modelTarget.remove(0);
            }
            this.listSource.setSelectedIndex(this.modelSource.size() - 1);
        } else {
            if (obj == this.bttOk) {
                this.isOkButtonClicked = true;
                this.setVisible(false);
                return;
            }
            if (obj == this.bttCancel) {
                this.isOkButtonClicked = false;
                this.setVisible(false);
                return;
            }
        }
        this.bttAdd.setEnabled(this.modelSource.size() != 0);
        this.bttAddAll.setEnabled(this.modelSource.size() != 0);
        this.bttRemove.setEnabled(this.modelTarget.size() != 0);
        this.bttRemoveAll.setEnabled(this.modelTarget.size() != 0);
        this.listSource.ensureIndexIsVisible(this.listSource.getSelectedIndex());
        this.listTarget.ensureIndexIsVisible(this.listTarget.getSelectedIndex());
    }

    public static void main(String[] args) {
        JFrame frame = OpenSwingUtil.createDemoFrame("JListChooser Demo");
        frame.setSize(600, 400);
        JTextArea txt = new JTextArea("Current Selection:\n");
        frame.getContentPane().add((Component)new JScrollPane(txt), "Center");
        frame.setVisible(true);
        String[] str = JListChooser.showDialog(txt, "JListChooser Demo", true, GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        String s = "";
        int i = 0;
        while (i < str.length) {
            s = String.valueOf(s) + "\t" + str[i] + "\n";
            ++i;
        }
        txt.setText(String.valueOf(txt.getText()) + s);
    }
}

