/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing;

import com.office.swing.NumberDocument;
import com.office.swing.OpenSwingUtil;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class JNumberField
extends JTextField
implements ActionListener,
FocusListener,
Serializable {
    public JNumberField() {
        this(true);
    }

    public JNumberField(boolean addAction) {
        this(16, 0, addAction);
    }

    public JNumberField(int intPartLen) {
        this(intPartLen, true);
    }

    public JNumberField(int intPartLen, boolean addAction) {
        this(intPartLen, 0, addAction);
    }

    public JNumberField(int maxLen, int decLen) {
        this(maxLen, decLen, true);
    }

    public JNumberField(int maxLen, int decLen, boolean addAction) {
        this.setPreferredSize(new Dimension(150, 25));
        this.setDocument(new NumberDocument(maxLen, decLen));
        super.setHorizontalAlignment(4);
        if (addAction) {
            this.addActionListener(this);
        }
        this.addFocusListener(this);
    }

    public JNumberField(int maxLen, int decLen, double minRange, double maxRange, boolean addAction) {
        this.setPreferredSize(new Dimension(150, 25));
        this.setDocument(new NumberDocument(maxLen, decLen, minRange, maxRange));
        super.setHorizontalAlignment(4);
        if (addAction) {
            this.addActionListener(this);
        }
        this.addFocusListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        this.transferFocus();
    }

    public void focusGained(FocusEvent e) {
        this.selectAll();
    }

    public void focusLost(FocusEvent e) {
    }

    public static void main(String[] args) {
        JFrame frame = OpenSwingUtil.createDemoFrame("JNumberField Demo");
        frame.getContentPane().setLayout(new GridLayout(10, 2));
        frame.getContentPane().add(new JLabel("New JNumberField()"));
        frame.getContentPane().add(new JNumberField());
        frame.getContentPane().add(new JLabel("New JNumberField(2)"));
        frame.getContentPane().add(new JNumberField(2));
        frame.getContentPane().add(new JLabel("New JNumberField(8,2)"));
        frame.getContentPane().add(new JNumberField(8, 2));
        frame.getContentPane().add(new JLabel("New JNumberField(5,2,-10,100)"));
        frame.getContentPane().add(new JNumberField(5, 2, -10.0, 100.0, false));
        frame.setVisible(true);
    }
}

