/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class NumberDocument
extends PlainDocument {
    int maxLength = 16;
    int decLength = 0;
    double minRange = -1.7976931348623157E308;
    double maxRange = Double.MAX_VALUE;

    public NumberDocument(int maxLen, int decLen) {
        this.maxLength = maxLen;
        this.decLength = decLen;
    }

    public NumberDocument(int maxLen, int decLen, double minRange, double maxRange) {
        this(maxLen, decLen);
        this.minRange = minRange;
        this.maxRange = maxRange;
    }

    public NumberDocument(int decLen) {
        this.decLength = decLen;
    }

    public NumberDocument() {
    }

    public void insertString(int offset, String s, AttributeSet a) throws BadLocationException {
        String str = this.getText(0, this.getLength());
        if (s.equals("F") || s.equals("f") || s.equals("D") || s.equals("d") || str.trim().equals("0") && !s.substring(0, 1).equals(".") && offset != 0 || s.equals(".") && this.decLength == 0) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        String strIntPart = "";
        String strDecPart = "";
        String strNew = String.valueOf(str.substring(0, offset)) + s + str.substring(offset, this.getLength());
        int decPos = (strNew = strNew.replaceFirst("-", "")).indexOf(".");
        if (decPos > -1) {
            strIntPart = strNew.substring(0, decPos);
            strDecPart = strNew.substring(decPos + 1);
        } else {
            strIntPart = strNew;
        }
        if (strIntPart.length() > this.maxLength - this.decLength || strDecPart.length() > this.decLength || strNew.length() > 1 && strNew.substring(0, 1).equals("0") && !strNew.substring(1, 2).equals(".")) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            double d;
            if (!strNew.equals("") && !strNew.equals("-") && ((d = Double.parseDouble(strNew)) < this.minRange || d > this.maxRange)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.insertString(offset, s, a);
    }
}

