/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing;

import com.office.swing.JTreeComboBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.tree.TreePath;

class TreePopup
extends JPopupMenu
implements ComboPopup {
    protected JTreeComboBox comboBox;
    protected JScrollPane scrollPane;
    protected MouseMotionListener mouseMotionListener;
    protected MouseListener mouseListener;
    private MouseListener treeSelectListener = new MouseAdapter(){

        public void mouseReleased(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            TreePath tp = tree.getPathForLocation(e.getPoint().x, e.getPoint().y);
            if (tp == null) {
                return;
            }
            TreePopup.this.comboBox.setSelectedItem(tp);
            TreePopup.this.togglePopup();
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
    };
    protected JList list = new JList();

    public TreePopup(JComboBox comboBox) {
        this.comboBox = (JTreeComboBox)comboBox;
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(new BorderLayout());
        this.setLightWeightPopupEnabled(comboBox.isLightWeightPopupEnabled());
        JTree tree = this.comboBox.getTree();
        if (tree != null) {
            this.scrollPane = new JScrollPane(tree);
            this.scrollPane.setBorder(null);
            this.add((Component)this.scrollPane, "Center");
            tree.addMouseListener(this.treeSelectListener);
        }
    }

    public void show() {
        this.updatePopup();
        this.show(this.comboBox, 0, this.comboBox.getHeight());
        this.comboBox.getTree().requestFocus();
    }

    public void hide() {
        this.setVisible(false);
        this.comboBox.firePropertyChange("popupVisible", true, false);
    }

    public JList getList() {
        return this.list;
    }

    public MouseMotionListener getMouseMotionListener() {
        if (this.mouseMotionListener == null) {
            this.mouseMotionListener = new MouseMotionAdapter(){};
        }
        return this.mouseMotionListener;
    }

    public KeyListener getKeyListener() {
        return null;
    }

    public void uninstallingUI() {
    }

    public MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new InvocationMouseHandler();
        }
        return this.mouseListener;
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    protected void updatePopup() {
        this.setPreferredSize(new Dimension(this.comboBox.getSize().width, 200));
        Object selectedObj = this.comboBox.getSelectedItem();
        if (selectedObj != null) {
            TreePath tp = (TreePath)selectedObj;
            this.comboBox.getTree().setSelectionPath(tp);
        }
    }

    protected class InvocationMouseHandler
    extends MouseAdapter {
        protected InvocationMouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e) || !TreePopup.this.comboBox.isEnabled()) {
                return;
            }
            if (TreePopup.this.comboBox.isEditable()) {
                Component comp = TreePopup.this.comboBox.getEditor().getEditorComponent();
                if (!(comp instanceof JComponent) || ((JComponent)comp).isRequestFocusEnabled()) {
                    comp.requestFocus();
                }
            } else if (TreePopup.this.comboBox.isRequestFocusEnabled()) {
                TreePopup.this.comboBox.requestFocus();
            }
            TreePopup.this.togglePopup();
        }
    }
}

