/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing.print;

import com.office.swing.OpenSwingUtil;
import com.office.swing.print.BookOfPrint;
import com.office.swing.print.PrintOptionDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class PrintAction
extends AbstractAction {
    public static final String PRINT_ACTION = "PrintAction";
    public static final String PAGESET_ACTION = "PageSetAction";
    private PrintOptionDialog dialog;
    private PageFormat pageFormat;
    private Window owner;
    private BookOfPrint bookOfPrint;

    public PrintAction(BookOfPrint bookOfPrint) {
        super(OpenSwingUtil.getOpenResource("Preview"), OpenSwingUtil.getOpenSwingImage("preview.gif", new ImageIcon()));
        this.putValue("ShortDescription", OpenSwingUtil.getOpenResource("Preview"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(9, 128));
        PrinterJob printJob = PrinterJob.getPrinterJob();
        this.pageFormat = printJob.defaultPage();
        super.putValue("ConfirmAction", new ConfirmAction());
        super.putValue(PRINT_ACTION, new PrintPageAction());
        super.putValue(PAGESET_ACTION, new PageSetAction());
        this.bookOfPrint = bookOfPrint;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            if (this.owner == null) {
                this.owner = SwingUtilities.getWindowAncestor((Component)e.getSource());
            }
            this.dialog = new PrintOptionDialog(this.owner, OpenSwingUtil.getOpenResource("Preview"));
            this.dialog.setActions((Action)this.getValue("ConfirmAction"), (Action)this.getValue(PRINT_ACTION), (Action)this.getValue(PAGESET_ACTION));
            this.dialog.setSize(800, 600);
            this.dialog.setLocationRelativeTo(this.owner);
        }
        this.dialog.setPageFormat(this.pageFormat);
        if (this.owner instanceof Dialog) {
            this.dialog.setBook(this.bookOfPrint.makeBook(true, this.pageFormat));
            JDialog d = new JDialog((Dialog)this.owner, this.dialog.getTitle(), true);
            d.getContentPane().add(this.dialog.getContentPane());
            d.setBounds(this.dialog.getBounds());
            d.show();
        } else {
            this.dialog.show();
            this.dialog.setExtendedState(6);
            this.dialog.setBook(this.bookOfPrint.makeBook(true, this.pageFormat));
        }
    }

    public Action getAction(String actionName) {
        Object obj = this.getValue(actionName);
        if (obj != null && obj instanceof Action) {
            return (Action)obj;
        }
        return null;
    }

    class ConfirmAction
    extends AbstractAction {
        public ConfirmAction() {
            super.putValue("Name", OpenSwingUtil.getOpenResource("Close"));
            super.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent e) {
            SwingUtilities.getWindowAncestor((Component)e.getSource()).setVisible(false);
        }
    }

    class PageSetAction
    extends AbstractAction {
        public PageSetAction() {
            super.putValue("Name", OpenSwingUtil.getOpenResource("PrintSetup"));
            super.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent e) {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            if (PrintAction.this.dialog != null) {
                PrintAction.this.pageFormat = PrintAction.this.dialog.getPageFormat();
            }
            PrintAction.this.pageFormat = printJob.pageDialog(PrintAction.this.pageFormat);
            if (PrintAction.this.dialog != null) {
                PrintAction.this.dialog.setPageFormat(PrintAction.this.pageFormat);
                PrintAction.this.dialog.setBook(PrintAction.this.bookOfPrint.makeBook(true, PrintAction.this.pageFormat));
            }
        }
    }

    class PrintPageAction
    extends AbstractAction {
        public PrintPageAction() {
            super.putValue("Name", OpenSwingUtil.getOpenResource("Print"));
            super.putValue("SmallIcon", OpenSwingUtil.getOpenSwingImage("print.gif", new ImageIcon()));
            super.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent e) {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPageable(PrintAction.this.bookOfPrint.makeBook(false, PrintAction.this.pageFormat));
            if (printJob.printDialog()) {
                try {
                    printJob.print();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

