/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing.print;

import com.office.swing.print.Content;
import com.office.swing.print.PrintColor;
import com.office.swing.print.StartPos;
import com.office.swing.print.content.PrintContentInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.util.Vector;

public class PrintContent {
    private Vector vAllContents = new Vector();
    private Component c;

    public void println() {
        this.vAllContents.add(new Content(null, null));
    }

    public void print(PrintContentInterface content, Font f) {
        this.vAllContents.add(new Content(content, f));
    }

    public void println(PrintContentInterface content, Font f) {
        this.print(content, f);
        this.println();
    }

    public void print(PrintContentInterface content) {
        this.vAllContents.add(new Content(content, null));
    }

    public void println(PrintContentInterface content) {
        this.print(content);
        this.println();
    }

    public void setStartPos(int i) {
        this.vAllContents.add(new Content(new StartPos(i), null));
    }

    public void setColor(Color c) {
        this.vAllContents.add(new Content(new PrintColor(c), null));
    }

    public void draw(Graphics g, Point p, PageFormat pf) {
        FontMetrics fm = g.getFontMetrics();
        int pw = (int)pf.getImageableWidth();
        int ph = (int)pf.getImageableHeight();
        p.y = fm.getHeight() * 2;
        int startPos = 2;
        int i = 0;
        while (i < this.vAllContents.size()) {
            PrintContentInterface obj;
            Content content = (Content)this.vAllContents.elementAt(i);
            Font newFont = content.getFont();
            pw = (int)(pf.getImageableWidth() - (double)startPos);
            if (p.x < startPos) {
                p.x = startPos;
            }
            if (newFont != null) {
                g.setFont(newFont);
                fm = g.getFontMetrics();
            }
            if ((obj = content.getContent()) == null) {
                p.x = startPos;
                p.y += fm.getHeight();
                if ((double)(p.y % ph) < (double)fm.getHeight() * 1.25) {
                    p.y += fm.getHeight();
                }
            } else if (obj instanceof StartPos) {
                startPos = ((StartPos)obj).getStartPos();
            } else {
                obj.draw(g, p, pf, startPos);
            }
            ++i;
        }
    }
}

