/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing.print;

import com.office.swing.OpenSwingUtil;
import com.office.swing.print.MultiPagePopup;
import com.office.swing.print.PreviewCanvas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class PrintOptionDialog
extends JFrame
implements ActionListener {
    private PageFormat pageFormat;
    private Book book;
    JToolBar toolbar = new JToolBar();
    JButton bttMulti = new JButton(OpenSwingUtil.getOpenSwingImage("multipage.gif", new ImageIcon()));
    JButton bttSingle = new JButton(OpenSwingUtil.getOpenSwingImage("singlepage.gif", new ImageIcon()));
    JButton bttPrint = new JButton(OpenSwingUtil.getOpenSwingImage("print.gif", new ImageIcon()));
    JPanel canvas = new JPanel(new FlowLayout());
    JScrollPane sp = new JScrollPane(this.canvas, 22, 32){

        public void doLayout() {
            super.doLayout();
            JScrollBar bar = this.getHorizontalScrollBar();
            bar.setValue((bar.getMaximum() - bar.getVisibleAmount()) / 2);
        }
    };
    JButton bttPageSetup = new JButton(OpenSwingUtil.getOpenSwingImage("page.gif", new ImageIcon()));
    JButton bttConfirm = new JButton();
    JComboBox boxResize = new JComboBox<String>(new String[]{"500%", "250%", "150%", "100%", "75%", "50%", "25%", "10%", OpenSwingUtil.getOpenResource("PageWidth"), OpenSwingUtil.getOpenResource("FontWidth"), OpenSwingUtil.getOpenResource("OnePage"), OpenSwingUtil.getOpenResource("DoublePage")});
    MultiPagePopup popupMulti = new MultiPagePopup();
    boolean popupIsLastClick = false;
    Window owner;
    JPanel[] pPreviews;

    public PrintOptionDialog(Window owner, String title) {
        super(title);
        this.owner = owner;
        this.boxResize.setMaximumSize(new Dimension(200, 33));
        this.boxResize.setMinimumSize(new Dimension(200, 33));
        this.boxResize.setPreferredSize(new Dimension(200, 33));
        this.boxResize.addActionListener(this);
        this.toolbar.add((Component)this.bttPageSetup, null);
        this.toolbar.add((Component)this.bttPrint, null);
        this.toolbar.add((Component)this.bttSingle, null);
        this.toolbar.add((Component)this.bttMulti, null);
        this.toolbar.add((Component)this.boxResize, null);
        this.toolbar.add((Component)this.bttConfirm, null);
        this.bttConfirm.setMaximumSize(new Dimension(60, 33));
        this.bttConfirm.setMinimumSize(new Dimension(60, 33));
        this.bttConfirm.setPreferredSize(new Dimension(60, 33));
        this.bttSingle.addActionListener(this);
        this.bttMulti.addActionListener(this);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.getContentPane().add((Component)this.sp, "Center");
        this.canvas.setLayout(new BoxLayout(this.canvas, 3));
        this.popupMulti.setAction(new PopupAction());
        this.boxResize.setSelectedIndex(10);
        this.sp.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                PrintOptionDialog.this.layoutPreview();
            }
        });
    }

    public void setActions(Action confirmAction, Action printAction, Action pageSetAction) {
        this.bttConfirm.setAction(confirmAction);
        this.bttPrint.addActionListener(printAction);
        this.bttPageSetup.addActionListener(pageSetAction);
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setBook(Book book) {
        this.book = book;
        this.pPreviews = this.getPreviewPanel(book);
        this.layoutPreview();
    }

    private JPanel[] getPreviewPanel(Book book) {
        JPanel[] result = new JPanel[book.getNumberOfPages()];
        int i = 0;
        while (i < book.getNumberOfPages()) {
            PreviewCanvas previewCanvas = new PreviewCanvas(book, i);
            previewCanvas.setBackground(Color.white);
            previewCanvas.setPreferredSize(new Dimension((int)this.pageFormat.getWidth(), (int)this.pageFormat.getHeight()));
            JPanel p = new JPanel(new BorderLayout());
            p.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 3));
            p.setBackground(Color.gray);
            p.add(previewCanvas);
            result[i] = p;
            ++i;
        }
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.bttMulti) {
            this.popupMulti.show(this.bttMulti, 0, this.bttMulti.getHeight());
        } else if (obj == this.bttSingle) {
            this.boxResize.setSelectedIndex(10);
        } else if (obj == this.boxResize) {
            this.popupIsLastClick = false;
            this.layoutPreview();
        }
    }

    public void layoutPreview() {
        if (this.pageFormat == null || this.pPreviews == null || this.pPreviews.length == 0) {
            return;
        }
        int spW = this.sp.getWidth() - this.sp.getVerticalScrollBar().getWidth() - 20;
        int spH = this.sp.getHeight() - this.sp.getHorizontalScrollBar().getHeight() - 20;
        double pw = this.pageFormat.getWidth();
        double ph = this.pageFormat.getHeight();
        int col = 0;
        int row = 1;
        int w = this.getPreviewWidth();
        int h = (int)(ph * (double)w / pw);
        this.canvas.removeAll();
        if (this.popupIsLastClick || this.boxResize.getSelectedIndex() > 9 || w < spW / 2) {
            if (this.popupIsLastClick) {
                col = this.popupMulti.getVerticalPages();
                row = this.popupMulti.getHorizontalPages();
            } else {
                col = this.boxResize.getSelectedIndex() == 10 ? 1 : (this.boxResize.getSelectedIndex() == 11 ? 2 : spW / w);
            }
            boolean isSingleLine = false;
            if (w > h) {
                w = spW / col;
                h = (int)(ph * (double)w / pw);
            } else {
                h = spH / row;
                w = (int)(pw * (double)h / ph);
                if (w * col >= spW) {
                    isSingleLine = true;
                    w = spW / col;
                    h = (int)(ph * (double)w / pw);
                }
            }
            if (col * row < this.pPreviews.length) {
                row = this.pPreviews.length / col + (this.pPreviews.length % col == 0 ? 0 : 1);
            }
            int index = 0;
            int i = 0;
            while (i < row) {
                JPanel p = new JPanel();
                int j = 0;
                while (j < col) {
                    if (index == this.pPreviews.length) break;
                    p.add(this.pPreviews[index]);
                    this.pPreviews[index].setPreferredSize(new Dimension(w, h));
                    ++index;
                    ++j;
                }
                if (isSingleLine || row == 1) {
                    p.setPreferredSize(new Dimension(spW + 20, spH + 20));
                    p.setBorder(BorderFactory.createEmptyBorder((spH + 20 - h) / 2, -50, 0, -50));
                }
                if (p.getComponentCount() != 0) {
                    this.canvas.add(p);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.pPreviews.length) {
                JPanel p = new JPanel();
                p.add(this.pPreviews[i]);
                this.pPreviews[i].setPreferredSize(new Dimension(w, h));
                this.canvas.add(p);
                ++i;
            }
        }
        this.canvas.setSize(this.canvas.getPreferredSize());
        this.canvas.validate();
        System.gc();
    }

    int getPreviewWidth() {
        int spW = this.sp.getWidth() - this.sp.getVerticalScrollBar().getWidth() - 20;
        int spH = this.sp.getHeight() - this.sp.getHorizontalScrollBar().getHeight() - 20;
        double w = this.pageFormat.getWidth();
        double h = this.pageFormat.getHeight();
        double[] fScale = new double[]{5.0, 2.5, 1.5, 1.0, 0.75, 0.5, 0.25, 0.1};
        int index = this.boxResize.getSelectedIndex();
        if (index < fScale.length) {
            return (int)(w * fScale[index]);
        }
        if (index == 8) {
            return spW;
        }
        if (index == 9) {
            double d = this.pageFormat.getImageableWidth();
            return (int)(w * (double)spW / d) - 20;
        }
        if (index == 10) {
            if (w > h) {
                return spW;
            }
            return (int)(w * (double)spH / h);
        }
        if (w > h) {
            return spW / 2;
        }
        return (int)(w * (double)spH / h / 2.0);
    }

    class PopupAction
    extends AbstractAction {
        PopupAction() {
        }

        public void actionPerformed(ActionEvent e) {
            PrintOptionDialog.this.popupIsLastClick = true;
            PrintOptionDialog.this.layoutPreview();
        }
    }
}

