/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import softcore.awt.DialogInputValidCheck;
import softcore.util.Utilities;

public class DefaultDialogInputValidCheck
implements DialogInputValidCheck {
    JComponent component;
    int checkType;
    int checkFlags;

    public DefaultDialogInputValidCheck(JComponent jcomponent, int i, int j) {
        this.component = jcomponent;
        this.checkType = i;
        this.checkFlags = j;
    }

    public DefaultDialogInputValidCheck(JComponent jcomponent, int i) {
        this(jcomponent, i >> 16, i & 0xFFFF);
    }

    public boolean isValid() {
        if (this.component instanceof JTextComponent) {
            String s = ((JTextComponent)this.component).getText();
            if (this.checkType == 2) {
                return Utilities.isValidNumber(s, this.checkFlags);
            }
            if (this.checkType == 1) {
                return s != null && s.trim().length() > 0;
            }
            if (this.checkType == 3) {
                if (s == null || s.trim().length() == 0) {
                    return (this.checkFlags & 1) == 0;
                }
                return Utilities.parseDate(s.trim(), null);
            }
        }
        if (this.component instanceof JList) {
            ListSelectionModel listselectionmodel = ((JList)this.component).getSelectionModel();
            if (this.checkType == 5) {
                return listselectionmodel.getMinSelectionIndex() >= 0 && listselectionmodel.getMaxSelectionIndex() >= 0;
            }
            if (this.checkType == 6) {
                return listselectionmodel.getMinSelectionIndex() >= 0 && listselectionmodel.getMinSelectionIndex() == listselectionmodel.getMaxSelectionIndex();
            }
        }
        if (this.component instanceof JTree) {
            TreePath[] atreepath = ((JTree)this.component).getSelectionPaths();
            if (this.checkType == 5) {
                return atreepath != null && atreepath.length > 0;
            }
            if (this.checkType == 6) {
                return atreepath != null && atreepath.length == 1;
            }
        }
        return true;
    }
}

