/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import softcore.util.Utilities;

public class DragableTree
extends JTree
implements MouseListener,
MouseMotionListener {
    private DefaultMutableTreeNode rootNode = null;
    protected DefaultTreeModel treeModel = null;
    private boolean bCanDragable = true;
    private boolean m_bDragging;
    private boolean m_bPrepareDragging = false;
    private DefaultMutableTreeNode m_hitemDrag = null;
    private DefaultMutableTreeNode m_hitemDrop = null;
    public boolean canDragOutsideRoot = true;
    private Rectangle itemRect = new Rectangle();
    private int itemWidth;
    private int itemHeight;
    private String szItemName = null;
    private Icon imgIcon = null;
    private TreePath preSelPath = null;

    public DragableTree() {
        this.rootNode = new DefaultMutableTreeNode("root");
        this.treeModel = (DefaultTreeModel)this.getModel();
        this.treeModel.setRoot(this.rootNode);
        this.setRootVisible(false);
        TreeSelectionModel treeselectionmodel = this.getSelectionModel();
        treeselectionmodel.setSelectionMode(1);
        this.setSelectionModel(treeselectionmodel);
        DefaultTreeCellRenderer defaulttreecellrenderer = (DefaultTreeCellRenderer)this.getCellRenderer();
        if (defaulttreecellrenderer != null) {
            ImageIcon imageicon = null;
            try {
                imageicon = Utilities.createImageIconFromResource("res/treeleaf.jpg");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (imageicon != null) {
                defaulttreecellrenderer.setLeafIcon(imageicon);
            }
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.m_bPrepareDragging = false;
        this.m_bDragging = false;
    }

    public void setDragable(boolean flag) {
        this.bCanDragable = flag;
    }

    public boolean isDraging() {
        return this.m_bDragging;
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent mouseevent) {
        if (!this.bCanDragable) {
            return;
        }
        this.m_hitemDrag = null;
        this.m_hitemDrop = null;
        if (!this.m_bPrepareDragging && (mouseevent.getModifiers() & 0x10) > 0) {
            Point point = mouseevent.getPoint();
            this.m_hitemDrag = this.getNodeByPosition(point, this.itemRect);
            if (this.m_hitemDrag != null) {
                this.m_bPrepareDragging = true;
                this.szItemName = this.m_hitemDrag.getUserObject().toString();
                this.itemWidth = this.itemRect.width;
                this.itemHeight = this.itemRect.height + 2;
                this.itemRect.setBounds(point.x, point.y, this.itemWidth, this.itemHeight);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseevent) {
        if (this.m_bPrepareDragging) {
            this.m_bDragging = true;
            this.m_hitemDrop = null;
            this.repaint(this.itemRect.x - 1, this.itemRect.y - 1, this.itemWidth + 2, this.itemHeight + 2);
            Point point = mouseevent.getPoint();
            DefaultMutableTreeNode defaultmutabletreenode = this.getNodeByPosition(point, null);
            if (defaultmutabletreenode != null) {
                this.m_hitemDrop = defaultmutabletreenode;
            }
            this.itemRect.setBounds(point.x, point.y, this.itemWidth, this.itemHeight);
            this.repaint(this.itemRect.x - 1, this.itemRect.y - 1, this.itemWidth + 2, this.itemHeight + 2);
        }
    }

    public void mouseMoved(MouseEvent mouseevent) {
    }

    public void mouseReleased(MouseEvent mouseevent) {
        if (this.m_bDragging && (mouseevent.getModifiers() & 0x10) > 0) {
            this.repaint(this.itemRect.x - 1, this.itemRect.y - 1, this.itemWidth + 2, this.itemHeight + 2);
            if (this.canDragOutsideRoot && this.m_hitemDrop == null) {
                this.m_hitemDrop = (DefaultMutableTreeNode)this.treeModel.getRoot();
            }
            if (this.m_hitemDrag != null && this.m_hitemDrop != null && this.m_hitemDrag != this.m_hitemDrop && !this.isChildNodeOf(this.m_hitemDrop, this.m_hitemDrag) && ((DefaultMutableTreeNode)this.m_hitemDrag.getParent() != this.m_hitemDrop || mouseevent.isControlDown()) && this.canMove(this.m_hitemDrag, this.m_hitemDrop)) {
                DefaultMutableTreeNode defaultmutabletreenode = null;
                if (mouseevent.isControlDown()) {
                    defaultmutabletreenode = this.transferItem(this.m_hitemDrag, this.m_hitemDrop, true);
                } else if (mouseevent.isAltDown()) {
                    defaultmutabletreenode = this.transferItem(this.m_hitemDrag, this.m_hitemDrop, false);
                } else {
                    defaultmutabletreenode = this.transferItem(this.m_hitemDrag, this.m_hitemDrop, true);
                    this.treeModel.removeNodeFromParent(this.m_hitemDrag);
                }
                this.setSelectedNode(defaultmutabletreenode);
            } else if (this.preSelPath != null) {
                this.setSelectionPath(this.preSelPath);
                this.preSelPath = null;
            }
        }
        this.m_hitemDrop = null;
        this.m_hitemDrag = null;
        this.m_bPrepareDragging = false;
        this.m_bDragging = false;
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent mouseevent) {
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.m_bDragging && !this.itemRect.isEmpty()) {
            g.setColor(Color.black);
            int i = 0;
            int j = 0;
            if (this.imgIcon != null) {
                j = this.itemRect.y + (this.itemHeight - this.imgIcon.getIconHeight()) / 2;
                i = this.itemRect.x + this.imgIcon.getIconWidth() + 2;
                this.imgIcon.paintIcon(this, g, this.itemRect.x, j);
            }
            g.drawString(this.szItemName, i, j += 12);
        }
    }

    private DefaultMutableTreeNode getNodeByPosition(Point point, Rectangle rectangle) {
        TreePath treepath = this.getPathForLocation(point.x, point.y);
        DefaultMutableTreeNode defaultmutabletreenode = null;
        if (treepath != null) {
            defaultmutabletreenode = (DefaultMutableTreeNode)treepath.getLastPathComponent();
            if (rectangle != null) {
                this.preSelPath = treepath;
                rectangle = this.getPathBounds(treepath);
                this.itemRect.width = (int)rectangle.getWidth();
                this.itemRect.height = (int)rectangle.getHeight();
                DefaultTreeCellRenderer defaulttreecellrenderer = (DefaultTreeCellRenderer)this.getCellRenderer();
                if (defaulttreecellrenderer != null) {
                    this.imgIcon = defaultmutabletreenode.isLeaf() ? defaulttreecellrenderer.getLeafIcon() : (this.isExpanded(treepath) ? defaulttreecellrenderer.getOpenIcon() : defaulttreecellrenderer.getClosedIcon());
                }
            } else {
                this.setSelectionPath(treepath);
            }
        }
        return defaultmutabletreenode;
    }

    private DefaultMutableTreeNode transferItem(DefaultMutableTreeNode defaultmutabletreenode, DefaultMutableTreeNode defaultmutabletreenode1, boolean flag) {
        DefaultMutableTreeNode defaultmutabletreenode2 = new DefaultMutableTreeNode(defaultmutabletreenode.getUserObject());
        this.treeModel.insertNodeInto(defaultmutabletreenode2, defaultmutabletreenode1, defaultmutabletreenode1.getChildCount());
        if (!defaultmutabletreenode.isLeaf() && flag) {
            int i = 0;
            while (i < defaultmutabletreenode.getChildCount()) {
                DefaultMutableTreeNode defaultmutabletreenode3 = (DefaultMutableTreeNode)defaultmutabletreenode.getChildAt(i);
                this.transferItem(defaultmutabletreenode3, defaultmutabletreenode2, flag);
                ++i;
            }
        }
        return defaultmutabletreenode2;
    }

    boolean isChildNodeOf(DefaultMutableTreeNode defaultmutabletreenode, DefaultMutableTreeNode defaultmutabletreenode1) {
        DefaultMutableTreeNode defaultmutabletreenode2 = defaultmutabletreenode;
        while (defaultmutabletreenode2 != defaultmutabletreenode1 && (defaultmutabletreenode2 = (DefaultMutableTreeNode)defaultmutabletreenode2.getParent()) != null) {
        }
        return defaultmutabletreenode2 != null;
    }

    boolean canMove(DefaultMutableTreeNode defaultmutabletreenode, DefaultMutableTreeNode defaultmutabletreenode1) {
        return true;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath treepath = this.getSelectionPath();
        DefaultMutableTreeNode defaultmutabletreenode = null;
        if (treepath != null) {
            defaultmutabletreenode = (DefaultMutableTreeNode)treepath.getLastPathComponent();
        }
        return defaultmutabletreenode;
    }

    public int getRowForTreeNode(DefaultMutableTreeNode defaultmutabletreenode) {
        if (defaultmutabletreenode != null) {
            TreePath treepath;
            int i = 0;
            while ((treepath = this.getPathForRow(i)) != null) {
                if (defaultmutabletreenode == (DefaultMutableTreeNode)treepath.getLastPathComponent()) {
                    return i + 1;
                }
                ++i;
            }
        }
        return -1;
    }

    public void setSelectedNode(DefaultMutableTreeNode defaultmutabletreenode) {
        int i = this.getRowForTreeNode(defaultmutabletreenode);
        if (i >= 1) {
            this.setSelectionRow(i - 1);
        }
    }

    public void expandAllItem() {
        TreePath treepath;
        int i = 0;
        while ((treepath = this.getPathForRow(i)) != null) {
            this.expandPath(treepath);
            ++i;
        }
    }
}

