/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.TableDataSet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import softcore.awt.ScrollBarPanel;
import softcore.awt.chart.BarChart;
import softcore.awt.chart.Chart;
import softcore.awt.chart.ChartComponent;
import softcore.awt.chart.ChartStyleDialogPanel;
import softcore.awt.chart.LineChart;
import softcore.awt.chart.PieChart;
import softcore.print.Print;
import softcore.print.PrintFormat;
import softcore.table.GridTable;
import softcore.table.TableColumn;
import softcore.util.Utilities;
import softface.MainFrame;

public class GraphData {
    double[][] values;
    String[] groupId;
    String[] itemId;
    String[] groupText;
    String[] itemText;
    int graphType;
    int graphStyle = -1;
    String titleGroupId;
    String titleItemId;
    String titleGroupText;
    String titleItemText;
    String dataTitle = "\u6570\u636e";
    String title;
    boolean groupIdInteger;
    boolean itemIdInteger;
    public boolean displayItemId = true;
    public boolean displayGroupId = true;
    public int dataTotalMode;
    public QueryDetail queryDetail;
    private String[] popupMenuItemText;
    private String[] popupMenuItemCommands;
    private ActionListener[] popupMenuItemListener;

    public String[] getGroupId() {
        return this.groupId;
    }

    public String[] getItemId() {
        return this.itemId;
    }

    public String[] getGroupText() {
        return this.groupText;
    }

    public String[] getItemText() {
        return this.itemText;
    }

    public double[][] getValues() {
        return this.values;
    }

    public void setValues(double[][] ad) {
        this.values = ad;
    }

    public void setDataTitle(String s) {
        this.dataTitle = s;
    }

    public String getDataTitle() {
        return this.dataTitle;
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public String getTitle() {
        return this.title;
    }

    public void setGraphType(int i) {
        this.graphType = i;
    }

    public int getGraphType() {
        return this.graphType;
    }

    public void setGraphStyle(int i) {
        this.graphStyle = i;
    }

    public int getGraphStyle() {
        return this.graphStyle;
    }

    public void setTitleGroupId(String s) {
        this.titleGroupId = s;
    }

    public void setTitleItemId(String s) {
        this.titleItemId = s;
    }

    public void setTitleGroupText(String s) {
        this.titleGroupText = s;
    }

    public void setTitleItemText(String s) {
        this.titleItemText = s;
    }

    public void setGroupIdInteger(boolean flag) {
        this.groupIdInteger = flag;
    }

    public void setItemIdInteger(boolean flag) {
        this.itemIdInteger = flag;
    }

    public int countValueGroups() {
        return this.values != null ? this.values.length : 0;
    }

    public int countValueItems() {
        if (this.values == null) {
            return 0;
        }
        int i = 0;
        int j = 0;
        while (j < this.values.length) {
            int k;
            int n = k = this.values[j] != null ? this.values[j].length : 0;
            if (i < k) {
                i = k;
            }
            ++j;
        }
        return i;
    }

    public String getItemText(int i, int j) {
        String s1;
        String s = this.groupText == null || i >= this.groupText.length ? null : this.groupText[i];
        String string = s1 = this.itemText == null || j >= this.itemText.length ? null : this.itemText[j];
        return s != null ? (s1 != null ? String.valueOf(s) + '.' + s1 : s) : s1;
    }

    public double getValue(int i, int j) {
        if (this.values == null || i < 0 || i >= this.values.length || j < 0) {
            return 0.0;
        }
        if (this.values[i] == null || j >= this.values[i].length) {
            return 0.0;
        }
        return this.values[i][j];
    }

    public void setValue(int i, int j, double d) {
        if (this.values == null || this.values.length <= i) {
            double[][] ad = this.values;
            this.values = new double[i + 1][];
            if (ad != null) {
                System.arraycopy(ad, 0, this.values, 0, ad.length);
            }
        }
        if (this.values[i] == null || this.values[i].length <= j) {
            double[] ad1 = this.values[i];
            this.values[i] = new double[j + 1];
            if (ad1 != null) {
                System.arraycopy(ad1, 0, this.values[i], 0, ad1.length);
            }
        }
        this.values[i][j] = d;
    }

    public void setGroupText(String s, int i) {
        this.groupText = Utilities.setStringArrayElement(this.groupText, s, i);
    }

    public void setGroupId(String s, int i) {
        this.groupId = Utilities.setStringArrayElement(this.groupId, s, i);
    }

    public void setGroupId(String[] as) {
        this.groupId = as;
    }

    public void setGroupText(String[] as) {
        this.groupText = as;
    }

    public void setItemText(String s, int i) {
        this.itemText = Utilities.setStringArrayElement(this.itemText, s, i);
    }

    public void setItemId(String s, int i) {
        this.itemId = Utilities.setStringArrayElement(this.itemId, s, i);
    }

    public void setItemText(String[] as) {
        this.itemText = as;
    }

    public void setItemId(String[] as) {
        this.itemId = as;
    }

    public TableDataSet createTableDataSet() throws DataSetException {
        TableDataSet tabledataset = new TableDataSet();
        Column column = new Column("groupid", this.titleGroupId != null ? this.titleGroupId : "groupid", this.groupIdInteger ? 4 : 16);
        tabledataset.addColumn(column);
        column = new Column("grouptext", this.titleGroupText != null ? this.titleGroupText : "grouptext", 16);
        tabledataset.addColumn(column);
        column = new Column("itemid", this.titleItemId != null ? this.titleItemId : "itemid", this.itemIdInteger ? 4 : 16);
        tabledataset.addColumn(column);
        column = new Column("itemtext", this.titleItemText != null ? this.titleItemText : "itemtext", 16);
        tabledataset.addColumn(column);
        column = new Column("data", this.dataTitle, 7);
        tabledataset.addColumn(column);
        tabledataset.open();
        int i = this.countValueGroups();
        int j = this.countValueItems();
        double d = 0.0;
        int k = 0;
        while (k < i) {
            double d1 = 0.0;
            int l = 0;
            while (l < j) {
                tabledataset.insertRow(false);
                if (l == 0) {
                    if (this.groupId != null && this.groupId.length > k) {
                        if (this.groupIdInteger) {
                            try {
                                tabledataset.setInt(0, Integer.parseInt(this.groupId[k].trim()));
                            }
                            catch (Exception exception) {}
                        } else {
                            tabledataset.setString(0, this.groupId[k]);
                        }
                    }
                    if (this.groupText != null && this.groupText.length > k) {
                        tabledataset.setString(1, this.groupText[k]);
                    }
                }
                if (this.itemId != null && this.itemId.length > l) {
                    if (this.itemIdInteger) {
                        try {
                            tabledataset.setInt(2, Integer.parseInt(this.itemId[l].trim()));
                        }
                        catch (Exception exception) {}
                    } else {
                        tabledataset.setString(2, this.itemId[l]);
                    }
                }
                if (this.itemText != null && this.itemText.length > l) {
                    tabledataset.setString(3, this.itemText[l]);
                }
                if (this.values != null && this.values.length > k && this.values[k] != null && this.values[k].length > l && this.values[k][l] != 0.0) {
                    tabledataset.setDouble(4, this.values[k][l]);
                    d1 += this.values[k][l];
                }
                tabledataset.post();
                ++l;
            }
            if (j > 1 && (this.dataTotalMode & 1) != 0) {
                tabledataset.insertRow(false);
                tabledataset.setString(3, "\u5408\u8ba1");
                tabledataset.setDouble(4, d1);
                tabledataset.post();
            }
            d += d1;
            ++k;
        }
        if (i > 1 && (this.dataTotalMode & 2) != 0) {
            tabledataset.insertRow(false);
            tabledataset.setString(1, "\u5408\u8ba1");
            tabledataset.setDouble(4, d);
            tabledataset.post();
        }
        return tabledataset;
    }

    public GridTable createGridTable() throws DataSetException {
        TableDataSet tabledataset = this.createTableDataSet();
        DataTable datatable = new DataTable(this.countValueGroups(), this.countValueItems(), this.queryDetail);
        datatable.setDataSet((DataSet)tabledataset);
        datatable.initial();
        TableColumn[] atablecolumn = datatable.getTableColumns();
        if (atablecolumn == null || atablecolumn.length != 5) {
            throw new RuntimeException();
        }
        if (this.titleGroupId == null) {
            atablecolumn[0].setOptions(1, true);
        } else if (!this.groupIdInteger) {
            atablecolumn[0].width = 64;
        }
        if (this.titleGroupText == null) {
            atablecolumn[1].setOptions(1, true);
        } else {
            atablecolumn[1].width = 144;
        }
        if (this.titleItemId == null) {
            atablecolumn[2].setOptions(1, true);
        }
        if (!this.itemIdInteger) {
            atablecolumn[2].width = 64;
        }
        atablecolumn[3].width = 144;
        atablecolumn[4].setMinDecimals(2);
        atablecolumn[4].setMaxDecimals(4);
        atablecolumn[4].setOptions(48, true);
        datatable.refreshPaint();
        datatable.setRwFlags(1, true);
        try {
            datatable.getDataSet().first();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return datatable;
    }

    private static double scaleRange(double d) {
        double d1;
        block6: {
            int i;
            block5: {
                if (d < 1.0E-8) {
                    return d;
                }
                i = 0;
                while (d > 100.0) {
                    d /= 10.0;
                    ++i;
                }
                while (d < 10.0) {
                    d *= 10.0;
                    --i;
                }
                int j = (int)d / 20;
                d1 = (int)d + (j > 0 ? j : 1);
                if (i <= 0) break block5;
                while (i > 0) {
                    d1 *= 10.0;
                    --i;
                }
                break block6;
            }
            if (i >= 0) break block6;
            while (i < 0) {
                d1 /= 10.0;
                ++i;
            }
        }
        return d1;
    }

    public Chart createChart() {
        Chart obj;
        int j;
        int i = this.values.length;
        int n = j = this.itemId != null ? this.itemId.length : 0;
        if (j == 0) {
            j = this.itemText != null ? this.itemText.length : 0;
        }
        double d = 0.0;
        double d1 = 0.0;
        int k = 0;
        while (k < i) {
            int l = 0;
            while (l < this.values[k].length) {
                double d2 = this.values[k][l];
                if (d2 > d) {
                    d = d2;
                }
                if (d2 < d1) {
                    d1 = d2;
                }
                ++l;
            }
            ++k;
        }
        d = GraphData.scaleRange(d);
        d1 = GraphData.scaleRange(d1);
        if (this.graphType == 1) {
            BarChart barchart;
            obj = barchart = new BarChart(i, j, d, d1);
            ChartStyleDialogPanel.setBarChartValue(barchart, this.graphStyle);
            barchart.setBarLabelStyle(2);
        } else if (this.graphType == 2) {
            PieChart piechart = new PieChart(i, j);
            obj = piechart;
            ChartStyleDialogPanel.setPieChartValue(piechart, this.graphStyle);
        } else if (this.graphType == 3) {
            LineChart linechart = new LineChart(i, j, d, d1);
            obj = linechart;
            linechart.setSampleHighlightOn(true);
            ChartStyleDialogPanel.setLineChartValue(linechart, this.graphStyle);
            int j1 = 0;
            while (j1 < i) {
                int i2 = j1 % 9;
                i2 = i2 / 3 + i2 % 3 * 3;
                linechart.setSampleHighlightStyle(j1, i2, 9);
                ++j1;
            }
        } else {
            return null;
        }
        int i1 = 0;
        while (i1 < i) {
            ((Chart)obj).setSampleValues(i1, this.values[i1]);
            ++i1;
        }
        if (this.groupId != null) {
            int k1 = 0;
            while (k1 < this.groupId.length) {
                ((Chart)obj).setSeriesLabel(k1, this.groupText == null || this.groupText[k1] == null || this.groupText[k1].equals(this.groupId[k1]) ? this.groupId[k1] : (this.displayGroupId ? String.valueOf(this.groupId[k1]) + ":" + this.groupText[k1] : this.groupText[k1]));
                ++k1;
            }
        } else if (this.groupText != null) {
            ((Chart)obj).setSeriesLabels(this.groupText);
        }
        if (this.itemId != null) {
            int l1 = 0;
            while (l1 < this.itemId.length) {
                ((Chart)obj).setSampleLabel(l1, this.itemText == null || this.itemText[l1] == null || this.itemText[l1].equals(this.itemId[l1]) ? this.itemId[l1] : (this.displayItemId ? String.valueOf(this.itemId[l1]) + ":" + this.itemText[l1] : this.itemText[l1]));
                ++l1;
            }
        } else if (this.itemText != null) {
            ((Chart)obj).setSampleLabels(this.itemText);
        }
        if (this.title != null) {
            ((Chart)obj).setTitle(this.title);
            ((Chart)obj).setTitleOn(true);
        }
        return obj;
    }

    public JComponent createChartComponent() {
        return this.createChartComponent(null);
    }

    public JComponent createChartComponent(ChartComponent chartcomponent) {
        if (chartcomponent == null) {
            chartcomponent = new ChartComponent();
        }
        chartcomponent.setGraphData(this);
        chartcomponent.setChart(this.createChart());
        if (this.popupMenuItemText != null) {
            int i = 0;
            while (i < this.popupMenuItemText.length) {
                chartcomponent.addPopupMenuItem(this.popupMenuItemText[i], this.popupMenuItemCommands != null ? this.popupMenuItemCommands[i] : null, this.popupMenuItemListener[i]);
                ++i;
            }
        }
        chartcomponent.setChartAutoResize(true);
        return chartcomponent;
    }

    public void setPupupMenuItems(String[] as, String[] as1, ActionListener[] aactionlistener) {
        this.popupMenuItemText = as;
        this.popupMenuItemCommands = as1;
        this.popupMenuItemListener = aactionlistener;
    }

    public void createInternalFrame() throws DataSetException {
        MainFrame.getDesktopPane().createInternalFrame(this.title, this.createTabbedPane());
    }

    public JTabbedPane createTabbedPane() throws DataSetException {
        JTabbedPane jtabbedpane = new JTabbedPane();
        ImageIcon imageicon = null;
        try {
            imageicon = Utilities.createImageIconFromResource("res/icon20_graph.jpg");
        }
        catch (Exception exception) {
            // empty catch block
        }
        jtabbedpane.addTab("\u56fe\u5f62", imageicon, new JScrollPane(this.createChartComponent()));
        GridTable gridtable = this.createGridTable();
        jtabbedpane.addChangeListener(gridtable);
        try {
            imageicon = Utilities.createImageIconFromResource("res/icon20_table.jpg");
        }
        catch (Exception exception) {
            // empty catch block
        }
        jtabbedpane.addTab("\u6570\u636e", imageicon, new ScrollBarPanel(gridtable, 3));
        return jtabbedpane;
    }

    public void printGraph(int i) throws DataSetException, PrintFormat.PrintFormatErrorException {
        this.printGraph(i, 1, null);
    }

    public void printGraph(int i, int j, String s) throws DataSetException, PrintFormat.PrintFormatErrorException {
        if (s == null) {
            s = "\u56fe\u5f62/\u56fe\u5f62:%";
        }
        TableDataSet tabledataset = this.createTableDataSet();
        Print print = new Print();
        print.setRwObject(tabledataset, true);
        Column[] acolumn = tabledataset.getColumns();
        String[] as = new String[]{"\u7ec4\u6807\u8bc6", "\u7ec4\u8bf4\u660e", "\u9879\u76ee\u6807\u8bc6", "\u9879\u76ee\u8bf4\u660e", "\u6570\u636e"};
        int k = 0;
        while (k < 5) {
            print.addRwName(0, as[k], acolumn[k].getColumnName());
            ++k;
        }
        int l = this.countValueGroups();
        int i1 = this.countValueItems();
        print.addDefaultGlobalVar("title", this.title);
        print.defineMacro("\u6807\u9898", "title");
        print.defineMacro("\u7ec4\u6570", l);
        print.defineMacro("COUNTGROUPS", l);
        print.defineMacro("\u9879\u76ee\u6570", i1);
        print.defineMacro("COUNTITEMS", i1);
        print.defineMacro("\u7ec4\u53f7", "getRowGetData()/" + i1);
        print.defineMacro("\u9879\u76ee\u53f7", "mod(getRowGetData()," + i1 + ")");
        print.defineMacro("GRAPHTYPE", this.graphType);
        print.addDefaultGlobalVar("groupId", this.groupId);
        print.addDefaultGlobalVar("itemId", this.itemId);
        print.addDefaultGlobalVar("groupText", this.groupText);
        print.addDefaultGlobalVar("itemText", this.itemText);
        print.addDefaultGlobalVar("values", this.values);
        print.addDefaultGlobalVar("graphData", this);
        if (!print.loadFromDef(i, j, s)) {
            return;
        }
        print.setDefaultGraphObject(this.createChart());
        if (print.preparePrint()) {
            print.preview(this.title);
        }
    }

    static class DataTable
    extends GridTable {
        final int countGroup;
        final int countItem;
        final QueryDetail queryDetail;

        public void actionPerformed(ActionEvent actionevent) {
            super.actionPerformed(actionevent);
            if ("viewdetail".equals(actionevent.getActionCommand()) && this.queryDetail != null) {
                try {
                    int i = this.dataSet.getRow();
                    this.queryDetail.gi = i / this.countItem;
                    this.queryDetail.ii = i % this.countItem;
                    this.queryDetail.queryDetail();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        DataTable(int i, int j, QueryDetail querydetail) {
            this.countGroup = i;
            this.countItem = j;
            this.queryDetail = querydetail;
            if (querydetail != null) {
                this.setAcceptActionCommands(new String[]{"viewdetail"});
            }
        }
    }

    public static abstract class QueryDetail {
        public int gi;
        public int ii;

        public abstract void queryDetail();
    }
}

