/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import softcore.util.Message;
import softface.MainApp;

public class HtmlShowPanel
extends JPanel
implements HyperlinkListener {
    JEditorPane html;

    public HtmlShowPanel() {
        this((URL)null);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkevent) {
        if (hyperlinkevent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(hyperlinkevent.getURL());
        }
    }

    protected void linkActivated(URL url) {
        Cursor cursor = this.html.getCursor();
        Cursor cursor1 = Cursor.getPredefinedCursor(3);
        this.html.setCursor(cursor1);
        SwingUtilities.invokeLater(new PageLoader(url, cursor));
    }

    public void showURL(URL url) {
        block3: {
            if (url != null) {
                try {
                    this.html.setPage(url);
                }
                catch (IOException ioexception) {
                    Message.out.println("Can not load " + url);
                    if (!MainApp.isDebug) break block3;
                    Message.printException(ioexception, true);
                }
            }
        }
    }

    public HtmlShowPanel(URL url) {
        this.setLayout(new BorderLayout());
        this.html = new JEditorPane();
        this.html.setEditable(false);
        this.html.addHyperlinkListener(this);
        this.html.setContentType("text/html;charset=gb2312");
        JScrollPane jscrollpane = new JScrollPane();
        JViewport jviewport = jscrollpane.getViewport();
        jviewport.add(this.html);
        jviewport.setScrollMode(2);
        this.add((Component)jscrollpane, "Center");
        this.showURL(url);
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (this.url == null) {
                HtmlShowPanel.this.html.setCursor(this.cursor);
                Container container = HtmlShowPanel.this.html.getParent();
                container.repaint();
                return;
            }
            Document document = HtmlShowPanel.this.html.getDocument();
            try {
                try {
                    HtmlShowPanel.this.html.setPage(this.url);
                }
                catch (IOException ioexception) {
                    HtmlShowPanel.this.html.setDocument(document);
                    HtmlShowPanel.this.getToolkit().beep();
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.url = null;
                SwingUtilities.invokeLater(this);
                throw throwable;
            }
            {
                Object var3_6 = null;
                this.url = null;
            }
            SwingUtilities.invokeLater(this);
        }

        PageLoader(URL url1, Cursor cursor1) {
            this.url = url1;
            this.cursor = cursor1;
        }
    }
}

