/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import softcore.util.Utilities;

public class JDragableCheckList
extends JList
implements KeyListener,
MouseListener,
MouseMotionListener {
    private boolean dragable;
    private boolean checkable;
    private boolean checkEditable = true;
    private Icon[] icons;
    protected int indexSelected = -1;
    public boolean mutiSelectOnControlKeyDown = true;

    public JDragableCheckList() {
        this(true, true);
    }

    public JDragableCheckList(boolean flag, boolean flag1) {
        this(flag, flag1, true);
    }

    public JDragableCheckList(boolean flag, boolean flag1, boolean flag2) {
        super(new DefaultListModel());
        this.dragable = flag;
        this.checkable = flag1;
        this.setCellRenderer(flag1 ? new CheckListCellRenderer() : new LabelListCellRenderer());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.mutiSelectOnControlKeyDown = flag2;
    }

    public JDragableCheckList(boolean[] aflag, String[] as, Object[] aobj) {
        this(true, true);
        if (as != null) {
            int i = 0;
            while (i < as.length) {
                this.addItem(aflag != null && i < aflag.length && aflag[i], as[i], aobj == null || i >= aobj.length ? null : aobj[i]);
                ++i;
            }
        }
    }

    public JDragableCheckList(ListModel listmodel) {
        super(listmodel);
        this.setCellRenderer(new CheckListCellRenderer());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public JDragableCheckList(Object[] aobj) {
        super(aobj);
        this.setCellRenderer(new CheckListCellRenderer());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public JDragableCheckList(Vector vector) {
        super(vector);
        this.setCellRenderer(new CheckListCellRenderer());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public int getItemCount() {
        ListModel listmodel = this.getModel();
        return listmodel.getSize();
    }

    private Object[] createModelElement(int i, String s, Object obj) {
        Boolean ob = i == 0 ? null : Boolean.TRUE;
        return new Object[]{this.checkable ? (Comparable<Boolean>)ob : (Comparable<Boolean>)new Integer(i), s, obj};
    }

    private Object[] createModelElement(int i, String s, Object obj, boolean flag) {
        Boolean ob = i == 0 ? null : Boolean.TRUE;
        return new Object[]{this.checkable ? (Comparable<Boolean>)ob : (Comparable<Boolean>)new Integer(i), s, obj, flag ? Boolean.TRUE : null};
    }

    public void setItemAt(int i, boolean flag, String s) {
        this.setItemAt(i, flag, s, null);
    }

    public void setItemAt(int i, boolean flag, String s, Object obj) {
        ListModel listmodel = this.getModel();
        if (listmodel instanceof DefaultListModel) {
            ((DefaultListModel)listmodel).setElementAt(this.createModelElement(flag ? 1 : 0, s, obj), i);
        }
    }

    public void setItemAt(int i, boolean flag, String s, Object obj, boolean flag1) {
        ListModel listmodel = this.getModel();
        if (listmodel instanceof DefaultListModel) {
            ((DefaultListModel)listmodel).setElementAt(this.createModelElement(flag ? 1 : 0, s, obj, flag1), i);
        }
    }

    public void checkItemAt(int i, boolean flag) {
        ListModel listmodel = this.getModel();
        Object obj = listmodel.getElementAt(i);
        if (obj instanceof Object[] && ((Object[])obj).length >= 2) {
            ((Object[])obj)[0] = flag ? Boolean.TRUE : null;
            this.fireSelectionValueChanged(i, i, false);
        }
    }

    public void checkItemAt(int i, int j) {
        ListModel listmodel = this.getModel();
        Object obj = listmodel.getElementAt(i);
        if (obj instanceof Object[] && ((Object[])obj).length >= 2) {
            ((Object[])obj)[0] = new Integer(j);
            this.fireSelectionValueChanged(i, i, false);
        }
    }

    public void removeItemAt(int i) {
        ListModel listmodel = this.getModel();
        if (listmodel instanceof DefaultListModel) {
            ((DefaultListModel)listmodel).removeElementAt(i);
        }
    }

    public void removeAllItem() {
        ListModel listmodel = this.getModel();
        if (listmodel instanceof DefaultListModel) {
            ((DefaultListModel)listmodel).removeAllElements();
        }
    }

    public void insertItemAt(int i, boolean flag, String s) {
        this.insertItemAt(i, flag, s, null);
    }

    public void insertItemAt(int i, boolean flag, String s, Object obj) {
        ListModel listmodel = this.getModel();
        if (listmodel instanceof DefaultListModel) {
            ((DefaultListModel)listmodel).insertElementAt(this.createModelElement(flag ? 1 : 0, s, obj), i);
        }
    }

    public void insertItemAt(int i, boolean flag, String s, Object obj, boolean flag1) {
        ListModel listmodel = this.getModel();
        if (listmodel instanceof DefaultListModel) {
            ((DefaultListModel)listmodel).insertElementAt(this.createModelElement(flag ? 1 : 0, s, obj, flag1), i);
        }
    }

    public void addItem(boolean flag, String s) {
        this.addItem(flag, s, null);
    }

    public void addItem(boolean flag, String s, Object obj) {
        ListModel listmodel = this.getModel();
        if (listmodel instanceof DefaultListModel) {
            ((DefaultListModel)listmodel).addElement(this.createModelElement(flag ? 1 : 0, s, obj));
        }
    }

    public void addItem(int i, String s, Object obj) {
        ListModel listmodel = this.getModel();
        if (listmodel instanceof DefaultListModel) {
            ((DefaultListModel)listmodel).addElement(this.createModelElement(i, s, obj));
        }
    }

    public void addItem(boolean flag, String s, Object obj, boolean flag1) {
        ListModel listmodel = this.getModel();
        if (listmodel instanceof DefaultListModel) {
            ((DefaultListModel)listmodel).addElement(this.createModelElement(flag ? 1 : 0, s, obj, flag1));
        }
    }

    public void addItem(int i, String s, Object obj, boolean flag) {
        ListModel listmodel = this.getModel();
        if (listmodel instanceof DefaultListModel) {
            ((DefaultListModel)listmodel).addElement(this.createModelElement(i, s, obj, flag));
        }
    }

    public boolean isItemChecked(int i) {
        ListModel listmodel = this.getModel();
        Object obj = listmodel.getElementAt(i);
        if (obj instanceof Object[] && ((Object[])obj).length >= 2) {
            return ((Object[])obj)[0] instanceof Boolean && (Boolean)((Object[])obj)[0] != false;
        }
        return false;
    }

    public int getItemCheckedAsInt(int i) {
        ListModel listmodel = this.getModel();
        Object obj = listmodel.getElementAt(i);
        if (obj instanceof Object[] && ((Object[])obj).length >= 2) {
            if (((Object[])obj)[0] instanceof Boolean) {
                return (Boolean)((Object[])obj)[0] != false ? 1 : 0;
            }
            if (((Object[])obj)[0] instanceof Number) {
                return ((Number)((Object[])obj)[0]).intValue();
            }
        }
        return 0;
    }

    public void getItemChecked(boolean[] aflag) {
        if (aflag == null) {
            return;
        }
        ListModel listmodel = this.getModel();
        int i = listmodel.getSize();
        int j = 0;
        while (j < i && j < aflag.length) {
            Object obj = listmodel.getElementAt(j);
            aflag[j] = obj instanceof Object[] && ((Object[])obj).length >= 2 && ((Object[])obj)[0] instanceof Boolean && (Boolean)((Object[])obj)[0] != false;
            ++j;
        }
    }

    public int getCheckedCount() {
        int i = 0;
        int j = 0;
        while (j < this.getItemCount()) {
            if (this.isItemChecked(j)) {
                ++i;
            }
            ++j;
        }
        return i;
    }

    public boolean[] getItemChecked() {
        boolean[] aflag = new boolean[this.getModel().getSize()];
        this.getItemChecked(aflag);
        return aflag;
    }

    public int[] getIntValueItem(boolean flag) {
        ListModel listmodel = this.getModel();
        int i = listmodel.getSize();
        int[] ai = new int[i];
        int j = 0;
        int k = 0;
        while (k < i) {
            Object obj = listmodel.getElementAt(k);
            if (obj instanceof Object[] && ((Object[])obj).length >= 3 && (!flag || ((Object[])obj)[0] instanceof Boolean && ((Boolean)((Object[])obj)[0]).booleanValue()) && ((Object[])obj)[2] instanceof Number) {
                ai[j++] = ((Number)((Object[])obj)[2]).intValue();
            }
            ++k;
        }
        int[] ai1 = new int[j];
        System.arraycopy(ai, 0, ai1, 0, j);
        return ai1;
    }

    public void checkIntValueItem(int[] ai) {
        ListModel listmodel = this.getModel();
        int i = listmodel.getSize();
        int j = 0;
        while (j < i) {
            Object obj = listmodel.getElementAt(j);
            if (obj instanceof Object[] && ((Object[])obj).length >= 3) {
                boolean flag = ((Object[])obj)[2] instanceof Number && Utilities.linearSearch(ai, ((Number)((Object[])obj)[2]).intValue()) >= 0;
                ((Object[])obj)[0] = flag ? Boolean.TRUE : null;
                this.fireSelectionValueChanged(j, j, false);
            }
            ++j;
        }
    }

    public void setItemChecked(boolean[] aflag) {
        if (aflag == null) {
            return;
        }
        ListModel listmodel = this.getModel();
        int i = listmodel.getSize();
        int j = 0;
        while (j < i && j < aflag.length) {
            this.checkItemAt(j, aflag[j]);
            ++j;
        }
    }

    public String getItemText(int i) {
        ListModel listmodel = this.getModel();
        Object obj = listmodel.getElementAt(i);
        if (obj instanceof Object[] && ((Object[])obj).length >= 2) {
            return ((Object[])obj)[1] != null ? ((Object[])obj)[1].toString() : null;
        }
        return null;
    }

    public Object getItemValue(int i) {
        ListModel listmodel = this.getModel();
        Object obj = listmodel.getElementAt(i);
        if (obj instanceof Object[] && ((Object[])obj).length >= 3) {
            return ((Object[])obj)[2];
        }
        return null;
    }

    public boolean getItemEditdisable(int i) {
        ListModel listmodel = this.getModel();
        Object obj = listmodel.getElementAt(i);
        if (obj instanceof Object[] && ((Object[])obj).length >= 4) {
            return ((Object[])obj)[3] instanceof Boolean && (Boolean)((Object[])obj)[3] != false;
        }
        return false;
    }

    public int getItemIndexByValue(Object obj) {
        ListModel listmodel = this.getModel();
        int i = listmodel.getSize();
        int j = 0;
        while (j < i) {
            Object obj1 = listmodel.getElementAt(j);
            if (obj1 instanceof Object[] && ((Object[])obj1).length >= 3 && (obj == ((Object[])obj1)[2] || obj != null && obj.equals(((Object[])obj1)[2]))) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    public int getItemIndexByText(String s) {
        ListModel listmodel = this.getModel();
        int i = listmodel.getSize();
        int j = 0;
        while (j < i) {
            Object obj = listmodel.getElementAt(j);
            if (obj instanceof Object[] && ((Object[])obj).length >= 2 && (s == ((Object[])obj)[1] || s != null && s.equals(((Object[])obj)[1]))) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    public void setDragable(boolean flag) {
        this.dragable = flag;
    }

    public void setCheckable(boolean flag) {
        if (flag) {
            this.icons = null;
        }
        if (this.checkable == flag) {
            return;
        }
        this.checkable = flag;
        this.setCellRenderer(flag ? new CheckListCellRenderer() : (this.icons == null ? new LabelListCellRenderer() : new ToggleCheckListCellRenderer(this.icons)));
    }

    public void setCheckIcons(Icon[] aicon) {
        this.icons = aicon;
        this.checkable = false;
        this.setCellRenderer(new ToggleCheckListCellRenderer(aicon));
    }

    public void setCheckEditable(boolean flag) {
        this.checkEditable = flag;
    }

    public boolean isCheckEditable() {
        return this.checkEditable;
    }

    public boolean isDragable() {
        return this.dragable;
    }

    public boolean isCheckable() {
        return this.checkable;
    }

    public void keyTyped(KeyEvent keyevent) {
    }

    public void keyPressed(KeyEvent keyevent) {
    }

    public void keyReleased(KeyEvent keyevent) {
        if (keyevent.getKeyCode() == 65 && (keyevent.isAltDown() || keyevent.isShiftDown())) {
            boolean flag = keyevent.isAltDown();
            ListModel listmodel = this.getModel();
            int i = listmodel.getSize();
            int j = 0;
            while (j < i) {
                if (!this.getItemEditdisable(j)) {
                    this.checkItemAt(j, flag);
                }
                ++j;
            }
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent mouseevent) {
        this.indexSelected = this.locationToIndex(mouseevent.getPoint());
        if (this.indexSelected >= this.getItemCount()) {
            this.indexSelected = -1;
        }
        if (this.isEnabled() && this.checkable && this.checkEditable && mouseevent.getX() < 12 && this.indexSelected >= 0 && !this.getItemEditdisable(this.indexSelected)) {
            this.checkItemAt(this.indexSelected, !this.isItemChecked(this.indexSelected));
            this.repaint();
        } else if (this.isEnabled() && this.icons != null && this.getCellRenderer() instanceof ToggleCheckListCellRenderer && this.checkEditable && mouseevent.getX() < 12 && this.indexSelected >= 0 && !this.getItemEditdisable(this.indexSelected)) {
            this.checkItemAt(this.indexSelected, (this.getItemCheckedAsInt(this.indexSelected) + 1) % this.icons.length);
            this.repaint();
        }
    }

    protected void itemDragged(int i, int j) {
    }

    /*
     * Unable to fully structure code
     */
    public void mouseDragged(MouseEvent mouseevent) {
        block3: {
            block4: {
                if (this.indexSelected < 0 || !this.dragable || !(this.getModel() instanceof DefaultListModel)) {
                    return;
                }
                defaultlistmodel = (DefaultListModel)this.getModel();
                i = this.locationToIndex(mouseevent.getPoint());
                if (i < 0 || i == this.indexSelected) break block3;
                j = this.indexSelected;
                obj = defaultlistmodel.getElementAt(this.indexSelected);
                if (this.indexSelected >= i) ** GOTO lbl16
                while (this.indexSelected < i) {
                    defaultlistmodel.setElementAt(defaultlistmodel.getElementAt(this.indexSelected + 1), this.indexSelected);
                    ++this.indexSelected;
                }
                break block4;
lbl-1000:
                // 1 sources

                {
                    defaultlistmodel.setElementAt(defaultlistmodel.getElementAt(this.indexSelected - 1), this.indexSelected);
                    --this.indexSelected;
lbl16:
                    // 2 sources

                    ** while (this.indexSelected > i)
                }
            }
            defaultlistmodel.setElementAt(obj, this.indexSelected);
            this.itemDragged(j, this.indexSelected);
            this.invalidate();
        }
    }

    public void mouseMoved(MouseEvent mouseevent) {
    }

    public void mouseReleased(MouseEvent mouseevent) {
        this.indexSelected = -1;
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent mouseevent) {
        this.indexSelected = -1;
    }

    public boolean getMutiSelectOnControlKeyDown() {
        return this.mutiSelectOnControlKeyDown;
    }

    public static class CheckListCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        protected static Border noFocusBorder;

        public Component getListCellRendererComponent(JList jlist, Object obj, int i, boolean flag, boolean flag1) {
            if (flag) {
                this.setBackground(jlist.getSelectionBackground());
                this.setForeground(jlist.getSelectionForeground());
            } else {
                this.setBackground(jlist.getBackground());
                this.setForeground(jlist.getForeground());
            }
            if (obj instanceof Object[] && ((Object[])obj).length >= 2) {
                this.setSelected(((Object[])obj)[0] instanceof Boolean && (Boolean)((Object[])obj)[0] != false);
                this.setText(((Object[])obj)[1] != null ? ((Object[])obj)[1].toString() : "");
            } else {
                this.setSelected(false);
            }
            this.setEnabled(jlist.isEnabled());
            this.setFont(jlist.getFont());
            this.setBorder(flag1 ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }

        public CheckListCellRenderer() {
            noFocusBorder = new EmptyBorder(1, 1, 1, 1);
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }
    }

    public static class LabelListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jlist, Object obj, int i, boolean flag, boolean flag1) {
            if (obj instanceof Object[] && ((Object[])obj).length >= 2) {
                obj = ((Object[])obj)[1];
            }
            return super.getListCellRendererComponent((JList<?>)jlist, obj, i, flag, flag1);
        }
    }

    public static class ToggleCheckListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected static Border noFocusBorder;
        final Icon[] icons;

        public Component getListCellRendererComponent(JList jlist, Object obj, int i, boolean flag, boolean flag1) {
            if (flag) {
                this.setBackground(jlist.getSelectionBackground());
                this.setForeground(jlist.getSelectionForeground());
            } else {
                this.setBackground(jlist.getBackground());
                this.setForeground(jlist.getForeground());
            }
            if (obj instanceof Object[] && ((Object[])obj).length >= 2) {
                int j = ((Object[])obj)[0] instanceof Number ? ((Number)((Object[])obj)[0]).intValue() : 0;
                this.setIcon(j < 0 || j >= this.icons.length ? this.icons[0] : this.icons[j]);
                this.setText(((Object[])obj)[1] != null ? ((Object[])obj)[1].toString() : "");
            } else {
                this.setIcon(this.icons[0]);
            }
            this.setEnabled(jlist.isEnabled());
            this.setFont(jlist.getFont());
            this.setBorder(flag1 ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }

        public ToggleCheckListCellRenderer(Icon[] aicon) {
            this.icons = aicon;
            noFocusBorder = new EmptyBorder(1, 1, 1, 1);
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }
    }
}

