/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

public class PopupMenuForTextArea
extends JPopupMenu
implements MouseListener,
ActionListener {
    final JTextArea textArea;

    public PopupMenuForTextArea(JTextArea jtextarea) {
        this.textArea = jtextarea;
        this.addPopupMenuItem("\u62f7\u8d1d[CTRL-C]", "copy");
        this.addPopupMenuItem("\u88c1\u526a[CTRL-X]", "cut");
        this.addPopupMenuItem("\u7c98\u8d34[CTRL-V]", "paste");
        this.addPopupMenuItem("\u5168\u9009[CTRL-A]", "selectall");
        jtextarea.addMouseListener(this);
    }

    public JMenuItem addPopupMenuItem(String s, String s1) {
        if (s1 != null) {
            JMenuItem jmenuitem = new JMenuItem(s);
            jmenuitem.setActionCommand(s1);
            jmenuitem.addActionListener(this);
            this.add(jmenuitem);
            return jmenuitem;
        }
        return null;
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent mouseevent) {
        if ((mouseevent.getModifiers() & 0x10) == 0) {
            this.show(this.textArea, mouseevent.getX(), mouseevent.getY());
        }
    }

    public void showPopupMenu(int i, int j) {
        Dimension dimension = this.getPreferredSize();
        Dimension dimension1 = Toolkit.getDefaultToolkit().getScreenSize();
        dimension1.height -= 10;
        dimension1.width -= 10;
        Point point = this.getLocationOnScreen();
        if (point.y + j + dimension.height >= dimension1.height && point.y + (j -= dimension.height) < 0) {
            j = -point.y;
        }
        if (point.x + i + dimension.width >= dimension1.width && point.x + (i -= dimension.width) < 0) {
            i = -point.x;
        }
        this.show(this, i, j);
    }

    public void mouseReleased(MouseEvent mouseevent) {
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent mouseevent) {
    }

    public void actionPerformed(ActionEvent actionevent) {
        String s = actionevent.getActionCommand();
        if ("copy".equals(s)) {
            this.textArea.copy();
        } else if ("cut".equals(s)) {
            this.textArea.cut();
        } else if ("paste".equals(s)) {
            this.textArea.paste();
        } else if ("selectall".equals(s)) {
            this.textArea.selectAll();
        }
    }
}

