/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import softcore.table.Table;

public class ScrollBarPanel
extends JComponent {
    protected Component viewComponent;
    protected JScrollBar verticalScrollBar;
    protected JScrollBar horizontalScrollBar;
    private static final int scrollBarSize = 20;
    private int hgap;
    private int vgap;
    private Dimension preferredSize = new Dimension();

    public Component getViewComponent() {
        return this.viewComponent;
    }

    public ScrollBarPanel(Component component, int i) {
        this.viewComponent = component;
        this.add(component);
        if ((i & 1) != 0) {
            this.verticalScrollBar = new JScrollBar(1);
            this.add(this.verticalScrollBar);
            if (component instanceof Table) {
                ((Table)component).setVerticalScrollBar(this.verticalScrollBar);
            }
        }
        if ((i & 2) != 0) {
            this.horizontalScrollBar = new JScrollBar(0);
            this.add(this.horizontalScrollBar);
            if (component instanceof Table) {
                ((Table)component).setHorizontalScrollBar(this.horizontalScrollBar);
            }
        }
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.viewComponent.getPreferredSize();
        this.preferredSize.setSize(dimension.width + (this.verticalScrollBar != null ? 20 : 0) + insets.left + insets.right, dimension.height + (this.horizontalScrollBar != null ? 20 : 0) + insets.top + insets.bottom);
        return this.preferredSize;
    }

    protected void paintComponent(Graphics g) {
        if (this.verticalScrollBar != null && this.horizontalScrollBar != null) {
            g.setColor(Color.lightGray);
            Dimension dimension = this.getSize();
            g.draw3DRect(dimension.width - 32, dimension.height - 32, dimension.width, dimension.height, true);
        }
    }

    public void doLayout() {
        Insets insets = this.getInsets();
        int i = insets.top;
        int j = this.getHeight() - insets.bottom;
        int k = insets.left;
        int l = this.getWidth() - insets.right;
        int temp = 18;
        if (this.verticalScrollBar != null) {
            this.verticalScrollBar.setSize(temp, j - i);
            this.verticalScrollBar.setBounds(l - temp, i, temp, j - i - (this.horizontalScrollBar != null ? temp : 0));
            l -= temp + this.hgap;
        }
        if (this.horizontalScrollBar != null) {
            this.horizontalScrollBar.setSize(l - k, temp);
            this.horizontalScrollBar.setBounds(k, j - temp, l - k, temp);
            j -= temp + this.vgap;
        }
        if (this.viewComponent != null) {
            this.viewComponent.setBounds(k, i, l - k, j - i);
        }
    }
}

