/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt.chart;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import softcore.awt.chart.Chart;
import softcore.awt.chart.ChartSample;

public class BarChart
extends Chart {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int TARGET_LINE_NO_LABEL = 0;
    public static final int TARGET_LINE_ID_LABEL = 1;
    public static final int TARGET_LINE_VALUE_LABEL = 2;
    public static final int TARGET_LINE_ID_AND_VALUE_LABEL = 3;
    public static final int SIDE_BY_SIDE_BARS = 0;
    public static final int STACKED_BARS = 1;
    public static final int VALUE_LABELS_OUTSIDE = 0;
    public static final int VALUE_LABELS_INSIDE = 1;
    public static final int VALUE_LABELS_FLOATING = 2;
    public static final int BAR_LABELS_BELOW = 0;
    public static final int BAR_LABELS_FLOATING = 1;
    public static final int BAR_LABELS_BELOW_AND_FLOATING = 2;
    private double upperRange;
    private double lowerRange;
    private int rangeDecimalCount;
    private boolean multiColorOn;
    private String[] barLabels;
    private boolean barLabelsOn;
    private int barLabelStyle;
    private int valueLabelStyle;
    private boolean valueLinesOn;
    private int maxValueLineCount;
    private boolean rangeLabelsOn;
    private boolean barOutlineOn;
    private int barAlignment;
    private Color valueLinesColor;
    private boolean autoLabelSpacingOn;
    private double barWidthFraction;
    private int barType;
    private boolean multiSeriesOn;
    private Hashtable targetValueLines;
    private Rectangle[][] barBounds;
    private Rectangle currentBounds;
    private int zeroLine;
    private int positiveSpace;
    private Point depth3dPoint;
    private int selectedSeries;
    private int selectedSample;
    private Point mousePosition;
    private static final float ANGLE = 1.25f;
    private static final float DEPTH = 0.75f;
    private static final double[] STEPS = new double[]{1.0, 2.0, 2.5, 5.0};
    private int MaxBarWidth = 50;

    public synchronized void setRange(double d) {
        this.upperRange = d;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized void setUpperRange(double d) {
        this.upperRange = d;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized void setRange(double d, double d1) {
        this.lowerRange = d;
        this.upperRange = d1;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized long getRange() {
        return (long)this.upperRange;
    }

    public void setBarLabelsOn(boolean flag) {
        this.barLabelsOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public boolean isValueLinesOn() {
        return this.valueLinesOn;
    }

    public void setRangeLabelsOn(boolean flag) {
        this.rangeLabelsOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setTargetValueLine(String s, double d, Color color, int i) {
        TargetValueLine targetvalueline;
        if (color != null) {
            switch (i) {
                default: {
                    throw new IllegalArgumentException("Invalid style");
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
            }
        }
        if ((targetvalueline = (TargetValueLine)this.targetValueLines.get(s)) != null) {
            if (color != null) {
                targetvalueline.value = d;
                targetvalueline.color = color;
            } else {
                this.targetValueLines.remove(s);
            }
        } else {
            this.targetValueLines.put(s, new TargetValueLine(s, d, color, i));
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public double getTargetValueLine(String s) {
        TargetValueLine targetvalueline = (TargetValueLine)this.targetValueLines.get(s);
        if (targetvalueline != null) {
            return targetvalueline.value;
        }
        throw new IllegalArgumentException("No target value line with the id: " + s);
    }

    public void setAutoLabelSpacingOn(boolean flag) {
        this.autoLabelSpacingOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setBarLabels(String[] as) {
        this.barLabels = as;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public String[] getBarLabels() {
        if (this.barLabels != null) {
            return this.barLabels;
        }
        return this.getSampleLabels();
    }

    public String[] getLegendLabels() {
        if (this.legendLabels != null) {
            return this.legendLabels;
        }
        if (this.getSeriesCount() > 1 || this.barType == 1 || this.multiSeriesOn) {
            return this.getSeriesLabels();
        }
        return this.getSampleLabels();
    }

    public synchronized void setLowerRange(double d) {
        this.lowerRange = d;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized long getLowerRange() {
        return (long)this.lowerRange;
    }

    public void setRangeDecimalCount(int i) {
        this.rangeDecimalCount = i;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getRangeDecimalCount() {
        return this.rangeDecimalCount;
    }

    public void setBarAlignment(int i) {
        if (i != 0 && i != 1) {
            throw new IllegalArgumentException("Alignment must be HORIZONTAL or VERTICAL");
        }
        this.barAlignment = i;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getBarAlignment() {
        return this.barAlignment;
    }

    private void paintBarLabels(Graphics g, Rectangle rectangle) {
        if (!this.barLabelsOn || this.barLabelStyle == 1) {
            return;
        }
        String[] as1 = this.getBarLabels();
        if (as1 == null) {
            return;
        }
        String[] as = new String[as1.length];
        int i = 0;
        while (i < as.length) {
            as[i] = as1[i];
            if (as[i] != null) {
                int n = as[i].indexOf(58);
            }
            ++i;
        }
        g.setFont(this.getFont("barLabelFont"));
        FontMetrics fontmetrics = g.getFontMetrics();
        int j = 0;
        int l = 0;
        while (l < as.length) {
            if (as[l] != null) {
                j = Math.max(j, fontmetrics.stringWidth(as[l]));
            }
            ++l;
        }
        int i1 = 0;
        int j1 = this.getSampleDecimalCount();
        String s = this.getLabel("valueLabelPrefix");
        String s1 = this.getLabel("valueLabelPostfix");
        int k1 = Math.min(as.length, this.getSampleCount());
        int l1 = 0;
        while (l1 < k1) {
            if (as[l1] != null) {
                Color color = this.getSampleLabelColor(l1);
                if (color != null) {
                    g.setColor(color);
                } else {
                    g.setColor(this.getForeground());
                }
                int i2 = fontmetrics.stringWidth(as[l1]);
                if (this.barAlignment == 1) {
                    int j2 = this.barBounds[0][l1].x;
                    int l2 = this.barBounds[this.barBounds.length - 1][l1].x + this.barBounds[this.barBounds.length - 1][l1].width - j2;
                    j2 = j2 + l2 / 2 - i2 / 2;
                    int j3 = rectangle.y + rectangle.height + fontmetrics.getMaxAscent() + 1;
                    if (this.is3DModeOn()) {
                        j3 -= this.depth3dPoint.y;
                    }
                    if (this.isValueLabelsOn() && this.valueLabelStyle != 2 && this.lowerRange < 0.0) {
                        int l3 = rectangle.y;
                        int j4 = 0;
                        while (j4 < this.barBounds.length) {
                            int l4 = this.barBounds[j4][l1].y + this.barBounds[j4][l1].height;
                            if (l4 > l3) {
                                l3 = l4;
                            }
                            ++j4;
                        }
                        j3 = Math.max(j3, l3 + fontmetrics.getMaxAscent() + 10);
                    }
                    if (this.autoLabelSpacingOn) {
                        if (j2 > i1) {
                            g.drawString(as[l1], j2, j3);
                            i1 = j2 + i2;
                        }
                    } else {
                        g.drawString(as[l1], j2, j3);
                    }
                } else {
                    int k2 = this.barBounds[this.barBounds.length - 1][l1].y + this.barBounds[this.barBounds.length - 1][l1].height - this.barBounds[0][l1].y;
                    int i3 = this.barBounds[0][l1].y + k2 / 2 + fontmetrics.getAscent() / 2 - 1;
                    int k3 = rectangle.x - i2 - 3;
                    if (this.is3DModeOn()) {
                        k3 -= this.depth3dPoint.x;
                    }
                    if (this.isValueLabelsOn() && this.lowerRange < 0.0) {
                        int i4 = rectangle.x + rectangle.width;
                        int k4 = 0;
                        double d = 0.0;
                        int i5 = 0;
                        while (i5 < this.barBounds.length) {
                            if (this.getSampleValue(i5, l1) < 0.0) {
                                d = this.barType == 1 ? (d += this.getSampleValue(i5, l1)) : this.getSampleValue(i5, l1);
                                if (this.barBounds[i5][l1].x < i4) {
                                    i4 = this.barBounds[i5][l1].x;
                                    String s2 = this.formatNumber(d, j1);
                                    s2 = s != null ? String.valueOf(s) + s2 : s2;
                                    s2 = s1 != null ? String.valueOf(s2) + s1 : s2;
                                    k4 = fontmetrics.stringWidth(s2);
                                }
                            }
                            ++i5;
                        }
                        k3 = Math.min(k3, i4 - k4 - i2 - 3);
                    }
                    g.drawString(as[l1], k3, i3);
                }
            }
            ++l1;
        }
    }

    private void paintFloatingLabels(Graphics g, Rectangle rectangle) {
        boolean flag;
        boolean bl = flag = this.valueLabelStyle == 2 || this.barLabelStyle == 1 || this.barLabelStyle == 2;
        if (flag && this.selectedSeries >= 0 && this.selectedSample >= -1) {
            g.setFont(this.getFont("floatingLabelFont"));
            FontMetrics fontmetrics = g.getFontMetrics();
            if (this.selectedSample >= 0) {
                String s = this.constructFloatingLabel(this.selectedSeries, this.selectedSample, true);
                this.paintFloatingLabel(g, this.selectedSeries, this.selectedSample, s, fontmetrics);
            } else {
                int i = this.getSampleCount();
                int j = 0;
                while (j < i) {
                    String s1 = this.constructFloatingLabel(this.selectedSeries, j, false);
                    this.paintFloatingLabel(g, this.selectedSeries, j, s1, fontmetrics);
                    ++j;
                }
            }
        }
    }

    public void setMultiColorOn(boolean flag) {
        this.multiColorOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    private void paintBars(Graphics g, Rectangle rectangle) {
        int i = this.getSeriesCount();
        int j = this.getSampleCount();
        if (rectangle.width < 0 || rectangle.height < 0) {
            return;
        }
        if (this.barAlignment == 1) {
            if (this.barType == 0) {
                int k = 0;
                while (k < j) {
                    int k1 = 0;
                    while (k1 < i) {
                        this.paintBar(g, k1, k);
                        ++k1;
                    }
                    ++k;
                }
            } else {
                int l = 0;
                while (l < j) {
                    int l1 = i - 1;
                    while (l1 >= 0) {
                        if (this.getSampleValue(l1, l) < 0.0) {
                            this.paintBar(g, l1, l);
                        }
                        --l1;
                    }
                    ++l;
                }
                int i2 = 0;
                while (i2 < j) {
                    int i3 = 0;
                    while (i3 < i) {
                        if (this.getSampleValue(i3, i2) >= 0.0) {
                            this.paintBar(g, i3, i2);
                        }
                        ++i3;
                    }
                    ++i2;
                }
            }
        } else if (this.barType == 0) {
            int i1 = j - 1;
            while (i1 >= 0) {
                int j2 = i - 1;
                while (j2 >= 0) {
                    this.paintBar(g, j2, i1);
                    --j2;
                }
                --i1;
            }
        } else {
            int j1 = j - 1;
            while (j1 >= 0) {
                int k2 = i - 1;
                while (k2 >= 0) {
                    if (this.getSampleValue(k2, j1) < 0.0) {
                        this.paintBar(g, k2, j1);
                    }
                    --k2;
                }
                --j1;
            }
            int l2 = j - 1;
            while (l2 >= 0) {
                int j3 = 0;
                while (j3 < i) {
                    if (this.getSampleValue(j3, l2) >= 0.0) {
                        this.paintBar(g, j3, l2);
                    }
                    ++j3;
                }
                --l2;
            }
        }
        if (!this.is3DModeOn()) {
            g.setColor(this.getChartForeground());
            if (this.barAlignment == 1) {
                if (this.zeroLine >= rectangle.y && this.zeroLine < rectangle.y + rectangle.height) {
                    g.drawLine(rectangle.x, this.zeroLine, rectangle.x + rectangle.width, this.zeroLine);
                }
            } else if (this.zeroLine >= rectangle.x && this.zeroLine < rectangle.x + rectangle.width) {
                g.drawLine(this.zeroLine, rectangle.y, this.zeroLine, rectangle.y + rectangle.height);
            }
        }
    }

    public boolean isMultiColorOn() {
        return this.multiColorOn;
    }

    private void paintValueLine(Graphics g, Rectangle rectangle, double d, Color color, String s, Color color1, FontMetrics fontmetrics, boolean flag, boolean flag1) {
        double d1 = 0.0;
        if (this.upperRange - this.lowerRange != 0.0) {
            d1 = (d - this.lowerRange) / (this.upperRange - this.lowerRange);
        }
        boolean flag2 = false;
        int i = fontmetrics.getHeight();
        int j = fontmetrics.getDescent();
        int k = s != null ? fontmetrics.stringWidth(s) : 0;
        boolean flag3 = this.is3DModeOn();
        Color color2 = this.getChartForeground();
        if (this.barAlignment == 1) {
            int l = (int)Math.round((double)(rectangle.y + rectangle.height) - d1 * (double)rectangle.height);
            if (flag && l >= rectangle.y && l <= rectangle.y + rectangle.height || l > rectangle.y + i - j && l < rectangle.y + rectangle.height - i + j) {
                if (this.valueLinesOn || flag) {
                    if (l == this.zeroLine && !flag1) {
                        g.setColor(color2);
                    } else {
                        g.setColor(color);
                    }
                    g.drawLine(rectangle.x, l, rectangle.x + rectangle.width, l);
                    if (flag3) {
                        g.drawLine(rectangle.x, l, rectangle.x - this.depth3dPoint.x, l - this.depth3dPoint.y);
                    }
                }
                if (s != null) {
                    int j1 = rectangle.x - k - 4;
                    int l1 = l + i - fontmetrics.getAscent() + 1;
                    g.setColor(color2);
                    if (flag3) {
                        j1 -= this.depth3dPoint.x;
                        l1 -= this.depth3dPoint.y;
                        g.drawLine(rectangle.x - this.depth3dPoint.x, l - this.depth3dPoint.y, rectangle.x - 3 - this.depth3dPoint.x, l - this.depth3dPoint.y);
                    } else {
                        g.drawLine(rectangle.x, l, rectangle.x - 3, l);
                    }
                    g.setColor(this.getBackground());
                    g.fillRect(j1, l1 - i + j * 2 - 2, k, i - j * 2 + 3);
                    g.setColor(color1);
                    g.drawString(s, j1, l1);
                }
            }
        } else {
            int i1 = d != 0.0 ? (int)Math.round((double)rectangle.x + d1 * (double)rectangle.width) : this.zeroLine;
            int k1 = this.getRangeDecimalCount();
            String s1 = this.formatNumber(this.lowerRange, k1);
            String s2 = this.formatNumber(this.upperRange, k1);
            boolean flag4 = i1 - k / 2 > rectangle.x + fontmetrics.stringWidth(s1) / 2;
            if (flag || (flag4 &= i1 + k / 2 < rectangle.x + rectangle.width - fontmetrics.stringWidth(s2) / 2 - 2)) {
                if (this.valueLinesOn || flag) {
                    if (i1 == this.zeroLine) {
                        g.setColor(color2);
                    } else {
                        g.setColor(color);
                    }
                    g.drawLine(i1, rectangle.y, i1, rectangle.y + rectangle.height);
                    if (flag3) {
                        g.drawLine(i1, rectangle.y + rectangle.height, i1 - this.depth3dPoint.x, rectangle.y + rectangle.height - this.depth3dPoint.y);
                    }
                }
                if (s != null) {
                    int i2 = i1 - k / 2;
                    int j2 = rectangle.y + rectangle.height + i - j + 3;
                    if (flag1) {
                        j2 = rectangle.y - 4;
                    }
                    g.setColor(color2);
                    if (flag3) {
                        if (!flag1) {
                            i2 -= this.depth3dPoint.x;
                            j2 -= this.depth3dPoint.y;
                        }
                        g.drawLine(i1 - this.depth3dPoint.x, rectangle.y + rectangle.height - this.depth3dPoint.y, i1 - this.depth3dPoint.x, rectangle.y + rectangle.height + 3 - this.depth3dPoint.y);
                    } else if (flag1) {
                        g.drawLine(i1, rectangle.y, i1, rectangle.y - 3);
                    } else {
                        g.drawLine(i1, rectangle.y + rectangle.height, i1, rectangle.y + rectangle.height + 3);
                    }
                    g.setColor(this.getBackground());
                    g.fillRect(i2, j2 - i + j * 2 - 2, k, i - j * 2 + 3);
                    g.setColor(color1);
                    g.drawString(s, i2, j2);
                }
            }
        }
    }

    private void calculateHelperValues(Rectangle rectangle) {
        if (this.upperRange - this.lowerRange != 0.0) {
            if (this.barAlignment == 1) {
                this.positiveSpace = (int)Math.round((double)rectangle.height * (this.upperRange / (this.upperRange - this.lowerRange)));
                this.zeroLine = rectangle.y + this.positiveSpace;
            } else {
                this.positiveSpace = (int)Math.round((double)rectangle.width * (this.upperRange / (this.upperRange - this.lowerRange)));
                this.zeroLine = rectangle.x + rectangle.width - this.positiveSpace;
            }
        }
        if (this.barAlignment == 1) {
            this.positiveSpace = rectangle.height;
            if (this.upperRange - this.lowerRange != 0.0) {
                this.positiveSpace = (int)Math.round((double)rectangle.height * (this.upperRange / (this.upperRange - this.lowerRange)));
            }
            this.positiveSpace = Math.min(this.positiveSpace, rectangle.height);
            this.positiveSpace = Math.max(this.positiveSpace, 0);
        } else {
            this.positiveSpace = rectangle.width;
            this.positiveSpace = this.upperRange - this.lowerRange != 0.0 ? (int)Math.round((double)rectangle.width * (this.upperRange / (this.upperRange - this.lowerRange))) : rectangle.width;
            this.positiveSpace = Math.min(this.positiveSpace, rectangle.width);
            this.positiveSpace = Math.max(this.positiveSpace, 0);
        }
        int i = this.getSampleCount();
        int j = this.getSeriesCount();
        if (this.is3DModeOn() && i > 0 && j > 0) {
            if (this.barAlignment == 1) {
                double d = (double)rectangle.width / (double)i;
                double d2 = d * this.barWidthFraction;
                if (this.barType == 0) {
                    d2 /= (double)j;
                }
                this.depth3dPoint.x = (int)Math.round(d2 * 1.25);
                this.depth3dPoint.y = (int)Math.round(-d2 / 1.25);
            } else {
                double d1 = (double)rectangle.height / (double)i;
                double d3 = d1 * this.barWidthFraction;
                if (this.barType == 0) {
                    d3 /= (double)j;
                }
                this.depth3dPoint.x = (int)Math.round(d3 * 1.25 * 0.75);
                this.depth3dPoint.y = (int)Math.round(-(d3 / 1.25 * 0.75));
            }
        }
    }

    public boolean isBarLabelsOn() {
        return this.barLabelsOn;
    }

    public boolean isRangeLabelsOn() {
        return this.rangeLabelsOn;
    }

    public boolean isAutoLabelSpacingOn() {
        return this.autoLabelSpacingOn;
    }

    public void setMultiSeriesOn(boolean flag) {
        this.multiSeriesOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized double getFloatRange() {
        return this.upperRange;
    }

    public synchronized void setRelativeRange(double d) {
        double d1 = this.getHighestBar();
        Enumeration enumeration = this.targetValueLines.elements();
        while (enumeration.hasMoreElements()) {
            d1 = Math.max(((TargetValueLine)enumeration.nextElement()).value, d1);
        }
        if (d1 >= 0.0) {
            this.setRange(d1 * Math.abs(d));
        } else {
            this.setRange(0.0);
        }
    }

    public synchronized void setRelativeRange(double d, double d1) {
        double d2 = this.getHighestBar();
        Enumeration enumeration = this.targetValueLines.elements();
        while (enumeration.hasMoreElements()) {
            d2 = Math.max(((TargetValueLine)enumeration.nextElement()).value, d2);
        }
        if (d2 >= 0.0) {
            d1 = Math.abs(d1);
            double d3 = d2 * Math.abs(d);
            if (d1 % 1.0 == 0.0) {
                if (d3 % d1 == 0.0) {
                    this.setRange(d3);
                } else {
                    this.setRange(d3 - d3 % d1 + d1);
                }
            } else {
                double d4 = 0.0;
                while (d4 < d3) {
                    d4 += d1;
                }
                this.setRange(d4);
            }
        } else {
            this.setRange(0.0);
        }
    }

    private void paintValueLabels(Graphics g, Rectangle rectangle) {
        block43: {
            int j1;
            int i1;
            int l;
            int k;
            Color color;
            boolean flag;
            FontMetrics fontmetrics;
            int j;
            int i;
            block42: {
                if (!this.isValueLabelsOn() || this.valueLabelStyle == 2) {
                    return;
                }
                i = this.getSampleCount();
                j = this.getSeriesCount();
                if (i == 0 || j == 0) {
                    return;
                }
                g.setFont(this.getFont("valueLabelFont"));
                fontmetrics = g.getFontMetrics();
                flag = this.is3DModeOn();
                color = this.getChartBackground();
                k = fontmetrics.getHeight();
                l = fontmetrics.getDescent();
                i1 = fontmetrics.getAscent();
                j1 = this.getSampleDecimalCount();
                if (this.valueLabelStyle != 0 || j <= 1 || this.barType != 1) break block42;
                String s = this.getLabel("valueLabelPrefix");
                String s1 = this.getLabel("valueLabelPostfix");
                int i2 = 0;
                while (i2 < i) {
                    double d = 0.0;
                    double d1 = 0.0;
                    boolean flag1 = false;
                    int j2 = 0;
                    while (j2 < j) {
                        ChartSample chartsample1 = this.getSample(j2, i2);
                        if (chartsample1 != null && chartsample1.value != null) {
                            flag1 = true;
                            double d3 = chartsample1.getFloatValue();
                            if (d3 >= 0.0) {
                                d += d3;
                            } else {
                                d1 += d3;
                            }
                        }
                        ++j2;
                    }
                    if (flag1) {
                        String s5 = d != 0.0 ? this.formatNumber(d, j1) : "";
                        s5 = s != null ? String.valueOf(s) + s5 : s5;
                        s5 = s1 != null ? String.valueOf(s5) + s1 : s5;
                        String s6 = d1 != 0.0 ? this.formatNumber(d1, j1) : "";
                        s6 = s != null ? String.valueOf(s) + s6 : s6;
                        s6 = s1 != null ? String.valueOf(s6) + s1 : s6;
                        int i3 = fontmetrics.stringWidth(s5);
                        int k3 = fontmetrics.stringWidth(s6);
                        Rectangle rectangle2 = this.barBounds[0][i2];
                        Rectangle rectangle3 = this.barBounds[0][i2];
                        int l3 = 0;
                        while (l3 < this.barBounds.length) {
                            Rectangle rectangle4 = this.barBounds[l3][i2];
                            if (rectangle4 != null) {
                                if (this.barAlignment == 1) {
                                    if (rectangle4.y < rectangle2.y) {
                                        rectangle2 = rectangle4;
                                    }
                                    if (rectangle4.y + rectangle4.height > rectangle3.y + rectangle3.height) {
                                        rectangle3 = rectangle4;
                                    }
                                } else {
                                    if (rectangle4.x + rectangle4.width > rectangle2.x + rectangle2.width) {
                                        rectangle2 = rectangle4;
                                    }
                                    if (rectangle4.x < rectangle3.x) {
                                        rectangle3 = rectangle4;
                                    }
                                }
                            }
                            ++l3;
                        }
                        int i4 = rectangle2.x + rectangle2.width / 2 - i3 / 2;
                        int j4 = rectangle2.y - 2;
                        int k4 = rectangle3.x + rectangle3.width / 2 - k3 / 2;
                        int l4 = rectangle3.y + rectangle3.height + k - l;
                        if (this.barAlignment == 0) {
                            i4 = rectangle2.x + rectangle2.width + 2;
                            j4 = rectangle2.y + rectangle2.height / 2 + k / 2 - l + 1;
                            k4 = rectangle3.x - k3 - 1;
                            l4 = j4;
                        }
                        if (flag) {
                            if (this.barAlignment == 1) {
                                i4 += this.depth3dPoint.x / 2;
                                j4 += this.depth3dPoint.y;
                            } else {
                                i4 += this.depth3dPoint.x;
                                j4 += this.depth3dPoint.y / 2;
                            }
                        }
                        if (d >= 0.0 && this.upperRange > 0.0) {
                            g.setColor(color);
                            g.fillRect(i4, j4 - k + l * 2, i3, k - l * 2);
                            g.setColor(this.getForeground());
                            g.drawString(s5, i4, j4);
                        }
                        if (d1 < 0.0 && this.lowerRange < 0.0) {
                            g.setColor(color);
                            g.fillRect(k4, l4 - k + l * 2, k3, k - l * 2);
                            g.setColor(this.getForeground());
                            g.drawString(s6, k4, l4);
                        }
                    }
                    ++i2;
                }
                break block43;
            }
            if (this.valueLabelStyle != 0 && this.valueLabelStyle != 1) break block43;
            int k1 = 0;
            while (k1 < i) {
                int l1 = 0;
                while (l1 < j) {
                    ChartSample chartsample = this.getSample(l1, k1);
                    if (chartsample != null && chartsample.value != null) {
                        double d2;
                        String s3;
                        String s2 = this.getLabel("valueLabelPrefix_" + l1);
                        if (s2 == null) {
                            s2 = this.getLabel("valueLabelPrefix");
                        }
                        if ((s3 = this.getLabel("valueLabelPostfix_" + l1)) == null) {
                            s3 = this.getLabel("valueLabelPostfix");
                        }
                        String s4 = (d2 = chartsample.getFloatValue()) != 0.0 ? this.formatNumber(d2, j1) : "";
                        s4 = s2 != null ? String.valueOf(s2) + s4 : s4;
                        s4 = s3 != null ? String.valueOf(s4) + s3 : s4;
                        int k2 = fontmetrics.stringWidth(s4);
                        Rectangle rectangle1 = this.barBounds[l1][k1];
                        int l2 = 0;
                        int j3 = 0;
                        boolean flag2 = true;
                        if (this.valueLabelStyle == 0) {
                            if (this.barAlignment == 1) {
                                l2 = rectangle1.x + rectangle1.width / 2 - k2 / 2;
                                j3 = d2 >= 0.0 ? rectangle1.y - 2 : rectangle1.y + rectangle1.height + i1;
                                if (flag && j == 1 && d2 >= 0.0) {
                                    j3 += this.depth3dPoint.y;
                                    l2 += this.depth3dPoint.x / 2;
                                }
                            } else {
                                l2 = d2 >= 0.0 ? rectangle1.x + rectangle1.width + 3 : rectangle1.x - k2 - 3;
                                j3 = rectangle1.y + rectangle1.height / 2 + k / 2 - l + 1;
                                if (flag && j == 1) {
                                    l2 += this.depth3dPoint.x;
                                    j3 += this.depth3dPoint.y / 2;
                                }
                            }
                        } else if (this.barAlignment == 1) {
                            l2 = rectangle1.x + rectangle1.width / 2 - k2 / 2;
                            j3 = d2 >= 0.0 ? rectangle1.y + k - l : rectangle1.y + rectangle1.height - 1;
                            flag2 = k - l * 2 < rectangle1.height - 2;
                        } else {
                            j3 = rectangle1.y + rectangle1.height / 2 + k / 2 - l + 1;
                            l2 = d2 >= 0.0 ? rectangle1.x + rectangle1.width - k2 - 1 : rectangle1.x + 2;
                            boolean bl = flag2 = k2 < rectangle1.width;
                        }
                        if (this.valueLabelStyle == 0) {
                            g.setColor(this.getForeground());
                        } else {
                            Color color1 = this.getSampleColor(0);
                            if (this.multiColorOn) {
                                color1 = j > 1 || this.barType == 1 || this.multiSeriesOn ? this.getSampleColor(l1) : this.getSampleColor(k1);
                            }
                            if ((color1.getRed() + color1.getGreen() + color1.getBlue()) / 3 > 110) {
                                g.setColor(Color.black);
                            } else {
                                g.setColor(Color.white);
                            }
                        }
                        if (this.valueLabelStyle == 0) {
                            Color color2 = g.getColor();
                            g.setColor(color);
                            g.fillRect(l2, j3 - k + l * 2, k2, k - l * 2);
                            g.setColor(color2);
                        }
                        if (flag2) {
                            g.drawString(s4, l2, j3);
                        }
                    }
                    ++l1;
                }
                ++k1;
            }
        }
    }

    public void setBarWidth(double d) {
        d = Math.max(0.0, d);
        this.barWidthFraction = d = Math.min(1.0, d);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public double getBarWidth() {
        return this.barWidthFraction;
    }

    public void setBarLabelStyle(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: {
                this.barLabelStyle = i;
                this.hasChanged = true;
                this.autoRepaint();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid barLabelStyle: " + i);
            }
        }
    }

    public int getBarLabelStyle() {
        return this.barLabelStyle;
    }

    public int getMinWidth() {
        int k;
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.getGraphBounds();
        int i = dimension.width - rectangle.width;
        int j = this.getSampleCount();
        if (j <= 0) {
            j = 1;
        }
        if ((k = this.getSeriesCount()) <= 0) {
            k = 1;
        }
        int l = (j + 1) * k * 15;
        return i + l;
    }

    public void render(Graphics g, boolean flag) {
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.getGraphBounds();
        this.calculateHelperValues(rectangle);
        this.calculateBarBounds(rectangle);
        if (this.hasChanged || flag) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, dimension.width, dimension.height);
            this.paintTitle(g, dimension);
            if (this.isLegendOn()) {
                this.paintLegend(g, rectangle, this.getLegendLabels());
            }
            this.paintGrid(g, rectangle);
            this.paintBarLabels(g, rectangle);
            if (this.upperRange != this.lowerRange) {
                this.paintBars(g, rectangle);
                if (this.is3DModeOn()) {
                    this.paint3DZeroDivider(g, rectangle);
                }
                this.paintValueLabels(g, rectangle);
            }
            this.hasChanged = false;
        }
        this.paintFloatingLabels(g, rectangle);
    }

    public int getValuePosition(double d) {
        return this.getValuePosition(d, this.getGraphBounds());
    }

    private int getValuePosition(double d, Rectangle rectangle) {
        int i = 0;
        int j = 0;
        if (this.barAlignment == 1) {
            if (this.upperRange - this.lowerRange != 0.0) {
                i = (int)((double)rectangle.height * (this.upperRange / (this.upperRange - this.lowerRange)));
            }
            j = rectangle.y + i;
        } else {
            if (this.upperRange - this.lowerRange != 0.0) {
                i = (int)((double)rectangle.width * (this.upperRange / (this.upperRange - this.lowerRange)));
            }
            j = rectangle.x + rectangle.width - i;
        }
        int k = 0;
        if (this.upperRange - this.lowerRange != 0.0) {
            k = this.barAlignment == 1 ? (int)((double)j - (double)rectangle.height * (d / (this.upperRange - this.lowerRange))) : (int)((double)j + (double)rectangle.width * (d / (this.upperRange - this.lowerRange)));
        }
        return k;
    }

    public void setBarOutlineOn(boolean flag) {
        this.barOutlineOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public boolean isMultiSeriesOn() {
        return this.multiSeriesOn;
    }

    public Rectangle getGraphBounds() {
        Insets insets;
        if (!this.hasChanged && this.currentBounds != null) {
            return this.currentBounds;
        }
        Rectangle rectangle = super.getGraphBounds(this.getLegendLabels());
        Dimension dimension = this.getSize();
        int i = rectangle.x;
        int j = dimension.width - rectangle.width - rectangle.x;
        int k = rectangle.y;
        int l = dimension.height - rectangle.height - rectangle.y;
        if (this.barLabelsOn && (this.barLabelStyle == 0 || this.barLabelStyle == 2)) {
            FontMetrics fontmetrics = this.getFontMetrics(this.getFont("barLabelFont"));
            if (this.barAlignment == 1) {
                l += fontmetrics.getMaxAscent();
            } else {
                int l1 = 0;
                int k2 = this.getSampleCount();
                int l2 = 0;
                while (l2 < k2) {
                    String s2 = this.getSampleLabel(l2);
                    if (s2 != null) {
                        l1 = Math.max(l1, fontmetrics.stringWidth(s2));
                    }
                    ++l2;
                }
                i += l1;
            }
        }
        if (this.rangeLabelsOn || this.targetValueLines.size() > 0) {
            int i1 = this.getRangeDecimalCount();
            FontMetrics fontmetrics3 = this.getFontMetrics(this.getFont("rangeLabelFont"));
            String s = this.getLabel("rangeLabelPrefix");
            String s1 = this.getLabel("rangeLabelPostfix");
            if (this.barAlignment == 1) {
                int i3 = 0;
                Enumeration enumeration = this.targetValueLines.elements();
                while (enumeration.hasMoreElements()) {
                    TargetValueLine targetvalueline = (TargetValueLine)enumeration.nextElement();
                    String s6 = targetvalueline.getLabel(i1);
                    if (s6 == null || s6.length() <= 0) continue;
                    i3 = Math.max(i3, fontmetrics3.stringWidth(s6));
                }
                if (this.rangeLabelsOn) {
                    String s5 = this.formatNumber(this.upperRange, i1);
                    String s7 = this.formatNumber(this.lowerRange, i1);
                    if (s != null) {
                        s5 = String.valueOf(s) + s5;
                        s7 = String.valueOf(s) + s7;
                    }
                    if (s1 != null) {
                        s5 = String.valueOf(s5) + s1;
                        s7 = String.valueOf(s7) + s1;
                    }
                    i3 = Math.max(i3, fontmetrics3.stringWidth(s5));
                    i3 = Math.max(i3, fontmetrics3.stringWidth(s7));
                }
                i += i3 + 2;
            } else {
                if (this.targetValueLines.size() > 0) {
                    k += fontmetrics3.getMaxAscent();
                }
                if (this.rangeLabelsOn) {
                    l += fontmetrics3.getMaxAscent();
                    String s3 = this.formatNumber(this.upperRange, i1);
                    s3 = s != null ? String.valueOf(s) + s3 : s3;
                    s3 = s1 != null ? String.valueOf(s3) + s1 : s3;
                    j = Math.max(j, fontmetrics3.stringWidth(s3) / 2 + 5);
                    String s4 = this.formatNumber(this.lowerRange, i1);
                    s4 = s != null ? String.valueOf(s) + s4 : s4;
                    s4 = s1 != null ? String.valueOf(s4) + s1 : s4;
                    i = Math.max(i, fontmetrics3.stringWidth(s4) / 2 + 5);
                }
            }
        }
        if (this.isValueLabelsOn() && this.valueLabelStyle == 0) {
            int j1 = this.getSampleDecimalCount();
            FontMetrics fontmetrics4 = this.getFontMetrics(this.getFont("valueLabelFont"));
            if (this.barAlignment == 1) {
                double d = this.getHighestBar();
                double d4 = 0.0;
                if (this.upperRange - this.lowerRange != 0.0) {
                    d4 = (d - this.lowerRange) / (this.upperRange - this.lowerRange);
                }
                rectangle.y = k;
                rectangle.height = dimension.height - k - l;
                int j3 = (int)Math.round((double)(rectangle.y + rectangle.height) - d4 * (double)rectangle.height);
                if ((j3 -= fontmetrics4.getAscent()) < rectangle.y - 4) {
                    k += Math.min(rectangle.y - 4 - j3, fontmetrics4.getAscent());
                }
                double d6 = this.getDeepestBar();
                d4 = 0.0;
                if (this.upperRange - this.lowerRange != 0.0) {
                    d4 = (d6 - this.lowerRange) / (this.upperRange - this.lowerRange);
                }
                j3 = (int)Math.round((double)(rectangle.y + rectangle.height) - d4 * (double)rectangle.height);
                if ((j3 += fontmetrics4.getAscent()) > rectangle.y + rectangle.height) {
                    l += Math.min(j3 - rectangle.height - rectangle.y, fontmetrics4.getAscent());
                }
            } else {
                double d1 = this.getHighestBar();
                double d5 = 0.0;
                if (this.upperRange - this.lowerRange != 0.0) {
                    d5 = (d1 - this.lowerRange) / (this.upperRange - this.lowerRange);
                }
                rectangle.x = i;
                rectangle.width = dimension.width - i - j;
                int k3 = (int)Math.round((double)rectangle.x + d5 * (double)rectangle.width);
                int l3 = fontmetrics4.stringWidth(this.formatNumber(d1, j1));
                if ((k3 += l3) > rectangle.x + rectangle.width) {
                    j += Math.min(k3 - rectangle.width - rectangle.x, l3);
                }
                double d7 = this.getDeepestBar();
                d5 = 0.0;
                if (this.upperRange - this.lowerRange != 0.0) {
                    d5 = (d7 - this.lowerRange) / (this.upperRange - this.lowerRange);
                }
                k3 = (int)Math.round((double)rectangle.x + d5 * (double)rectangle.width);
                l3 = fontmetrics4.stringWidth(this.formatNumber(d7, j1)) + 3;
                if ((k3 -= l3) < rectangle.x) {
                    i += Math.min(rectangle.x - k3, l3);
                }
            }
        }
        if (this.getLabel("sampleAxisLabel") != null) {
            FontMetrics fontmetrics1 = this.getFontMetrics(this.getFont("sampleAxisLabelFont"));
            if (this.barAlignment == 1) {
                l += fontmetrics1.getAscent();
            } else {
                k += fontmetrics1.getAscent();
                i = Math.max(i, fontmetrics1.stringWidth(this.getLabel("sampleAxisLabel")) / 2 + 2);
            }
        }
        if (this.getLabel("rangeAxisLabel") != null) {
            FontMetrics fontmetrics2 = this.getFontMetrics(this.getFont("rangeAxisLabelFont"));
            if (this.barAlignment == 1) {
                k += fontmetrics2.getAscent();
                i = Math.max(i, fontmetrics2.stringWidth(this.getLabel("rangeAxisLabel")) / 2 + 2);
            } else {
                l += fontmetrics2.getAscent();
            }
        }
        if (this.is3DModeOn()) {
            int k1 = Math.max(1, this.getSampleCount());
            if (this.barType == 0) {
                k1 *= Math.max(1, this.getSeriesCount());
            }
            if (this.barAlignment == 1) {
                int i2 = 0;
                if ((double)k1 + this.barWidthFraction * 1.25 > 0.0) {
                    i2 = (int)((double)rectangle.width * this.barWidthFraction * 1.25 / ((double)k1 + this.barWidthFraction * 1.25));
                }
                rectangle.width = dimension.width - (i += i2) - j;
                double d2 = 0.0;
                if (k1 > 0) {
                    d2 = (double)(rectangle.width / k1) * this.barWidthFraction;
                }
                l += (int)Math.round(d2 / 1.25);
            } else {
                int j2 = 0;
                if ((double)(1.25f * (float)k1) + this.barWidthFraction * 0.75 > 0.0) {
                    j2 = (int)((double)rectangle.height * this.barWidthFraction * 0.75 / ((double)(1.25f * (float)k1) + this.barWidthFraction * 0.75));
                }
                rectangle.height = dimension.height - k - (l += j2);
                double d3 = (double)(rectangle.height / k1) * this.barWidthFraction;
                i += (int)Math.round(d3 * 1.25 * 0.75);
            }
        }
        if ((insets = this.getGraphInsets()) != null) {
            k = insets.top == -1 ? k : insets.top;
            i = insets.left == -1 ? i : insets.left;
            l = insets.bottom == -1 ? l : insets.bottom;
            j = insets.right == -1 ? j : insets.right;
        }
        rectangle.x = i;
        rectangle.width = dimension.width - i - j;
        rectangle.y = k;
        rectangle.height = dimension.height - k - l;
        this.currentBounds = rectangle;
        return rectangle;
    }

    private void paint3DZeroDivider(Graphics g, Rectangle rectangle) {
        g.setColor(this.getChartForeground());
        if (this.barAlignment == 1) {
            int i = Math.max(this.zeroLine, rectangle.y);
            i = Math.min(i, rectangle.y + rectangle.height);
            int k = rectangle.x - this.depth3dPoint.x;
            int i1 = i - this.depth3dPoint.y;
            g.drawLine(k, i1, k + rectangle.width, i1);
            g.drawLine(k + rectangle.width, i1, rectangle.x + rectangle.width, i);
        } else {
            int j = Math.max(this.zeroLine, rectangle.x);
            j = Math.min(j, rectangle.x + rectangle.width);
            int l = rectangle.y - this.depth3dPoint.y;
            int j1 = j - this.depth3dPoint.x;
            g.drawLine(j1, l, j1, l + rectangle.height);
            g.drawLine(j1, l, j, rectangle.y);
        }
    }

    public void setValueLinesColor(Color color) {
        this.valueLinesColor = color;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color getValueLinesColor() {
        return this.valueLinesColor;
    }

    private void paintFloatingLabel(Graphics g, int i, int j, String s, FontMetrics fontmetrics) {
        if (i < 0 || i >= this.getSeriesCount() || j < 0 || j >= this.getSampleCount()) {
            return;
        }
        Rectangle rectangle = this.barBounds[i][j];
        if (rectangle == null) {
            return;
        }
        int k = fontmetrics.getHeight();
        int l = fontmetrics.getDescent();
        int i1 = fontmetrics.stringWidth(s);
        int j1 = rectangle.x + rectangle.width / 2 - i1 / 2 + 1;
        int k1 = this.mousePosition.y - 2;
        j1 = Math.max(j1, 3);
        j1 = Math.min(j1, this.getSize().width - i1 - 3);
        if (this.mousePosition.y < 0) {
            k1 = rectangle.y + rectangle.height / 2 + fontmetrics.getAscent() / 2 - 1;
        }
        g.setColor(new Color(255, 255, 231));
        g.fillRect(j1 - 2, k1 - k + l * 2 - 2, i1 + 5, k - l * 2 + 4);
        g.setColor(this.getChartForeground());
        if (this.getSeriesCount() == 1 && this.multiColorOn) {
            g.setColor(this.getSampleColor(j).darker());
        } else if (this.multiColorOn) {
            g.setColor(this.getSampleColor(i).darker());
        }
        g.drawRect(j1 - 3, k1 - k + l * 2 - 3, i1 + 5, k - l * 2 + 5);
        g.setColor(Color.black);
        g.drawString(s, j1, k1);
    }

    private double getHighestBar() {
        double d = 0.0;
        if (this.barType == 0) {
            d = this.getMaxValue(-1);
        } else {
            int i = this.getSampleCount();
            int j = this.getSeriesCount();
            int k = 0;
            while (k < i) {
                double d1 = 0.0;
                int l = 0;
                while (l < j) {
                    ChartSample chartsample = this.getSample(l, k);
                    if (chartsample != null && chartsample.value != null && !chartsample.value.isNaN() && chartsample.value > 0.0) {
                        d1 += chartsample.value.doubleValue();
                    }
                    ++l;
                }
                d = Math.max(d, d1);
                ++k;
            }
        }
        return d;
    }

    private double getDeepestBar() {
        double d = 0.0;
        if (this.barType == 0) {
            d = this.getMinValue(-1);
        } else {
            int i = this.getSampleCount();
            int j = this.getSeriesCount();
            int k = 0;
            while (k < i) {
                double d1 = 0.0;
                int l = 0;
                while (l < j) {
                    double d2 = this.getSampleValue(l, k);
                    ChartSample chartsample = this.getSample(l, k);
                    if (chartsample != null && chartsample.value != null && !chartsample.value.isNaN() && chartsample.value < 0.0) {
                        d1 += d2;
                    }
                    ++l;
                }
                d = Math.min(d, d1);
                ++k;
            }
        }
        return d;
    }

    private void paintBar(Graphics g, int i, int j) {
        ChartSample chartsample = this.getSample(i, j);
        if (chartsample == null || chartsample.value == null || chartsample.getFloatValue() == 0.0 && this.barType == 1) {
            return;
        }
        double d = chartsample.getFloatValue();
        if (this.barType != 1 && (d < this.lowerRange && this.lowerRange > 0.0 || d > this.upperRange && this.upperRange < 0.0)) {
            return;
        }
        if (this.multiColorOn) {
            if (this.getSeriesCount() > 1 || this.barType == 1 || this.multiSeriesOn) {
                g.setColor(this.getSampleColor(i));
            } else {
                g.setColor(this.getSampleColor(j));
            }
        } else {
            g.setColor(this.getSampleColor(0));
        }
        boolean flag = chartsample != null && chartsample.isSelected();
        Rectangle rectangle = this.barBounds[i][j];
        Color color = this.getChartForeground();
        if (this.barOutlineOn) {
            g.fillRect(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height);
            Color color1 = g.getColor();
            g.setColor(color);
            g.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (flag) {
                g.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
            }
            g.setColor(color1);
        } else {
            if (this.barAlignment == 1) {
                g.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                g.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (flag) {
                Color color2 = g.getColor();
                g.setColor(color);
                if (this.barAlignment == 1) {
                    g.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                } else {
                    g.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                }
                g.setColor(color2);
            }
        }
        if (this.is3DModeOn()) {
            this.paint3DBar(g, rectangle, flag, d);
        }
    }

    public void processEvent(AWTEvent awtevent) {
        switch (awtevent.getID()) {
            default: {
                break;
            }
            case 505: {
                this.selectedSample = -1;
                this.selectedSeries = -1;
                this.repaint();
                break;
            }
            case 503: 
            case 506: {
                MouseEvent mouseevent = (MouseEvent)awtevent;
                boolean flag = this.isValueLabelsOn() && this.valueLabelStyle == 2;
                boolean bl = flag = flag || this.barLabelsOn && (this.barLabelStyle == 1 || this.barLabelStyle == 2);
                if (!flag) break;
                this.mousePosition.x = mouseevent.getX();
                this.mousePosition.y = mouseevent.getY();
                ChartSample chartsample = super.checkSelection(this.mousePosition);
                if (chartsample != null) {
                    this.mousePosition.x = -1;
                    this.mousePosition.y = -1;
                } else {
                    chartsample = this.checkSelection(this.mousePosition);
                }
                if (chartsample != null) {
                    if (chartsample.getIndex() == this.selectedSample && chartsample.getSeries() == this.selectedSeries) break;
                    this.selectedSample = chartsample.getIndex();
                    this.selectedSeries = chartsample.getSeries();
                    this.repaint();
                    break;
                }
                boolean flag1 = this.selectedSample != -1 || this.selectedSeries != -1;
                this.selectedSample = -1;
                this.selectedSeries = -1;
                if (!flag1) break;
                this.repaint();
            }
        }
        super.processEvent(awtevent);
    }

    private void paintGrid(Graphics g, Rectangle rectangle) {
        Polygon polygon = new Polygon();
        polygon.addPoint(rectangle.x, rectangle.y);
        polygon.addPoint(rectangle.x - this.depth3dPoint.x, rectangle.y - this.depth3dPoint.y);
        polygon.addPoint(polygon.xpoints[1], polygon.ypoints[1] + rectangle.height);
        polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
        polygon.addPoint(rectangle.x, rectangle.y);
        Polygon polygon1 = new Polygon();
        polygon1.addPoint(rectangle.x, rectangle.y + rectangle.height);
        polygon1.addPoint(polygon.xpoints[2], polygon.ypoints[2]);
        polygon1.addPoint(polygon1.xpoints[1] + rectangle.width, polygon1.ypoints[1]);
        polygon1.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        polygon1.addPoint(polygon1.xpoints[0], polygon1.ypoints[0]);
        Color color = this.getChartBackground();
        g.setColor(color);
        g.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        boolean flag = this.is3DModeOn();
        if (flag) {
            g.setColor(this.barAlignment == 1 ? color : color.darker());
            g.fillPolygon(polygon);
            g.setColor(this.barAlignment == 0 ? color : color.darker());
            g.fillPolygon(polygon1);
        }
        g.setFont(this.getFont("rangeLabelFont"));
        FontMetrics fontmetrics = g.getFontMetrics();
        int i = this.getRangeDecimalCount();
        if (this.valueLinesOn || this.rangeLabelsOn) {
            String s6;
            double d;
            String s = this.getLabel("rangeLabelPrefix");
            String s1 = this.getLabel("rangeLabelPostfix");
            int j = 0;
            if (this.barAlignment == 1) {
                j = (int)Math.round((double)rectangle.height / (double)fontmetrics.getHeight());
            } else {
                String s4 = this.formatNumber(this.upperRange, i);
                String s5 = this.formatNumber(this.lowerRange, i);
                if (s != null && s.length() > 0) {
                    s4 = String.valueOf(s) + s4;
                    s5 = String.valueOf(s) + s5;
                }
                if (s1 != null && s1.length() > 0) {
                    s4 = String.valueOf(s4) + s1;
                    s5 = String.valueOf(s5) + s1;
                }
                int j1 = Math.max(fontmetrics.stringWidth(s4), fontmetrics.stringWidth(s5)) + 4;
                j = (int)Math.round((double)rectangle.width / (double)j1);
            }
            j = Math.min(this.maxValueLineCount, j);
            int k = (int)Math.round((this.upperRange - this.lowerRange) * Math.pow(10.0, i));
            j = Math.min(j, k);
            j = Math.max(1, j);
            double d1 = d = (this.upperRange - this.lowerRange) / (double)j;
            boolean flag1 = false;
            double d2 = 1.0E-9;
            while (!flag1 && d2 < 1.0E14) {
                int k2 = 0;
                while (k2 < STEPS.length) {
                    if (!(STEPS[k2] * d2 < d)) {
                        d1 = STEPS[k2] * d2;
                        flag1 = true;
                        break;
                    }
                    ++k2;
                }
                d2 *= 10.0;
            }
            Color color1 = this.getForeground();
            if (this.upperRange > 0.0) {
                double d3 = Math.max(0.0, this.lowerRange - this.lowerRange % d1);
                while (d3 < this.upperRange) {
                    String s7;
                    String string = s7 = this.rangeLabelsOn ? this.formatNumber(d3, i) : null;
                    if (s7 != null && s != null) {
                        s7 = String.valueOf(s) + s7;
                    }
                    if (s7 != null && s1 != null) {
                        s7 = String.valueOf(s7) + s1;
                    }
                    this.paintValueLine(g, rectangle, d3, this.valueLinesColor, s7, color1, fontmetrics, false, false);
                    d3 += d1;
                }
            }
            if (this.lowerRange < 0.0) {
                double d4 = Math.min(0.0, this.upperRange - this.upperRange % d1);
                while (d4 > this.lowerRange) {
                    String s8;
                    String string = s8 = this.rangeLabelsOn ? this.formatNumber(d4, i) : null;
                    if (s8 != null && s != null) {
                        s8 = String.valueOf(s) + s8;
                    }
                    if (s8 != null && s1 != null) {
                        s8 = String.valueOf(s8) + s1;
                    }
                    this.paintValueLine(g, rectangle, d4, this.valueLinesColor, s8, color1, fontmetrics, false, false);
                    d4 -= d1;
                }
            }
            String string = s6 = this.rangeLabelsOn ? this.formatNumber(this.upperRange, i) : null;
            if (s6 != null && s != null) {
                s6 = String.valueOf(s) + s6;
            }
            if (s6 != null && s1 != null) {
                s6 = String.valueOf(s6) + s1;
            }
            this.paintValueLine(g, rectangle, this.upperRange, this.valueLinesColor, s6, this.getForeground(), fontmetrics, true, false);
            String string2 = s6 = this.rangeLabelsOn ? this.formatNumber(this.lowerRange, i) : null;
            if (s6 != null && s != null) {
                s6 = String.valueOf(s) + s6;
            }
            if (s6 != null && s1 != null) {
                s6 = String.valueOf(s6) + s1;
            }
            this.paintValueLine(g, rectangle, this.lowerRange, this.valueLinesColor, s6, this.getForeground(), fontmetrics, true, false);
        }
        g.setColor(this.getChartForeground());
        if (flag) {
            g.drawPolygon(polygon);
            g.drawPolygon(polygon1);
        }
        g.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Enumeration enumeration = this.targetValueLines.elements();
        while (enumeration.hasMoreElements()) {
            TargetValueLine targetvalueline = (TargetValueLine)enumeration.nextElement();
            this.paintValueLine(g, rectangle, targetvalueline.value, targetvalueline.color, targetvalueline.getLabel(i), targetvalueline.color, fontmetrics, true, true);
        }
        g.setColor(this.getChartForeground());
        if (this.getLabel("sampleAxisLabel") != null) {
            String s2 = this.getLabel("sampleAxisLabel");
            g.setFont(this.getFont("sampleAxisLabelFont"));
            FontMetrics fontmetrics1 = g.getFontMetrics();
            int l = 0;
            int k1 = 0;
            int i2 = fontmetrics1.stringWidth(s2);
            if (this.barAlignment == 1) {
                l = rectangle.x + rectangle.width / 2 - i2 / 2;
                k1 = rectangle.y + rectangle.height + fontmetrics1.getMaxAscent();
                if (this.is3DModeOn()) {
                    k1 -= this.depth3dPoint.y;
                    l -= this.depth3dPoint.x;
                }
                if (this.barLabelsOn && this.barLabelStyle != 1) {
                    k1 += this.getFontMetrics(this.getFont("barLabelFont")).getHeight();
                }
            } else {
                l = rectangle.x - i2 / 2;
                k1 = rectangle.y - 6;
                g.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y - 3);
            }
            g.drawString(s2, l, k1);
        }
        if (this.getLabel("rangeAxisLabel") != null) {
            String s3 = this.getLabel("rangeAxisLabel");
            g.setFont(this.getFont("rangeAxisLabelFont"));
            FontMetrics fontmetrics2 = g.getFontMetrics();
            int i1 = 0;
            int l1 = 0;
            int j2 = fontmetrics2.stringWidth(s3);
            if (this.barAlignment == 1) {
                i1 = rectangle.x - j2 / 2;
                l1 = rectangle.y - fontmetrics2.getHeight() / 2 - 1;
                g.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y - 3);
            } else {
                i1 = rectangle.x + rectangle.width / 2 - j2 / 2;
                l1 = rectangle.y + rectangle.height + fontmetrics2.getMaxAscent();
                if (this.is3DModeOn()) {
                    l1 -= this.depth3dPoint.y;
                    i1 -= this.depth3dPoint.x;
                }
                if (this.rangeLabelsOn) {
                    l1 += this.getFontMetrics(this.getFont("barLabelFont")).getHeight();
                }
            }
            g.drawString(s3, i1, l1);
        }
    }

    public void setBarType(int i) {
        if (i != 0 && i != 1) {
            throw new IllegalArgumentException("Invalid bar type: " + i);
        }
        this.barType = i;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getBarType() {
        return this.barType;
    }

    public synchronized double getFloatLowerRange() {
        return this.lowerRange;
    }

    public synchronized void setLowerRelativeRange(double d) {
        double d1 = this.getDeepestBar();
        Enumeration enumeration = this.targetValueLines.elements();
        while (enumeration.hasMoreElements()) {
            d1 = Math.min(((TargetValueLine)enumeration.nextElement()).value, d1);
        }
        if (d1 < 0.0) {
            this.setLowerRange(d1 * Math.abs(d));
        } else {
            this.setLowerRange(0.0);
        }
    }

    public synchronized void setLowerRelativeRange(double d, double d1) {
        double d2 = this.getDeepestBar();
        Enumeration enumeration = this.targetValueLines.elements();
        while (enumeration.hasMoreElements()) {
            d2 = Math.min(((TargetValueLine)enumeration.nextElement()).value, d2);
        }
        if (d2 < 0.0) {
            d1 = Math.abs(d1);
            double d3 = d2 * Math.abs(d);
            if (d1 % 1.0 == 0.0) {
                if (d3 % d1 == 0.0) {
                    this.setLowerRange(d3);
                } else {
                    this.setLowerRange(d3 - d3 % d1 - d1);
                }
            } else {
                double d4 = 0.0;
                while (d4 > d3) {
                    d4 -= d1;
                }
                this.setLowerRange(d4);
            }
        } else {
            this.setLowerRange(0.0);
        }
    }

    public void setValueLinesOn(boolean flag) {
        this.valueLinesOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    private void calculateBarBounds(Rectangle rectangle) {
        int i = this.getSampleCount();
        int j = this.getSeriesCount();
        if (this.barBounds == null || this.barBounds.length != j || this.barBounds[0].length != i) {
            Rectangle[][] arectangle = new Rectangle[j][i];
            int l = 0;
            while (l < j) {
                int j1 = 0;
                while (j1 < i) {
                    if (this.barBounds != null && l < this.barBounds.length && j1 < this.barBounds[0].length && this.barBounds[l][j1] != null) {
                        arectangle[l][j1] = this.barBounds[l][j1];
                    }
                    ++j1;
                }
                ++l;
            }
            this.barBounds = arectangle;
        }
        int k = 0;
        while (k < i) {
            int i1 = 0;
            while (i1 < j) {
                if (this.barBounds[i1][k] == null) {
                    this.barBounds[i1][k] = new Rectangle();
                }
                ++i1;
            }
            ++k;
        }
        double d = 0.0;
        double d1 = rectangle.width;
        if (i > 0 && j > 0) {
            d = this.barAlignment == 1 ? (double)rectangle.width / (double)i : (double)rectangle.height / (double)i;
            d1 = d * this.barWidthFraction;
            if (this.barType == 0) {
                d1 /= (double)j;
            }
        }
        double d2 = d * (1.0 - this.barWidthFraction);
        double d3 = 0.0;
        boolean flag = this.is3DModeOn();
        if (this.barAlignment == 1) {
            d3 = (double)rectangle.x + d2 / 2.0;
            if (flag) {
                d3 -= (double)this.depth3dPoint.x;
            }
        } else {
            d3 = (double)rectangle.y + d2 / 2.0;
            if (flag) {
                d3 -= (double)this.depth3dPoint.y;
            }
        }
        if (this.barAlignment == 1) {
            int k1 = 0;
            while (k1 < i) {
                int i2 = 0;
                while (i2 < j) {
                    Rectangle rectangle1 = this.barBounds[i2][k1];
                    rectangle1.x = (int)Math.round(d3);
                    rectangle1.width = (int)Math.round(d3 + d1) - rectangle1.x;
                    double d4 = this.getSampleValue(i2, k1);
                    if (d4 >= 0.0) {
                        int i3;
                        int k2;
                        double d6 = 0.0;
                        if (this.upperRange != 0.0) {
                            d6 = d4 / this.upperRange * (double)(this.zeroLine - rectangle.y);
                        }
                        rectangle1.height = (int)Math.round(d6);
                        rectangle1.y = this.zeroLine - rectangle1.height;
                        rectangle1.height = Math.max(0, rectangle1.height);
                        if (this.barType == 1 && i2 > 0) {
                            double d10 = 0.0;
                            int k3 = 0;
                            while (k3 < i2) {
                                if (this.getSampleValue(k3, k1) >= 0.0) {
                                    d10 += this.getSampleValue(k3, k1);
                                }
                                ++k3;
                            }
                            double d14 = 0.0;
                            if (this.upperRange != 0.0) {
                                d14 = d10 / this.upperRange * (double)(this.zeroLine - rectangle.y);
                            }
                            double d18 = (double)this.zeroLine - d14 - d6;
                            rectangle1.y = (int)Math.round(d18);
                            rectangle1.height = (int)Math.round(d6 + d18 - (double)Math.round(d18));
                        }
                        if ((k2 = rectangle1.y + rectangle1.height) > (i3 = rectangle.y + rectangle.height)) {
                            rectangle1.height -= k2 - i3;
                        }
                    } else {
                        double d7 = 0.0;
                        if (this.lowerRange != 0.0) {
                            d7 = d4 / this.lowerRange * (double)(rectangle.y + rectangle.height - this.zeroLine);
                        }
                        rectangle1.height = (int)Math.round(d7);
                        rectangle1.y = this.zeroLine;
                        if (this.barType == 1 && i2 > 0) {
                            double d11 = 0.0;
                            int l3 = 0;
                            while (l3 < i2) {
                                if (this.getSampleValue(l3, k1) < 0.0) {
                                    d11 += this.getSampleValue(l3, k1);
                                }
                                ++l3;
                            }
                            double d15 = 0.0;
                            if (this.lowerRange != 0.0) {
                                d15 = d11 / this.lowerRange * (double)(rectangle.y + rectangle.height - this.zeroLine);
                            }
                            double d19 = (double)this.zeroLine + d15;
                            rectangle1.y = (int)Math.round(d19);
                            rectangle1.height = (int)Math.round(d7 + d19 - (double)Math.round(d19));
                        }
                        if (rectangle1.y < rectangle.y) {
                            rectangle1.height -= rectangle.y - rectangle1.y;
                            rectangle1.y = rectangle.y;
                        }
                    }
                    if (flag) {
                        rectangle1.y -= this.depth3dPoint.y;
                    }
                    if (this.barType == 0 || i2 == j - 1) {
                        d3 += d1;
                    }
                    ++i2;
                }
                d3 += d2;
                ++k1;
            }
        } else {
            int l1 = 0;
            while (l1 < i) {
                int j2 = 0;
                while (j2 < j) {
                    Rectangle rectangle2 = this.barBounds[j2][l1];
                    rectangle2.y = (int)Math.round(d3);
                    rectangle2.height = (int)Math.round(d3 + d1) - rectangle2.y;
                    double d5 = this.getSampleValue(j2, l1);
                    if (d5 >= 0.0) {
                        double d8 = 0.0;
                        if (this.upperRange != 0.0) {
                            d8 = d5 / this.upperRange * (double)(rectangle.x + rectangle.width - this.zeroLine);
                        }
                        rectangle2.width = (int)Math.round(d8);
                        rectangle2.x = this.zeroLine;
                        if (this.barType == 1 && j2 > 0) {
                            double d12 = 0.0;
                            int i4 = 0;
                            while (i4 < j2) {
                                if (this.getSampleValue(i4, l1) >= 0.0) {
                                    d12 += this.getSampleValue(i4, l1);
                                }
                                ++i4;
                            }
                            double d16 = 0.0;
                            if (this.upperRange != 0.0) {
                                d16 = d12 / this.upperRange * (double)(rectangle.x + rectangle.width - this.zeroLine);
                            }
                            double d20 = (double)this.zeroLine + d16;
                            rectangle2.x = (int)Math.round(d20);
                            rectangle2.width = (int)Math.round(d8 + d20 - (double)Math.round(d20));
                        }
                        if (rectangle2.x < rectangle.x) {
                            rectangle2.width -= rectangle.x - rectangle2.x;
                            rectangle2.x = rectangle.x;
                        }
                    } else {
                        int j3;
                        int l2;
                        double d9 = 0.0;
                        if (this.lowerRange != 0.0) {
                            d9 = d5 / this.lowerRange * (double)(this.zeroLine - rectangle.x);
                        }
                        rectangle2.width = (int)Math.round(d9);
                        rectangle2.x = this.zeroLine - rectangle2.width;
                        if (this.barType == 1 && j2 > 0) {
                            double d13 = 0.0;
                            int j4 = 0;
                            while (j4 < j2) {
                                if (this.getSampleValue(j4, l1) < 0.0) {
                                    d13 += this.getSampleValue(j4, l1);
                                }
                                ++j4;
                            }
                            double d17 = 0.0;
                            if (this.lowerRange != 0.0) {
                                d17 = d13 / this.lowerRange * (double)(this.zeroLine - rectangle.x);
                            }
                            double d21 = (double)this.zeroLine - d17 - d9;
                            rectangle2.x = (int)Math.round(d21);
                            rectangle2.width = (int)Math.round(d9 + d21 - (double)Math.round(d21));
                        }
                        if ((l2 = rectangle2.x + rectangle2.width) > (j3 = rectangle.x + rectangle.width)) {
                            rectangle2.width -= l2 - j3;
                        }
                    }
                    if (flag) {
                        rectangle2.x -= this.depth3dPoint.x;
                    }
                    if (this.barType == 0 || j2 == j - 1) {
                        d3 += d1;
                    }
                    ++j2;
                }
                d3 += d2;
                ++l1;
            }
        }
    }

    public void setValueLabelStyle(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: {
                this.valueLabelStyle = i;
                this.hasChanged = true;
                this.autoRepaint();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid valueLabelStyle: " + i);
            }
        }
    }

    public int getValueLabelStyle() {
        return this.valueLabelStyle;
    }

    public boolean isBarOutlineOn() {
        return this.barOutlineOn;
    }

    protected ChartSample checkSelection(Point point) {
        ChartSample chartsample = null;
        int i = this.getSeriesCount();
        if (this.isLegendOn() && this.legendBounds != null) {
            int j = 0;
            while (j < this.legendBounds.length) {
                if (this.legendBounds[j] != null && this.legendBounds[j].contains(point)) {
                    if (i > 1 || this.barType == 1 || this.multiSeriesOn) {
                        chartsample = new ChartSample(-1);
                        chartsample.setSeries(j);
                        break;
                    }
                    chartsample = this.getSample(0, j);
                    break;
                }
                ++j;
            }
        }
        if (chartsample == null && this.barBounds != null) {
            int k = 0;
            while (k < this.barBounds.length) {
                Rectangle[] arectangle = this.barBounds[k];
                if (arectangle != null) {
                    int l = 0;
                    while (l < arectangle.length) {
                        if (arectangle[l] != null && arectangle[l].contains(point)) {
                            return this.getSample(k, l);
                        }
                        ++l;
                    }
                }
                ++k;
            }
        }
        return chartsample;
    }

    public void setMaxValueLineCount(int i) {
        this.maxValueLineCount = i > -1 ? i : Integer.MAX_VALUE;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getMaxValueLineCount() {
        if (this.maxValueLineCount != Integer.MAX_VALUE) {
            return this.maxValueLineCount;
        }
        return -1;
    }

    public BarChart() {
        this(1);
    }

    public BarChart(int i) {
        this(i, 100.0);
    }

    public BarChart(int i, double d) {
        this(i, d, 0.0);
    }

    public BarChart(int i, double d, double d1) {
        this(1, i, d, d1);
    }

    public BarChart(int i, int j, double d, double d1) {
        super(j);
        this.setAutomaticRepaintOn(false);
        this.setSeriesCount(i);
        this.targetValueLines = new Hashtable();
        this.rangeLabelsOn = true;
        this.barOutlineOn = true;
        this.valueLinesColor = Color.lightGray;
        this.maxValueLineCount = Integer.MAX_VALUE;
        this.upperRange = d;
        this.lowerRange = d1;
        this.barAlignment = 1;
        this.barWidthFraction = 0.85;
        this.depth3dPoint = new Point();
        this.selectedSeries = -1;
        this.selectedSample = -1;
        this.mousePosition = new Point();
        this.setAutomaticRepaintOn(true);
    }

    private String constructFloatingLabel(int i, int j, boolean flag) {
        if (i < 0 || i >= this.getSeriesCount() || j < 0 || j >= this.getSampleCount()) {
            return "";
        }
        String s = "";
        if (this.barLabelsOn && (this.barLabelStyle == 1 || this.barLabelStyle == 2)) {
            if (this.getSeriesCount() == 1) {
                if (this.getSampleLabel(j) != null) {
                    s = String.valueOf(s) + this.getSampleLabel(j);
                }
            } else {
                if (flag && this.getSeriesLabel(i) != null) {
                    s = String.valueOf(s) + this.getSeriesLabel(i) + " : ";
                }
                if (this.getSampleLabel(j) != null) {
                    s = String.valueOf(s) + this.getSampleLabel(j);
                }
            }
        }
        if (this.isValueLabelsOn() && this.valueLabelStyle == 2) {
            String s2;
            String s1 = this.getLabel("valueLabelPrefix_" + i);
            if (s1 == null) {
                s1 = this.getLabel("valueLabelPrefix");
            }
            if ((s2 = this.getLabel("valueLabelPostfix_" + i)) == null) {
                s2 = this.getLabel("valueLabelPostfix");
            }
            if (s.length() > 0) {
                String s3 = this.formatNumber(this.getSampleValue(i, j), this.getSampleDecimalCount());
                s3 = s1 != null ? String.valueOf(s1) + s3 : s3;
                s3 = s2 != null ? String.valueOf(s3) + s2 : s3;
                s = String.valueOf(s) + " : " + s3;
            } else {
                s = this.formatNumber(this.getSampleValue(i, j), this.getSampleDecimalCount());
                s = s1 != null ? String.valueOf(s1) + s : s;
                s = s2 != null ? String.valueOf(s) + s2 : s;
            }
        }
        return s;
    }

    private void paint3DBar(Graphics g, Rectangle rectangle, boolean flag, double d) {
        Polygon polygon = new Polygon();
        polygon.addPoint(rectangle.x, rectangle.y);
        polygon.addPoint(polygon.xpoints[0] + this.depth3dPoint.x, polygon.ypoints[0] + this.depth3dPoint.y);
        polygon.addPoint(polygon.xpoints[1] + rectangle.width, polygon.ypoints[1]);
        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
        Polygon polygon1 = new Polygon();
        polygon1.addPoint(rectangle.x + rectangle.width, rectangle.y);
        polygon1.addPoint(polygon.xpoints[2], polygon.ypoints[2]);
        polygon1.addPoint(polygon.xpoints[2], polygon.ypoints[2] + rectangle.height);
        polygon1.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        g.setColor(g.getColor().darker());
        g.fillPolygon(polygon);
        g.setColor(g.getColor().darker());
        g.fillPolygon(polygon1);
        if (this.barOutlineOn) {
            g.setColor(this.getChartForeground());
            g.drawPolygon(polygon);
            g.drawPolygon(polygon1);
        }
    }

    private class TargetValueLine {
        String id;
        double value;
        Color color;
        int style;

        public String getLabel(int i) {
            switch (this.style) {
                case 1: {
                    return this.id;
                }
                case 2: {
                    String s = BarChart.this.formatNumber(this.value, i);
                    String s1 = BarChart.super.getLabel("rangeLabelPrefix");
                    String s2 = BarChart.super.getLabel("rangeLabelPostfix");
                    if (s1 != null) {
                        s = String.valueOf(s1) + s;
                    }
                    if (s2 != null) {
                        s = String.valueOf(s) + s2;
                    }
                    return s;
                }
                case 3: {
                    String s3 = String.valueOf(this.id) + " ";
                    String s4 = BarChart.this.formatNumber(this.value, i);
                    String s5 = BarChart.super.getLabel("rangeLabelPrefix");
                    String s6 = BarChart.super.getLabel("rangeLabelPostfix");
                    if (s5 != null) {
                        s4 = String.valueOf(s5) + s4;
                    }
                    if (s6 != null) {
                        s4 = String.valueOf(s4) + s6;
                    }
                    return String.valueOf(s3) + s4;
                }
            }
            return null;
        }

        public TargetValueLine(String s, double d, Color color1, int i) {
            this.id = s;
            this.value = d;
            this.color = color1;
            this.style = i;
        }
    }
}

