/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt.chart;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import softcore.awt.chart.ChartData;
import softcore.awt.chart.ChartSample;

public abstract class Chart
implements ItemSelectable {
    protected Component component;
    private Font font = new Font("Dialog", 0, 11);
    Dimension size = new Dimension(400, 400);
    Color foreground = Color.black;
    Color background = new Color(231, 221, 231);
    protected Image offImage;
    protected Graphics offGraphics;
    int offWidth;
    int offHeight;
    boolean forceRerender = true;
    boolean doubleBuffered = true;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    protected ChartData chartData;
    private Color[] sampleColors;
    private Color[] sampleLabelColors;
    private Color[] seriesLabelColors;
    private String chartTitle;
    private boolean chartTitleOn;
    private int sampleDecimalCount;
    private boolean legendOn;
    private int legendPosition;
    private boolean valueLabelsOn;
    private boolean display3dOn;
    private Color chartBackground;
    private Color chartForeground;
    private Hashtable labelFonts;
    private Hashtable labels = new Hashtable();
    String[] legendLabels;
    private boolean automaticRepaintOn;
    private Insets graphInsets = new Insets(-1, -1, -1, -1);
    private int lastSelectedSample;
    private int lastSelectedSeries;
    private ChartSample selectedSample;
    Rectangle[] legendBounds;
    private Vector listeners = new Vector();
    private NumberFormat numberFormatter;
    boolean hasChanged;
    int legendWidth;
    int legendHeight;
    private boolean colorDepth;
    long chartColorDepth;
    private static Color[] DEFAULT_SAMPLE_COLORS = new Color[]{new Color(132, 130, 255), new Color(132, 32, 99), new Color(255, 255, 198), new Color(165, 227, 231), new Color(99, 0, 132), new Color(255, 130, 132), new Color(0, 130, 198), new Color(198, 195, 255), new Color(0, 0, 132), new Color(255, 0, 255), new Color(255, 255, 0), new Color(0, 255, 255), new Color(132, 0, 132), new Color(132, 0, 0), new Color(0, 130, 132), new Color(0, 0, 255), new Color(0, 207, 255), new Color(107, 255, 255), new Color(206, 255, 206), new Color(255, 255, 156)};

    public void setComponent(Component component1) {
        this.component = component1;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setFont(Font font1) {
        this.font = font1;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Font getFont() {
        return this.font;
    }

    public void setSize(Dimension dimension) {
        this.size = new Dimension(dimension);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setSize(int i, int j) {
        this.size = new Dimension(i, j);
    }

    public Dimension getSize() {
        return new Dimension(this.size);
    }

    public int getMinWidth() {
        return 0;
    }

    public void setForeground(Color color) {
        this.foreground = color;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setBackground(Color color) {
        this.background = color;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color getBackground() {
        return this.background;
    }

    public FontMetrics getFontMetrics(Font font1) {
        if (this.component != null) {
            this.component.getFontMetrics(font1);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font1);
    }

    public void setCursor(Cursor cursor) {
        if (this.component != null) {
            this.component.setCursor(cursor);
        }
    }

    public int getLastSelectedSeries() {
        return this.lastSelectedSeries;
    }

    public void setLegendLabels(String[] as) {
        this.legendLabels = as != null ? as : null;
        this.autoRepaint();
    }

    public String[] getLegendLabels() {
        if (this.legendLabels != null) {
            return this.legendLabels;
        }
        if (this.getSeriesCount() == 1) {
            return this.getSampleLabels();
        }
        return this.getSeriesLabels();
    }

    public void clearSelection() {
        this.setSelection(-1, -1, false);
    }

    public boolean isFrameOn() {
        return false;
    }

    public boolean isTitleOn() {
        return this.chartTitleOn;
    }

    public void setLegendPosition(int i) {
        if (i != 2 && i != 3 && i != 0 && i != 1) {
            throw new IllegalArgumentException("Should be TOP, BOTTOM, LEFT, or RIGHT");
        }
        this.legendPosition = i;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getLegendPosition() {
        return this.legendPosition;
    }

    public boolean is3DModeOn() {
        return this.display3dOn;
    }

    public void repaint() {
        if (this.component != null) {
            this.component.repaint();
        }
    }

    protected void autoRepaint() {
        if (this.automaticRepaintOn && this.component != null) {
            this.repaint();
        }
    }

    public void setChartForeground(Color color) {
        this.chartForeground = color;
    }

    public Color getChartForeground() {
        return this.chartForeground;
    }

    public static String getVersion() {
        return "2.05";
    }

    public void setSampleColor(int i, Color color) {
        if (i < 0) {
            throw new IllegalArgumentException("Negativ index");
        }
        this.sampleColors[i % this.sampleColors.length] = color;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color getSampleColor(int i) {
        Color color = DEFAULT_SAMPLE_COLORS[i % DEFAULT_SAMPLE_COLORS.length];
        if (this.sampleColors != null && this.sampleColors.length > 0 && (color = this.sampleColors[i % this.sampleColors.length]) == null) {
            int j = Math.min(this.sampleColors.length, DEFAULT_SAMPLE_COLORS.length);
            color = DEFAULT_SAMPLE_COLORS[i % j];
        }
        return color;
    }

    public void setLegendOn(boolean flag) {
        this.legendOn = flag;
        this.legendWidth = 0;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized void setSamples(int i, ChartSample[] achartsample) {
        this.chartData.setSamples(i, achartsample);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized ChartSample[] getSamples(int i) {
        return this.chartData.getSamples(i);
    }

    public synchronized void setSamples(ChartSample[] achartsample) {
        this.chartData.setSamples(0, achartsample);
    }

    public synchronized ChartSample[] getSamples() {
        return this.getSamples(0);
    }

    public Object[] getSelectedObjects() {
        int i = this.getSeriesCount();
        int j = this.getSampleCount();
        int k = 0;
        int l = 0;
        while (l < i) {
            int i1 = 0;
            while (i1 < j) {
                if (this.isSelected(l, i1)) {
                    ++k;
                }
                ++i1;
            }
            ++l;
        }
        if (k > 0) {
            Object[] aobj = new Object[k];
            int j1 = 0;
            int k1 = 0;
            while (k1 < i) {
                int l1 = 0;
                while (l1 < j) {
                    if (this.isSelected(k1, l1) && j1 < aobj.length) {
                        aobj[j1++] = this.getSample(k1, l1);
                    }
                    ++l1;
                }
                ++k1;
            }
            return aobj;
        }
        return null;
    }

    public double getMinValue(int i) {
        return this.chartData.getMinValue(i);
    }

    public synchronized double getFloatSampleValue(int i) {
        return this.getSampleValue(0, i);
    }

    public long getMinValue() {
        return (long)this.getMinValue(0);
    }

    public String toString() {
        String s = this.getTitle();
        return s == null ? super.toString() : s;
    }

    public synchronized double[] getFloatSampleValues() {
        return this.getSampleValues(0);
    }

    public void setChartData(ChartData chartdata) {
        this.chartData = chartdata;
        this.checkDataIntegrity();
        this.autoRepaint();
    }

    public ChartData getChartData() {
        return this.chartData;
    }

    public void setValueLabelsOn(boolean flag) {
        this.valueLabelsOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setTitleFont(Font font1) {
        this.setFont("titleFont", font1);
    }

    public Font getTitleFont() {
        return this.getFont("titleFont");
    }

    public void setFont(String s, Font font1) {
        if (s == null || s.trim().length() < 1) {
            return;
        }
        s = s.trim().toLowerCase();
        if (font1 != null) {
            this.labelFonts.put(s, font1);
        } else {
            this.labelFonts.remove(s);
        }
        this.hasChanged = true;
    }

    public Font getFont(String s) {
        Font font1;
        if (s == null) {
            this.getFont();
        }
        if ((font1 = (Font)this.labelFonts.get(s.trim().toLowerCase())) != null) {
            return font1;
        }
        return this.getFont();
    }

    public synchronized void setSeriesLabels(String[] as) {
        this.chartData.setSeriesLabels(as);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized String[] getSeriesLabels() {
        return this.chartData.getSeriesLabels();
    }

    public String getSelectedSeriesLabel() {
        String[] as = this.getSeriesLabels();
        return as == null || this.lastSelectedSeries < 0 || this.lastSelectedSeries >= as.length ? null : as[this.lastSelectedSeries];
    }

    public String getSelectedSampleLabel() {
        String[] as = this.getSampleLabels();
        return as == null || this.lastSelectedSample < 0 || this.lastSelectedSample >= as.length ? null : as[this.lastSelectedSample];
    }

    public void removeItemListener(ItemListener itemlistener) {
        if (itemlistener != null && this.listeners != null) {
            this.listeners.removeElement(itemlistener);
        }
    }

    protected abstract void render(Graphics var1, boolean var2);

    public boolean isValueLabelsOn() {
        return this.valueLabelsOn;
    }

    public void setTrackSelectionOn(boolean flag) {
    }

    public void setAutomaticRepaintOn(boolean flag) {
        this.automaticRepaintOn = flag;
    }

    public void setSelection(int i, int j, boolean flag) {
        this.setSelection(i, j, flag, false);
    }

    private void setSelection(int i, int j, boolean flag, boolean flag1) {
        this.chartData.setSelection(i, j, flag, flag1);
        this.lastSelectedSample = -1;
        this.lastSelectedSeries = -1;
        if (j == -1 && i == -1) {
            if (this.selectedSample != null) {
                this.notifyListeners(this, 2, this.selectedSample);
                this.selectedSample = null;
            }
        } else if (j == -1 && i != -1) {
            ChartSample chartsample = new ChartSample(j);
            chartsample.setSeries(i);
            if (this.legendLabels != null && i < this.legendLabels.length && this.legendLabels[i] != null) {
                chartsample.setLabel(this.legendLabels[i]);
            } else {
                chartsample.setLabel(this.getSeriesLabel(i));
            }
            if (flag) {
                this.lastSelectedSeries = i;
                if ((this.selectedSample == null || chartsample.getSeries() != this.selectedSample.getSeries()) && this.selectedSample != null) {
                    this.notifyListeners(this, 2, this.selectedSample);
                }
                this.notifyListeners(this, 1, chartsample);
                this.selectedSample = chartsample;
            } else {
                this.notifyListeners(this, 2, chartsample);
                if (chartsample == this.selectedSample) {
                    this.selectedSample = null;
                }
            }
        } else if (j != -1 && i != -1) {
            ChartSample chartsample1 = this.getSample(i, j);
            if (flag) {
                this.lastSelectedSample = j;
                this.lastSelectedSeries = i;
                if (this.selectedSample != null && chartsample1 != this.selectedSample) {
                    this.notifyListeners(this, 2, this.selectedSample);
                }
                this.notifyListeners(this, 1, chartsample1);
                this.selectedSample = chartsample1;
            } else {
                this.notifyListeners(this, 2, chartsample1);
                if (chartsample1 == this.selectedSample) {
                    this.selectedSample = null;
                }
            }
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    protected Rectangle getGraphBounds(String[] as) {
        if (as == null) {
            throw new IllegalArgumentException("Labels is NULL");
        }
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(10, 10, dimension.width - 20, dimension.height - 20);
        FontMetrics fontmetrics = this.getFontMetrics(this.getFont("legendFont"));
        int i = fontmetrics.getHeight();
        if (this.chartTitleOn) {
            FontMetrics fontmetrics1 = this.getFontMetrics(this.getFont("titleFont"));
            int k = fontmetrics1.getAscent();
            rectangle.y += k;
            rectangle.height -= k;
        }
        if (this.legendOn) {
            int j = this.getSampleCount();
            int l = this.getSeriesCount();
            int i1 = as.length;
            if (l == 1) {
                i1 = 0;
                int j1 = 0;
                while (j1 < as.length) {
                    ChartSample chartsample;
                    if (j1 < j && (chartsample = this.getSample(0, j1)) != null && chartsample.value != null) {
                        ++i1;
                    }
                    ++j1;
                }
                i1 = Math.min(i1, as.length);
            }
            this.legendWidth = 0;
            int k1 = 0;
            while (k1 < as.length) {
                int l1;
                if (as[k1] != null && (l1 = fontmetrics.stringWidth(as[k1])) > this.legendWidth) {
                    this.legendWidth = l1;
                }
                ++k1;
            }
            this.legendWidth += 14;
            this.legendHeight = i * i1;
            switch (this.legendPosition) {
                default: {
                    rectangle.width -= this.legendWidth;
                    break;
                }
                case 0: {
                    rectangle.x += this.legendWidth;
                    rectangle.width -= this.legendWidth;
                    break;
                }
                case 2: {
                    rectangle.y += 20 + i;
                    rectangle.height -= 20 + i;
                    this.legendWidth = dimension.width - 20;
                    break;
                }
                case 3: {
                    rectangle.height -= i + 10;
                    this.legendWidth = dimension.width - 20;
                    this.legendHeight = i + 10;
                }
            }
        }
        return rectangle;
    }

    public void setChartBackground(Color color) {
        this.chartBackground = color;
    }

    public Color getChartBackground() {
        return this.chartBackground;
    }

    synchronized void paintLegend(Graphics g, Rectangle rectangle, String[] as) {
        if (g == null || rectangle == null || as == null) {
            return;
        }
        int byte0 = 6;
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        g.setFont(this.getFont("legendFont"));
        FontMetrics fontmetrics = g.getFontMetrics();
        int i1 = fontmetrics.getHeight();
        int j1 = this.getSeriesCount();
        int k1 = this.getSampleCount();
        int l1 = as.length;
        if (j1 == 1) {
            l1 = 0;
            int i2 = 0;
            while (i2 < k1) {
                ChartSample chartsample = this.getSample(0, i2);
                if (chartsample != null && chartsample.value != null) {
                    ++l1;
                }
                ++i2;
            }
            l1 = Math.min(l1, as.length);
        }
        l1 = Math.max(1, l1);
        if (this.legendBounds == null || this.legendBounds.length != l1) {
            this.legendBounds = new Rectangle[l1];
            int j2 = 0;
            while (j2 < this.legendBounds.length) {
                this.legendBounds[j2] = new Rectangle();
                ++j2;
            }
        }
        switch (this.legendPosition) {
            default: {
                Dimension dimension = this.getSize();
                j = dimension.width - this.legendWidth - 2;
                k = j + byte0 + 4;
                i = dimension.height / 2 - this.legendHeight / 2;
                l = i + byte0 + 1;
                break;
            }
            case 0: {
                j = 8;
                k = j + byte0 + 4;
                Dimension dimension1 = this.getSize();
                i = dimension1.height / 2 - this.legendHeight / 2;
                l = i + byte0 + 1;
                break;
            }
            case 2: {
                l = rectangle.y - fontmetrics.getDescent() - 10;
                i = l - byte0 - i1;
                break;
            }
            case 3: {
                i = this.getSize().height - fontmetrics.getHeight() - byte0 - 5;
                l = i + byte0 + i1;
            }
        }
        int k2 = 0;
        int l2 = 0;
        while (l2 < as.length) {
            ChartSample chartsample1;
            if (j1 != 1 || l2 >= k1 || (chartsample1 = this.getSample(0, l2)) != null && chartsample1.value != null) {
                ChartSample chartsample2;
                String s = as[l2];
                if (s == null) {
                    s = " ";
                }
                if (this.legendPosition == 2 || this.legendPosition == 3) {
                    j = (int)((float)this.legendWidth * ((float)l2 / (float)l1));
                    k = (j += this.legendWidth / l1 / 2 + byte0) - fontmetrics.stringWidth(s) / 2 + byte0 / 2;
                }
                g.setColor(this.getSampleColor(l2));
                g.fillRect(j, i, byte0, byte0);
                g.setColor(Color.black);
                g.drawRect(j, i, byte0, byte0);
                g.setColor(this.getForeground());
                if (j1 == 1 && l2 < k1) {
                    g.setColor(this.getSampleLabelColor(l2));
                } else if (j1 > 1 && l2 < j1) {
                    g.setColor(this.getSeriesLabelColor(l2));
                }
                if (s != null && s.trim().length() > 0) {
                    g.drawString(s, k, l);
                }
                int i3 = 5;
                if (s != null && fontmetrics != null) {
                    i3 = fontmetrics.stringWidth(s);
                }
                Rectangle rectangle1 = this.legendBounds[k2];
                if (this.legendPosition == 1 || this.legendPosition == 0) {
                    rectangle1.setBounds(j - 3, l - i1 + 2, i3 + byte0 * 2 + 3, i1 + 1);
                } else {
                    rectangle1.setBounds(j + byte0 / 2 - i3 / 2 - 3, i - 3, i3 + 6, byte0 * 2 + i1);
                }
                g.setColor(this.getForeground());
                if (j1 > 1) {
                    boolean flag = false;
                    int j3 = 0;
                    while (j3 < k1) {
                        ChartSample chartsample3;
                        if (l2 < j1 && (chartsample3 = this.getSample(l2, j3)) != null && chartsample3.isSelected()) {
                            flag = true;
                        }
                        ++j3;
                    }
                    if (flag) {
                        g.drawRect(rectangle1.x, rectangle1.y, rectangle1.width, rectangle1.height);
                    }
                } else if (l2 < k1 && (chartsample2 = this.getSample(0, l2)) != null && chartsample2.isSelected()) {
                    g.drawRect(rectangle1.x, rectangle1.y, rectangle1.width, rectangle1.height);
                }
                ++k2;
                if (this.legendPosition == 1 || this.legendPosition == 0) {
                    i += i1 + 1;
                    l += i1 + 1;
                }
            }
            ++l2;
        }
    }

    public synchronized void setSeriesLabelColor(int i, Color color) {
        try {
            this.seriesLabelColors[i] = color;
            this.autoRepaint();
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid series index: " + i);
        }
    }

    public Color getSeriesLabelColor(int i) {
        try {
            return this.seriesLabelColors[i];
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid series index: " + i);
        }
    }

    public void setLabel(String s, String s1) {
        if (s != null && s.length() > 0) {
            s = s.toLowerCase().trim();
            if (s1 != null && s1.length() > 0) {
                this.labels.put(s, s1);
            } else {
                this.labels.remove(s);
            }
        }
    }

    public String getLabel(String s) {
        if (s != null) {
            s = s.toLowerCase().trim();
            return (String)this.labels.get(s);
        }
        return null;
    }

    public synchronized ChartSample getSample(Object obj) {
        return this.chartData.getSample(obj);
    }

    public synchronized int appendSample(int i, ChartSample chartsample, boolean flag) {
        int j = this.chartData.appendSample(i, chartsample, flag);
        this.checkDataIntegrity();
        this.hasChanged = true;
        this.autoRepaint();
        return j;
    }

    public synchronized void setSample(int i, int j, ChartSample chartsample) {
        this.chartData.setSample(i, j, chartsample);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized void setSample(int i, ChartSample chartsample) {
        this.setSample(0, i, chartsample);
    }

    public synchronized ChartSample getSample(int i) {
        return this.getSample(0, i);
    }

    public synchronized void setSample(int i, double d, String s, Object obj) {
        ChartSample chartsample = new ChartSample(i, d, s, obj);
        this.setSample(0, i, chartsample);
    }

    public synchronized ChartSample getSample(int i, int j) {
        return this.chartData.getSample(i, j);
    }

    public boolean isLegendOn() {
        return this.legendOn;
    }

    public synchronized String formatNumber(double d, int i) {
        if (i == 0 && d < 1000.0 && d > -1000.0) {
            return String.valueOf(Math.round(d));
        }
        if (this.numberFormatter == null) {
            this.numberFormatter = NumberFormat.getInstance();
        }
        this.numberFormatter.setMaximumFractionDigits(i);
        this.numberFormatter.setMinimumFractionDigits(i);
        return this.numberFormatter.format(d);
    }

    public void processEvent(AWTEvent awtevent) {
        switch (awtevent.getID()) {
            default: {
                break;
            }
            case 501: {
                if (this.colorDepth) {
                    this.colorDepth = false;
                    this.repaint();
                    break;
                }
                if (this.chartColorDepth == 983763298745252854L) break;
                Dimension dimension = this.getSize();
                int i = ((MouseEvent)awtevent).getX();
                int k = ((MouseEvent)awtevent).getY();
                if (i <= 0 || i >= 11 || k <= dimension.height - 11 || k >= dimension.height) break;
                this.colorDepth = true;
                this.repaint();
                break;
            }
            case 502: {
                ChartSample chartsample = this.checkSelection(new Point(((MouseEvent)awtevent).getX(), ((MouseEvent)awtevent).getY()));
                if (chartsample != null) {
                    int j = chartsample.getSeries();
                    if (j < 0 || j >= this.getSeriesCount()) break;
                    this.setSelection(j, chartsample.getIndex(), true, true);
                    this.repaint();
                    break;
                }
                if (this.selectedSample == null) break;
                this.setSelection(-1, -1, false, true);
                this.repaint();
                break;
            }
            case 101: {
                this.hasChanged = true;
                this.repaint();
            }
        }
    }

    public synchronized void setSeriesLabel(int i, String s) {
        this.chartData.setSeriesLabel(i, s);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized String getSeriesLabel(int i) {
        return this.chartData.getSeriesLabel(i);
    }

    public double getMaxValue(int i) {
        return this.chartData.getMaxValue(i);
    }

    public synchronized void setSampleValue(int i, int j, double d) {
        this.chartData.setSampleValue(i, j, d);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized double getSampleValue(int i, int j) {
        return this.chartData.getSampleValue(i, j);
    }

    public synchronized int appendSampleValue(int i, double d, boolean flag) {
        int j = this.chartData.appendSampleValue(i, d, flag);
        this.hasChanged = true;
        this.autoRepaint();
        return j;
    }

    public synchronized void setSampleValue(int i, double d) {
        this.setSampleValue(0, i, d);
    }

    public synchronized long getSampleValue(int i) {
        return (long)this.getSampleValue(0, i);
    }

    public synchronized int appendSampleValue(double d, boolean flag) {
        return this.appendSampleValue(0, d, flag);
    }

    public long getMaxValue() {
        return (long)this.getMaxValue(0);
    }

    public double getFloatMinValue() {
        return this.getMinValue(0);
    }

    public final void update(Graphics g) {
        this.paint(g);
    }

    public void setTitle(String s) {
        this.chartTitle = s;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public String getTitle() {
        return this.chartTitle;
    }

    private void paintChart(Graphics g) {
        Dimension dimension = this.getSize();
        int i = dimension.height / 2;
        int j = dimension.width / 2;
        g.setColor(Color.white);
        g.fillRect(0, 0, dimension.width, dimension.height);
        g.setColor(Color.black);
        g.setFont(new Font("Dialog", 1, 20));
        FontMetrics fontmetrics = g.getFontMetrics();
        String s = "EasyCharts " + Chart.getVersion();
        g.drawString(s, j - fontmetrics.stringWidth(s) / 2, i - 20);
        g.setFont(new Font("Dialog", 0, 10));
        fontmetrics = g.getFontMetrics();
        s = "(banner removed with registration)";
        g.drawString(s, j - fontmetrics.stringWidth(s) / 2, i - 5);
        s = "Copyright 1998-2000";
        g.drawString(s, j - fontmetrics.stringWidth(s) / 2, i + 10);
        s = "ObjectPlanet, Inc. - all rights reserved";
        g.drawString(s, j - fontmetrics.stringWidth(s) / 2, i + 25);
        s = "www.objectplanet.com/EasyCharts";
        g.drawString(s, j - fontmetrics.stringWidth(s) / 2, i + 40);
        g.setColor(Color.black);
        g.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
    }

    public void addItemListener(ItemListener itemlistener) {
        if (itemlistener != null) {
            this.listeners.addElement(itemlistener);
        }
    }

    public synchronized void setSampleValues(int i, double[] ad) {
        this.chartData.setSampleValues(i, ad);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized double[] getSampleValues(int i) {
        return this.chartData.getSampleValues(i);
    }

    public synchronized void setSampleValues(long[] al) {
        if (al == null || al.length < 1) {
            throw new IllegalArgumentException("Values are NULL or 0 length");
        }
        double[] ad = new double[al.length];
        int i = 0;
        while (i < ad.length) {
            ad[i] = al[i];
            ++i;
        }
        this.setSampleValues(0, ad);
    }

    public synchronized void setSampleValues(double[] ad) {
        this.setSampleValues(0, ad);
    }

    public synchronized long[] getSampleValues() {
        double[] ad = this.getSampleValues(0);
        long[] al = new long[ad.length];
        int i = 0;
        while (i < al.length) {
            al[i] = (long)ad[i];
            ++i;
        }
        return al;
    }

    public void setGraphInsets(int i, int j, int k, int l) {
        this.graphInsets.top = i;
        this.graphInsets.left = j;
        this.graphInsets.bottom = k;
        this.graphInsets.right = l;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized void setSampleLabels(String[] as) {
        this.chartData.setSampleLabels(as);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized String[] getSampleLabels() {
        return this.chartData.getSampleLabels();
    }

    public Insets getGraphInsets() {
        return this.graphInsets;
    }

    void paintTitle(Graphics g, Dimension dimension) {
        if (this.chartTitleOn && this.chartTitle != null) {
            g.setFont(this.getFont("titleFont"));
            FontMetrics fontmetrics = g.getFontMetrics();
            int i = fontmetrics.stringWidth(this.chartTitle);
            int j = dimension.width / 2 - i / 2;
            int k = fontmetrics.getMaxAscent() + 2;
            g.setColor(this.getForeground());
            g.drawString(this.chartTitle, j, k);
        }
    }

    public void setFrameOn(boolean flag) {
    }

    public void setTitleOn(boolean flag) {
        this.chartTitleOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void set3DModeOn(boolean flag) {
        this.display3dOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public boolean isAutomaticRepaintOn() {
        return this.automaticRepaintOn;
    }

    protected ChartSample checkSelection(Point point) {
        if (this.legendBounds == null || !this.legendOn) {
            return null;
        }
        ChartSample chartsample = null;
        int i = this.getSeriesCount();
        int j = this.getSampleCount();
        if (j > 0 && i > 0) {
            int k = 0;
            while (k < this.legendBounds.length) {
                if (this.legendBounds[k] != null && this.legendBounds[k].contains(point)) {
                    if (i == 1) {
                        chartsample = this.getSample(0, k);
                        break;
                    }
                    chartsample = new ChartSample(-1);
                    chartsample.setSeries(k);
                    break;
                }
                ++k;
            }
        }
        return chartsample;
    }

    public synchronized void setSeriesCount(int i) {
        this.chartData.setSeriesCount(i);
        this.checkDataIntegrity();
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized int getSeriesCount() {
        return this.chartData.getSeriesCount();
    }

    public void setSampleColors(Color[] acolor) {
        if (acolor != null) {
            this.sampleColors = acolor;
        } else {
            this.sampleColors = new Color[DEFAULT_SAMPLE_COLORS.length];
            System.arraycopy(DEFAULT_SAMPLE_COLORS, 0, this.sampleColors, 0, this.sampleColors.length);
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Chart(int i) {
        this(1, i);
    }

    public Chart(int i, int j) {
        this.chartData = new ChartData(i, j);
        this.sampleLabelColors = new Color[j];
        this.seriesLabelColors = new Color[i];
        this.chartBackground = Color.white;
        this.chartForeground = Color.black;
        this.labelFonts = new Hashtable();
        this.setFont("titleFont", new Font("Dialog", 1, 14));
        this.legendPosition = 1;
        this.setSampleColors(null);
        this.lastSelectedSample = -1;
        this.lastSelectedSeries = -1;
        this.automaticRepaintOn = true;
    }

    public synchronized void setSampleLabelColor(int i, Color color) {
        try {
            this.sampleLabelColors[i] = color;
            this.autoRepaint();
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid sample index: " + i);
        }
    }

    public Color getSampleLabelColor(int i) {
        try {
            return this.sampleLabelColors[i];
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid sample index: " + i);
        }
    }

    public synchronized void setSampleCount(int i) {
        this.chartData.setSampleCount(i);
        this.checkDataIntegrity();
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized int getSampleCount() {
        return this.chartData.getSampleCount();
    }

    public void setSampleDecimalCount(int i) {
        this.sampleDecimalCount = i;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getSampleDecimalCount() {
        return this.sampleDecimalCount;
    }

    public Color[] getSampleColors() {
        return this.sampleColors;
    }

    public boolean isSelected(int i, int j) {
        return this.chartData.isSelected(i, j);
    }

    public int getLastSelectedSample() {
        return this.lastSelectedSample;
    }

    public final void paint(Graphics g) {
        Dimension dimension = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, dimension.width, dimension.height);
        g.setColor(this.getForeground());
        if (!this.colorDepth) {
            this.render(g, false);
            this.hasChanged = false;
        }
        if (this.chartColorDepth != 983763298745252854L) {
            if (this.colorDepth) {
                this.paintChart(g);
            } else {
                g.setColor(Color.red);
                g.fill3DRect(1, dimension.height - 10, 9, 9, true);
            }
        }
    }

    public void setForceRerender(boolean flag) {
        this.forceRerender = flag;
    }

    public void setDoubleBuffered(boolean flag) {
        this.doubleBuffered = flag;
    }

    public void paint(Component component1, Graphics g, Rectangle rectangle) {
        if (rectangle == null && component1 != null) {
            rectangle = component1.getBounds();
        }
        if (!this.doubleBuffered) {
            this.paint(g);
            return;
        }
        if (this.offImage == null || this.offWidth != rectangle.width || this.offHeight != rectangle.height || this.hasChanged || this.forceRerender) {
            this.offWidth = rectangle.width;
            this.offHeight = rectangle.height;
            this.offImage = component1.createImage(this.offWidth, this.offHeight);
            if (this.offImage == null) {
                return;
            }
            this.offGraphics = this.offImage.getGraphics();
            this.paint(this.offGraphics);
            this.forceRerender = false;
        }
        if (this.offImage != null) {
            g.drawImage(this.offImage, 0, 0, component1);
        }
    }

    public synchronized void setSampleLabel(int i, String s) {
        this.chartData.setSampleLabel(i, s);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized String getSampleLabel(int i) {
        return this.chartData.getSampleLabel(i);
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 200);
    }

    protected synchronized void checkDataIntegrity() {
        int j;
        int i = this.chartData.getSeriesCount();
        if (i != this.seriesLabelColors.length) {
            this.hasChanged = true;
            Color[] acolor = new Color[i];
            int k = Math.min(i, this.seriesLabelColors.length);
            System.arraycopy(this.seriesLabelColors, 0, acolor, 0, k);
            this.seriesLabelColors = acolor;
        }
        if ((j = this.chartData.getSampleCount()) != this.sampleLabelColors.length) {
            this.hasChanged = true;
            Color[] acolor1 = new Color[j];
            int l = Math.min(j, this.sampleLabelColors.length);
            System.arraycopy(this.sampleLabelColors, 0, acolor1, 0, l);
            this.sampleLabelColors = acolor1;
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 70);
    }

    void notifyListeners(Chart chart, int i, Object obj) {
        if (this.listeners != null) {
            ItemEvent itemevent = new ItemEvent(chart, 701, obj, i);
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                ((ItemListener)enumeration.nextElement()).itemStateChanged(itemevent);
            }
        }
    }

    public double getFloatMaxValue() {
        return this.getMaxValue(0);
    }
}

