/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt.chart;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import softcore.awt.GraphData;
import softcore.awt.chart.Chart;
import softcore.awt.chart.ChartStyleDialogPanel;
import softcore.tac.Tac;

public class ChartComponent
extends JComponent
implements ActionListener,
MouseListener,
MouseMotionListener {
    Tac interposeTac;
    Chart chart;
    GraphData graphData;
    boolean chartAutoResize = false;
    JPopupMenu popupMenu;

    public void setInterposeTac(Tac tac) {
        this.interposeTac = tac;
    }

    Tac getInterposeTac() {
        return this.interposeTac;
    }

    public void setGraphData(GraphData graphdata) {
        this.graphData = graphdata;
    }

    public GraphData getGraphData() {
        return this.graphData;
    }

    public ChartComponent() {
        this.addDefaultPopupMenu();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public ChartComponent(Chart chart1) {
        this.chart = chart1;
        this.chart.setComponent(this);
        this._setPreferredSize();
        this.enableEvents(48L);
        this.addDefaultPopupMenu();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setChart(Chart chart1) {
        this.chart = chart1;
        this.chart.setComponent(this);
        this._setPreferredSize();
    }

    private void addDefaultPopupMenu() {
        this.addPopupMenuItem("\u8bbe\u7f6e\u56fe\u5f62\u98ce\u683c", "setchartstyle", this);
    }

    public Chart getChart() {
        return this.chart;
    }

    protected void paintComponent(Graphics g) {
        if (this.chart != null) {
            this.chart.paint(this, g, null);
        }
    }

    public void setChartAutoResize(boolean flag) {
        this.chartAutoResize = flag;
    }

    public void reshape(int i, int j, int k, int l) {
        super.reshape(i, j, k, l);
        this.setChartSize();
    }

    public void setChartSize() {
        if (this.chartAutoResize && this.chart != null) {
            Dimension dimension = this.getSize();
            this.chart.setSize(dimension);
        }
    }

    private void _setPreferredSize() {
        if (this.chart == null) {
            return;
        }
        int i = this.chart.getMinWidth();
        Dimension dimension = super.getPreferredSize();
        dimension.width = i;
        this.setPreferredSize(dimension);
    }

    private void showPopupMenu(int i, int j) {
        if (this.popupMenu != null) {
            this.popupMenu.show(this, i, j);
        }
    }

    public void addPopupMenuItem(String s, String s1, ActionListener actionlistener) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
        }
        if (s.equals("-")) {
            this.popupMenu.addSeparator();
        } else {
            JMenuItem jmenuitem = new JMenuItem(s);
            jmenuitem.setActionCommand(s1 == null ? s : s1);
            jmenuitem.addActionListener(actionlistener);
            this.popupMenu.add(jmenuitem);
        }
    }

    public JMenuItem getPopupMenuItemForCommand(String s) {
        if (this.popupMenu == null) {
            return null;
        }
        int i = 0;
        while (i < this.popupMenu.getComponentCount()) {
            Component component = this.popupMenu.getComponent(i);
            if (component instanceof JMenuItem && s.equals(((JMenuItem)component).getActionCommand())) {
                return (JMenuItem)component;
            }
            ++i;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionevent) {
        if ("setchartstyle".equals(actionevent.getActionCommand()) && this.chart != null) {
            ChartStyleDialogPanel.setChartStyle(this.chart);
        }
    }

    public void mouseClicked(MouseEvent mouseevent) {
        if (this.chart != null) {
            this.chart.processEvent(mouseevent);
        }
        if (this.interposeTac != null) {
            this.interposeTac.callProc(mouseevent.getClickCount() != 2 ? "onChartMouseClicked" : "onChartMouseDoubleClicked", null, new Object[]{this.chart});
        }
    }

    public void mousePressed(MouseEvent mouseevent) {
        if (this.popupMenu != null) {
            System.out.println(mouseevent);
            MouseEvent _tmp = mouseevent;
            if ((mouseevent.getModifiers() & 0x10) == 0) {
                this.showPopupMenu(mouseevent.getX(), mouseevent.getY());
                return;
            }
        }
        if (this.chart != null) {
            this.chart.processEvent(mouseevent);
        }
    }

    public void mouseReleased(MouseEvent mouseevent) {
        if (this.chart != null) {
            this.chart.processEvent(mouseevent);
        }
    }

    public void mouseEntered(MouseEvent mouseevent) {
        if (this.chart != null) {
            this.chart.processEvent(mouseevent);
        }
    }

    public void mouseExited(MouseEvent mouseevent) {
        if (this.chart != null) {
            this.chart.processEvent(mouseevent);
        }
    }

    public void mouseDragged(MouseEvent mouseevent) {
        if (this.chart != null) {
            this.chart.processEvent(mouseevent);
        }
    }

    public void mouseMoved(MouseEvent mouseevent) {
        if (this.chart != null) {
            this.chart.processEvent(mouseevent);
        }
    }
}

