/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt.chart;

import java.util.Hashtable;
import softcore.awt.chart.ChartSample;

public class ChartData {
    private ChartSample[][] data;
    private Hashtable sampleLookup;
    private String[] seriesLabels;
    private String[] sampleLabels;
    private int seriesCount;
    private int sampleCount;

    public synchronized ChartSample getSample(Object obj) {
        return (ChartSample)this.sampleLookup.get(obj);
    }

    public synchronized int appendSample(int i, ChartSample chartsample, boolean flag) {
        if (i < 0 || i >= this.seriesCount) {
            throw new IllegalArgumentException("Illegal serie: " + i);
        }
        int j = -1;
        int k = 0;
        while (k < this.sampleCount) {
            ChartSample chartsample1 = this.data[i][k];
            if (chartsample1 == null || chartsample1.value == null) {
                j = k;
                break;
            }
            ++k;
        }
        if (j >= 0) {
            this.setSample(i, j, chartsample);
            return j;
        }
        if (flag) {
            int l = this.sampleCount;
            this.setSampleCount(l + 1);
            this.setSample(i, l, chartsample);
            return l;
        }
        if (this.sampleCount > 0) {
            int i1 = 0;
            while (i1 < this.sampleLabels.length - 1) {
                this.sampleLabels[i1] = this.sampleLabels[i1 + 1];
                ++i1;
            }
            int j1 = 0;
            while (j1 < this.data[i].length - 1) {
                this.data[i][j1] = this.data[i][j1 + 1];
                ++j1;
            }
            this.setSample(i, this.sampleCount - 1, chartsample);
            return this.sampleCount - 1;
        }
        return -1;
    }

    public synchronized void setSample(int i, int j, ChartSample chartsample) {
        if (i < 0 || i >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + i);
        }
        try {
            chartsample.setIndex(j);
            chartsample.setSeries(i);
            this.data[i][j] = chartsample;
            if (chartsample.key == null) {
                chartsample.key = String.valueOf(i) + "." + j;
            }
            this.sampleLookup.put(chartsample.key, chartsample);
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid index: " + j);
        }
        catch (NullPointerException nullpointerexception) {
            System.out.println("Internal error: setSample(serie, index, sample) method");
        }
        this.setIndividualSampleLabel(i, j);
    }

    public synchronized void setSeriesLabel(int i, String s) {
        try {
            this.seriesLabels[i] = s;
            int j = 0;
            while (j < this.sampleCount) {
                this.setIndividualSampleLabel(i, j);
                ++j;
            }
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid series: " + i);
        }
    }

    public synchronized String getSeriesLabel(int i) {
        try {
            return this.seriesLabels[i];
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid series: " + i);
        }
    }

    private void setIndividualSampleLabel(int i, int j) {
        try {
            ChartSample chartsample = this.data[i][j];
            if (chartsample != null) {
                String s = this.seriesLabels[i];
                String s1 = this.sampleLabels[j];
                String s2 = "";
                if (s != null && s1 != null) {
                    s2 = String.valueOf(s) + " " + s1;
                } else if (s != null) {
                    s2 = s;
                } else if (s1 != null) {
                    s2 = s1;
                }
                chartsample.setLabel(s2);
            }
        }
        catch (Exception exception) {
            System.out.println("Internal error: ChartData.setIndividualSampleLabel(serie, sample)");
        }
    }

    public double getMaxValue(int i) {
        boolean flag = i >= 0 && i < this.seriesCount;
        boolean flag1 = false;
        double d = -1.7976931348623157E308;
        if (flag) {
            int j = 0;
            while (j < this.sampleCount) {
                ChartSample chartsample = this.data[i][j];
                if (chartsample != null && chartsample.value != null && !chartsample.value.isNaN()) {
                    d = Math.max(d, chartsample.getFloatValue());
                    flag1 = true;
                }
                ++j;
            }
        } else {
            int k = 0;
            while (k < this.seriesCount) {
                int l = 0;
                while (l < this.sampleCount) {
                    ChartSample chartsample1 = this.data[k][l];
                    if (chartsample1 != null && chartsample1.value != null && !chartsample1.value.isNaN()) {
                        d = Math.max(d, chartsample1.getFloatValue());
                        flag1 = true;
                    }
                    ++l;
                }
                ++k;
            }
        }
        if (flag1) {
            return d;
        }
        return 0.0;
    }

    public synchronized void setSampleValue(int i, int j, double d) {
        if (i < 0 || i >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + i);
        }
        try {
            if (this.data[i][j] == null) {
                this.data[i][j] = new ChartSample(j);
                this.data[i][j].setSeries(i);
                this.data[i][j].key = String.valueOf(i) + "." + j;
                this.sampleLookup.put(this.data[i][j].key, this.data[i][j]);
            }
            this.data[i][j].setValue(d);
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid index: " + j);
        }
        catch (NullPointerException nullpointerexception) {
            System.out.println("Internal error: setSampleValue(serie, index, value) method");
        }
        this.setIndividualSampleLabel(i, j);
    }

    public synchronized double getSampleValue(int i, int j) {
        if (i < 0 || i >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + i);
        }
        if (this.data[i] == null) {
            return 0.0;
        }
        if (j < 0 || j >= this.data[i].length) {
            throw new IllegalArgumentException("Invalid index: " + j);
        }
        if (this.data[i][j] != null) {
            return this.data[i][j].getFloatValue();
        }
        return 0.0;
    }

    public synchronized int appendSampleValue(int i, double d, boolean flag) {
        if (i < 0 || i >= this.seriesCount) {
            throw new IllegalArgumentException("Illegal serie: " + i);
        }
        int j = -1;
        int k = 0;
        while (k < this.sampleCount) {
            ChartSample chartsample = this.data[i][k];
            if (chartsample == null || chartsample.value == null) {
                j = k;
                break;
            }
            ++k;
        }
        if (j >= 0) {
            this.setSampleValue(i, j, d);
            return j;
        }
        if (flag) {
            int l = this.sampleCount;
            this.setSampleCount(l + 1);
            this.setSampleValue(i, l, d);
            return l;
        }
        if (this.sampleCount > 0) {
            double[] ad = this.getSampleValues(i);
            int i1 = 0;
            while (i1 < ad.length - 1) {
                ad[i1] = ad[i1 + 1];
                ++i1;
            }
            ad[ad.length - 1] = d;
            this.setSampleValues(i, ad);
            return ad.length - 1;
        }
        return -1;
    }

    public synchronized void setSamples(int i, ChartSample[] achartsample) {
        if (i < 0 || i >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + i);
        }
        if (this.data[i] == null) {
            this.data[i] = new ChartSample[this.sampleCount];
        }
        int j = 0;
        while (j < this.sampleCount) {
            if (achartsample != null && j < achartsample.length && achartsample[j] != null) {
                achartsample[j].setIndex(j);
                achartsample[j].setSeries(i);
                this.data[i][j] = achartsample[j];
                if (achartsample[j].key == null) {
                    achartsample[j].key = String.valueOf(i) + "." + j;
                }
                this.sampleLookup.put(achartsample[j].key, achartsample[j]);
            } else {
                this.data[i][j] = null;
            }
            ++j;
        }
        this.setIndividualSampleLabels();
    }

    public synchronized ChartSample[] getSamples(int i) {
        try {
            return this.data[i];
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid series: " + i);
        }
    }

    public synchronized void setSampleValues(int i, double[] ad) {
        if (i < 0 || i >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + i);
        }
        if (this.data[i] == null) {
            this.data[i] = new ChartSample[this.sampleCount];
        }
        int j = 0;
        while (j < this.sampleCount) {
            double d = 0.0;
            if (ad != null && j < ad.length) {
                d = ad[j];
            }
            if (this.data[i][j] == null) {
                this.data[i][j] = new ChartSample(j);
                this.data[i][j].setSeries(i);
                this.data[i][j].key = String.valueOf(i) + "." + j;
                this.sampleLookup.put(this.data[i][j].key, this.data[i][j]);
            }
            if (j < ad.length) {
                this.data[i][j].setValue(d);
            } else {
                this.data[i][j].value = null;
            }
            ++j;
        }
        this.setIndividualSampleLabels();
    }

    public synchronized double[] getSampleValues(int i) {
        try {
            ChartSample[] achartsample = this.data[i];
            double[] ad = new double[achartsample.length];
            int j = 0;
            while (j < achartsample.length) {
                if (achartsample[j] != null) {
                    ad[j] = achartsample[j].getFloatValue();
                }
                ++j;
            }
            return ad;
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid series: " + i);
        }
        catch (Exception exception) {
            System.out.println("Internal error: ChartData.getSampleValues(serie)");
            return null;
        }
    }

    public synchronized void setSampleLabels(String[] as) {
        int i = 0;
        while (i < this.sampleCount) {
            this.sampleLabels[i] = as == null ? null : (i < as.length ? as[i] : null);
            ++i;
        }
        this.setIndividualSampleLabels();
    }

    public synchronized String[] getSampleLabels() {
        String[] as = new String[this.sampleCount];
        System.arraycopy(this.sampleLabels, 0, as, 0, this.sampleLabels.length);
        return as;
    }

    public synchronized void setSeriesCount(int i) {
        this.setDataCount(i, this.sampleCount);
    }

    public synchronized int getSeriesCount() {
        return this.seriesCount;
    }

    public double getMinValue(int i) {
        boolean flag = i >= 0 && i < this.seriesCount;
        boolean flag1 = false;
        double d = Double.MAX_VALUE;
        if (flag) {
            int j = 0;
            while (j < this.sampleCount) {
                ChartSample chartsample = this.data[i][j];
                if (chartsample != null && chartsample.value != null && !chartsample.value.isNaN()) {
                    d = Math.min(d, chartsample.getFloatValue());
                    flag1 = true;
                }
                ++j;
            }
        } else {
            int k = 0;
            while (k < this.seriesCount) {
                int l = 0;
                while (l < this.sampleCount) {
                    ChartSample chartsample1 = this.data[k][l];
                    if (chartsample1 != null && chartsample1.value != null && !chartsample1.value.isNaN()) {
                        d = Math.min(d, chartsample1.getFloatValue());
                        flag1 = true;
                    }
                    ++l;
                }
                ++k;
            }
        }
        if (flag1) {
            return d;
        }
        return 0.0;
    }

    private void setDataCount(int i, int j) {
        if (this.seriesCount == i && this.sampleCount == j) {
            return;
        }
        this.seriesCount = Math.max(0, i);
        this.sampleCount = Math.max(0, j);
        ChartSample[][] achartsample = new ChartSample[this.seriesCount][this.sampleCount];
        int k = 0;
        while (k < achartsample.length) {
            if (k < this.data.length) {
                ChartSample[] achartsample1 = achartsample[k];
                int l = 0;
                while (l < achartsample1.length) {
                    if (l < this.data[k].length) {
                        achartsample[k][l] = this.data[k][l];
                    }
                    ++l;
                }
            }
            ++k;
        }
        this.data = achartsample;
        String[] as = new String[this.seriesCount];
        int i1 = 0;
        while (i1 < as.length) {
            if (i1 < this.seriesLabels.length) {
                as[i1] = this.seriesLabels[i1];
            }
            ++i1;
        }
        this.seriesLabels = as;
        String[] as1 = new String[this.sampleCount];
        int j1 = 0;
        while (j1 < as1.length) {
            if (j1 < this.sampleLabels.length) {
                as1[j1] = this.sampleLabels[j1];
            }
            ++j1;
        }
        this.sampleLabels = as1;
    }

    public String toString() {
        return "ChartData " + this.seriesCount + " series, " + this.sampleCount + " samples";
    }

    public ChartData(int i, int j) {
        this.seriesCount = Math.max(0, i);
        this.sampleCount = Math.max(0, j);
        this.data = new ChartSample[this.seriesCount][];
        int k = 0;
        while (k < this.data.length) {
            this.data[k] = new ChartSample[this.sampleCount];
            ++k;
        }
        this.seriesLabels = new String[this.seriesCount];
        this.sampleLabels = new String[this.sampleCount];
        int l = Math.max(1, j) * Math.max(1, i);
        this.sampleLookup = new Hashtable(l);
    }

    public boolean isSelected(int i, int j) {
        if (i < -1 || i >= this.seriesCount) {
            throw new IllegalArgumentException("Invalid series index: " + i);
        }
        if (j < -1 || j >= this.sampleCount) {
            throw new IllegalArgumentException("Invalid sample index: " + j);
        }
        boolean flag = true;
        if (i == -1 && j == -1) {
            int k = 0;
            while (k < this.seriesCount) {
                int j1 = 0;
                while (j1 < this.sampleCount) {
                    if (this.data[k] == null || this.data[k][j1] == null || !this.data[k][j1].isSelected()) {
                        flag = false;
                    }
                    ++j1;
                }
                ++k;
            }
        } else if (j == -1) {
            int l = 0;
            while (l < this.sampleCount) {
                if (this.data[i] != null && this.data[i][l] != null && !this.data[i][l].isSelected()) {
                    flag = false;
                }
                ++l;
            }
        } else if (i == -1) {
            int i1 = 0;
            while (i1 < this.seriesCount) {
                if (this.data[i1] != null && this.data[i1][j] != null && !this.data[i1][j].isSelected()) {
                    flag = false;
                }
                ++i1;
            }
        } else if (this.data[i] == null || this.data[i][j] == null || !this.data[i][j].isSelected()) {
            flag = false;
        }
        return flag;
    }

    public synchronized void setSampleCount(int i) {
        this.setDataCount(this.seriesCount, i);
    }

    public synchronized int getSampleCount() {
        return this.sampleCount;
    }

    public synchronized void setSampleLabel(int i, String s) {
        try {
            this.sampleLabels[i] = s;
            int j = 0;
            while (j < this.seriesCount) {
                this.setIndividualSampleLabel(j, i);
                ++j;
            }
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid index: " + i);
        }
    }

    public synchronized String getSampleLabel(int i) {
        try {
            return this.sampleLabels[i];
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid index: " + i);
        }
    }

    public synchronized void setSeriesLabels(String[] as) {
        int i = 0;
        while (i < this.seriesCount) {
            this.seriesLabels[i] = as == null ? null : (i < as.length ? as[i] : null);
            ++i;
        }
        this.setIndividualSampleLabels();
    }

    public synchronized String[] getSeriesLabels() {
        String[] as = new String[this.seriesCount];
        System.arraycopy(this.seriesLabels, 0, as, 0, as.length);
        return as;
    }

    private void setIndividualSampleLabels() {
        int i = 0;
        while (i < this.seriesCount) {
            ChartSample[] achartsample = this.data[i];
            if (achartsample != null) {
                int j = 0;
                while (j < achartsample.length) {
                    if (achartsample[j] != null) {
                        String s = this.seriesLabels[i];
                        String s1 = this.sampleLabels[j];
                        if (s != null && s1 != null) {
                            achartsample[j].setLabel(String.valueOf(s) + " " + s1);
                        } else if (s != null) {
                            achartsample[j].setLabel(s);
                        } else if (s1 != null) {
                            achartsample[j].setLabel(s1);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void setSelection(int i, int j, boolean flag) {
        this.setSelection(i, j, flag, false);
    }

    void setSelection(int i, int j, boolean flag, boolean flag1) {
        if (i < -1 || i >= this.seriesCount) {
            throw new IllegalArgumentException("Invalid series index: " + i);
        }
        if (j < -1 || j >= this.sampleCount) {
            throw new IllegalArgumentException("Invalid sample index: " + j);
        }
        if (flag1) {
            this.setSelection(false);
        }
        if (i == -1 && j == -1) {
            int k = 0;
            while (k < this.seriesCount) {
                int j1 = 0;
                while (j1 < this.sampleCount) {
                    if (this.data[k] != null && this.data[k][j1] != null) {
                        this.data[k][j1].setSelection(flag);
                    }
                    ++j1;
                }
                ++k;
            }
        } else if (i == -1) {
            int l = 0;
            while (l < this.sampleCount) {
                if (this.data[l] != null && this.data[l][j] != null) {
                    this.data[l][j].setSelection(flag);
                }
                ++l;
            }
        } else if (j == -1) {
            int i1 = 0;
            while (i1 < this.sampleCount) {
                if (this.data[i] != null && this.data[i][i1] != null) {
                    this.data[i][i1].setSelection(flag);
                }
                ++i1;
            }
        } else if (this.data[i] != null && this.data[i][j] != null) {
            this.data[i][j].setSelection(flag);
        }
    }

    private void setSelection(boolean flag) {
        int i = 0;
        while (i < this.seriesCount) {
            int j = 0;
            while (j < this.sampleCount) {
                if (this.data[i] != null && this.data[i][j] != null) {
                    this.data[i][j].setSelection(flag);
                }
                ++j;
            }
            ++i;
        }
    }

    public synchronized ChartSample getSample(int i, int j) {
        if (i < 0 || i >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + i);
        }
        try {
            return this.data[i][j];
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid index: " + j);
        }
        catch (NullPointerException nullpointerexception) {
            System.out.println("Internal error: getSample(serie, index");
            return null;
        }
    }
}

