/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt.chart;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import softcore.awt.chart.Chart;
import softcore.awt.chart.ChartSample;

public class LineChart
extends Chart {
    public static final int TARGET_LINE_NO_LABEL = 0;
    public static final int TARGET_LINE_ID_LABEL = 1;
    public static final int TARGET_LINE_VALUE_LABEL = 2;
    public static final int TARGET_LINE_ID_AND_VALUE_LABEL = 3;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE = 0;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_OPAQUE = 1;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_FILLED = 2;
    public static final int SAMPLE_HIGHLIGHT_SQUARE = 3;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_OPAQUE = 4;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_FILLED = 5;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND = 6;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_OPAQUE = 7;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_FILLED = 8;
    public static final int VALUE_LABELS_OUTSIDE_POINT = 0;
    public static final int VALUE_LABELS_AT_POINT = 1;
    private Hashtable targetValueLines;
    private double upperRange;
    private double lowerRange;
    private int rangeDecimalCount;
    private boolean valueLinesOn;
    private int valueLabelStyle;
    private int maxValueLineCount;
    private boolean sampleLabelsOn;
    private boolean rangeLabelsOn;
    private boolean autoLabelSpacingOn;
    private int[] lineWidth;
    private boolean rangeAdjusterOn;
    private boolean stackedOn;
    private Color valueLinesColor;
    private boolean[][] sampleHighlightOn;
    private int[] sampleHighlightStyle;
    private int[] sampleHighlightSize;
    private boolean[] seriesLinesOn;
    private boolean[] connectedLinesOn;
    private double currentUpperRange;
    private double currentLowerRange;
    private Point depth3dPoint;
    private static final double ANGLE = 1.25;
    private static final double[] STEPS = new double[]{1.0, 2.0, 2.5, 5.0};
    private static Cursor RESIZE_CURSOR;
    private static Cursor MOVE_CURSOR;
    private static Cursor DEFAULT_CURSOR;
    private boolean adjustingUpper;
    private boolean adjustingLower;
    private boolean slidingAdjuster;
    private int lastAdjusterClick;
    private Rectangle currentBounds;

    public void setSampleHighlightStyle(int i, int j) {
        int k = 0;
        while (k < this.sampleHighlightStyle.length) {
            this.setSampleHighlightStyle(k, i, j);
            ++k;
        }
    }

    public void setSampleHighlightStyle(int i, int j, int k) {
        this.sampleHighlightSize[i] = Math.max(0, k);
        this.sampleHighlightStyle[i] = j;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setSampleHighlightStyle(int i, int j, int k, boolean flag) {
        this.setSampleHighlightStyle(i, j, k);
    }

    public int getSampleHighlightStyle(int i) {
        try {
            return this.sampleHighlightStyle[i];
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid series: " + i);
        }
    }

    public void setConnectedLinesOn(int i, boolean flag) {
        if (i >= 0 && i < this.connectedLinesOn.length) {
            this.connectedLinesOn[i] = flag;
        } else if (i == -1) {
            int j = 0;
            while (j < this.connectedLinesOn.length) {
                this.connectedLinesOn[j] = flag;
                ++j;
            }
        }
        this.autoRepaint();
    }

    public synchronized void setRange(double d) {
        this.setUpperRange(d);
    }

    public synchronized void setUpperRange(double d) {
        this.upperRange = d;
        this.currentUpperRange = Math.min(this.currentUpperRange, d);
        if (!this.rangeAdjusterOn) {
            this.currentUpperRange = d;
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized long getRange() {
        return (long)this.upperRange;
    }

    public void setCurrentLowerRange(double d) {
        d = Math.max(this.lowerRange, d);
        this.currentLowerRange = d = Math.min(this.currentUpperRange, d);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public double getCurrentLowerRange() {
        return this.currentLowerRange;
    }

    public void setTargetValueLine(String s, double d, Color color, int i) {
        TargetValueLine targetvalueline;
        if (color != null) {
            switch (i) {
                default: {
                    throw new IllegalArgumentException("Invalid style");
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
            }
        }
        if ((targetvalueline = (TargetValueLine)this.targetValueLines.get(s)) != null) {
            if (color != null) {
                targetvalueline.value = d;
                targetvalueline.color = color;
            } else {
                this.targetValueLines.remove(s);
            }
        } else {
            this.targetValueLines.put(s, new TargetValueLine(s, d, color, i));
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public double getTargetValueLine(String s) {
        TargetValueLine targetvalueline = (TargetValueLine)this.targetValueLines.get(s);
        if (targetvalueline != null) {
            return targetvalueline.value;
        }
        throw new IllegalArgumentException("No target value line with the id: " + s);
    }

    public boolean isValueLinesOn() {
        return this.valueLinesOn;
    }

    public void setRangeLabelsOn(boolean flag) {
        this.rangeLabelsOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public String[] getLegendLabels() {
        if (this.legendLabels != null) {
            return this.legendLabels;
        }
        return this.getSeriesLabels();
    }

    public boolean isSampleLabelsOn() {
        return this.sampleLabelsOn;
    }

    public void setAutoLabelSpacingOn(boolean flag) {
        this.autoLabelSpacingOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized void setLowerRange(double d) {
        this.lowerRange = d;
        this.currentLowerRange = Math.max(this.currentLowerRange, d);
        if (!this.rangeAdjusterOn) {
            this.currentLowerRange = d;
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized long getLowerRange() {
        return (long)this.lowerRange;
    }

    public void setSeriesLineOn(boolean flag) {
        int i = 0;
        while (i < this.seriesLinesOn.length) {
            this.seriesLinesOn[i] = flag;
            ++i;
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setSeriesLineOn(int i, boolean flag) {
        this.seriesLinesOn[i] = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    private void paintSampleHighlight(Graphics g, int i, int j, int k, Color color) {
        int l = 6;
        if (i >= 0 && i < this.sampleHighlightSize.length) {
            l = this.sampleHighlightSize[i];
        }
        int i1 = 0;
        if (i >= 0 && i < this.sampleHighlightStyle.length) {
            i1 = this.sampleHighlightStyle[i];
        }
        Color color1 = this.getChartBackground();
        g.setColor(color);
        switch (i1) {
            default: {
                break;
            }
            case 0: {
                g.drawOval(j - l / 2, k - l / 2, l, l);
                break;
            }
            case 2: {
                g.fillOval(j - l / 2, k - l / 2, l + 1, l + 1);
                break;
            }
            case 1: {
                g.setColor(color1);
                g.fillOval(j - l / 2, k - l / 2, l + 1, l + 1);
                g.setColor(color);
                g.drawOval(j - l / 2, k - l / 2, l, l);
                break;
            }
            case 3: {
                g.drawRect(j - l / 2, k - l / 2, l, l);
                break;
            }
            case 5: {
                g.fillRect(j - l / 2, k - l / 2, l + 1, l + 1);
                break;
            }
            case 4: {
                g.setColor(color1);
                g.fillRect(j - l / 2, k - l / 2, l + 1, l + 1);
                g.setColor(color);
                g.drawRect(j - l / 2, k - l / 2, l, l);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                int[] ai = new int[4];
                ai[0] = ai[2] = j;
                ai[1] = j + l / 2;
                ai[3] = j - l / 2;
                int[] ai1 = new int[4];
                ai1[0] = k - l / 2;
                ai1[2] = k + l / 2;
                ai1[1] = ai1[3] = k;
                if (i1 == 7) {
                    g.setColor(color1);
                    g.fillPolygon(ai, ai1, 4);
                } else if (i1 == 8) {
                    g.setColor(color);
                    g.fillPolygon(ai, ai1, 4);
                }
                g.setColor(color);
                g.drawPolygon(ai, ai1, 4);
            }
        }
    }

    public void setRangeDecimalCount(int i) {
        this.rangeDecimalCount = i;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getRangeDecimalCount() {
        return this.rangeDecimalCount;
    }

    public boolean isSeriesLineOn() {
        boolean flag = true;
        int i = 0;
        while (i < this.seriesLinesOn.length) {
            if (!this.seriesLinesOn[i]) {
                flag = false;
            }
            ++i;
        }
        return flag;
    }

    public boolean isRangeAdjusterOn() {
        return this.rangeAdjusterOn;
    }

    public boolean isSeriesLineOn(int i) {
        return this.seriesLinesOn[i];
    }

    public double getFloatSampleValue(int i, int j) {
        return this.getSampleValue(i, j);
    }

    public boolean isSampleHighlightFilled(int i) {
        return false;
    }

    private void paintValueLine(Graphics g, Rectangle rectangle, double d, Color color, String s, Color color1, FontMetrics fontmetrics, boolean flag, boolean flag1) {
        double d1 = 0.0;
        if (this.currentUpperRange - this.currentLowerRange != 0.0) {
            d1 = (d - this.currentLowerRange) / (this.currentUpperRange - this.currentLowerRange);
        }
        int i = 0;
        int j = fontmetrics.getHeight();
        int k = fontmetrics.getDescent();
        int l = s != null ? fontmetrics.stringWidth(s) : 0;
        boolean flag2 = this.is3DModeOn();
        Color color2 = this.getChartForeground();
        i = (int)Math.round((double)(rectangle.y + rectangle.height) - d1 * (double)rectangle.height);
        if (flag && i >= rectangle.y && i <= rectangle.y + rectangle.height || i > rectangle.y + j - k && i < rectangle.y + rectangle.height - j + k) {
            if (this.valueLinesOn || flag) {
                if (d != 0.0 || flag1) {
                    g.setColor(color);
                } else {
                    g.setColor(color2);
                }
                g.drawLine(rectangle.x, i, rectangle.x + rectangle.width, i);
                if (flag2) {
                    g.drawLine(rectangle.x, i, rectangle.x - this.depth3dPoint.x, i - this.depth3dPoint.y);
                }
            }
            if (s != null) {
                int i1 = rectangle.x - l - 4;
                int j1 = i + j - fontmetrics.getAscent() + 1;
                g.setColor(color2);
                if (flag2) {
                    i1 -= this.depth3dPoint.x;
                    j1 -= this.depth3dPoint.y;
                    g.drawLine(rectangle.x - this.depth3dPoint.x, i - this.depth3dPoint.y, rectangle.x - 3 - this.depth3dPoint.x, i - this.depth3dPoint.y);
                } else {
                    g.drawLine(rectangle.x, i, rectangle.x - 3, i);
                }
                if (flag1) {
                    g.setColor(this.getBackground());
                    g.fillRect(i1, j1 - j + k * 2 - 2, l, j - k * 2 + 3);
                }
                g.setColor(color1);
                g.drawString(s, i1, j1);
            }
        }
    }

    private void paintLine(Graphics g, int i, Rectangle rectangle, Color color, boolean flag) {
        int j = this.getSeriesCount();
        if (i < 0 || i >= j) {
            throw new IllegalArgumentException("Invalid series: " + i);
        }
        ChartSample[] achartsample = this.getSamples(i);
        if (achartsample == null || achartsample.length == 0) {
            return;
        }
        double d = rectangle.width;
        if (achartsample.length - 1 > 0) {
            d = (double)(rectangle.width - 1) / (double)(achartsample.length - 1);
        }
        Color color1 = this.stackedOn || flag ? color.darker() : color;
        Rectangle rectangle1 = rectangle;
        if (g.getClip() != null) {
            rectangle1 = g.getClip().getBounds();
        }
        Dimension dimension = this.getSize();
        int k = Math.max(rectangle.x, rectangle1.x);
        int l = Math.max(dimension.width - rectangle.width - rectangle.x, dimension.width - rectangle1.width - rectangle1.x);
        int i1 = Math.max(rectangle.y, rectangle1.y);
        int j1 = Math.max(dimension.height - rectangle.height - rectangle.y - 1, dimension.height - rectangle1.height - rectangle1.y);
        boolean flag1 = this.is3DModeOn();
        if (flag1) {
            j1 = Math.max(dimension.height - rectangle.height - rectangle.y + this.depth3dPoint.y, dimension.height - rectangle1.height - rectangle1.y);
            k = Math.max(rectangle.x - this.depth3dPoint.x, rectangle1.x);
            i1 = Math.max(rectangle1.x, 0);
        }
        Rectangle rectangle2 = new Rectangle(k, i1, dimension.width - l - k, dimension.height - j1 - i1);
        Graphics g1 = g.create();
        g1.setClip(rectangle2);
        Graphics g2 = g;
        double d1 = rectangle.x + 1;
        int[] ai = new int[4];
        int[] ai1 = new int[4];
        boolean flag2 = false;
        double d2 = d1;
        double d3 = this.calculateYPos(i, 0, rectangle);
        int k1 = 0;
        while (k1 < achartsample.length - 1) {
            boolean flag4;
            boolean flag3 = achartsample[k1] != null && achartsample[k1].value != null && !achartsample[k1].value.isNaN();
            boolean bl = flag4 = achartsample[k1 + 1] != null && achartsample[k1 + 1].value != null && !achartsample[k1 + 1].value.isNaN();
            if (flag3) {
                d2 = d1;
                d3 = this.calculateYPos(i, k1, rectangle);
                flag2 = true;
            }
            boolean flag5 = flag3 && flag4;
            if ((flag5 |= flag4 && this.connectedLinesOn[i]) && flag2) {
                if (this.connectedLinesOn[i]) {
                    ai[0] = (int)d2;
                    ai1[0] = (int)d3;
                } else {
                    ai[0] = (int)d1;
                    ai1[0] = this.calculateYPos(i, k1, rectangle);
                }
                ai[1] = (int)(d1 + d);
                ai1[1] = this.calculateYPos(i, k1 + 1, rectangle);
                if (flag1) {
                    ai[0] = ai[0] - this.depth3dPoint.x;
                    ai[1] = ai[1] - this.depth3dPoint.x;
                    ai[2] = ai[2] - this.depth3dPoint.x;
                    ai[3] = ai[3] - this.depth3dPoint.x;
                    if (!this.stackedOn) {
                        double d5 = (double)this.depth3dPoint.x / (double)j;
                        int j2 = (int)Math.round(d5 * (double)i);
                        ai[0] = ai[0] + j2;
                        ai[1] = ai[1] + j2;
                        ai[2] = ai[2] + j2;
                        ai[3] = ai[3] + j2;
                    }
                }
                if (this.stackedOn) {
                    ai[2] = ai[1];
                    ai1[2] = this.calculateYPos(i - 1, k1 + 1, rectangle);
                    ai[3] = ai[0];
                    ai1[3] = this.calculateYPos(i - 1, k1, rectangle);
                }
                g = g1;
                if (this.seriesLinesOn[i]) {
                    if (flag1 && this.stackedOn) {
                        boolean flag7;
                        boolean flag6 = i == j - 1;
                        boolean bl2 = flag7 = k1 == achartsample.length - 2;
                        if (k1 < achartsample.length - 2) {
                            flag7 |= achartsample[k1 + 2] == null || achartsample[k1 + 2].value == null || achartsample[k1 + 2].value.isNaN();
                            flag7 &= !this.connectedLinesOn[i];
                        }
                        this.paint3DLine(g, ai[0], ai1[0], ai[1], ai1[1], ai1[2], color1, flag6, flag7);
                    } else if (flag1) {
                        this.paint3DLine(g, ai[0], ai1[0], ai[1], ai1[1], ai1[2], color1, true, false);
                    }
                }
                if (this.stackedOn && this.seriesLinesOn[i]) {
                    g.setColor(flag ? color.darker() : color);
                    g.fillPolygon(ai, ai1, 4);
                    g.setColor(color.darker());
                    g.drawLine(ai[1], ai1[1], ai[2], ai1[2]);
                }
                g.setColor(color);
                if (flag1 && this.stackedOn) {
                    g.setColor(color.darker().darker());
                } else if (flag1 || this.stackedOn) {
                    g.setColor(color.darker());
                }
                if (this.seriesLinesOn[i] || flag) {
                    g.drawLine(ai[0], ai1[0], ai[1], ai1[1]);
                    if (!flag1 && !this.stackedOn && this.lineWidth[i] > 1 && (this.seriesLinesOn[i] || flag)) {
                        double d6 = 0.0;
                        if (ai[1] - ai[0] != 0) {
                            d6 = Math.abs((double)(ai1[1] - ai1[0]) / (double)(ai[1] - ai[0]));
                        }
                        int k2 = 1;
                        int i3 = 2;
                        while (i3 <= this.lineWidth[i]) {
                            int j3 = i3 / 2 * k2;
                            if (d6 <= 1.0) {
                                g.drawLine(ai[0], ai1[0] + j3, ai[1], ai1[1] + j3);
                            } else {
                                g.drawLine(ai[0] - j3, ai1[0], ai[1] - j3, ai1[1]);
                            }
                            k2 = -k2;
                            ++i3;
                        }
                    }
                }
                if (flag && this.seriesLinesOn[i] && !flag1 && !this.stackedOn) {
                    double d7 = 0.0;
                    if (ai[1] - ai[0] != 0) {
                        d7 = Math.abs((double)(ai1[1] - ai1[0]) / (double)(ai[1] - ai[0]));
                    }
                    int l2 = this.lineWidth[i] / 2 + 1;
                    g.setColor(color.darker().darker());
                    if (d7 <= 1.0) {
                        g.drawLine(ai[0], ai1[0] + l2, ai[1], ai1[1] + l2);
                    } else {
                        g.drawLine(ai[0] - l2, ai1[0], ai[1] - l2, ai1[1]);
                    }
                }
            }
            d1 += d;
            ++k1;
        }
        if (!flag1) {
            double d4 = rectangle.x + 1;
            int l1 = 0;
            while (l1 < achartsample.length) {
                ChartSample chartsample = achartsample[l1];
                if (chartsample != null && chartsample.value != null && !chartsample.value.isNaN() && this.sampleHighlightOn[i][l1]) {
                    boolean flag8;
                    int i2 = this.calculateYPos(i, l1, rectangle);
                    boolean bl = flag8 = i2 >= rectangle.y && i2 <= rectangle.y + rectangle.height;
                    if (flag8) {
                        this.paintSampleHighlight(g2, i, (int)Math.round(d4), i2, color);
                    }
                }
                d4 += d;
                ++l1;
            }
        }
        if (g1 != g2) {
            try {
                g1.dispose();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
    }

    public double[] getFloatSampleValues(int i) {
        return this.getSampleValues(i);
    }

    public boolean isConnectedLinesOn(int i) {
        if (i >= 0 && i < this.connectedLinesOn.length) {
            return this.connectedLinesOn[i];
        }
        if (i == -1) {
            boolean flag = false;
            int j = 0;
            while (j < this.connectedLinesOn.length) {
                if (this.connectedLinesOn[j]) {
                    flag = true;
                }
                ++j;
            }
            return flag;
        }
        return false;
    }

    public boolean isRangeLabelsOn() {
        return this.rangeLabelsOn;
    }

    public boolean isAutoLabelSpacingOn() {
        return this.autoLabelSpacingOn;
    }

    private void calculateHelperValues(Rectangle rectangle) {
        if (this.is3DModeOn()) {
            int i = Math.max(this.getSampleCount(), 20);
            int j = this.getSeriesCount();
            if (j > 1 && !this.stackedOn) {
                i /= j;
                i = Math.max(i, 4);
            }
            double d = (double)rectangle.width / (double)i;
            this.depth3dPoint.x = (int)Math.round(d * 1.25);
            this.depth3dPoint.y = (int)Math.round(-d / 1.25);
        }
    }

    public synchronized double getFloatRange() {
        return this.upperRange;
    }

    public synchronized void setRelativeRange(double d) {
        double d1 = this.getMaxValue(-2);
        Enumeration enumeration = this.targetValueLines.elements();
        while (enumeration.hasMoreElements()) {
            TargetValueLine targetvalueline = (TargetValueLine)enumeration.nextElement();
            d1 = Math.max(d1, targetvalueline.value);
        }
        if (d1 >= 0.0) {
            this.setRange(d1 * Math.abs(d));
        } else {
            this.setRange(0.0);
        }
    }

    public synchronized void setRelativeRange(double d, double d1) {
        double d2 = this.getMaxValue(-2);
        Enumeration enumeration = this.targetValueLines.elements();
        while (enumeration.hasMoreElements()) {
            TargetValueLine targetvalueline = (TargetValueLine)enumeration.nextElement();
            d2 = Math.max(d2, targetvalueline.value);
        }
        if (d2 >= 0.0) {
            d1 = Math.abs(d1);
            double d3 = d2 * Math.abs(d);
            if (d1 % 1.0 == 0.0) {
                if (d3 % d1 == 0.0) {
                    this.setRange(d3);
                } else {
                    this.setRange(d3 - d3 % d1 + d1);
                }
            } else {
                double d4 = 0.0;
                while (d4 < d3) {
                    d4 += d1;
                }
                this.setRange(d4);
            }
        } else {
            this.setRange(0.0);
        }
    }

    private void paintValueLabels(Graphics g, Rectangle rectangle, int i, boolean flag) {
        String s1;
        g.setFont(this.getFont("valueLabelFont"));
        FontMetrics fontmetrics = g.getFontMetrics();
        int j = fontmetrics.getAscent();
        int k = this.getSampleDecimalCount();
        int l = this.getSampleCount();
        int i1 = this.getSeriesCount();
        Dimension dimension = this.getSize();
        double d = rectangle.x;
        double d1 = rectangle.width;
        if (l > 2) {
            d1 = (double)rectangle.width / (double)(l - 1);
        }
        double d2 = this.depth3dPoint.x;
        boolean flag1 = this.is3DModeOn();
        if (flag1) {
            d -= (double)this.depth3dPoint.x;
            double d3 = (double)this.depth3dPoint.x / (double)i1 * (double)i;
            d += d3;
        }
        g.setColor(this.getChartForeground());
        String s = this.getLabel("valueLabelPrefix_" + i);
        if (s == null) {
            s = this.getLabel("valueLabelPrefix");
        }
        if ((s1 = this.getLabel("valueLabelPostfix_" + i)) == null) {
            s1 = this.getLabel("valueLabelPostfix");
        }
        ChartSample[] achartsample = this.getSamples(i);
        int j1 = 0;
        while (j1 < achartsample.length) {
            if (!flag && (achartsample[j1] == null || achartsample[j1].value == null || achartsample[j1].value.isNaN())) {
                d += d1;
            } else {
                boolean flag2;
                double d4 = 0.0;
                if (flag) {
                    int k1 = 0;
                    while (k1 < i1) {
                        ChartSample chartsample = this.getSample(k1, j1);
                        if (chartsample != null && chartsample.value != null && !chartsample.value.isNaN()) {
                            d4 += chartsample.value.doubleValue();
                        }
                        ++k1;
                    }
                } else {
                    d4 = achartsample[j1].getFloatValue();
                }
                String s2 = this.formatNumber(d4, k);
                s2 = s != null ? String.valueOf(s) + s2 : s2;
                s2 = s1 != null ? String.valueOf(s2) + s1 : s2;
                int l1 = fontmetrics.stringWidth(s2);
                int i2 = this.calculateYPos(i, j1, rectangle) - 1;
                int j2 = (int)Math.round(d - (double)(l1 / 2)) + 1;
                if (this.valueLabelStyle == 0) {
                    j2 = flag1 ? Math.max(rectangle.x - this.depth3dPoint.x + 2, j2) : Math.max(rectangle.x + 2, j2);
                }
                j2 = Math.min(j2, dimension.width - l1 - 2);
                boolean bl = flag2 = i2 < rectangle.y - 1 || i2 > rectangle.y + rectangle.height + 1;
                if (!flag1 && flag2) {
                    d += d1;
                } else {
                    if (this.valueLabelStyle == 1) {
                        i2 += j / 2;
                    } else if (!this.stackedOn) {
                        double d6;
                        double d8;
                        double d5 = j1 > 0 && achartsample[j1 - 1] != null ? achartsample[j1 - 1].getFloatValue() : d4;
                        double d7 = (d4 - d5) / d1;
                        if (d7 < (d8 = ((d6 = j1 < achartsample.length - 1 && achartsample[j1 + 1] != null ? achartsample[j1 + 1].getFloatValue() : d4) - d4) / d1)) {
                            i2 += j;
                        } else if (flag1) {
                            double d9 = (double)this.depth3dPoint.x / (double)i1;
                            j2 = (int)((double)j2 + d9);
                            d9 = (double)this.depth3dPoint.y / (double)i1;
                            i2 = (int)((double)i2 + d9);
                        }
                        try {
                            boolean flag3 = this.sampleHighlightOn[i][j1];
                            int k2 = this.sampleHighlightSize[i];
                            if (flag3 && d7 < d8) {
                                i2 += k2 / 2;
                            } else if (flag3) {
                                i2 -= k2 / 2;
                            }
                        }
                        catch (IndexOutOfBoundsException indexoutofboundsexception) {
                            System.out.println("Internal error with value labels");
                            indexoutofboundsexception.printStackTrace();
                        }
                    }
                    g.drawString(s2, j2, i2);
                    d += d1;
                }
            }
            ++j1;
        }
    }

    public void render(Graphics g, boolean flag) {
        this.checkDataIntegrity();
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.getGraphBounds();
        this.calculateHelperValues(rectangle);
        if (this.hasChanged || flag) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, dimension.width, dimension.height);
            this.paintGrid(g, rectangle);
            if (this.isLegendOn()) {
                this.paintLegend(g, rectangle, this.getLegendLabels());
            }
            if (this.rangeAdjusterOn) {
                this.paintRangeAdjuster(g, rectangle, this.currentUpperRange);
            }
            this.paintLines(g, rectangle);
            this.paintTitle(g, dimension);
            if (this.is3DModeOn()) {
                this.paint3DZeroDivider(g, rectangle);
            }
            this.hasChanged = false;
        }
    }

    protected void paintLines(Graphics g, Rectangle rectangle) {
        if (this.currentUpperRange == 0.0 && this.currentLowerRange == 0.0) {
            return;
        }
        int i = this.getSeriesCount();
        if (i > 0) {
            int j = i - 1;
            while (j >= 0) {
                this.paintLine(g, j, rectangle, this.getSampleColor(j), this.isSelected(j, -1));
                if (!this.stackedOn && this.isValueLabelsOn()) {
                    this.paintValueLabels(g, rectangle, j, false);
                }
                --j;
            }
            if (this.stackedOn && this.isValueLabelsOn()) {
                this.paintValueLabels(g, rectangle, i - 1, true);
            }
        }
        if (this.is3DModeOn() && this.stackedOn) {
            g.setColor(this.getBackground());
            Polygon polygon = new Polygon();
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height - this.depth3dPoint.y);
            polygon.addPoint(rectangle.x + rectangle.width - this.depth3dPoint.x, rectangle.y + rectangle.height - this.depth3dPoint.y);
            g.fillPolygon(polygon);
            g.setColor(this.getChartForeground());
            g.drawLine(rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x + rectangle.width - this.depth3dPoint.x, rectangle.y + rectangle.height - this.depth3dPoint.y);
        }
    }

    public int getValuePosition(double d) {
        Rectangle rectangle = this.getGraphBounds();
        double d1 = 0.0;
        if (this.currentUpperRange - this.currentLowerRange != 0.0) {
            d1 = (d - this.currentLowerRange) / (this.currentUpperRange - this.currentLowerRange);
        }
        return rectangle.y + rectangle.height - (int)(d1 * (double)rectangle.height);
    }

    public void setSampleHighlightOn(boolean flag) {
        int i = 0;
        while (i < this.sampleHighlightOn.length) {
            int j = 0;
            while (j < this.sampleHighlightOn[i].length) {
                this.sampleHighlightOn[i][j] = flag;
                ++j;
            }
            ++i;
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int i, boolean flag) {
        try {
            int j = 0;
            while (j < this.sampleHighlightOn[i].length) {
                this.sampleHighlightOn[i][j] = flag;
                ++j;
            }
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid series: " + i);
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int i, int j, boolean flag) {
        try {
            this.sampleHighlightOn[i][j] = flag;
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid series or index: " + i + ", " + j);
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Rectangle getGraphBounds() {
        Insets insets;
        if (!this.hasChanged && this.currentBounds != null) {
            return this.currentBounds;
        }
        Rectangle rectangle = super.getGraphBounds(this.getLegendLabels());
        Dimension dimension = this.getSize();
        int i = rectangle.x;
        int j = dimension.width - rectangle.width - rectangle.x;
        int k = rectangle.y;
        int l = dimension.height - rectangle.height - rectangle.y;
        if (this.rangeAdjusterOn) {
            j += 5;
        }
        if (this.sampleLabelsOn && this.getSampleCount() > 0) {
            FontMetrics fontmetrics = this.getFontMetrics(this.getFont("sampleLabelFont"));
            l += fontmetrics.getMaxAscent();
            String s1 = this.getSampleLabel(this.getSampleCount() - 1);
            int l1 = 0;
            if (s1 != null) {
                l1 = fontmetrics.stringWidth(s1) / 2 - 5;
            }
            int k2 = 0;
            if (this.isLegendOn() && this.getLegendPosition() == 1) {
                k2 = this.legendWidth;
            }
            if (l1 > k2) {
                j += l1 - k2;
            }
        }
        if (this.rangeLabelsOn || this.targetValueLines.size() > 0) {
            String s = this.getLabel("rangeLabelPrefix");
            String s2 = this.getLabel("rangeLabelPostfix");
            int i2 = this.getRangeDecimalCount();
            FontMetrics fontmetrics3 = this.getFontMetrics(this.getFont("rangeLabelFont"));
            int l2 = 0;
            Enumeration enumeration = this.targetValueLines.elements();
            while (enumeration.hasMoreElements()) {
                TargetValueLine targetvalueline = (TargetValueLine)enumeration.nextElement();
                String s8 = targetvalueline.getLabel(i2);
                if (s8 == null || !(targetvalueline.value >= this.lowerRange) || !(targetvalueline.value <= this.upperRange)) continue;
                l2 = Math.max(l2, fontmetrics3.stringWidth(targetvalueline.getLabel(i2)));
            }
            if (this.rangeLabelsOn) {
                String s7 = this.formatNumber(this.upperRange, i2);
                s7 = s != null ? String.valueOf(s) + s7 : s7;
                s7 = s2 != null ? String.valueOf(s7) + s2 : s7;
                String s9 = this.formatNumber(this.lowerRange, i2);
                s9 = s != null ? String.valueOf(s) + s9 : s9;
                s9 = s2 != null ? String.valueOf(s9) + s2 : s9;
                l2 = Math.max(l2, fontmetrics3.stringWidth(s7));
                l2 = Math.max(l2, fontmetrics3.stringWidth(s9));
            }
            i += l2 + 2;
        }
        if (this.isValueLabelsOn()) {
            FontMetrics fontmetrics1 = this.getFontMetrics(this.getFont("valueLabelFont"));
            int j1 = this.getSampleDecimalCount();
            String s3 = this.getLabel("valueLabelPrefix");
            String s4 = this.getLabel("valueLabelPostfix");
            String s5 = this.formatNumber(this.currentUpperRange, j1);
            s5 = s3 != null ? String.valueOf(s3) + s5 : s5;
            s5 = s4 != null ? String.valueOf(s5) + s4 : s5;
            String s6 = this.formatNumber(this.currentLowerRange, j1);
            s6 = s3 != null ? String.valueOf(s3) + s6 : s6;
            s6 = s4 != null ? String.valueOf(s6) + s4 : s6;
            int i3 = Math.max(fontmetrics1.stringWidth(s5), fontmetrics1.stringWidth(s6));
            j += i3 / 2 - 5;
        }
        if (this.getLabel("sampleAxisLabel") != null) {
            l += this.getFontMetrics(this.getFont("sampleAxisLabelFont")).getAscent();
        }
        if (this.getLabel("rangeAxisLabel") != null) {
            FontMetrics fontmetrics2 = this.getFontMetrics(this.getFont("rangeAxisLabelFont"));
            k += fontmetrics2.getAscent();
            i = Math.max(i, fontmetrics2.stringWidth(this.getLabel("rangeAxisLabel")) / 2 + 2);
        }
        if (this.is3DModeOn()) {
            int i1 = Math.max(20, this.getSampleCount());
            int k1 = this.getSeriesCount();
            if (k1 > 1 && !this.stackedOn) {
                i1 /= k1;
                i1 = Math.max(i1, 4);
            }
            int j2 = (int)((double)rectangle.width * 1.25 / ((double)i1 + 1.25));
            rectangle.width = dimension.width - (i += j2) - j;
            double d = rectangle.width / i1;
            l += (int)Math.round(d / 1.25);
        }
        if ((insets = this.getGraphInsets()) != null) {
            k = insets.top == -1 ? k : insets.top;
            i = insets.left == -1 ? i : insets.left;
            l = insets.bottom == -1 ? l : insets.bottom;
            j = insets.right == -1 ? j : insets.right;
        }
        rectangle.x = i;
        rectangle.width = dimension.width - i - j;
        rectangle.y = k;
        rectangle.height = dimension.height - k - l;
        this.currentBounds = rectangle;
        return rectangle;
    }

    private void paint3DZeroDivider(Graphics g, Rectangle rectangle) {
        int i;
        double d = 1.0;
        if (this.currentLowerRange - this.currentUpperRange != 0.0) {
            d = this.currentLowerRange / (this.currentLowerRange - this.currentUpperRange);
        }
        if ((i = (int)Math.round((double)(rectangle.y + rectangle.height) - d * (double)rectangle.height)) < rectangle.y || i > rectangle.y + rectangle.height) {
            return;
        }
        g.setColor(this.getChartForeground());
        g.drawLine(rectangle.x - this.depth3dPoint.x, i -= this.depth3dPoint.y, rectangle.x + rectangle.width - this.depth3dPoint.x, i);
        g.drawLine(rectangle.x + rectangle.width - this.depth3dPoint.x, i, rectangle.x + rectangle.width, i + this.depth3dPoint.y);
    }

    public void setValueLinesColor(Color color) {
        this.valueLinesColor = color;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color getValueLinesColor() {
        return this.valueLinesColor;
    }

    public void setStackedOn(boolean flag) {
        this.stackedOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void processEvent(AWTEvent awtevent) {
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        if (awtevent instanceof MouseEvent && this.rangeAdjusterOn) {
            int i = ((MouseEvent)awtevent).getX();
            int k = ((MouseEvent)awtevent).getY();
            Rectangle rectangle1 = this.currentBounds != null ? this.currentBounds : this.getGraphBounds();
            double d2 = 0.0;
            if (this.upperRange - this.lowerRange != 0.0) {
                d2 = (this.currentUpperRange - this.lowerRange) / (this.upperRange - this.lowerRange);
            }
            int i1 = (int)Math.round((double)(rectangle1.y + rectangle1.height) - d2 * (double)rectangle1.height);
            if (this.upperRange - this.lowerRange != 0.0) {
                d2 = (this.currentLowerRange - this.lowerRange) / (this.upperRange - this.lowerRange);
            }
            int j1 = (int)Math.round((double)(rectangle1.y + rectangle1.height) - d2 * (double)rectangle1.height);
            flag2 = i >= rectangle1.x + rectangle1.width && i <= rectangle1.x + rectangle1.width + 10;
            flag2 = flag2 && k >= i1 && k <= j1;
            flag3 = k >= i1 - 2 && k <= i1 + 2;
            boolean bl = flag4 = k >= j1 - 2 && k <= j1 + 2;
            if (!flag2) {
                this.setCursor(DEFAULT_CURSOR);
            }
        }
        if (awtevent.getID() == 502) {
            this.repaint();
        }
        if (awtevent.getID() != 101) {
            // empty if block
        }
        if (this.rangeAdjusterOn) {
            switch (awtevent.getID()) {
                default: {
                    break;
                }
                case 503: {
                    if (flag3 && flag2) {
                        this.setCursor(RESIZE_CURSOR);
                        break;
                    }
                    if (flag4 && flag2) {
                        this.setCursor(RESIZE_CURSOR);
                        break;
                    }
                    if (!flag2) break;
                    this.setCursor(MOVE_CURSOR);
                    break;
                }
                case 501: {
                    if (flag3 && flag2) {
                        this.adjustingUpper = true;
                        return;
                    }
                    if (flag4 && flag2) {
                        this.adjustingLower = true;
                        return;
                    }
                    if (!flag2) break;
                    this.slidingAdjuster = true;
                    this.lastAdjusterClick = ((MouseEvent)awtevent).getY();
                    return;
                }
                case 506: {
                    int j = ((MouseEvent)awtevent).getY();
                    Rectangle rectangle = this.currentBounds;
                    if (this.adjustingUpper) {
                        this.setCursor(RESIZE_CURSOR);
                        double d = 1.0 - (double)(j -= rectangle.y) / (double)rectangle.height;
                        double d4 = this.lowerRange + d * (this.upperRange - this.lowerRange);
                        if (d4 > this.currentLowerRange) {
                            this.currentUpperRange = d4;
                        }
                        this.currentUpperRange = Math.min(this.currentUpperRange, this.upperRange);
                    }
                    if (this.adjustingLower) {
                        this.setCursor(RESIZE_CURSOR);
                        double d1 = 1.0 - (double)(j -= rectangle.y) / (double)rectangle.height;
                        double d5 = this.lowerRange + d1 * (this.upperRange - this.lowerRange);
                        if (d5 < this.currentUpperRange) {
                            this.currentLowerRange = d5;
                        }
                        this.currentLowerRange = Math.max(this.currentLowerRange, this.lowerRange);
                    }
                    if (this.slidingAdjuster) {
                        this.setCursor(MOVE_CURSOR);
                        int l = this.lastAdjusterClick - j;
                        double d3 = (double)l / (double)rectangle.height;
                        double d6 = d3 * (this.upperRange - this.lowerRange);
                        if (d6 >= 0.0) {
                            d6 = Math.min(this.upperRange - this.currentUpperRange, d6);
                        } else if (this.currentLowerRange + d6 < this.lowerRange) {
                            d6 = this.lowerRange - this.currentLowerRange;
                        }
                        this.currentUpperRange += d6;
                        this.currentLowerRange += d6;
                        this.lastAdjusterClick = j;
                    }
                    this.hasChanged = true;
                    this.repaint();
                    return;
                }
                case 502: {
                    this.slidingAdjuster = false;
                    this.adjustingLower = false;
                    this.adjustingUpper = false;
                }
            }
        }
        super.processEvent(awtevent);
    }

    private void paintGrid(Graphics g, Rectangle rectangle) {
        Color color = this.getChartBackground();
        Color color1 = this.getChartForeground();
        g.setColor(color);
        g.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Polygon polygon = null;
        Polygon polygon1 = null;
        boolean flag = this.is3DModeOn();
        if (flag) {
            polygon = new Polygon();
            polygon.addPoint(rectangle.x, rectangle.y);
            polygon.addPoint(rectangle.x - this.depth3dPoint.x, rectangle.y - this.depth3dPoint.y);
            polygon.addPoint(polygon.xpoints[1], polygon.ypoints[1] + rectangle.height);
            polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x, rectangle.y);
            polygon1 = new Polygon();
            polygon1.addPoint(rectangle.x, rectangle.y + rectangle.height);
            polygon1.addPoint(polygon.xpoints[2], polygon.ypoints[2]);
            polygon1.addPoint(polygon1.xpoints[1] + rectangle.width, polygon1.ypoints[1]);
            polygon1.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            polygon1.addPoint(polygon1.xpoints[0], polygon1.ypoints[0]);
            g.setColor(color);
            g.fillPolygon(polygon);
            g.setColor(color.darker());
            g.fillPolygon(polygon1);
        }
        g.setFont(this.getFont("rangeLabelFont"));
        FontMetrics fontmetrics = g.getFontMetrics();
        int i = this.getRangeDecimalCount();
        if (this.valueLinesOn || this.rangeLabelsOn) {
            double d;
            String s = this.getLabel("rangeLabelPrefix");
            String s1 = this.getLabel("rangeLabelPostfix");
            int j = (int)Math.round((double)rectangle.height / (double)fontmetrics.getHeight());
            j = Math.min(this.maxValueLineCount, j);
            int l = (int)Math.round((this.currentUpperRange - this.currentLowerRange) * Math.pow(10.0, i)) + 1;
            j = Math.min(j, l);
            j = Math.max(1, j);
            double d2 = d = (this.currentUpperRange - this.currentLowerRange) / (double)j;
            boolean flag1 = false;
            double d4 = 1.0E-9;
            while (!flag1 && d4 < 1.0E14) {
                int k3 = 0;
                while (k3 < STEPS.length) {
                    if (!(STEPS[k3] * d4 < d)) {
                        d2 = STEPS[k3] * d4;
                        flag1 = true;
                        break;
                    }
                    ++k3;
                }
                d4 *= 10.0;
            }
            Color color2 = this.getForeground();
            if (this.currentUpperRange > 0.0) {
                double d5 = Math.max(0.0, this.currentLowerRange - this.currentLowerRange % d2);
                while (d5 < this.currentUpperRange) {
                    String s6 = this.rangeLabelsOn ? this.formatNumber(d5, i) : null;
                    s6 = s != null ? String.valueOf(s) + s6 : s6;
                    s6 = s1 != null ? String.valueOf(s6) + s1 : s6;
                    this.paintValueLine(g, rectangle, d5, this.valueLinesColor, s6, color2, fontmetrics, false, false);
                    d5 += d2;
                }
            }
            if (this.currentLowerRange < 0.0) {
                double d6 = Math.min(0.0, this.currentUpperRange - this.currentUpperRange % d2);
                while (d6 > this.currentLowerRange) {
                    String s7 = this.rangeLabelsOn ? this.formatNumber(d6, i) : null;
                    s7 = s != null ? String.valueOf(s) + s7 : s7;
                    s7 = s1 != null ? String.valueOf(s7) + s1 : s7;
                    this.paintValueLine(g, rectangle, d6, this.valueLinesColor, s7, color2, fontmetrics, false, false);
                    d6 -= d2;
                }
            }
            String s4 = this.rangeLabelsOn ? this.formatNumber(this.currentUpperRange, i) : null;
            s4 = s != null ? String.valueOf(s) + s4 : s4;
            s4 = s1 != null ? String.valueOf(s4) + s1 : s4;
            this.paintValueLine(g, rectangle, this.currentUpperRange, this.valueLinesColor, s4, this.getForeground(), fontmetrics, true, false);
            s4 = this.rangeLabelsOn ? this.formatNumber(this.currentLowerRange, i) : null;
            s4 = s != null ? String.valueOf(s) + s4 : s4;
            s4 = s1 != null ? String.valueOf(s4) + s1 : s4;
            this.paintValueLine(g, rectangle, this.currentLowerRange, this.valueLinesColor, s4, this.getForeground(), fontmetrics, true, false);
        }
        this.paintValueLine(g, rectangle, 0.0, color1, null, null, fontmetrics, true, false);
        String[] as = this.getSampleLabels();
        if (this.sampleLabelsOn && as != null) {
            g.setFont(this.getFont("sampleLabelFont"));
            FontMetrics fontmetrics1 = g.getFontMetrics();
            int k = fontmetrics1.getMaxAscent() + 4;
            int i1 = this.getSampleCount();
            double d1 = rectangle.width;
            if (i1 > 1) {
                d1 = (float)rectangle.width / (float)(i1 - 1);
            }
            int l2 = rectangle.y + rectangle.height;
            double d3 = rectangle.x;
            int i3 = 0;
            if (flag) {
                l2 -= this.depth3dPoint.y;
                d3 -= (double)this.depth3dPoint.x;
            }
            int j3 = 0;
            while (j3 < as.length) {
                if (as[j3] != null && as[j3].length() > 0) {
                    Color color3 = this.getSampleLabelColor(j3);
                    if (color3 == null) {
                        color3 = this.getForeground();
                    }
                    String s5 = as[j3];
                    int l3 = fontmetrics1.stringWidth(s5);
                    int i4 = (int)(d3 - (double)(l3 / 2));
                    g.setColor(color1);
                    if (this.autoLabelSpacingOn) {
                        if (i4 - 2 > i3 + 2) {
                            g.drawLine((int)d3, l2, (int)d3, l2 + 3);
                            g.setColor(color3);
                            g.drawString(s5, i4, l2 + k);
                            i3 = (int)d3 + l3 / 2;
                        }
                    } else {
                        g.drawLine((int)d3, l2, (int)d3, l2 + 3);
                        g.setColor(color3);
                        g.drawString(s5, i4, l2 + k);
                        i3 = (int)d3 + l3 / 2;
                    }
                }
                d3 += d1;
                ++j3;
            }
        }
        g.setColor(color1);
        if (flag && polygon != null && polygon1 != null) {
            g.drawPolygon(polygon);
            g.drawPolygon(polygon1);
        }
        g.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.targetValueLines.size() > 0) {
            g.setFont(this.getFont("rangeLabelFont"));
            FontMetrics fontmetrics2 = g.getFontMetrics();
            Enumeration enumeration = this.targetValueLines.elements();
            while (enumeration.hasMoreElements()) {
                TargetValueLine targetvalueline = (TargetValueLine)enumeration.nextElement();
                this.paintValueLine(g, rectangle, targetvalueline.value, targetvalueline.color, targetvalueline.getLabel(i), targetvalueline.color, fontmetrics2, true, true);
            }
        }
        g.setColor(this.getChartForeground());
        if (this.getLabel("sampleAxisLabel") != null) {
            String s2 = this.getLabel("sampleAxisLabel");
            g.setFont(this.getFont("sampleAxisLabelFont"));
            FontMetrics fontmetrics3 = g.getFontMetrics();
            int j1 = 0;
            int l1 = 0;
            int j2 = fontmetrics3.stringWidth(s2);
            j1 = rectangle.x + rectangle.width / 2 - j2 / 2;
            l1 = rectangle.y + rectangle.height + fontmetrics3.getMaxAscent();
            if (this.is3DModeOn()) {
                l1 -= this.depth3dPoint.y;
                j1 -= this.depth3dPoint.x;
            }
            if (this.sampleLabelsOn) {
                l1 += this.getFontMetrics(this.getFont("sampleLabelFont")).getHeight();
            }
            g.drawString(s2, j1, l1);
        }
        if (this.getLabel("rangeAxisLabel") != null) {
            String s3 = this.getLabel("rangeAxisLabel");
            g.setFont(this.getFont("rangeAxisLabelFont"));
            FontMetrics fontmetrics4 = g.getFontMetrics();
            int k1 = 0;
            int i2 = 0;
            int k2 = fontmetrics4.stringWidth(s3);
            k1 = rectangle.x - k2 / 2;
            i2 = rectangle.y - fontmetrics4.getHeight() / 2 - 1;
            g.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y - 3);
            g.drawString(s3, k1, i2);
        }
    }

    public double getMaxValue(int i) {
        if (i >= -1 || !this.stackedOn) {
            return super.getMaxValue(i);
        }
        double d = 0.0;
        int j = this.getSampleCount();
        int k = this.getSeriesCount();
        int l = 0;
        while (l < j) {
            double d1 = 0.0;
            int i1 = 0;
            while (i1 < k) {
                ChartSample chartsample = this.getSample(i1, l);
                if (chartsample != null && chartsample.value != null && !chartsample.value.isNaN() && chartsample.value > 0.0) {
                    d1 += chartsample.value.doubleValue();
                }
                ++i1;
            }
            d = Math.max(d, d1);
            ++l;
        }
        return d;
    }

    public double getFloatMinValue() {
        return super.getMinValue(-1);
    }

    public synchronized double getFloatLowerRange() {
        return this.lowerRange;
    }

    public synchronized void setLowerRelativeRange(double d) {
        double d1 = this.getMinValue(-1);
        Enumeration enumeration = this.targetValueLines.elements();
        while (enumeration.hasMoreElements()) {
            TargetValueLine targetvalueline = (TargetValueLine)enumeration.nextElement();
            d1 = Math.min(d1, targetvalueline.value);
        }
        if (d1 < 0.0) {
            this.setLowerRange(d1 * Math.abs(d));
        } else {
            this.setLowerRange(0.0);
        }
    }

    public synchronized void setLowerRelativeRange(double d, double d1) {
        double d2 = this.getMinValue(-1);
        Enumeration enumeration = this.targetValueLines.elements();
        while (enumeration.hasMoreElements()) {
            TargetValueLine targetvalueline = (TargetValueLine)enumeration.nextElement();
            d2 = Math.min(d2, targetvalueline.value);
        }
        if (d2 < 0.0) {
            d1 = Math.abs(d1);
            double d3 = d2 * Math.abs(d);
            if (d1 % 1.0 == 0.0) {
                if (d3 % d1 == 0.0) {
                    this.setLowerRange(d3);
                } else {
                    this.setLowerRange(d3 - d3 % d1 - d1);
                }
            } else {
                double d4 = 0.0;
                while (d4 > d3) {
                    d4 -= d1;
                }
                this.setLowerRange(d4);
            }
        } else {
            this.setLowerRange(0.0);
        }
    }

    public synchronized void setSampleValues(int i, long[] al) {
        double[] ad = new double[al.length];
        int j = 0;
        while (j < ad.length) {
            ad[j] = al[j];
            ++j;
        }
        this.setSampleValues(i, ad);
    }

    public void setCurrentRange(double d) {
        d = Math.min(this.upperRange, d);
        this.currentUpperRange = d = Math.max(this.currentLowerRange, d);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public double getCurrentRange() {
        return this.currentUpperRange;
    }

    public void setValueLinesOn(boolean flag) {
        this.valueLinesOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setSampleLabelsOn(boolean flag) {
        this.sampleLabelsOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    private void paintRangeAdjuster(Graphics g, Rectangle rectangle, double d) {
        int i = rectangle.x + rectangle.width + 5;
        g.setColor(this.getBackground().darker());
        g.drawLine(i, rectangle.y, i, rectangle.y + rectangle.height);
        g.setColor(this.getBackground().brighter());
        g.drawLine(i + 1, rectangle.y, i + 1, rectangle.y + rectangle.height);
        double d1 = 0.0;
        double d2 = 0.0;
        if (this.upperRange - this.lowerRange != 0.0) {
            d1 = (this.currentUpperRange - this.lowerRange) / (this.upperRange - this.lowerRange);
            d2 = (this.currentLowerRange - this.lowerRange) / (this.upperRange - this.lowerRange);
        }
        int j = (int)Math.round((double)(rectangle.y + rectangle.height) - d1 * (double)rectangle.height);
        int k = (int)Math.round((double)(rectangle.y + rectangle.height) - d2 * (double)rectangle.height);
        g.setColor(Color.lightGray);
        g.fillRect(i - 3, j, 7, k - j);
        g.setColor(Color.white);
        g.drawLine(i - 3, j, i - 3, k);
        g.drawLine(i - 3, j, i + 3, j);
        g.setColor(Color.gray.darker());
        g.drawLine(i + 3, j, i + 3, k);
        g.drawLine(i + 3, k, i - 3, k);
        g.setColor(Color.gray);
        g.drawLine(i - 2, j + 2, i + 2, j + 2);
        g.setColor(Color.white);
        g.drawLine(i - 2, k - 2, i + 2, k - 2);
    }

    public void setLineWidth(int i) {
        this.setLineWidth(-1, i);
    }

    public void setLineWidth(int i, int j) {
        if (i >= 0 && i < this.lineWidth.length) {
            this.lineWidth[i] = j;
        } else if (i < 0) {
            int k = 0;
            while (k < this.lineWidth.length) {
                this.lineWidth[k] = j;
                ++k;
            }
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getLineWidth() {
        return this.getLineWidth(0);
    }

    public int getLineWidth(int i) {
        if (i >= 0 && i < this.lineWidth.length) {
            return this.lineWidth[i];
        }
        return this.lineWidth[0];
    }

    public void setValueLabelStyle(int i) {
        this.valueLabelStyle = i;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getValueLabelStyle() {
        return this.valueLabelStyle;
    }

    public boolean isSampleHighlightOn(int i, int j) {
        try {
            return this.sampleHighlightOn[i][j];
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid series or index: " + i + ", " + j);
        }
    }

    protected ChartSample checkSelection(Point point) {
        ChartSample chartsample = super.checkSelection(point);
        if (chartsample != null && this.getSeriesCount() == 1) {
            chartsample = new ChartSample(-1);
            chartsample.setSeries(0);
        }
        return chartsample;
    }

    public void setMaxValueLineCount(int i) {
        this.maxValueLineCount = i > -1 ? i : Integer.MAX_VALUE;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getMaxValueLineCount() {
        if (this.maxValueLineCount != Integer.MAX_VALUE) {
            return this.maxValueLineCount;
        }
        return -1;
    }

    public void setSampleColors(Color[] acolor) {
        super.setSampleColors(acolor);
        if (acolor == null) {
            this.setSampleColor(2, new Color(132, 255, 198));
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public LineChart() {
        this(1, 5, 100.0);
    }

    public LineChart(int i, int j, double d) {
        this(i, j, d, 0.0);
    }

    public LineChart(int i, int j, double d, double d1) {
        super(j);
        this.setAutomaticRepaintOn(false);
        this.sampleHighlightOn = new boolean[i][j];
        this.sampleHighlightStyle = new int[i];
        this.sampleHighlightSize = new int[i];
        this.seriesLinesOn = new boolean[i];
        this.lineWidth = new int[i];
        int k = 0;
        while (k < i) {
            this.sampleHighlightSize[k] = 6;
            this.seriesLinesOn[k] = true;
            this.lineWidth[k] = 2;
            ++k;
        }
        this.connectedLinesOn = new boolean[i];
        this.setSeriesCount(i);
        this.targetValueLines = new Hashtable();
        this.rangeLabelsOn = true;
        this.setRange(d);
        this.setLowerRange(d1);
        this.valueLinesColor = Color.lightGray;
        this.setSampleColors(null);
        this.maxValueLineCount = Integer.MAX_VALUE;
        this.depth3dPoint = new Point();
        RESIZE_CURSOR = new Cursor(8);
        MOVE_CURSOR = new Cursor(12);
        DEFAULT_CURSOR = new Cursor(0);
        this.setAutomaticRepaintOn(true);
    }

    public boolean isStackedOn() {
        return this.stackedOn;
    }

    private int calculateYPos(int i, int j, Rectangle rectangle) {
        double d = 0.0;
        if (i >= 0 && this.stackedOn) {
            int k = 0;
            while (k <= i) {
                d += this.getSampleValue(k, j);
                ++k;
            }
        } else if (i >= 0) {
            d = this.getSampleValue(i, j);
        }
        double d1 = 0.0;
        if (this.currentUpperRange - this.currentLowerRange != 0.0) {
            d1 = (d - this.currentLowerRange) / (this.currentUpperRange - this.currentLowerRange);
        }
        int l = rectangle.y + rectangle.height - (int)(d1 * (double)rectangle.height);
        boolean flag = this.is3DModeOn();
        if (flag && this.stackedOn) {
            l -= this.depth3dPoint.y;
        } else if (flag) {
            l -= this.depth3dPoint.y;
            double d2 = (double)this.depth3dPoint.y / (double)this.getSeriesCount() * (double)i;
            l += (int)Math.round(d2);
        }
        return l;
    }

    public void setRangeAdjusterOn(boolean flag) {
        this.rangeAdjusterOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getSampleHighlightSize(int i) {
        try {
            return this.sampleHighlightSize[i];
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            throw new IllegalArgumentException("Invalid series: " + i);
        }
    }

    protected void checkDataIntegrity() {
        super.checkDataIntegrity();
        int i = this.getSeriesCount();
        int j = this.getSampleCount();
        int k = this.sampleHighlightOn.length;
        int l = this.sampleHighlightOn[0].length;
        if (i != k || j != l) {
            boolean[][] aflag = new boolean[i][j];
            int i1 = 0;
            while (i1 < i) {
                int j1 = 0;
                while (j1 < j) {
                    if (i1 < k && j1 < l) {
                        aflag[i1][j1] = this.sampleHighlightOn[i1][j1];
                    }
                    ++j1;
                }
                ++i1;
            }
            this.sampleHighlightOn = aflag;
            int[] ai = new int[i];
            int[] ai1 = new int[i];
            boolean[] aflag1 = new boolean[i];
            boolean[] aflag2 = new boolean[i];
            int[] ai2 = new int[i];
            int k1 = 0;
            while (k1 < i) {
                if (k1 < k) {
                    ai[k1] = this.sampleHighlightStyle[k1];
                    ai1[k1] = this.sampleHighlightSize[k1];
                    aflag1[k1] = this.seriesLinesOn[k1];
                    aflag2[k1] = this.connectedLinesOn[k1];
                    ai2[k1] = this.lineWidth[k1];
                } else {
                    ai1[k1] = 6;
                    aflag1[k1] = true;
                    ai2[k1] = 2;
                }
                ++k1;
            }
            this.sampleHighlightStyle = ai;
            this.sampleHighlightSize = ai1;
            this.seriesLinesOn = aflag1;
            this.connectedLinesOn = aflag2;
            this.lineWidth = ai2;
        }
    }

    public double getFloatMaxValue() {
        return super.getMaxValue(-1);
    }

    private void paint3DLine(Graphics g, int i, int j, int k, int l, int i1, Color color, boolean flag, boolean flag1) {
        int[] ai = new int[4];
        int[] ai1 = new int[4];
        int j1 = this.stackedOn ? 1 : Math.max(1, this.getSeriesCount());
        int k1 = (int)Math.round((double)this.depth3dPoint.x / (double)j1);
        int l1 = (int)Math.round((double)this.depth3dPoint.y / (double)j1);
        ai[0] = i;
        ai1[0] = j;
        ai[1] = i + k1;
        ai1[1] = j + l1;
        ai[2] = ai[1] + (k - i);
        ai1[2] = l + l1;
        ai[3] = k;
        ai1[3] = l;
        Color color1 = color.darker();
        if (flag) {
            double d = 0.0;
            if (ai[1] - ai[0] != 0) {
                d = (double)(j - l) / (double)(k - i);
            }
            if (d > 0.69) {
                g.setColor(color1);
            } else {
                g.setColor(color);
            }
            g.fillPolygon(ai, ai1, 4);
            g.setColor(color1);
            g.drawLine(ai[0], ai1[0], ai[1], ai1[1]);
            g.drawLine(ai[1], ai1[1], ai[2], ai1[2]);
            g.drawLine(ai[2], ai1[2], ai[3], ai1[3]);
        }
        if (flag1) {
            ai[0] = ai[3];
            ai1[0] = ai1[3];
            ai[1] = ai[2];
            ai1[1] = ai1[2];
            ai[2] = ai[2];
            ai1[2] = i1 + l1;
            ai[3] = ai[0];
            ai1[3] = i1;
            g.setColor(color);
            g.fillPolygon(ai, ai1, 4);
            g.setColor(color1);
            g.drawLine(ai[0], ai1[0], ai[1], ai1[1]);
            g.drawLine(ai[1], ai1[1], ai[2], ai1[2]);
            g.drawLine(ai[2], ai1[2], ai[3], ai1[3]);
            g.drawLine(ai[3], ai1[3], ai[0], ai1[0]);
        }
    }

    public void setSampleHighlightStyle(int i, int j, boolean flag) {
        this.setSampleHighlightStyle(i, j);
    }

    private class TargetValueLine {
        String id;
        double value;
        Color color;
        int style;

        public String getLabel(int i) {
            switch (this.style) {
                case 1: {
                    return this.id;
                }
                case 2: {
                    String s = LineChart.this.formatNumber(this.value, i);
                    String s1 = LineChart.super.getLabel("rangeLabelPrefix");
                    String s2 = LineChart.super.getLabel("rangeLabelPostfix");
                    if (s1 != null) {
                        s = String.valueOf(s1) + s;
                    }
                    if (s2 != null) {
                        s = String.valueOf(s) + s2;
                    }
                    return s;
                }
                case 3: {
                    String s3 = String.valueOf(this.id) + " ";
                    String s4 = LineChart.this.formatNumber(this.value, i);
                    String s5 = LineChart.super.getLabel("rangeLabelPrefix");
                    String s6 = LineChart.super.getLabel("rangeLabelPostfix");
                    if (s5 != null) {
                        s4 = String.valueOf(s5) + s4;
                    }
                    if (s6 != null) {
                        s4 = String.valueOf(s4) + s6;
                    }
                    return String.valueOf(s3) + s4;
                }
            }
            return null;
        }

        public TargetValueLine(String s, double d, Color color1, int i) {
            this.id = s;
            this.value = d;
            this.color = color1;
            this.style = i;
        }
    }
}

