/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt.chart;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import softcore.awt.chart.Chart;
import softcore.awt.chart.ChartSample;

public class PieChart
extends Chart {
    int N1SeriesCount = 0;
    public static final int SELECTION_STYLE_TRIANGLE = 0;
    public static final int SELECTION_STYLE_CIRCLE = 1;
    public static final int SELECTION_STYLE_DETACHED = 2;
    private int pieAngle = 20;
    private double pieDepth = 0.4f;
    private boolean sampleLabelsOn;
    private boolean percentLabelsOn;
    private boolean pieLabelsOn;
    private int percentDecimalCount = 2;
    private int selectionStyle;
    private boolean sliceSeperatorOn;
    private Color sliceSeperatorColor;
    private double detachedDistance;
    private Hashtable detachedSlices;
    private int selectedSample = -1;
    private int selectedSeries = -1;
    private double[][] angles;
    private Rectangle[] pieBounds;
    private Point[] pieCenter;
    private int[] pieWidth;
    private static final int PAINT_2D = 0;
    private static final int PAINT_3D = 1;
    private static final int PAINT_ALL = 2;

    private void paintPies(Graphics g, Rectangle rectangle) {
        int i = this.getSeriesCount();
        if (i <= this.N1SeriesCount) {
            this.pieBounds[0] = rectangle;
            double[] ad = this.getSampleValues(0);
            this.paintPie(g, rectangle, ad, 0);
        } else {
            int j = this.getSampleCount();
            this.calculatePieBounds(rectangle, j);
            int k = 0;
            while (k < j) {
                double[] ad1 = new double[i];
                int l = 0;
                while (l < i) {
                    ad1[l] = this.getSampleValue(l, k);
                    ++l;
                }
                this.paintPie(g, this.pieBounds[k], ad1, k);
                ++k;
            }
        }
    }

    public boolean isPercentLabelsOn() {
        return this.percentLabelsOn;
    }

    public boolean isSampleLabelsOn() {
        return this.sampleLabelsOn;
    }

    public boolean isPieLabelsOn() {
        return this.pieLabelsOn;
    }

    private void paintPieSegment(Graphics g, Color color, double d, double d1, int i, int j, int k, int l, boolean flag, double d2, int i1) {
        if (d2 > 0.0) {
            double d3 = -d + d1 / 2.0;
            double d5 = d3 * (Math.PI / 180);
            k += (int)Math.round(Math.cos(d5) * ((double)i * (d2 / 2.0)));
            l += (int)Math.round(Math.sin(d5) * ((double)j * (d2 / 2.0)));
        }
        if (i1 == 1 || i1 == 2) {
            double d4 = d * (Math.PI / 180);
            double d6 = (d - d1) * (Math.PI / 180);
            int l1 = (int)Math.round((double)i * this.pieDepth * ((double)this.pieAngle / 90.0));
            int i2 = i / 2;
            int j2 = j / 2;
            double d7 = Math.abs(d4 - d6) / (Math.PI * 2);
            double d8 = Math.PI * (double)Math.max(i, j);
            double d9 = d7 * d8;
            double d10 = Math.abs(d4 - d6) / d9;
            double d11 = d4;
            double d12 = d4;
            g.setColor(color.darker().darker());
            while (d11 >= d6) {
                int k2 = (int)Math.round(Math.cos(d11 -= d10) * (double)i2);
                int l2 = (int)Math.round(Math.sin(d11) * (double)j2);
                if (l2 < 0) {
                    g.drawLine(k + k2, l - l2, k + k2, l - l2 + l1 + 1);
                } else {
                    g.drawLine(k + k2, l - l2 + 1, k + k2, l - l2 + l1 + 2);
                }
                double d3 = d11;
            }
        }
        if (i1 == 0 || i1 == 2) {
            int j1 = k - i / 2;
            int k1 = l - j / 2;
            g.setColor(color);
            g.fillArc(j1, k1, i + 1, j + 1, (int)Math.round(d), (int)Math.round(-d1));
            g.setColor(color.darker());
            g.drawArc(j1, k1, i, j, (int)Math.round(d), (int)Math.round(-d1));
        }
        if (flag) {
            this.paintSelectionMarker(g, color, (int)Math.round(-d), (int)Math.round(-d1), i, j, k, l, this.selectionStyle);
        }
    }

    public void processEvent(AWTEvent awtevent) {
        switch (awtevent.getID()) {
            default: {
                break;
            }
            case 505: {
                this.selectedSample = -1;
                this.selectedSeries = -1;
                this.repaint();
                break;
            }
            case 503: 
            case 506: {
                MouseEvent mouseevent = (MouseEvent)awtevent;
                if (!this.sampleLabelsOn && !this.isValueLabelsOn() && !this.percentLabelsOn) break;
                Point point = new Point(mouseevent.getX(), mouseevent.getY());
                ChartSample chartsample = this.checkSelection(point);
                boolean flag = false;
                if (chartsample != null) {
                    flag = chartsample.getIndex() != this.selectedSample || chartsample.getSeries() != this.selectedSeries;
                    this.selectedSample = chartsample.getIndex();
                    this.selectedSeries = chartsample.getSeries();
                } else {
                    flag = this.selectedSample != -1 || this.selectedSeries != -1;
                    this.selectedSample = -1;
                    this.selectedSeries = -1;
                }
                if (!flag) break;
                this.repaint();
                break;
            }
            case 101: {
                this.repaint();
            }
        }
        super.processEvent(awtevent);
    }

    private void paintLabel(Graphics g, int i, int j, boolean flag, FontMetrics fontmetrics) {
        int k = this.getSeriesCount();
        Point point = this.pieCenter[k > this.N1SeriesCount ? j : 0];
        if (point == null) {
            return;
        }
        double d = 0.0;
        d = k == 1 ? (j < this.angles[0].length - 1 ? -((this.angles[0][j] + this.angles[0][j + 1]) / 2.0) : -((this.angles[0][j] - 270.0) / 2.0)) : (i < this.angles.length - 1 ? -((this.angles[i][j] + this.angles[i + 1][j]) / 2.0) : -((this.angles[i][j] - 270.0) / 2.0));
        double d1 = 1.0;
        int l = this.pieWidth[k == 1 ? 0 : j];
        if (this.is3DModeOn()) {
            int i1 = (int)Math.round((double)l * ((double)this.pieAngle / 90.0));
            d1 = (double)(l - i1) / (double)l;
        }
        double d2 = d * (Math.PI / 180);
        int j1 = point.x + (int)Math.round(Math.cos(d2) * (double)l / 3.0);
        int k1 = point.y + (int)Math.round(Math.sin(d2) * (double)l / 3.0 * d1);
        String s = this.constructLabel(i, j, flag);
        int l1 = fontmetrics.stringWidth(s);
        int i2 = fontmetrics.getHeight();
        j1 -= l1 / 2;
        j1 = Math.max(0, j1);
        Dimension dimension = this.getSize();
        j1 = Math.min(j1, dimension.width - l1 - 6);
        g.setColor(new Color(255, 255, 231));
        g.fillRect(j1, k1 -= i2 / 2, l1 + 4, i2 + 2);
        g.setColor(Color.black);
        g.drawRect(j1, k1, l1 + 4, i2 + 2);
        g.drawString(s, j1 + 2, k1 + i2 - 1);
    }

    public void setDepth(double d) {
        this.pieDepth = d;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public float getDepth() {
        return (float)this.pieDepth;
    }

    public void setDetachedDistance(double d) {
        this.detachedDistance = d;
        this.autoRepaint();
    }

    public double getDetachedDistance() {
        return this.detachedDistance;
    }

    public void setDetachedSlice(int i, int j, double d) {
        Double double1 = new Double(i * 1000000 + j);
        if (d != 0.0) {
            this.detachedSlices.put(double1, new Double(d));
        } else {
            this.detachedSlices.remove(double1);
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public double getDetachedSlice(int i, int j) {
        Double double1 = new Double(i * 1000000 + j);
        Double double2 = (Double)this.detachedSlices.get(double1);
        if (double2 != null) {
            return double2;
        }
        return 0.0;
    }

    public boolean isSliceSeperatorOn() {
        return this.sliceSeperatorOn;
    }

    public double getPercentValue(int i) {
        return this.getPercentValue(0, i);
    }

    public double getPercentValue(int i, int j) {
        if (i < 0 || i >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Invalid series index: " + i);
        }
        if (j < 0 || j >= this.getSampleCount()) {
            throw new IllegalArgumentException("Invalid sample index: " + j);
        }
        int k = this.getSeriesCount();
        if (k <= this.N1SeriesCount) {
            int l = this.getSampleCount();
            double d1 = 0.0;
            int j1 = 0;
            while (j1 < l) {
                double d4 = this.getSampleValue(0, j1);
                if (d4 > 0.0) {
                    d1 += d4;
                }
                ++j1;
            }
            double d5 = this.getSampleValue(0, j);
            if (d5 >= 0.0) {
                return d5 / d1 * 100.0;
            }
        } else {
            double d = 0.0;
            int i1 = 0;
            while (i1 < k) {
                double d2 = this.getSampleValue(i1, j);
                if (d2 > 0.0) {
                    d += d2;
                }
                ++i1;
            }
            double d3 = this.getSampleValue(i, j);
            if (d3 > 0.0) {
                return d3 / d * 100.0;
            }
        }
        return 0.0;
    }

    private void paintSelectionMarker(Graphics g, Color color, double d, double d1, int i, int j, int k, int l, int i1) {
        if (i1 == 1) {
            double d2 = d - d1 / 2.0;
            double d4 = d2 * (Math.PI / 180);
            int j1 = k + (int)Math.round(Math.cos(d4) * ((double)i * 0.4));
            int l1 = l + (int)Math.round(Math.sin(d4) * ((double)j * 0.4));
            int j2 = Math.max(i / 16, 3);
            int l2 = Math.max(j / 16, 3);
            int j3 = j2 / 2;
            int k3 = l2 / 2;
            g.setColor(color.darker());
            g.fillOval(j1 - j3, l1 - k3, j2, l2);
            g.setColor(color.darker());
            g.drawArc(j1 - j3, l1 - k3, j2, l2, 45, 180);
            g.setColor(color.darker().darker());
            g.drawArc(j1 - j3 + 1, l1 - k3 + 1, j2 - 2, l2 - 2, 45, 180);
            g.setColor(color);
            g.drawArc(j1 - j3 + 1, l1 - k3 + 1, j2 - 2, l2 - 2, 45, -180);
            g.setColor(color.brighter());
            g.drawArc(j1 - j3, l1 - k3, j2, l2, 45, -180);
        } else if (i1 == 0) {
            double d3 = d - d1 / 2.0;
            double d5 = d3 * (Math.PI / 180);
            int k1 = (int)Math.round((double)i * 0.7);
            int i2 = (int)Math.round((double)j * 0.7);
            int k2 = k + (int)Math.round(Math.cos(d5) * ((double)i * 0.1));
            int i3 = l + (int)Math.round(Math.sin(d5) * ((double)j * 0.1));
            g.setColor(color.darker());
            g.fillArc(k2 -= (int)Math.round((double)k1 / 2.0), i3 -= (int)Math.round((double)i2 / 2.0), k1 + 1, i2 + 1, (int)(-Math.round(d)), (int)Math.round(d1));
        }
    }

    public void setPercentLabelsOn(boolean flag) {
        this.percentLabelsOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setSampleLabelsOn(boolean flag) {
        this.sampleLabelsOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setPieLabelsOn(boolean flag) {
        this.pieLabelsOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    private void paintPie(Graphics g, Rectangle rectangle, double[] ad, int i) {
        int k;
        int l;
        ad = (double[])ad.clone();
        int j = 0;
        while (j < ad.length) {
            if (ad[j] < 0.0) {
                ad[j] = 0.0;
            }
            ++j;
        }
        int i1 = l = (k = Math.min(rectangle.width, rectangle.height));
        int j1 = rectangle.x + rectangle.width / 2;
        int k1 = rectangle.y + rectangle.height / 2;
        Font font = this.getFont("pieLabelFont");
        if (font != null) {
            g.setFont(font);
        } else {
            g.setFont(this.getFont());
        }
        FontMetrics fontmetrics = g.getFontMetrics();
        boolean flag = this.is3DModeOn();
        if (flag) {
            int l1 = (int)Math.round((double)k * ((double)this.pieAngle / 90.0));
            int k2 = (int)Math.round((double)k * this.pieDepth * ((double)this.pieAngle / 90.0));
            int i3 = (l -= l1) + k2;
            k1 -= k2 / 2;
            double d1 = (double)rectangle.width / (double)k;
            int l3 = (int)Math.round((double)k * d1);
            int j4 = (int)Math.round((double)l * d1);
            k2 = (int)Math.round((double)l3 * this.pieDepth * ((double)this.pieAngle / 90.0));
            i3 = j4 + k2;
            k1 = rectangle.y + rectangle.height / 2 - k2 / 2;
            if (k1 - j4 / 2 < rectangle.y) {
                double d3 = (double)j4 / (double)i3;
                i3 = rectangle.height;
                j4 = (int)Math.round((double)i3 * d3);
                int l5 = rectangle.height - j4;
                double d10 = (double)k / (double)l;
                l3 = (int)Math.round((double)j4 * d10);
                k1 = rectangle.y + rectangle.height / 2 - l5 / 2;
            }
            k = l3;
            l = j4;
        }
        if (this.pieLabelsOn) {
            if (flag) {
                int i2 = (int)Math.round((double)k * this.pieDepth * ((double)this.pieAngle / 90.0));
                int l2 = k1 + l / 2 + fontmetrics.getHeight() - fontmetrics.getDescent() + 2;
                if ((l2 += i2) > rectangle.y + rectangle.height) {
                    int j3 = l2 - (rectangle.y + rectangle.height);
                    l -= j3;
                    k1 -= j3 / 2;
                }
            } else {
                int j2 = fontmetrics.getHeight();
                k = l -= j2;
                k1 -= j2 / 2;
            }
        }
        this.pieCenter[i].x = j1;
        this.pieCenter[i].y = k1;
        this.pieWidth[i] = k;
        double d = 0.0;
        int k3 = 0;
        while (k3 < ad.length) {
            if (ad[k3] > 0.0) {
                d += ad[k3];
            }
            ++k3;
        }
        double d2 = 90.0;
        int i4 = this.getSeriesCount();
        int k4 = 0;
        while (k4 < ad.length) {
            double d4 = ad[k4] / d * 360.0;
            if (i4 <= this.N1SeriesCount) {
                this.angles[0][k4] = d2;
            } else {
                this.angles[k4][i] = d2;
            }
            d2 -= d4;
            ++k4;
        }
        if (flag) {
            int l4 = k1;
            k1 += (int)Math.round((double)k * this.pieDepth * ((double)this.pieAngle / 90.0));
            int j5 = 0;
            while (j5 < ad.length) {
                double d7;
                double d12 = d7 = -270.0;
                if (i4 <= this.N1SeriesCount) {
                    if (j5 < this.angles[0].length - 1) {
                        d7 = this.angles[0][j5 + 1];
                    }
                    d12 = this.angles[0][j5];
                } else {
                    if (j5 < this.angles.length - 1) {
                        d7 = this.angles[j5 + 1][i];
                    }
                    d12 = this.angles[j5][i];
                }
                if (d12 != d7) {
                    boolean flag3 = false;
                    flag3 = i4 <= this.N1SeriesCount ? this.isSelected(0, j5) : this.isSelected(j5, i);
                    double d17 = 0.0;
                    d17 = flag3 && this.selectionStyle == 2 ? this.detachedDistance : (i4 <= this.N1SeriesCount ? this.getDetachedSlice(0, j5) : this.getDetachedSlice(j5, i));
                    flag3 = false;
                    this.paintPieSegment(g, this.getSampleColor(j5).darker(), d12, d12 - d7, k, l, j1, k1, flag3, d17, 0);
                }
                ++j5;
            }
            k1 = l4;
        }
        if (flag) {
            double d5 = -270.0;
            int k6 = ad.length - 1;
            while (d5 < -90.0 && k6 >= 0) {
                double d8 = d5;
                d8 = i4 <= this.N1SeriesCount ? this.angles[0][k6] : this.angles[k6][i];
                boolean flag1 = false;
                flag1 = i4 <= this.N1SeriesCount ? this.isSelected(0, k6) : this.isSelected(k6, i);
                double d14 = 0.0;
                d14 = flag1 && this.selectionStyle == 2 ? this.detachedDistance : (i4 <= this.N1SeriesCount ? this.getDetachedSlice(0, k6) : this.getDetachedSlice(k6, i));
                this.paintPieSegment(g, this.getSampleColor(k6), d8, d8 - d5, k, l, j1, k1, flag1, d14, 1);
                --k6;
                d5 = d8;
            }
            int l6 = 0;
            while (l6 < ad.length) {
                double d15;
                double d18 = d15 = -270.0;
                if (i4 <= this.N1SeriesCount) {
                    if (l6 < this.angles[0].length - 1) {
                        d15 = this.angles[0][l6 + 1];
                    }
                    d18 = this.angles[0][l6];
                } else {
                    if (l6 < this.angles.length - 1) {
                        d15 = this.angles[l6 + 1][i];
                    }
                    d18 = this.angles[l6][i];
                }
                if (d18 >= -90.0) {
                    boolean flag4 = false;
                    flag4 = i4 <= this.N1SeriesCount ? this.isSelected(0, l6) : this.isSelected(l6, i);
                    double d19 = 0.0;
                    d19 = flag4 && this.selectionStyle == 2 ? this.detachedDistance : (i4 <= this.N1SeriesCount ? this.getDetachedSlice(0, l6) : this.getDetachedSlice(l6, i));
                    this.paintPieSegment(g, this.getSampleColor(l6), d18, d18 - d15, k, l, j1, k1, flag4, d19, 1);
                }
                ++l6;
            }
        }
        int i5 = 0;
        while (i5 < ad.length) {
            double d6;
            double d11 = d6 = -270.0;
            if (i4 <= this.N1SeriesCount) {
                if (i5 < this.angles[0].length - 1) {
                    d6 = this.angles[0][i5 + 1];
                }
                d11 = this.angles[0][i5];
            } else {
                if (i5 < this.angles.length - 1) {
                    d6 = this.angles[i5 + 1][i];
                }
                d11 = this.angles[i5][i];
            }
            if (d11 != d6) {
                boolean flag2 = false;
                flag2 = i4 <= this.N1SeriesCount ? this.isSelected(0, i5) : this.isSelected(i5, i);
                double d16 = 0.0;
                d16 = flag2 && this.selectionStyle == 2 ? this.detachedDistance : (i4 <= this.N1SeriesCount ? this.getDetachedSlice(0, i5) : this.getDetachedSlice(i5, i));
                this.paintPieSegment(g, this.getSampleColor(i5), d11, d11 - d6, k, l, j1, k1, flag2, d16, 0);
            }
            ++i5;
        }
        if (this.sliceSeperatorOn) {
            int k5 = 0;
            while (k5 < ad.length) {
                double d9 = 0.0;
                d9 = i4 <= this.N1SeriesCount ? this.angles[0][k5] : this.angles[k5][i];
                double d13 = -d9 * (Math.PI / 180);
                int i7 = j1 + (int)Math.round(Math.cos(d13) * ((double)k * 0.5));
                int j7 = k1 + (int)Math.round(Math.sin(d13) * ((double)l * 0.5));
                if (this.sliceSeperatorColor != null) {
                    g.setColor(this.sliceSeperatorColor);
                } else {
                    g.setColor(this.getSampleColor(k5).darker());
                }
                g.drawLine(j1, k1, i7, j7);
                ++k5;
            }
        }
        if (this.pieLabelsOn) {
            String s = this.getSampleLabel(i);
            if (i4 <= this.N1SeriesCount) {
                s = this.getSeriesLabel(i);
            }
            if (s != null && s.trim().length() > 0) {
                Color color;
                int i6 = j1 - fontmetrics.stringWidth(s) / 2;
                int j6 = k1 + l / 2 + fontmetrics.getHeight() - fontmetrics.getDescent() + 2;
                if (flag) {
                    j6 += (int)Math.round((double)k * this.pieDepth * ((double)this.pieAngle / 90.0));
                }
                g.setColor((color = this.getSampleLabelColor(i)) != null ? color : this.getForeground());
                g.drawString(s, i6, j6);
            }
        }
    }

    private String constructLabel(int i, int j, boolean flag) {
        String s1;
        int k = this.getSeriesCount();
        int l = this.getSampleCount();
        if (i < 0 || i >= k || j < 0 || j >= l) {
            return "";
        }
        String s = this.getLabel("valueLabelPrefix_" + i);
        if (s == null) {
            s = this.getLabel("valueLabelPrefix");
        }
        if ((s1 = this.getLabel("valueLabelPostfix_" + i)) == null) {
            s1 = this.getLabel("valueLabelPostfix");
        }
        double d = this.getSampleValue(i, j);
        String s2 = "";
        int i1 = this.getSampleDecimalCount();
        if (this.sampleLabelsOn) {
            if (k <= this.N1SeriesCount && this.getSampleLabel(j) != null) {
                s2 = this.getSampleLabel(j);
            } else if (k > this.N1SeriesCount) {
                if (flag && this.getSeriesLabel(i) != null) {
                    s2 = String.valueOf(this.getSeriesLabel(i)) + " : ";
                }
                if (this.getSampleLabel(j) != null) {
                    s2 = String.valueOf(s2) + this.getSampleLabel(j);
                }
            }
        }
        if (this.isValueLabelsOn() && this.percentLabelsOn) {
            if (s2.length() > 0) {
                s2 = String.valueOf(s2) + " : ";
            }
            String s3 = this.formatNumber(d, i1);
            s3 = s != null ? String.valueOf(s) + s3 : s3;
            s3 = s1 != null ? String.valueOf(s3) + s1 : s3;
            s2 = String.valueOf(s2) + s3;
            double d2 = this.getPercentValue(i, j);
            s2 = String.valueOf(s2) + " : " + this.formatNumber(d2, this.percentDecimalCount) + "%";
        } else if (this.isValueLabelsOn()) {
            if (this.sampleLabelsOn) {
                s2 = String.valueOf(s2) + " : ";
            }
            String s4 = this.formatNumber(d, i1);
            s4 = s != null ? String.valueOf(s) + s4 : s4;
            s4 = s1 != null ? String.valueOf(s4) + s1 : s4;
            s2 = String.valueOf(s2) + s4;
        } else if (this.percentLabelsOn) {
            if (this.sampleLabelsOn) {
                s2 = String.valueOf(s2) + " : ";
            }
            double d1 = this.getPercentValue(i, j);
            s2 = String.valueOf(s2) + this.formatNumber(d1, this.percentDecimalCount) + "%";
        }
        return s2;
    }

    public void setSliceSeperatorOn(boolean flag) {
        this.sliceSeperatorOn = flag;
        this.hasChanged = true;
        this.autoRepaint();
    }

    protected ChartSample checkSelection(Point point) {
        ChartSample chartsample;
        block16: {
            chartsample = super.checkSelection(point);
            if (chartsample != null) break block16;
            int i = -1;
            Object obj = null;
            int j = 0;
            while (j < this.pieBounds.length) {
                Rectangle rectangle = this.pieBounds[j];
                if (rectangle != null && rectangle.contains(point)) {
                    i = j;
                    break;
                }
                ++j;
            }
            if (i >= 0) {
                int i1;
                double d;
                point.x -= this.pieCenter[i].x;
                point.y -= this.pieCenter[i].y;
                if (this.is3DModeOn()) {
                    int k = this.pieWidth[i];
                    int l = (int)Math.round((double)k * ((double)this.pieAngle / 90.0));
                    double d1 = (double)k / (double)(k - l);
                    point.y = (int)Math.round((double)point.y * d1);
                }
                if ((d = Math.sqrt(point.x * point.x + point.y * point.y)) > (double)(this.pieWidth[i] / 2)) {
                    return null;
                }
                double d2 = Math.atan2(point.y, point.x);
                double d3 = -(d2 * 57.29577951308232);
                if (d3 > 90.0 && d3 <= 180.0) {
                    d3 += -360.0;
                }
                if ((i1 = this.getSeriesCount()) <= this.N1SeriesCount) {
                    int j1 = this.getSampleCount();
                    int l1 = 0;
                    while (l1 < j1) {
                        double d5 = 0.0;
                        double d7 = 0.0;
                        if (l1 < j1 - 1) {
                            d5 = Math.min(this.angles[0][l1], this.angles[0][l1 + 1]);
                            d7 = Math.max(this.angles[0][l1], this.angles[0][l1 + 1]);
                        } else {
                            d5 = Math.min(this.angles[0][l1], -270.0);
                            d7 = Math.max(this.angles[0][l1], -270.0);
                        }
                        if (d3 >= d5 && d3 < d7) {
                            return this.getSample(0, l1);
                        }
                        ++l1;
                    }
                } else {
                    int k1 = 0;
                    while (k1 < i1) {
                        double d4 = 0.0;
                        double d6 = 0.0;
                        if (k1 < i1 - 1) {
                            d4 = Math.min(this.angles[k1][i], this.angles[k1 + 1][i]);
                            d6 = Math.max(this.angles[k1][i], this.angles[k1 + 1][i]);
                        } else {
                            d4 = Math.min(this.angles[k1][i], -270.0);
                            d6 = Math.max(this.angles[k1][i], -270.0);
                        }
                        if (d3 >= d4 && d3 < d6) {
                            return this.getSample(k1, i);
                        }
                        ++k1;
                    }
                }
            }
        }
        return chartsample;
    }

    public PieChart() {
        this(1);
    }

    public PieChart(int i) {
        this(1, i);
    }

    public PieChart(int i, int j) {
        super(i, j);
        this.angles = new double[i][j];
        this.detachedDistance = 0.1;
        this.detachedSlices = new Hashtable();
        this.pieBounds = new Rectangle[i <= this.N1SeriesCount ? 1 : j];
        this.pieCenter = new Point[this.pieBounds.length];
        this.pieWidth = new int[this.pieBounds.length];
        int k = 0;
        while (k < this.pieBounds.length) {
            this.pieBounds[k] = new Rectangle();
            this.pieCenter[k] = new Point();
            ++k;
        }
    }

    public void setPercentDecimalCount(int i) {
        this.percentDecimalCount = i;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getPercentDecimalCount() {
        return this.percentDecimalCount;
    }

    public void setSliceSeperatorColor(Color color) {
        this.sliceSeperatorColor = color;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color getSliceSeperatorColor() {
        return this.sliceSeperatorColor;
    }

    public void setFont(String s, Font font) {
        super.setFont(s, font);
    }

    private void paintLabels(Graphics g, int i, int j) {
        int k = this.getSeriesCount();
        int l = this.getSampleCount();
        if (g == null || i < 0 || i >= k || j < -1 || j >= l) {
            return;
        }
        Font font = this.getFont("floatingLabelFont");
        if (font != null) {
            g.setFont(font);
        } else {
            g.setFont(this.getFont());
        }
        FontMetrics fontmetrics = g.getFontMetrics();
        if (j >= 0) {
            this.paintLabel(g, i, j, true, fontmetrics);
        } else {
            int i1 = 0;
            while (i1 < l) {
                this.paintLabel(g, i, i1, false, fontmetrics);
                ++i1;
            }
        }
    }

    public void setAngle(int i) {
        this.pieAngle = i;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getAngle() {
        return this.pieAngle;
    }

    public void setSelectionStyle(int i) {
        this.selectionStyle = i;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getSelectionStyle() {
        return this.selectionStyle;
    }

    public String[] getLegendLabels() {
        String[] as = super.getLegendLabels();
        if (as != null && (this.getSampleCount() <= 1 || this.getSeriesCount() <= 1)) {
            int i = 0;
            while (i < as.length) {
                double d = this.getSampleCount() > 1 ? this.getPercentValue(0, i) : this.getPercentValue(i, 0);
                String s = String.valueOf(this.formatNumber(d, this.percentDecimalCount)) + "%";
                as[i] = as[i] != null ? String.valueOf(as[i]) + "(" + s + ")" : s;
                ++i;
            }
        }
        return as;
    }

    protected void render(Graphics g, boolean flag) {
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.getGraphBounds();
        if (this.hasChanged || flag) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, dimension.width, dimension.height);
            this.paintPies(g, rectangle);
            if (this.isLegendOn()) {
                this.paintLegend(g, rectangle, this.getLegendLabels());
            }
            this.paintTitle(g, dimension);
            this.hasChanged = false;
        }
        if (this.sampleLabelsOn || this.isValueLabelsOn() || this.percentLabelsOn) {
            this.paintLabels(g, this.selectedSeries, this.selectedSample);
        }
    }

    protected void checkDataIntegrity() {
        super.checkDataIntegrity();
        int i = this.getSeriesCount();
        int j = this.getSampleCount();
        this.angles = new double[i][j];
        this.pieBounds = new Rectangle[i <= this.N1SeriesCount ? 1 : j];
        this.pieCenter = new Point[this.pieBounds.length];
        this.pieWidth = new int[this.pieBounds.length];
        int k = 0;
        while (k < this.pieBounds.length) {
            this.pieBounds[k] = new Rectangle();
            this.pieCenter[k] = new Point();
            ++k;
        }
    }

    public Rectangle getGraphBounds() {
        Rectangle rectangle = super.getGraphBounds(this.getLegendLabels());
        Insets insets = this.getGraphInsets();
        if (insets != null) {
            Dimension dimension = this.getSize();
            if (insets.top != -1) {
                int i = rectangle.y + rectangle.height;
                rectangle.y = insets.top;
                rectangle.height = i - rectangle.y;
            }
            if (insets.left != -1) {
                int j = rectangle.x + rectangle.width;
                rectangle.x = insets.left;
                rectangle.width = j - rectangle.x;
            }
            if (insets.bottom != -1) {
                rectangle.height = dimension.height - insets.bottom - rectangle.y;
            }
            if (insets.right != -1) {
                rectangle.width = dimension.width - insets.right - rectangle.x;
            }
        }
        return rectangle;
    }

    private void calculatePieBounds(Rectangle rectangle, int i) {
        int j = 0;
        int k = i;
        int l = 1;
        int i1 = 1;
        while (i1 <= i) {
            int j1 = 1;
            while (j1 <= i) {
                int l1;
                if (i1 * j1 >= i && (l1 = Math.min(rectangle.width / i1, rectangle.height / j1)) > j) {
                    j = l1;
                    k = i1;
                    l = j1;
                }
                ++j1;
            }
            ++i1;
        }
        int k1 = 0;
        int i2 = 0;
        while (i2 < l) {
            int j2 = 0;
            while (j2 < k) {
                if (k1 < i) {
                    Rectangle rectangle1 = this.pieBounds[k1];
                    rectangle1.width = rectangle.width / k;
                    rectangle1.height = rectangle.height / l;
                    rectangle1.x = rectangle.x + rectangle1.width * j2;
                    rectangle1.y = rectangle.y + rectangle1.height * i2;
                    rectangle1.width -= 10;
                    rectangle1.height -= 10;
                    rectangle1.x += 5;
                    rectangle1.y += 5;
                    ++k1;
                }
                ++j2;
            }
            ++i2;
        }
    }
}

