/*
 * Decompiled with CFR 0.152.
 */
package softcore.dataset;

import softcore.dataset.DataColumn;
import softcore.dataset.DataSet;
import softcore.dataset.DataSetException;
import softcore.dataset.DataSetListener;

public abstract class AbstractDataSet
implements DataSet {
    protected DataColumn[] dataColumns;
    private DataSetListener[] listDataSetListener;

    public int getRowCount() throws DataSetException {
        return 0;
    }

    public int getRow() throws DataSetException {
        return 0;
    }

    public void gotoRow(int i) throws DataSetException {
    }

    public int getColumnCount() throws DataSetException {
        return this.dataColumns.length;
    }

    public DataColumn[] getColumns() throws DataSetException {
        return this.dataColumns;
    }

    public DataColumn getColumn(int i) throws DataSetException {
        return this.dataColumns[i];
    }

    public DataColumn getColumn(String s) throws DataSetException {
        int i = this.toColumnIndex(s);
        return i < 0 ? null : this.dataColumns[i];
    }

    public int toColumnIndex(String s) throws DataSetException {
        int i = 0;
        while (i < this.dataColumns.length) {
            if (this.dataColumns[i].columnName.equalsIgnoreCase(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object getValue(int i, int j) throws DataSetException {
        return null;
    }

    public Object getValue(int i, String s) throws DataSetException {
        return this.getValue(i, this.toColumnIndex(s));
    }

    public Object getValue(int i) throws DataSetException {
        return this.getValue(this.getRow(), i);
    }

    public Object getValue(String s) throws DataSetException {
        return this.getValue(this.toColumnIndex(s));
    }

    public void insertRow(boolean flag) throws DataSetException {
    }

    public void postRow() throws DataSetException {
    }

    public boolean isRowChanged() throws DataSetException {
        return false;
    }

    public boolean isNewRow() throws DataSetException {
        return false;
    }

    public void deleteRow() throws DataSetException {
    }

    public void setValue(int i, Object obj) throws DataSetException {
    }

    public void setValue(String s, Object obj) throws DataSetException {
        this.setValue(this.toColumnIndex(s), obj);
    }

    public void saveChanges() throws DataSetException {
    }

    public boolean isChanged() throws DataSetException {
        return false;
    }

    public void close() throws DataSetException {
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void addDataSetListener(DataSetListener datasetlistener) {
        int i = this.listDataSetListener != null ? this.listDataSetListener.length : 0;
        int j = 0;
        while (j < i) {
            if (this.listDataSetListener[j] == null) {
                this.listDataSetListener[j] = datasetlistener;
                return;
            }
            ++j;
        }
        DataSetListener[] adatasetlistener = this.listDataSetListener;
        this.listDataSetListener = new DataSetListener[i + 1];
        if (i > 0) {
            System.arraycopy(adatasetlistener, 0, this.listDataSetListener, 0, i);
        }
        this.listDataSetListener[i] = datasetlistener;
    }

    public void removeDataSetListener(DataSetListener datasetlistener) {
        int i = this.listDataSetListener != null ? this.listDataSetListener.length : 0;
        int j = 0;
        while (j < i) {
            if (this.listDataSetListener[j] == datasetlistener) {
                this.listDataSetListener[j] = null;
                return;
            }
            ++j;
        }
    }
}

