/*
 * Decompiled with CFR 0.152.
 */
package softcore.dbf;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;

public class DbfWrite {
    private OutputStream os;
    boolean autoClose;
    final String[] columnName;
    final byte[] columnType;
    final short[] columnSize;
    final short[] columnDeci;
    final int recordLength;
    RandomAccessFile randomFile;
    private int headLength;
    private int recordCount;
    final Vector recordsBuffer = new Vector();

    private void writeInt(int i) throws IOException {
        this.os.write(i >>> 0 & 0xFF);
        this.os.write(i >>> 8 & 0xFF);
        this.os.write(i >>> 16 & 0xFF);
        this.os.write(i >>> 24 & 0xFF);
    }

    private void writeShort(int i) throws IOException {
        this.os.write(i >>> 0 & 0xFF);
        this.os.write(i >>> 8 & 0xFF);
    }

    private void writeString(String s, int i, int j) throws IOException {
        byte[] abyte0 = s.getBytes();
        int k = 0;
        while (k < i) {
            this.os.write(k >= abyte0.length ? j : abyte0[k]);
            ++k;
        }
    }

    private void fill(int i, int j) throws IOException {
        int k = 0;
        while (k < i) {
            this.os.write(j);
            ++k;
        }
    }

    public DbfWrite(OutputStream outputstream, String[] as, byte[] abyte0, short[] aword0, short[] aword1) throws IOException {
        this.os = outputstream;
        this.columnName = as;
        this.columnType = abyte0;
        this.columnSize = aword0;
        this.columnDeci = aword1;
        int i = 1;
        int j = 0;
        while (j < as.length) {
            if (abyte0[j] == 68) {
                aword0[j] = 8;
            }
            i += aword0[j];
            ++j;
        }
        this.recordLength = i;
    }

    public DbfWrite(String s, String[] as, byte[] abyte0, short[] aword0, short[] aword1) throws IOException {
        this(new FileOutputStream(s), as, abyte0, aword0, aword1);
        this.autoClose = true;
    }

    public DbfWrite(String s) throws IOException {
        this.randomFile = new RandomAccessFile(s, "rw");
        this.autoClose = true;
        byte byte0 = this.randomFile.readByte();
        byte byte1 = this.randomFile.readByte();
        byte byte2 = this.randomFile.readByte();
        byte byte3 = this.randomFile.readByte();
        this.recordCount = this.readInt();
        this.headLength = this.readShort();
        this.recordLength = this.readShort();
        this.randomFile.skipBytes(20);
        int i = (this.headLength - 32) / 32;
        this.columnName = new String[i];
        this.columnType = new byte[i];
        this.columnSize = new short[i];
        this.columnDeci = new short[i];
        int j = 0;
        while (j < i) {
            this.columnName[j] = this.readString(11);
            if (this.columnName[j] == null || this.columnName[j].length() == 0 || this.columnName[j].charAt(0) <= ' ') {
                this.columnName[j] = null;
                break;
            }
            this.columnName[j] = this.columnName[j].toUpperCase();
            this.columnType[j] = this.randomFile.readByte();
            this.randomFile.skipBytes(4);
            this.columnSize[j] = this.randomFile.readByte();
            this.columnDeci[j] = this.randomFile.readByte();
            this.randomFile.skipBytes(14);
            ++j;
        }
    }

    private String toNumber(Object obj, int i) {
        BigDecimal bigdecimal;
        if (obj instanceof String) {
            try {
                bigdecimal = new BigDecimal((String)obj);
            }
            catch (Exception exception) {
                return "";
            }
        } else if (obj instanceof BigDecimal) {
            bigdecimal = (BigDecimal)obj;
        } else if (obj instanceof Number) {
            bigdecimal = new BigDecimal(((Number)obj).doubleValue());
        } else {
            return "";
        }
        if (bigdecimal.scale() != this.columnDeci[i]) {
            bigdecimal = bigdecimal.setScale(this.columnDeci[i]);
        }
        return bigdecimal.toString();
    }

    private int toDate(Object obj) {
        Date obj1;
        if (obj instanceof String) {
            obj1 = java.sql.Date.valueOf((String)obj);
        } else if (obj instanceof Date) {
            obj1 = (Date)obj;
        } else {
            return 0;
        }
        GregorianCalendar gregoriancalendar = new GregorianCalendar();
        gregoriancalendar.setTime(obj1);
        int i = gregoriancalendar.get(1);
        int j = gregoriancalendar.get(2) + 1;
        int k = gregoriancalendar.get(5);
        return i * 10000 + j * 100 + k;
    }

    public void addRecord(Object[] aobj) {
        byte[] abyte0 = new byte[this.recordLength];
        int i = 0;
        while (i < this.recordLength) {
            abyte0[i++] = 32;
        }
        if (aobj != null) {
            int j = 1;
            int k = 0;
            while (k < this.columnName.length && k < aobj.length) {
                if (aobj[k] != null) {
                    if (this.columnType[k] == 67) {
                        byte[] abyte1 = aobj[k].toString().getBytes();
                        int i1 = 0;
                        while (i1 < abyte1.length && i1 < this.columnSize[k]) {
                            abyte0[j + i1] = abyte1[i1];
                            ++i1;
                        }
                    } else if (this.columnType[k] == 78) {
                        String s = this.toNumber(aobj[k], k);
                        int j1 = s.length();
                        if (j1 <= this.columnSize[k]) {
                            int l1 = 0;
                            while (l1 < j1) {
                                abyte0[j + this.columnSize[k] - j1 + l1] = (byte)s.charAt(l1);
                                ++l1;
                            }
                        }
                    } else if (this.columnType[k] == 68) {
                        int l = this.toDate(aobj[k]);
                        int k1 = 7;
                        while (k1 >= 0) {
                            abyte0[j + k1] = (byte)(l % 10 + 48);
                            l /= 10;
                            --k1;
                        }
                    }
                }
                j += this.columnSize[k++];
            }
        }
        this.recordsBuffer.addElement(abyte0);
    }

    public void close() throws IOException {
        if (this.randomFile != null) {
            if (this.recordsBuffer.size() > 0) {
                this.randomFile.seek(1L);
                Calendar calendar = Calendar.getInstance();
                this.randomFile.writeByte(calendar.get(1) % 100);
                this.randomFile.writeByte(calendar.get(2) + 1);
                this.randomFile.writeByte(calendar.get(5));
                int i = this.recordsBuffer.size() + this.recordCount;
                this.randomFile.writeByte(i >>> 0 & 0xFF);
                this.randomFile.writeByte(i >>> 8 & 0xFF);
                this.randomFile.writeByte(i >>> 16 & 0xFF);
                this.randomFile.writeByte(i >>> 24 & 0xFF);
                this.randomFile.seek(this.headLength + this.recordCount * this.recordLength);
                int k = 0;
                while (k < this.recordsBuffer.size()) {
                    this.randomFile.write((byte[])this.recordsBuffer.elementAt(k));
                    ++k;
                }
            }
            if (this.autoClose) {
                this.randomFile.close();
            }
            this.randomFile = null;
        }
        if (this.os == null) {
            return;
        }
        this.os.write(3);
        Calendar calendar1 = Calendar.getInstance();
        this.os.write(calendar1.get(1) % 100);
        this.os.write(calendar1.get(2) + 1);
        this.os.write(calendar1.get(5));
        this.writeInt(this.recordsBuffer.size());
        this.writeShort(32 + this.columnName.length * 32 + 1);
        this.writeShort(this.recordLength);
        this.fill(20, 0);
        int j = 0;
        while (j < this.columnName.length) {
            this.writeString(this.columnName[j], 11, 0);
            this.os.write(this.columnType[j]);
            this.fill(4, 0);
            this.os.write(this.columnSize[j]);
            this.os.write(this.columnDeci[j]);
            this.fill(14, 0);
            ++j;
        }
        this.os.write(13);
        int l = 0;
        while (l < this.recordsBuffer.size()) {
            this.os.write((byte[])this.recordsBuffer.elementAt(l));
            ++l;
        }
        if (this.autoClose) {
            this.os.close();
        }
        this.os = null;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean isOpen() {
        return this.os != null || this.randomFile != null;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public int loadRecord(int i, Dictionary dictionary) throws IOException {
        if (i < 0 || i >= this.recordCount) {
            return 0;
        }
        this.randomFile.seek(this.headLength + this.recordLength * i);
        this.randomFile.read();
        boolean flag = false;
        int j = 0;
        while (j < this.columnName.length && this.columnName[j] != null) {
            Object obj;
            if (this.columnType[j] == 67) {
                obj = this.readString(this.columnSize[j]);
            } else if (this.columnType[j] == 78) {
                int l1;
                String s = this.readString(this.columnSize[j]).trim();
                int k = this.columnDeci[j];
                int j1 = s.indexOf(46);
                if (j1 >= 0 && (l1 = s.length() - (j1 + 1)) > k) {
                    k = l1;
                }
                obj = k == 0 && this.columnSize[j] < 9 ? Integer.valueOf(s.trim()) : new BigDecimal(s.trim()).setScale(k, 4);
            } else if (this.columnType[j] == 68) {
                String s1 = this.readString(this.columnSize[j]).trim();
                int i1 = Integer.parseInt(s1.substring(0, 4));
                int k1 = Integer.parseInt(s1.substring(4, 6));
                int i2 = Integer.parseInt(s1.substring(6, 8));
                GregorianCalendar gregoriancalendar = new GregorianCalendar();
                gregoriancalendar.clear();
                gregoriancalendar.set(1, i1);
                gregoriancalendar.set(2, k1 - 1);
                gregoriancalendar.set(5, i2);
                obj = gregoriancalendar.getTime();
            } else if (this.columnType[j] == 66) {
                long l = this.readLong();
                obj = new Double(Double.longBitsToDouble(l));
            } else {
                throw new IOException("Unknown DBF column type '" + this.columnType[j] + "'");
            }
            if (obj == null) {
                dictionary.remove(this.columnName[j]);
            } else {
                dictionary.put(this.columnName[j], obj);
            }
            ++j;
        }
        return 1;
    }

    public int findRecord(String[] as, Object[] aobj) throws IOException {
        Hashtable hashtable = new Hashtable();
        int i = 0;
        while (i < this.recordCount) {
            block3: {
                hashtable.clear();
                this.loadRecord(i, hashtable);
                int j = 0;
                while (j < as.length) {
                    Object obj = hashtable.get(as[j].toUpperCase());
                    if (obj == aobj[j] || obj != null && obj.equals(aobj[j])) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findRecord(String s, Object obj) throws IOException {
        return this.findRecord(new String[]{s}, new Object[]{obj});
    }

    public void writeRecord(int i, Dictionary dictionary) throws IOException {
        if (i < 0 || i >= this.recordCount) {
            return;
        }
        this.randomFile.seek(this.headLength + this.recordLength * i + 1);
        int j = 0;
        while (j < this.columnName.length && this.columnName[j] != null) {
            Object obj = dictionary.get(this.columnName[j]);
            byte byte0 = this.columnType[j];
            int word0 = this.columnSize[j];
            byte[] abyte0 = null;
            int k = 32;
            if (byte0 == 67) {
                abyte0 = obj != null ? obj.toString().getBytes() : null;
            } else if (byte0 == 78) {
                String s = this.toNumber(obj, j);
                abyte0 = s != null ? s.getBytes() : null;
            } else if (byte0 == 68) {
                int l = this.toDate(obj);
                abyte0 = new byte[8];
                int j1 = 7;
                while (j1 >= 0) {
                    abyte0[j1] = (byte)(l % 10 + 48);
                    --j1;
                }
                l /= 10;
            } else if (byte0 == 66) {
                long l1 = obj instanceof Number ? Double.doubleToLongBits(((Number)obj).doubleValue()) : 0L;
                abyte0 = new byte[8];
                int k1 = 0;
                while (k1 < 8) {
                    abyte0[k1] = (byte)(l1 >> k1 * 8);
                    ++k1;
                }
            }
            int i1 = 0;
            while (i1 < word0) {
                this.randomFile.writeByte(abyte0 != null && i1 < abyte0.length ? abyte0[i1] : (byte)k);
                ++i1;
            }
            ++j;
        }
    }

    private long readLong() throws IOException {
        long l = 0L;
        int i = 0;
        while (i < 8) {
            int j = this.randomFile.readByte() & 0xFF;
            l |= (long)j << i * 8;
            ++i;
        }
        return l;
    }

    private int readInt() throws IOException {
        int i = this.randomFile.readByte() & 0xFF;
        int j = this.randomFile.readByte() & 0xFF;
        int k = this.randomFile.readByte() & 0xFF;
        int l = this.randomFile.readByte() & 0xFF;
        return (l << 24) + (k << 16) + (j << 8) + (i << 0);
    }

    private int readShort() throws IOException {
        int i = this.randomFile.readByte() & 0xFF;
        int j = this.randomFile.readByte() & 0xFF;
        return (short)((j << 8) + (i << 0));
    }

    private String readString(int i) throws IOException {
        byte[] abyte0 = new byte[i];
        int j = -1;
        int k = 0;
        while (k < i) {
            int l = this.randomFile.read();
            if (l > 0) {
                abyte0[k] = (byte)l;
            } else if (j == -1) {
                j = k;
            }
            ++k;
        }
        if (j == -1) {
            j = i;
        }
        return this.readString(abyte0, 0, j);
    }

    private String readString(byte[] abyte0, int i, int j) {
        while (j > 0 && abyte0[i + j - 1] <= 32) {
            --j;
        }
        return new String(abyte0, i, j);
    }
}

