/*
 * Decompiled with CFR 0.152.
 */
package softcore.dbswing;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;
import javax.swing.text.TextAction;

public class JdbNavField
extends JTextField
implements ColumnAware,
FocusListener {
    public static final String locateNextAction = "locate-next";
    public static final String locatePreviousAction = "locate-previous";
    public static final String locateEnterAction = "locate-enter";
    private static final JTextComponent.KeyBinding[] keyBindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(40, 0, true), "locate-next"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(38, 0, true), "locate-previous"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(10, 0, true), "locate-enter")};
    private static final Action[] navFieldActions = new Action[]{new LocateNextAction(), new LocatePreviousAction(), new LocateEnterAction()};
    private DataSet dataSet;
    private String columnName;
    private boolean caseSensitive;
    private boolean locateFirst = true;
    private boolean justLocated = false;
    private int selectStart;
    private int selectEnd;
    private int locateOptions;
    private boolean enterPressed;

    public JdbNavField() {
        this.commonInit();
    }

    public JdbNavField(String text) {
        super(text);
        this.commonInit();
    }

    public JdbNavField(int columns) {
        super(columns);
        this.commonInit();
    }

    public JdbNavField(String text, int columns) {
        super(text, columns);
        this.commonInit();
    }

    public JdbNavField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.commonInit();
    }

    public void addNotify() {
        super.addNotify();
        this.openDataSet();
    }

    protected void commonInit() {
        this.getCaret().setBlinkRate(0);
        Insets margin = this.getMargin();
        this.setMargin(new Insets(margin.top, margin.left + 2, margin.bottom, margin.right + 2));
        this.mapNavFieldActions();
        this.enableEvents(2048L);
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.removeFocusListener(this);
        }
        this.dataSet = dataSet;
        if (dataSet != null) {
            this.addFocusListener(this);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    protected Document createDefaultModel() {
        return new JdbNavFieldDocument();
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), navFieldActions);
    }

    private void mapNavFieldActions() {
        Keymap parentKeymap = this.getKeymap();
        Keymap navFieldKeymap = JTextComponent.addKeymap("JdbNavField Keymap", parentKeymap);
        JTextComponent.loadKeymap(navFieldKeymap, keyBindings, this.getActions());
        this.setKeymap(navFieldKeymap);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    private void openDataSet() {
        try {
            if (this.dataSet != null && !this.dataSet.isOpen()) {
                this.dataSet.open();
            }
        }
        catch (DataSetException e) {
            e.printStackTrace();
        }
    }

    private void locateNext() {
        this.locateOptions = 2;
        this.locateFirst = false;
        this.doInteractiveLocate();
    }

    private void locatePrev() {
        this.locateOptions = 4;
        this.locateFirst = false;
        this.doInteractiveLocate();
    }

    private void locateEnter() {
        this.enterPressed = true;
        this.doInteractiveLocate();
        this.enterPressed = false;
    }

    private void doInteractiveLocate() {
        Document model = this.getDocument();
        if (model instanceof JdbNavFieldDocument) {
            String searchText = null;
            if (this.getSelectionEnd() == this.getDocument().getLength() && this.getSelectionStart() < this.getSelectionEnd()) {
                try {
                    searchText = this.getText(0, this.getSelectionStart());
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            } else {
                searchText = this.getText();
            }
            this.setText(searchText);
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    protected void processInputMethodEvent(InputMethodEvent e) {
        super.processInputMethodEvent(e);
        if (this.justLocated) {
            this.justLocated = false;
            this.setCaretPosition(this.selectStart);
            this.moveCaretPosition(this.selectEnd);
        }
    }

    public void setAction(JButton btn, int i) {
        if (i == 1) {
            btn.addActionListener(new LocateNextAction());
        } else if (i == 0) {
            btn.addActionListener(new LocatePreviousAction());
        }
    }

    class JdbNavFieldDocument
    extends PlainDocument {
        JdbNavFieldDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null || JdbNavField.this.dataSet == null) {
                return;
            }
            super.insertString(offs, str, a);
            if (a != null && a.getAttribute(StyleConstants.ComposedTextAttribute) != null) {
                return;
            }
            if (JdbNavField.this.locateFirst) {
                JdbNavField.this.locateOptions = 32;
            }
            JdbNavField.this.locateFirst = true;
            String searchText = this.getText(0, this.getLength());
            if (!JdbNavField.this.caseSensitive && searchText.toLowerCase().equals(searchText)) {
                JdbNavField jdbNavField = JdbNavField.this;
                jdbNavField.locateOptions = jdbNavField.locateOptions | 8;
            }
            try {
                String value;
                JdbNavField.this.dataSet.interactiveLocate(searchText, JdbNavField.this.columnName, JdbNavField.this.locateOptions, JdbNavField.this.enterPressed);
                String currentColumnName = JdbNavField.this.columnName == null ? JdbNavField.this.dataSet.getLastColumnVisited() : JdbNavField.this.columnName;
                Column column = JdbNavField.this.dataSet.hasColumn(currentColumnName);
                if (column != null && column.getDataType() == 16 && (value = JdbNavField.this.dataSet.getString(currentColumnName)).regionMatches((JdbNavField.this.locateOptions & 8) == 8, 0, searchText, 0, searchText.length())) {
                    super.insertString(this.getLength(), value.substring(this.getLength()), null);
                    JdbNavField.this.justLocated = true;
                    JdbNavField.this.selectStart = searchText.length();
                    JdbNavField.this.selectEnd = this.getLength();
                    JdbNavField.this.setCaretPosition(JdbNavField.this.selectStart);
                    JdbNavField.this.moveCaretPosition(JdbNavField.this.selectEnd);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class LocateEnterAction
    extends TextAction {
        LocateEnterAction() {
            super(JdbNavField.locateEnterAction);
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target instanceof JdbNavField) {
                ((JdbNavField)target).locateEnter();
            }
        }
    }

    static class LocateNextAction
    extends TextAction {
        LocateNextAction() {
            super(JdbNavField.locateNextAction);
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target instanceof JdbNavField) {
                ((JdbNavField)target).locateNext();
            }
        }
    }

    static class LocatePreviousAction
    extends TextAction {
        LocatePreviousAction() {
            super(JdbNavField.locatePreviousAction);
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target instanceof JdbNavField) {
                ((JdbNavField)target).locatePrev();
            }
        }
    }
}

