/*
 * Decompiled with CFR 0.152.
 */
package softcore.net;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import softcore.util.Message;
import softface.MainFrame;
import softface.mdi.JMDIDesktopPane;

public class Telnet
extends JPanel
implements ActionListener {
    final JTextArea requestTextArea = new JTextArea("USER caoyuwu");
    final JTextArea responseTextArea = new JTextArea();
    final JToolBar toolBar = new JToolBar();
    final JTextField ipAddrField = new JTextField("10.0.0.10", 12);
    final JTextField ipPortField = new JTextField("110", 5);
    final JButton connectButton = new JButton("\u8fde\u63a5");
    final JButton disconnectButton = new JButton("\u65ad\u5f00");
    final JButton requestButton = new JButton("\u8bf7\u6c42");
    Socket socket;

    void enableToolbarButton() {
        this.requestButton.setEnabled(this.socket != null);
        this.disconnectButton.setEnabled(this.socket != null);
    }

    public Telnet() {
        super(new BorderLayout());
        this.requestTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
        this.requestButton.addActionListener(this);
        this.connectButton.addActionListener(this);
        this.disconnectButton.addActionListener(this);
        JSplitPane jsplitpane = new JSplitPane(0);
        jsplitpane.add((Component)new JScrollPane(this.requestTextArea), "top");
        jsplitpane.add((Component)new JScrollPane(this.responseTextArea), "bottom");
        this.add((Component)jsplitpane, "Center");
        this.toolBar.add(this.ipAddrField);
        this.toolBar.add(this.ipPortField);
        this.toolBar.add(this.connectButton);
        this.toolBar.add(this.disconnectButton);
        this.toolBar.add(this.requestButton);
        this.add((Component)this.toolBar, "North");
        this.enableToolbarButton();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionevent) {
        if (actionevent.getSource() == this.connectButton) {
            this.socket = null;
            try {
                try {
                    String s = this.ipPortField.getText();
                    if (s == null) {
                        Object var4_6 = null;
                        this.enableToolbarButton();
                        return;
                    }
                    s = s.trim();
                    int i = Integer.parseInt(s);
                    this.socket = new Socket(this.ipAddrField.getText(), i);
                    this.receiveData();
                }
                catch (Exception exception) {
                    Message.showInformationDialog("Error", exception.toString());
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.enableToolbarButton();
                throw throwable;
            }
            {
                Object var4_8 = null;
                this.enableToolbarButton();
                return;
            }
        }
        if (actionevent.getSource() == this.disconnectButton && this.socket != null) {
            try {
                try {
                    this.socket.close();
                }
                catch (Exception exception1) {
                    Message.showInformationDialog("Error", exception1.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object i = null;
                this.socket = null;
                this.enableToolbarButton();
                throw throwable;
            }
            {
                Object i = null;
                this.socket = null;
                this.enableToolbarButton();
                return;
            }
        }
        if (actionevent.getSource() != this.requestButton) return;
        String s1 = this.requestTextArea.getText();
        if (s1 == null) {
            return;
        }
        if ((s1 = s1.trim()).length() == 0) {
            return;
        }
        s1 = String.valueOf(s1) + "\r\n";
        if (this.socket == null) {
            return;
        }
        try {
            OutputStream outputstream = this.socket.getOutputStream();
            outputstream.write(s1.getBytes());
            this.receiveData();
            return;
        }
        catch (Exception exception2) {
            Message.showInformationDialog("Error", exception2.getMessage());
        }
    }

    void receiveData() {
        if (this.socket == null) {
            return;
        }
        try {
            InputStream inputstream = this.socket.getInputStream();
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            while (true) {
                long l = System.currentTimeMillis();
                while (inputstream.available() == 0 && System.currentTimeMillis() - l < 500L) {
                }
                int i = inputstream.available();
                if (i <= 0) break;
                byte[] abyte0 = new byte[i];
                i = inputstream.read(abyte0);
                bytearrayoutputstream.write(abyte0, 0, i);
            }
            String s = new String(bytearrayoutputstream.toByteArray());
            this.responseTextArea.append(s);
            this.enableToolbarButton();
        }
        catch (Exception exception) {
            Message.showInformationDialog("Error", exception.getMessage());
        }
    }

    public static void createInternalFrame() {
        JMDIDesktopPane appdesktoppane = MainFrame.getDesktopPane();
        Telnet telnet = new Telnet();
        telnet.setPreferredSize(new Dimension(500, 400));
        appdesktoppane.createInternalFrame("TELNET", telnet);
    }
}

