/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

final class ColorComboBox
extends JComboBox {
    protected ColorComboBoxModel listModel = new ColorComboBoxModel();

    public ColorComboBox() {
        int[] nArray = new int[3];
        nArray[1] = 128;
        nArray[2] = 255;
        int[] ai = nArray;
        int i = 0;
        while (i <= 2) {
            int j = 0;
            while (j <= 2) {
                int k = 0;
                while (k <= 2) {
                    this.listModel.addColor(new Color(ai[i], ai[j], ai[k]));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.setModel(this.listModel);
        this.setRenderer(new ColorCellRenderer());
    }

    class ColorCellRenderer
    extends JComponent
    implements ListCellRenderer {
        Color curValue;
        boolean isCurSelected;

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension dimension = this.getSize();
            if (this.curValue == null) {
                return;
            }
            g.setColor(this.curValue);
            g.fillRect(0, 0, dimension.width, dimension.height);
            if (this.isCurSelected) {
                g.setColor(new Color(255 - this.curValue.getRed(), 255 - this.curValue.getGreen(), 255 - this.curValue.getBlue()));
                g.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
        }

        public Component getListCellRendererComponent(JList jlist, Object obj, int i, boolean flag, boolean flag1) {
            this.curValue = (Color)obj;
            this.isCurSelected = flag;
            return this;
        }

        public ColorCellRenderer() {
            this.setOpaque(true);
            this.setPreferredSize(new Dimension(50, 17));
        }
    }

    class ColorComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector colorBuffer = new Vector();
        Object currentValue;

        public void addColor(Color color) {
            this.colorBuffer.addElement(color);
        }

        public void setSelectedItem(Object obj) {
            this.currentValue = obj;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.currentValue;
        }

        public int getSize() {
            return this.colorBuffer.size();
        }

        public Object getElementAt(int i) {
            return this.colorBuffer.elementAt(i);
        }
    }
}

