/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import softcore.awt.AwtUtil;

final class LineComboBox
extends JComboBox {
    protected LineComboBoxModel listModel = new LineComboBoxModel();

    public LineComboBox() {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 2;
        nArray[2] = 3;
        nArray[3] = 4;
        nArray[4] = 5;
        int[] ai = nArray;
        int i = 0;
        while (i < ai.length) {
            this.listModel.addLineStyle(ai[i]);
            ++i;
        }
        this.setModel(this.listModel);
        this.setRenderer(new LineCellRenderer());
    }

    class LineCellRenderer
    extends JComponent
    implements ListCellRenderer {
        Integer curValue;
        boolean isCurSelected;

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension dimension = this.getSize();
            Color color = this.isCurSelected ? Color.red : Color.black;
            int i = this.curValue != null ? this.curValue : 0;
            AwtUtil.drawLine(g, 0, dimension.height / 2, dimension.width, dimension.height / 2, color, i, 1);
        }

        public Component getListCellRendererComponent(JList jlist, Object obj, int i, boolean flag, boolean flag1) {
            this.curValue = (Integer)obj;
            this.isCurSelected = flag;
            return this;
        }

        public LineCellRenderer() {
            this.setOpaque(true);
            this.setPreferredSize(new Dimension(64, 17));
        }
    }

    class LineComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector styleBuffer = new Vector();
        Object currentValue;

        public void addLineStyle(int i) {
            this.styleBuffer.addElement(new Integer(i));
        }

        public void setSelectedItem(Object obj) {
            this.currentValue = obj;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.currentValue;
        }

        public int getSize() {
            return this.styleBuffer.size();
        }

        public Object getElementAt(int i) {
            return this.styleBuffer.elementAt(i);
        }
    }
}

