/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.io.DataInput;
import java.io.IOException;
import softcore.print.Print;

public class PageRead {
    DataInput is;

    public PageRead(DataInput datainput) {
        this.is = datainput;
    }

    Rectangle readRect() throws IOException {
        return new Rectangle((int)this.is.readDouble(), (int)this.is.readDouble(), (int)this.is.readDouble(), (int)this.is.readDouble());
    }

    Color readColor() throws IOException {
        int i = this.is.readInt();
        if (i == 0) {
            return Color.black;
        }
        return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
    }

    Font readFont() throws IOException {
        return new Font(this.is.readUTF(), this.is.readInt(), this.is.readInt());
    }

    Print.TextCell readTextCell() throws IOException {
        Rectangle rectangle = this.readRect();
        String s = this.is.readUTF();
        if (s.length() == 0) {
            s = null;
        }
        short word0 = this.is.readShort();
        Color color = this.readColor();
        String s1 = this.is.readUTF();
        Font font = this.readFont();
        int i = this.is.readInt();
        int j = this.is.readInt();
        return new Print.TextCell(s, rectangle, s1, font, color, i, j);
    }

    Print.LineCell readLineCell() throws IOException {
        Rectangle rectangle = this.readRect();
        short word0 = this.is.readShort();
        Color color = this.readColor();
        int i = this.is.readInt();
        return new Print.LineCell(rectangle, i, color);
    }

    Print.BoolCell readBoolCell() throws IOException {
        Rectangle rectangle = this.readRect();
        short word0 = this.is.readShort();
        Color color = this.readColor();
        Print.BoolCell boolcell = new Print.BoolCell(rectangle);
        boolcell.color = color;
        return boolcell;
    }

    Print.PrintCell readCell() throws IOException {
        byte byte0 = this.is.readByte();
        switch (byte0) {
            case 1: {
                return this.readTextCell();
            }
            case 2: {
                return this.readLineCell();
            }
            case 3: {
                return this.readBoolCell();
            }
        }
        return null;
    }

    public Print.Page readPage(Print print) throws IOException {
        Print.PrintCell printcell;
        Print.Page page = new Print.Page();
        int i = this.is.readInt();
        boolean flag = this.is.readBoolean();
        page.defaultRuleUnit = this.is.readInt();
        double d = this.is.readDouble();
        double d1 = this.is.readDouble();
        if (print.pageFormat == null) {
            print.printLandScape = flag;
            print.pageFormat = new PageFormat();
            print.setPageFormatPaperSize(d, d1);
            print.pageFormat.setOrientation(i);
        }
        while ((printcell = this.readCell()) != null) {
            page.cellSet.addElement(printcell);
        }
        return page;
    }

    public void readPages(Print print) throws IOException {
        byte byte0;
        while ((byte0 = this.is.readByte()) == 1) {
            print.getPages().addElement(this.readPage(print));
        }
    }
}

