/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import softcore.awt.AwtUtil;
import softcore.awt.DialogPanel;
import softcore.awt.ExtObject;
import softcore.awt.chart.Chart;
import softcore.print.PageRead;
import softcore.print.PreviewFrame;
import softcore.print.PreviewView;
import softcore.print.PrintFormat;
import softcore.print.PrintablePages;
import softcore.table.Table;
import softcore.table.TableColumn;
import softcore.tac.Tac;
import softcore.tac.TacYacc;
import softcore.util.Constants;
import softcore.util.JDBC;
import softcore.util.KeyValueGetter;
import softcore.util.KeyValuePutter;
import softcore.util.Message;
import softcore.util.Type;
import softcore.util.Utilities;
import softface.MainApp;
import softoperation.finance.erpdata.ErpdataConfig;

public class Print
extends Tac
implements PrintablePages {
    private Hashtable backWriteExpr;
    public Object cellDefaultValue;
    public Object defaultGraphObject;
    private PrintFormat.FormulaCell inPritingCell;
    public String cellID;
    public int cellInsetR;
    private PrintFormat format;
    int splitRows;
    int splitCols;
    public Object[] bufferedObject = new Object[4];
    public PageFormat pageFormat;
    Vector bufferPrintFormat;
    private int defaultRuleUnit;
    public boolean selectEnableRuleUnit;
    private String selectedDefName;
    public String currentSelectedPrintFormat;
    public String saveID;
    public String saveFmtnm;
    public String selectPrtfmtFirst;
    private int currentSysid;
    double heightPageHeader;
    double heightPageFooter;
    double heightDetailRows;
    private double xAt;
    private double yAt;
    private double heightPageFooter0;
    private Page printingPage;
    private boolean logicalPagePrepared;
    private final Vector pages = new Vector();
    private int currentRow;
    private boolean rowLoaded;
    private boolean endLoadRow;
    private boolean pageHeaderPrinted;
    private boolean pageFooterPrinted;
    private boolean printingEmptyRow;
    protected boolean printEnd;
    protected int groupIndex;
    private int pagePhysicalNumberFrom = -1;
    private int pagePhysicalNumberTo = -1;
    private int pageLogicalNumber;
    private int pagePhysicalNumber;
    private int totalPageLogicalNumber;
    private int totalPagePhysicalNumber;
    private int rowsPrintedInPage;
    private int detailRowsPrintedInPage;
    private boolean groupStyle = true;
    private Hashtable tableDataTotalTo;
    private int guessMaxDetailPageRows;
    private static final int NGROUPSTACKITEMS = 2;
    Object[] groupStack = new Object[32];
    int topGroupStack;
    public boolean rowNewPage;
    private double[][] gridCellPrintWidth;
    private boolean[][] gridCellPrintRightLine;
    public boolean pageCanceled;
    private final double[] tmpDouble2 = new double[2];
    protected Hashtable cacheReportRowText;
    public boolean hideRow;
    public boolean enableTotal;
    public boolean autoReheight;
    private int colDupIndex;
    public int groupTag;
    Object printData;
    public boolean printCurrentRowOnly;
    public boolean forcePrintIfEmptyData;
    public DataSet loopMasterDataSet;
    private int atMasterTableRow = -1;
    private int countRowsForPrevMaster;
    private int pageWidthInPixcel;
    private int pageHeightInPixcel;
    private int printRectX;
    private int printRectY;
    private int printRectWidth;
    private int printRectHeight;
    private int splitPageRow;
    private int splitPageCol;
    boolean printLandScape;
    private final PrinterJob printerJob = PrinterJob.getPrinterJob();
    Vector contentsIndex;
    public String defaultContentsIndexPrtfmtName = "\u76ee\u5f55/\u76ee\u5f55:%";
    String[] emailAccountInfo;
    private Tac tnterposeTac = this;
    JTextComponent textComponent;
    PrintCell cellAtachEditTextComponent;
    int editable;
    String title;

    private static void assert0(boolean flag) {
        if (!flag) {
            try {
                throw new PrintErrorException();
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
    }

    public static Font getFont(Font font) {
        return font == null ? Constants.FontDialogPlain14 : font;
    }

    static final int min(int i, int j) {
        return i >= j ? j : i;
    }

    static final int max(int i, int j) {
        return i <= j ? j : i;
    }

    public void addBackWriteExpr(String s, String s1) {
        if (this.backWriteExpr == null) {
            this.backWriteExpr = new Hashtable();
        }
        this.backWriteExpr.put(s, s1);
    }

    public void defineSubPageNumber(String s, int i, String s1, String s2, String s3, String s4) {
        String[] as = new String[]{"getPagePhysicalNumber", "getPageLogicalNumber", "getTotalPagePhysicalNumber", "getTotalPageLogicalNumber"};
        if (s1 == null) {
            s1 = "%0/%1";
        }
        if (s2 == null) {
            s2 = "%0";
        }
        String s5 = "this.bufferedObject[1]=" + as[i] + "(true);softcore.util.Utilities.format(" + as[i] + "(true)>1?\"" + s1 + "\":\"" + s2 + "\",this.bufferedObject)";
        this.addBackWriteExpr("{*" + s + "*}", s5);
        String s6 = "this.bufferedObject[0]=" + as[i] + "();\"{*" + s + "*}\"";
        if (s3 != null) {
            s6 = "this.bufferedObject[2]=" + s3 + ';' + s6;
        }
        if (s4 != null) {
            s6 = "this.bufferedObject[3]=" + s4 + ';' + s6;
        }
        this.defineMacro(s, s6);
    }

    protected void backWrite(Page page) {
        if (page == null || this.backWriteExpr == null) {
            return;
        }
        int i = page.cellSet.size();
        int j = 0;
        while (j < i) {
            String s;
            Object obj;
            PrintCell printcell = (PrintCell)page.cellSet.elementAt(j);
            if (printcell instanceof BackWriteAbleTextCell && (obj = this.backWriteExpr.get(String.valueOf(s = ((BackWriteAbleTextCell)printcell).text) + "#ADDR")) instanceof Integer) {
                System.arraycopy(((BackWriteAbleTextCell)printcell).bufferedObject, 0, this.bufferedObject, 0, this.bufferedObject.length);
                this.clearExprValue();
                this.execute((Integer)obj, -1, true);
                Object obj1 = this.getExprValue();
                ((BackWriteAbleTextCell)printcell).text = obj1 != null ? obj1.toString() : "";
            }
            ++j;
        }
    }

    protected void backWrite(int i, int j) {
        if (this.backWriteExpr == null) {
            return;
        }
        int k = i;
        while (k <= j && k < this.pages.size()) {
            this.backWrite((Page)this.pages.elementAt(k));
            ++k;
        }
    }

    public Object getCellDefaultValue() {
        return this.cellDefaultValue;
    }

    public void setDefaultGraphObject(Object obj) {
        this.defaultGraphObject = obj;
    }

    public Object getDefaultGraphObject() {
        return this.cellDefaultValue;
    }

    public void setCellID(String s) {
        this.cellID = s;
    }

    public String getCellID() {
        return this.cellID;
    }

    static boolean isZero(String s) {
        if (s == null) {
            return true;
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c >= '1' && c <= '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object printCell(PrintFormat.FormulaCell formulacell, Page page, Object obj, boolean flag) {
        Object object;
        PrintFormat.FormulaCell formulacell1;
        block46: {
            Object object2;
            block44: {
                Object object3;
                block43: {
                    Object object4;
                    block42: {
                        Object object5;
                        block41: {
                            Object object6;
                            block40: {
                                this.setGlobalValue("thisCell", formulacell);
                                formulacell1 = this.inPritingCell;
                                this.inPritingCell = formulacell;
                                this.cellID = formulacell.strid;
                                try {
                                    Object obj3;
                                    Object obj1 = this.cellDefaultValue = obj;
                                    String s = null;
                                    Boolean boolean1 = null;
                                    Color color = formulacell.foreColor;
                                    if ((formulacell.options & PrintFormat.FormulaCell.cellIsStaticText) != 0) {
                                        s = formulacell.text;
                                    } else {
                                        if (!flag && formulacell instanceof PrintFormat.GridCell && ((PrintFormat.GridCell)formulacell).totalType > 0 && ((PrintFormat.GridCell)formulacell).row.groupTag < 0 && ((PrintFormat.GridCell)formulacell).row.groupTag > -255) {
                                            DelayedCell delayedcell1;
                                            DelayedCell delayedcell = new DelayedCell(formulacell.printRect);
                                            delayedcell.page = page;
                                            delayedcell.cell = (PrintFormat.GridCell)formulacell;
                                            delayedcell.enableTotal = this.enableTotal;
                                            DelayedCell delayedCell = delayedcell1 = delayedcell;
                                            Object var13_29 = null;
                                            this.inPritingCell = formulacell1;
                                            return delayedCell;
                                        }
                                        if (formulacell.addrFormula > 0) {
                                            obj1 = this.findExpr(formulacell.addrFormula, formulacell.text);
                                        } else if (this.defaultReportRow > 0 && this.defaultReportCol > 0 && this.defaultReportId != null && this.defaultCorpId != null) {
                                            obj1 = this.getReportData(Boolean.FALSE, null, null);
                                        }
                                        if (obj1 instanceof Boolean) {
                                            boolean1 = (Boolean)obj1;
                                        }
                                        if (obj1 instanceof BigDecimal) {
                                            BigDecimal bigdecimal = (BigDecimal)obj1;
                                            if ((formulacell.options & PrintFormat.FormulaCell.cellSuppressIfZero) != 0 && bigdecimal.signum() == 0) {
                                                Object obj4;
                                                object6 = obj4 = obj1;
                                                break block40;
                                            }
                                            s = Utilities.format(bigdecimal, formulacell.minDecimals, formulacell.maxDecimals, (formulacell.options & PrintFormat.FormulaCell.cellThousandsSeparator) != 0);
                                            if ((formulacell.options & PrintFormat.FormulaCell.cellSuppressIfZero) != 0 && Print.isZero(s)) {
                                                Object obj5;
                                                object5 = obj5 = obj1;
                                                break block41;
                                            }
                                            if ((formulacell.options & PrintFormat.FormulaCell.cellRedOnNegtive) != 0 && s.length() > 0 && s.charAt(0) == '-') {
                                                color = Color.red;
                                                s = s.substring(1);
                                            }
                                        } else if (obj1 instanceof Double || obj1 instanceof Float) {
                                            double d = ((Number)obj1).doubleValue();
                                            if ((formulacell.options & PrintFormat.FormulaCell.cellSuppressIfZero) != 0 && d == 0.0) {
                                                Object obj6;
                                                object4 = obj6 = obj1;
                                                break block42;
                                            }
                                            if ((formulacell.options & PrintFormat.FormulaCell.cellRedOnNegtive) != 0 && d < 0.0) {
                                                color = Color.red;
                                                d = -d;
                                            }
                                            s = Utilities.format(d, formulacell.minDecimals, formulacell.maxDecimals, (formulacell.options & PrintFormat.FormulaCell.cellThousandsSeparator) != 0);
                                            if ((formulacell.options & PrintFormat.FormulaCell.cellSuppressIfZero) != 0 && Print.isZero(s)) {
                                                Object obj7;
                                                object3 = obj7 = obj1;
                                                break block43;
                                            }
                                        } else if (obj1 instanceof Number) {
                                            if ((formulacell.options & PrintFormat.FormulaCell.cellSuppressIfZero) != 0 && ((Number)obj1).intValue() == 0) {
                                                Object obj2;
                                                object2 = obj2 = obj1;
                                                break block44;
                                            }
                                            if ((formulacell.options & PrintFormat.FormulaCell.cellRedOnNegtive) != 0 && ((Number)obj1).intValue() < 0) {
                                                s = "" + -((Number)obj1).intValue();
                                                color = Color.red;
                                            } else {
                                                s = obj1.toString();
                                            }
                                        } else if (obj1 instanceof Date) {
                                            s = Utilities.dateToString((Date)obj1);
                                        } else if (obj1 != null) {
                                            s = obj1.toString();
                                        }
                                    }
                                    if (formulacell instanceof PrintFormat.GraphCell) {
                                        if (formulacell.addrFormula <= 0 && (obj1 = this.defaultGraphObject) == null) {
                                            obj1 = this.getGlobalValue("graphObject");
                                        }
                                        if (obj1 instanceof String) {
                                            try {
                                                ImageIcon imageicon = new ImageIcon((String)obj1);
                                                obj1 = imageicon.getImage();
                                            }
                                            catch (Exception exception) {
                                                obj1 = null;
                                            }
                                        }
                                        if (obj1 != null) {
                                            page.addGraph(formulacell.printRect, obj1);
                                        }
                                    } else if (s != null && s.length() > 0 && formulacell.printRect.height > 1 && formulacell.printRect.width > 1) {
                                        if (boolean1 != null) {
                                            if (boolean1.booleanValue()) {
                                                page.addBool(formulacell.printRect);
                                            }
                                        } else {
                                            int i = formulacell.options & 0x7080;
                                            if (this.backWriteExpr != null && this.backWriteExpr.get(String.valueOf(s) + "#ADDR") != null) {
                                                page.addBackWriteAbleText(this.cellID, formulacell.printRect, s, formulacell.font, color, i, formulacell.lineGap, this.bufferedObject);
                                            } else {
                                                TextCell textcell = page.addText(this.cellID, formulacell.printRect, s, formulacell.font, color, i, formulacell.lineGap);
                                                textcell.widthInset = this.cellInsetR;
                                            }
                                        }
                                    }
                                    object = obj3 = obj1;
                                    break block46;
                                }
                                catch (Throwable throwable) {
                                    Object var13_36 = null;
                                    this.inPritingCell = formulacell1;
                                    throw throwable;
                                }
                            }
                            Object var13_30 = null;
                            this.inPritingCell = formulacell1;
                            return object6;
                        }
                        Object var13_31 = null;
                        this.inPritingCell = formulacell1;
                        return object5;
                    }
                    Object var13_32 = null;
                    this.inPritingCell = formulacell1;
                    return object4;
                }
                Object var13_33 = null;
                this.inPritingCell = formulacell1;
                return object3;
            }
            Object var13_34 = null;
            this.inPritingCell = formulacell1;
            return object2;
        }
        Object var13_35 = null;
        this.inPritingCell = formulacell1;
        return object;
    }

    public Print() {
        this(null);
    }

    public Print(String s) {
        super(s);
        this.defineMacro("\u9875\u53f7", "getPagePhysicalNumber()");
        this.defineMacro("\u8bb0\u5f55\u53f7", "getRowGetData()");
        this.defineSubPageNumber("\u9875\u53f7\u53ca\u603b\u9875\u6570", 1, "%0/%1", "1/1", null, null);
        this.defineSubPageNumber("\u603b\u9875\u6570", 1, "%1", "1", null, null);
    }

    private int parsePrintFormatFormula() throws IOException {
        return this.yaccParse();
    }

    protected int yaccParse(TacYacc tacyacc) throws IOException {
        if (this.format == null) {
            return 0;
        }
        int i = 0;
        tacyacc.appendCode(this.endCode);
        int j = this.yaccParseText(tacyacc, "\u542f\u52a8\u516c\u5f0f", this.format.startFormula, this.endCode);
        if (j >= 0) {
            this.format.addrStartFormula = j;
        } else {
            ++i;
        }
        int k = this.format.freeCellSet.size();
        int l = 0;
        while (l < k) {
            PrintFormat.Cell cell = (PrintFormat.Cell)this.format.freeCellSet.elementAt(l);
            if (cell instanceof PrintFormat.FormulaCell) {
                j = this.yaccParseText(tacyacc, "\u81ea\u7531\u5355\u5143\u516c\u5f0f", cell.text, this.endCode);
                if (j >= 0) {
                    ((PrintFormat.FormulaCell)cell).addrFormula = j;
                } else {
                    ++i;
                }
            }
            ++l;
        }
        k = this.format.colSet.size();
        int i1 = 0;
        while (i1 < k) {
            PrintFormat.Col col = (PrintFormat.Col)this.format.colSet.elementAt(i1);
            j = this.yaccParseText(tacyacc, "\u5217(" + (i1 + 1) + ")\u91cd\u590d\u6b21\u6570", col.dupTimes, this.endCode);
            if (j >= 0) {
                col.addrDupTimes = j;
            } else {
                ++i;
            }
            ++i1;
        }
        k = this.format.rowSet.size();
        int j1 = 0;
        while (j1 < k) {
            PrintFormat.Row row = (PrintFormat.Row)this.format.rowSet.elementAt(j1);
            this.defineMacro("_PRTFMTROWIDX_", j1);
            j = this.yaccParseText(tacyacc, "\u884c(" + (j1 + 1) + ")\u5206\u7ec4\u516c\u5f0f", row.groupFormula, this.endCode);
            if (j >= 0) {
                row.addrGroupFormula = j;
            } else {
                ++i;
            }
            if (row.startFormula != null) {
                row.startFormula = Utilities.macroReplace(row.startFormula, this.getMacro(), '%', '%');
            }
            if ((j = this.yaccParseText(tacyacc, "\u884c(" + (j1 + 1) + ")\u542f\u52a8\u516c\u5f0f", row.startFormula, this.endCode)) >= 0) {
                row.addrStartFormula = j;
            } else {
                ++i;
            }
            int k1 = row.cellSet.size();
            int l1 = 0;
            while (l1 < k1) {
                PrintFormat.GridCell gridcell = (PrintFormat.GridCell)row.cellSet.elementAt(l1);
                if ((gridcell.options & PrintFormat.FormulaCell.cellIsStaticText) == 0) {
                    j = this.yaccParseText(tacyacc, "\u5355\u5143(" + (j1 + 1) + ',' + (l1 + 1) + ")\u516c\u5f0f", gridcell.text, this.endCode);
                    if (j >= 0) {
                        gridcell.addrFormula = j;
                    } else {
                        ++i;
                    }
                }
                ++l1;
            }
            ++j1;
        }
        if (this.backWriteExpr != null) {
            Enumeration enumeration = this.backWriteExpr.keys();
            while (enumeration.hasMoreElements()) {
                String s = (String)enumeration.nextElement();
                Object obj = this.backWriteExpr.get(s);
                if (!(obj instanceof String)) continue;
                j = this.yaccParseText(tacyacc, s, (String)obj, this.endCode);
                if (j >= 0) {
                    this.backWriteExpr.put(String.valueOf(s) + "#ADDR", new Integer(j));
                    continue;
                }
                this.backWriteExpr.remove(String.valueOf(s) + "#ADDR");
                ++i;
            }
        }
        if ((j = this.yaccParseText(tacyacc, "\u7ec8\u6b62\u516c\u5f0f", this.format.endFormula, this.endCode)) >= 0) {
            this.format.addrEndFormula = j;
        } else {
            ++i;
        }
        return i;
    }

    protected Object findExpr(int i, String s) {
        if (i <= 0 || this.printingEmptyRow) {
            return null;
        }
        this.clearExprValue();
        int j = 0;
        while (j < this.bufferedObject.length) {
            this.bufferedObject[j] = null;
            ++j;
        }
        this.execute(i, -1, true);
        return this.getExprValue();
    }

    public void setPageFormatPaperSize(double d, double d1) {
        if (this.pageFormat != null) {
            Paper paper = this.pageFormat.getPaper();
            paper.setSize(d, d1);
            paper.setImageableArea(0.0, 0.0, d, d1);
            this.pageFormat.setPaper(paper);
        }
    }

    public PrintFormat getPrintFormat() {
        return this.format;
    }

    public int setPrintFormat(PrintFormat printformat) {
        double d1;
        double d;
        int i;
        block14: {
            this.format = printformat;
            try {
                this.addDefaultGlobalVar("thisFormat", printformat);
                this.addDefaultGlobalVar("thisCell", null);
                i = this.parsePrintFormatFormula();
                this.printerJob.setPageable(this);
                if (this.pageFormat != null) break block14;
                this.pageFormat = this.printerJob.defaultPage();
                if ((printformat.options & PrintFormat.printLandScape) != 0) {
                    this.pageFormat.setOrientation(0);
                } else if ((printformat.options & PrintFormat.printPortrait) != 0) {
                    this.pageFormat.setOrientation(1);
                }
                if (printformat.pageHeight > 127 && printformat.pageWidth > 127) break block14;
                PageFormat pageformat = this.pageFormat;
                this.pageFormat = this.printerJob.pageDialog(this.pageFormat);
                if (pageformat != this.pageFormat) break block14;
                return -1;
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
                return -1;
            }
        }
        if (this.pageFormat.getOrientation() == 0) {
            printformat.options &= 0xFFFFFFF9;
            printformat.options |= PrintFormat.printLandScape;
            this.pageFormat.setOrientation(1);
        }
        if (printformat.pageHeight > 127 && printformat.pageWidth > 127) {
            d = (double)printformat.pageWidth * 3.937007874015748 * 72.0 / 1000.0;
            d1 = (double)printformat.pageHeight * 3.937007874015748 * 72.0 / 1000.0;
            this.setPageFormatPaperSize(d, d1);
            if (this.pageFormat.getOrientation() == 0) {
                double d2 = d1;
                d1 = d;
                d = d2;
            }
        } else {
            d = this.pageFormat.getWidth();
            d1 = this.pageFormat.getHeight();
        }
        Paper paper = this.pageFormat.getPaper();
        double d3 = 0.0;
        double d4 = 0.0;
        paper.setSize(d, d1);
        paper.setImageableArea(d3, d4, d - 2.0 * d3, d1 - 2.0 * d4);
        this.pageFormat.setPaper(paper);
        if ((printformat.options & PrintFormat.printLandScape) != 0) {
            this.pageWidthInPixcel = Print.inch72ndsToPixcel(paper.getImageableHeight());
            this.pageHeightInPixcel = Print.inch72ndsToPixcel(paper.getImageableWidth());
        } else {
            this.pageWidthInPixcel = Print.inch72ndsToPixcel(paper.getImageableWidth());
            this.pageHeightInPixcel = Print.inch72ndsToPixcel(paper.getImageableHeight());
        }
        this.splitRows = printformat.splitRows;
        if (this.splitRows < 1) {
            this.splitRows = 1;
        }
        this.splitCols = printformat.splitCols;
        if (this.splitCols < 1) {
            this.splitCols = 1;
        }
        Print.findGroupTagOfRow(printformat);
        Print.findRowOfGridCell(printformat);
        this.printerJob.setPageable(this);
        return i;
    }

    public int loadPrintFormat(String s) {
        PrintFormat printformat = new PrintFormat();
        if (!printformat.loadFromText(s)) {
            Message.out.println("\u6253\u5370\u683c\u5f0f\u5b9a\u4e49\u9519");
            return -1;
        }
        return this.setPrintFormat(printformat);
    }

    int loadPrintFormatToBuffer(String s, String s1) {
        PrintFormat printformat = new PrintFormat();
        if (!printformat.loadFromText(s)) {
            Message.out.println("\u6253\u5370\u683c\u5f0f\u201c" + s1 + "\u201d\u5b9a\u4e49\u9519");
            return -1;
        }
        if (this.bufferPrintFormat == null) {
            this.bufferPrintFormat = new Vector();
        }
        this.bufferPrintFormat.addElement(new Object[]{s1, printformat});
        return 0;
    }

    PrintFormat nextBufferedPrintFormat() {
        if (this.bufferPrintFormat == null || this.bufferPrintFormat.size() == 0) {
            this.bufferPrintFormat = null;
            return null;
        }
        Object[] aobj = (Object[])this.bufferPrintFormat.elementAt(0);
        this.bufferPrintFormat.removeElementAt(0);
        this.selectedDefName = this.currentSelectedPrintFormat = (String)aobj[0];
        return (PrintFormat)aobj[1];
    }

    public String getSelectedDefName() {
        return this.selectedDefName;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean loadFromDef(int i, int j, String s) {
        this.currentSysid = i;
        this.selectedDefName = null;
        try {
            this.defaultRuleUnit = MainApp.getAppIntOption(90, 2);
            int k = MainApp.getAppIntOption(90, 3);
            String[] as = Utilities.splitString(s, '/');
            String s1 = ErpdataConfig.currentConfig != null ? ErpdataConfig.currentConfig.curUserCode : null;
            Object[] aobj = null;
            Object[] aobj1 = null;
            int l = 0;
            while (l < as.length) {
                String[] as1 = Utilities.splitString(as[l], '|');
                int i1 = 0;
                while (i1 < (s1 != null && s1.length() != 0 ? 2 : 1)) {
                    String s2 = "select defname from defs where ";
                    s2 = String.valueOf(s2) + Utilities.filterFormat("or", "defname like '%0'", null, as1, true);
                    s2 = String.valueOf(s2) + " order by defname";
                    if (i1 == 0) {
                        aobj = JDBC.sqlSelect2(s2);
                        if ((k & 1) > 0 && aobj != null && aobj.length > 0) {
                            break;
                        }
                    } else {
                        aobj1 = JDBC.sqlSelect2(s2);
                    }
                    ++i1;
                }
                if (aobj != null && aobj.length != 0 || aobj1 != null && aobj1.length != 0) {
                    int l1;
                    int j1 = aobj != null ? aobj.length : 0;
                    int n = l1 = aobj1 != null ? aobj1.length : 0;
                    if (!this.selectEnableRuleUnit) {
                        Object[] as3 = new String[j1 + l1];
                        int i2 = 0;
                        while (i2 < j1) {
                            String s4 = (String)aobj[i2];
                            int j2 = s4.indexOf(124);
                            if (j2 >= 0) {
                                s4 = "(\u79c1\u6709) " + s4.substring(j2 + 1);
                            }
                            as3[i2] = s4;
                            ++i2;
                        }
                        if (aobj1 != null) {
                            System.arraycopy(aobj1, 0, as3, j1, aobj1.length);
                        }
                        if (as3.length == 1) {
                            this.selectedDefName = as3[0];
                            break;
                        }
                        int[] ai = DialogPanel.mutiSelect("\u9009\u62e9\u6253\u5370\u683c\u5f0f", as3, true, Utilities.splitString(this.selectPrtfmtFirst, ','));
                        if (ai != null && ai.length > 0) {
                            int k2 = 0;
                            while (k2 < ai.length) {
                                this.selectedDefName = k2 == 0 ? as3[ai[k2]] : String.valueOf(this.selectedDefName) + "&" + (String)as3[ai[k2]];
                                ++k2;
                            }
                            break;
                        }
                    } else {
                        DialogPanel dialogpanel = new DialogPanel();
                        dialogpanel.nPosInsetY = 6;
                        dialogpanel.nPosInsetX = 6;
                        dialogpanel.nPosOption = 1;
                        dialogpanel.setLayout(new BorderLayout());
                        JCheckBox jcheckbox = new JCheckBox("\u6253\u5370\u7f51\u683c\u7ebf");
                        jcheckbox.setSelected(this.defaultRuleUnit > 0);
                        JTabbedPane jtabbedpane = new JTabbedPane();
                        ButtonGroup buttongroup = new ButtonGroup();
                        ButtonGroup buttongroup1 = new ButtonGroup();
                        String[] as4 = new String[j1];
                        int l2 = 0;
                        while (l2 < j1) {
                            String s5 = (String)aobj[l2];
                            int i3 = s5.indexOf(124);
                            if (i3 >= 0) {
                                s5 = s5.substring(i3 + 1);
                            }
                            as4[l2] = s5;
                            ++l2;
                        }
                        String[] as5 = new String[l1];
                        System.arraycopy(aobj1, 0, as5, 0, l1);
                        JPanel jpanel = DialogPanel.createGridLayoutRadioButton(buttongroup, as4, j1, 1);
                        JPanel jpanel1 = DialogPanel.createGridLayoutRadioButton(buttongroup1, as5, l1, 1);
                        DialogPanel.setValueOfRadioButton(buttongroup, 0);
                        DialogPanel.setValueOfRadioButton(buttongroup1, 0);
                        jtabbedpane.add((Component)jpanel, "\u79c1\u6709\u683c\u5f0f");
                        jtabbedpane.add((Component)jpanel1, "\u516c\u7528\u683c\u5f0f");
                        jtabbedpane.setPreferredSize(new Dimension(320, 160));
                        dialogpanel.add((Component)jcheckbox, "North");
                        dialogpanel.add((Component)jtabbedpane, "Center");
                        if ((k & 4) > 0) {
                            jtabbedpane.setSelectedIndex(1);
                        }
                        if (dialogpanel.showDialog("\u9009\u62e9\u6253\u5370\u683c\u5f0f") != 0) {
                            return false;
                        }
                        if (jcheckbox.isSelected()) {
                            this.defaultRuleUnit = 0;
                        }
                        if (jtabbedpane.getSelectedIndex() == 0) {
                            int j3 = DialogPanel.getValueOfRadioButton(buttongroup);
                            if (j3 >= 0) {
                                this.selectedDefName = aobj[j3].toString();
                                break;
                            }
                        } else {
                            int k3 = DialogPanel.getValueOfRadioButton(buttongroup1);
                            if (k3 >= 0) {
                                this.selectedDefName = aobj1[k3].toString();
                                break;
                            }
                        }
                    }
                    return false;
                }
                ++l;
            }
            String[] as2 = Utilities.splitString(this.selectedDefName, '&');
            if (as2 == null || as2.length == 0) {
                as2 = new String[1];
            }
            boolean flag = false;
            int k1 = 0;
            while (k1 < as2.length) {
                String s3;
                String string = s3 = as2[k1] != null ? JDBC.sqlSelectString("select deftext from defs where defname='" + as2[k1] + "'") : null;
                if (s3 == null || s3.length() == 0) {
                    Message.out.println("\u7cfb\u7edf" + i + "\u7684\u6253\u5370\u683c\u5f0f(" + s + ")\u672a\u5b9a\u4e49\u6216\u5b9a\u4e49\u9519");
                } else if (!flag) {
                    this.selectedDefName = this.currentSelectedPrintFormat = as2[k1];
                    this.saveFmtnm = this.currentSelectedPrintFormat;
                    if (this.loadPrintFormat(s3) != 0) {
                        return false;
                    }
                    flag = true;
                } else {
                    this.loadPrintFormatToBuffer(s3, as2[k1]);
                }
                ++k1;
            }
            return flag;
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
            return false;
        }
    }

    static final double findHeightPageHeader(PrintFormat printformat, boolean flag) {
        int i = printformat.rowSet.size();
        double d = 0.0;
        int j = 0;
        while (j < i) {
            PrintFormat.Row row = (PrintFormat.Row)printformat.rowSet.elementAt(j);
            if ((row.options & PrintFormat.Row.rowGroupBgn) != 0) break;
            if ((row.options & PrintFormat.Row.rowHideWhenPrinting) == 0 || flag) {
                d += row.height;
            }
            ++j;
        }
        return d;
    }

    static final double findHeightGroupHeader(PrintFormat printformat, int i, boolean flag, boolean flag1) {
        int j = printformat.rowSet.size();
        double d = 0.0;
        int k = i;
        while (k < j) {
            PrintFormat.Row row = (PrintFormat.Row)printformat.rowSet.elementAt(k);
            if (!flag1 && (row.options & PrintFormat.Row.rowGroupBgn) != 0) break;
            if ((row.options & PrintFormat.Row.rowHideWhenPrinting) == 0 || flag) {
                d += row.height;
            }
            if ((row.options & PrintFormat.Row.rowGroupEnd) != 0) break;
            ++k;
        }
        return d;
    }

    public void adjustHeightPageFooter(double d) {
        this.heightPageFooter = this.heightPageFooter0 + d;
    }

    static final double findHeightPageFooter(PrintFormat printformat, boolean flag) {
        int i = printformat.rowSet.size();
        double d = 0.0;
        int j = i - 1;
        while (j >= 0) {
            PrintFormat.Row row = (PrintFormat.Row)printformat.rowSet.elementAt(j);
            if ((row.options & PrintFormat.Row.rowGroupEnd) != 0) break;
            if ((row.options & PrintFormat.Row.rowHideWhenPrinting) == 0 || flag) {
                d += row.height;
            }
            --j;
        }
        return d;
    }

    static final int findFirstDetailRow(PrintFormat printformat) throws PrintFormat.PrintFormatErrorException {
        int i = printformat.rowSet.size();
        double d = 0.0;
        int j = -1;
        int k = 0;
        while (k < i) {
            PrintFormat.Row row = (PrintFormat.Row)printformat.rowSet.elementAt(k);
            if ((row.options & PrintFormat.Row.rowGroupBgn) != 0) {
                j = k;
            }
            ++k;
        }
        if (j >= 0) {
            return j;
        }
        throw new PrintFormat.PrintFormatErrorException();
    }

    static final int findFirstFooterRow(PrintFormat printformat) throws PrintFormat.PrintFormatErrorException {
        int i = printformat.rowSet.size();
        int j = i - 1;
        while (j >= 0) {
            PrintFormat.Row row = (PrintFormat.Row)printformat.rowSet.elementAt(j);
            if ((row.options & PrintFormat.Row.rowGroupEnd) != 0) {
                return j + 1;
            }
            --j;
        }
        throw new PrintFormat.PrintFormatErrorException();
    }

    static final int findFirstGroupRow(PrintFormat printformat) throws PrintFormat.PrintFormatErrorException {
        int i = printformat.rowSet.size();
        double d = 0.0;
        int j = 0;
        while (j < i) {
            PrintFormat.Row row = (PrintFormat.Row)printformat.rowSet.elementAt(j);
            if ((row.options & PrintFormat.Row.rowGroupBgn) != 0) {
                return j;
            }
            ++j;
        }
        throw new PrintFormat.PrintFormatErrorException();
    }

    static final double findHeightDetailRows(PrintFormat printformat, boolean flag) throws PrintFormat.PrintFormatErrorException {
        int i = printformat.rowSet.size();
        double d = 0.0;
        int j = Print.findFirstDetailRow(printformat);
        while (j < i) {
            PrintFormat.Row row = (PrintFormat.Row)printformat.rowSet.elementAt(j);
            if ((row.options & PrintFormat.Row.rowHideWhenPrinting) == 0 || flag) {
                d += row.height;
            }
            if ((row.options & PrintFormat.Row.rowGroupBgn) != 0) break;
            ++j;
        }
        return d;
    }

    static final double findRowHeight(PrintFormat printformat, int i, double[] ad) {
        int j = printformat.rowSet.size();
        ad[1] = 0.0;
        ad[0] = 0.0;
        int k = 0;
        while (k < j && k <= i) {
            PrintFormat.Row row = (PrintFormat.Row)printformat.rowSet.elementAt(k);
            ad[0] = ad[1] + 1.0;
            ad[1] = ad[1] + row.height;
            ++k;
        }
        return ad[1] - ad[0] + 1.0;
    }

    static final boolean isDetailRow(PrintFormat printformat, int i) {
        int j = printformat.rowSet.size();
        int k = i;
        while (k < j) {
            PrintFormat.Row row = (PrintFormat.Row)printformat.rowSet.elementAt(k);
            if (k > i && (row.options & PrintFormat.Row.rowGroupBgn) != 0) break;
            if ((row.options & PrintFormat.Row.rowGroupEnd) != 0) {
                return true;
            }
            ++k;
        }
        return false;
    }

    static final int findRowsInGroup(PrintFormat printformat, int i) {
        int j = printformat.rowSet.size();
        int k = 0;
        int l = 0;
        int i1 = i;
        while (i1 < j) {
            PrintFormat.Row row = (PrintFormat.Row)printformat.rowSet.elementAt(i1);
            ++k;
            if (i1 > i && (row.options & PrintFormat.Row.rowGroupBgn) != 0) {
                ++l;
            }
            if ((row.options & PrintFormat.Row.rowGroupEnd) != 0 && l-- <= 0) break;
            ++i1;
        }
        return k;
    }

    static final PrintFormat.Row findRow(PrintFormat printformat, int i) {
        return i < 0 || i >= printformat.rowSet.size() ? null : (PrintFormat.Row)printformat.rowSet.elementAt(i);
    }

    static final void findGroupTagOfRow(PrintFormat printformat) {
        int i = printformat.rowSet.size();
        int j = 0;
        int k = 0;
        int l = 0;
        while (l < i) {
            PrintFormat.Row row = (PrintFormat.Row)printformat.rowSet.elementAt(l);
            if ((row.options & PrintFormat.Row.rowGroupBgn) != 0) {
                k = ++j;
            }
            row.groupTag = j--;
            if ((row.options & PrintFormat.Row.rowGroupEnd) != 0) {
                // empty if block
            }
            ++l;
        }
        boolean flag = true;
        int i1 = 0;
        while (i1 < i) {
            PrintFormat.Row row1 = (PrintFormat.Row)printformat.rowSet.elementAt(i1);
            if (row1.groupTag == 0) {
                row1.groupTag = flag ? -255 : 255;
            } else {
                int n = row1.groupTag = flag ? row1.groupTag - k : k - row1.groupTag;
            }
            if (flag && (row1.options & PrintFormat.Row.rowGroupEnd) != 0) {
                flag = false;
            }
            ++i1;
        }
    }

    static final void findRowOfGridCell(PrintFormat printformat) {
        int i = printformat.rowSet.size();
        int j = 0;
        while (j < i) {
            PrintFormat.Row row = (PrintFormat.Row)printformat.rowSet.elementAt(j);
            int k = row.cellSet.size();
            int l = 0;
            while (l < k) {
                ((PrintFormat.GridCell)row.cellSet.elementAt((int)l)).row = row;
                ++l;
            }
            ++j;
        }
    }

    final void findPrintRect(Rectangle rectangle, int i, int j, int k) {
        int l = this.format.rowSet.size();
        rectangle.height = 0;
        int i1 = i;
        while (i1 < l) {
            PrintFormat.Row row = (PrintFormat.Row)this.format.rowSet.elementAt(i1);
            rectangle.height = (int)((double)rectangle.height + row.height);
            PrintFormat.GridCell gridcell = (PrintFormat.GridCell)row.cellSet.elementAt(j);
            if ((gridcell.options & PrintFormat.FormulaCell.cellMergeBottom) == 0) break;
            ++i1;
        }
        int j1 = this.format.colSet.size();
        rectangle.width = (int)this.gridCellPrintWidth[i][k];
    }

    public Page getPage(int i) {
        if (i < 0 || i >= this.pages.size()) {
            return null;
        }
        return (Page)this.pages.elementAt(i);
    }

    public final boolean isPrintingEmptyRow() {
        return this.printingEmptyRow;
    }

    public void setPrintEnd(boolean flag) {
        this.printEnd = flag;
    }

    public int getRowsPrintedInPage() {
        return this.rowsPrintedInPage;
    }

    public int getDetailRowsPrintedInPage() {
        return this.detailRowsPrintedInPage;
    }

    public void setGroupStyle(boolean flag) {
        this.groupStyle = flag;
    }

    public boolean getGroupStyle() {
        return this.groupStyle;
    }

    public int getPagePhysicalNumber() {
        return this.pagePhysicalNumber;
    }

    public int getPageLogicalNumber() {
        return this.pageLogicalNumber;
    }

    public int getTotalPagePhysicalNumber() {
        return this.totalPagePhysicalNumber;
    }

    public int getTotalPageLogicalNumber() {
        return this.totalPageLogicalNumber;
    }

    public int getPagePhysicalNumber(boolean flag) {
        return this.pagePhysicalNumber;
    }

    public int getPageLogicalNumber(boolean flag) {
        return !flag || !this.logicalPagePrepared ? this.pageLogicalNumber : this.pageLogicalNumber - 1;
    }

    public int getTotalPagePhysicalNumber(boolean flag) {
        return this.totalPagePhysicalNumber;
    }

    public int getTotalPageLogicalNumber(boolean flag) {
        return !flag || !this.logicalPagePrepared ? this.totalPageLogicalNumber : this.totalPageLogicalNumber - 1;
    }

    public void resetTableDataTotal() {
        this.tableDataTotalTo = new Hashtable();
    }

    public int getGuessMaxDetailPageRows() {
        return this.guessMaxDetailPageRows;
    }

    public boolean preparePrint() throws PrintFormat.PrintFormatErrorException {
        return this.preparePrint(true);
    }

    public boolean preparePrint(boolean flag) throws PrintFormat.PrintFormatErrorException {
        PrintFormat printformat;
        this._preparePrint(flag);
        while ((printformat = this.nextBufferedPrintFormat()) != null) {
            if (printformat.splitRows != this.splitRows || printformat.splitCols != this.splitCols) {
                this.endPreparePrint();
            }
            if (this.setPrintFormat(printformat) != 0) continue;
            this._preparePrint(flag);
        }
        return true;
    }

    private boolean _preparePrint(boolean flag) throws PrintFormat.PrintFormatErrorException {
        this.heightPageHeader = Print.findHeightPageHeader(this.format, false);
        this.heightPageFooter = this.heightPageFooter0 = Print.findHeightPageFooter(this.format, false);
        this.heightDetailRows = Print.findHeightDetailRows(this.format, false);
        this.currentRow = 0;
        this.rowLoaded = false;
        this.endLoadRow = false;
        if (this.groupStyle && !this.prepareRowData()) {
            return true;
        }
        this.pagePhysicalNumber = this.logicalPagePrepared ? 1 : 0;
        this.pageLogicalNumber = this.pagePhysicalNumber;
        this.tableDataTotalTo = new Hashtable();
        this.printEnd = false;
        this.pageHeaderPrinted = false;
        this.printingEmptyRow = false;
        this.pageFooterPrinted = true;
        this.groupIndex = 0;
        this.topGroupStack = 0;
        this.findExpr(this.format.addrStartFormula, this.format.startFormula);
        if (this.printEnd) {
            return true;
        }
        int i = this.pages.size();
        if (this.groupStyle) {
            this.loopPrintGroup(Print.findFirstGroupRow(this.format), null);
        } else {
            int j = Print.findFirstDetailRow(this.format);
            this.printRows(j, j + Print.findRowsInGroup(this.format, j) - 1);
        }
        if (!this.pageFooterPrinted && this.pageHeaderPrinted) {
            this.printPageFooter(flag);
        }
        this.closeCachedData();
        this.backWrite(i, this.pages.size() - 1);
        this.backWrite(this.printingPage);
        this.findExpr(this.format.addrEndFormula, this.format.endFormula);
        return true;
    }

    public void endPreparePrint() {
        if (this.printingPage != null) {
            if (this.printingPage.cellSet.size() > 0) {
                this.pages.addElement(this.printingPage);
            }
            this.printingPage = null;
        }
    }

    private static final boolean objectEquals(Object obj, Object obj1) {
        return obj == obj1 || obj != null && obj.equals(obj1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean inCurrentGroup() {
        boolean bl;
        if (!this.prepareRowData()) {
            return false;
        }
        int i = this.groupTag;
        try {
            int j = 0;
            while (true) {
                if (j >= this.topGroupStack) {
                    boolean flag;
                    bl = flag = true;
                    break;
                }
                PrintFormat.Row row = (PrintFormat.Row)this.groupStack[j * 2 + 1];
                this.groupTag = row.groupTag;
                Object obj = this.findExpr(row.addrGroupFormula, row.groupFormula);
                if (!Print.objectEquals(obj, this.groupStack[j * 2])) {
                    boolean flag1;
                    boolean bl2 = flag1 = false;
                    Object var6_8 = null;
                    this.groupTag = i;
                    return bl2;
                }
                ++j;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.groupTag = i;
            throw throwable;
        }
        Object var6_9 = null;
        this.groupTag = i;
        return bl;
    }

    void loopPrintGroup(int i, Hashtable hashtable) throws PrintFormat.PrintFormatErrorException {
        ++this.groupIndex;
        int j = 0;
        while (!this.printEnd && this.inCurrentGroup()) {
            this.printGroup(i, hashtable, j);
            ++j;
        }
        --this.groupIndex;
    }

    protected void beforeBeginGroup(boolean flag) {
    }

    protected void onBeginGroup(boolean flag) {
    }

    protected void onPrintDetailRow() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void printGroup(int i, Hashtable hashtable, int j) throws PrintFormat.PrintFormatErrorException {
        if (!this.prepareRowData()) {
            return;
        }
        PrintFormat.Row row = Print.findRow(this.format, i);
        if (row == null) return;
        if ((row.options & PrintFormat.Row.rowGroupBgn) == 0) {
            return;
        }
        boolean flag = Print.isDetailRow(this.format, i);
        this.beforeBeginGroup(flag);
        this.prepareLogicalPage(true, this.groupIndex == 1 && j == 0);
        if (((row.options & PrintFormat.Row.rowNewPage) != 0 || (row.options & PrintFormat.Row.rowGroupBgn) != 0 && (double)this.printRectHeight - this.yAt - this.heightPageFooter < Print.findHeightGroupHeader(this.format, i, false, true)) && this.rowsPrintedInPage > 0) {
            this.printPageFooter();
            this.prepareLogicalPage(true, this.groupIndex == 1 && j == 0);
        }
        int k = this.groupTag;
        try {
            this.groupTag = row.groupTag;
            this.groupStack[this.topGroupStack * 2] = this.findExpr(row.addrGroupFormula, row.groupFormula);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.groupTag = k;
            throw throwable;
        }
        {
            Object var7_10 = null;
            this.groupTag = k;
            this.groupStack[this.topGroupStack * 2 + 1] = row;
            ++this.topGroupStack;
        }
        try {
            Hashtable hashtable1 = new Hashtable();
            this.onBeginGroup(flag);
            int l = this.format.rowSet.size();
            int i1 = i;
            while (i1 < l) {
                PrintFormat.Row row1 = (PrintFormat.Row)this.format.rowSet.elementAt(i1);
                if (i1 > i && (row1.options & PrintFormat.Row.rowGroupBgn) != 0) {
                    Print.assert0(!flag);
                    int j1 = Print.findRowsInGroup(this.format, i1);
                    this.loopPrintGroup(i1, hashtable1);
                    i1 += j1;
                    continue;
                }
                this.printRow(row1, i1, hashtable, hashtable1);
                ++i1;
                if (!this.printEnd && (row1.options & PrintFormat.Row.rowGroupEnd) == 0) continue;
            }
            if (!flag) {
                this.backWriteGroupTopTotalCell(hashtable1, hashtable);
            }
            if (flag) {
                this.rowLoaded = false;
            }
            this.prepareRowData();
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            --this.topGroupStack;
            throw throwable;
        }
        {
            Object var12_16 = null;
            --this.topGroupStack;
            return;
        }
    }

    private void backWriteGroupTopTotalCell(Hashtable hashtable, Hashtable hashtable1) {
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object obj1 = hashtable.get(obj);
            if (!(obj1 instanceof DelayedCell)) continue;
            int i = (Integer)obj;
            Print.assert0(i < 0);
            DelayedCell delayedcell = (DelayedCell)obj1;
            obj1 = hashtable.get(new Integer(-i));
            Print.assert0(!(obj1 instanceof DelayedCell));
            delayedcell.cell.printRect = new Rectangle(delayedcell.x, delayedcell.y, delayedcell.width, delayedcell.height);
            obj1 = this.printCell(delayedcell.cell, delayedcell.page, obj1, true);
            Print.assert0(!(obj1 instanceof DelayedCell));
            if (hashtable1 == null || !delayedcell.enableTotal) continue;
            this.setTotalTo(hashtable1, obj1, delayedcell.cell.row.groupTag, delayedcell.colIndex, delayedcell.atCol);
        }
    }

    private void printRows(int i, int j) throws PrintFormat.PrintFormatErrorException {
        this.prepareLogicalPage(true, true);
        int k = i;
        while (k <= j) {
            PrintFormat.Row row = Print.findRow(this.format, k);
            this.rowNewPage = (row.options & PrintFormat.Row.rowNewPage) != 0;
            this.callProc("beforePrintRow" + k, null);
            if ((this.rowNewPage || (double)this.printRectHeight - this.yAt - this.heightPageFooter < row.height) && this.rowsPrintedInPage > 0) {
                this.printPageFooter();
                this.prepareLogicalPage(true, false);
            }
            this.printRow(row, k, null, null);
            ++k;
        }
    }

    void findColumnDupTimes() {
        int i = this.format.colSet.size();
        int j = 0;
        while (j < i) {
            Object obj;
            PrintFormat.Col col = (PrintFormat.Col)this.format.colSet.elementAt(j);
            col.duptimes = 1;
            if (col.addrDupTimes > 0 && (obj = this.findExpr(col.addrDupTimes, col.dupTimes)) instanceof Number) {
                col.duptimes = ((Number)obj).intValue();
            }
            ++j;
        }
    }

    private void findGridCellPrintWidth() {
        int i = 0;
        int j = this.format.colSet.size();
        int i1 = 0;
        while (i1 < j) {
            PrintFormat.Col col = (PrintFormat.Col)this.format.colSet.elementAt(i1);
            int k = Print.countGroupColumns(this.format, i1);
            Print.assert0(k >= 1);
            i += (col.duptimes > 0 ? col.duptimes : 0) * k;
            i1 += k;
        }
        int j1 = this.format.rowSet.size();
        this.gridCellPrintWidth = new double[j1][i];
        this.gridCellPrintRightLine = new boolean[j1][i];
        int k1 = 0;
        while (k1 < j1) {
            PrintFormat.Row row = (PrintFormat.Row)this.format.rowSet.elementAt(k1);
            int l1 = 0;
            int i2 = 0;
            boolean flag = true;
            PrintFormat.GridCell gridcell = null;
            int j2 = 0;
            while (j2 < j) {
                PrintFormat.Col col1 = (PrintFormat.Col)this.format.colSet.elementAt(j2);
                int l = Print.countGroupColumns(this.format, j2);
                Print.assert0(l >= 1);
                int k2 = l1;
                this.colDupIndex = 0;
                while (this.colDupIndex < col1.duptimes) {
                    int l2 = 0;
                    while (l2 < l) {
                        PrintFormat.Col col2 = (PrintFormat.Col)this.format.colSet.elementAt(j2 + l2);
                        PrintFormat.GridCell gridcell1 = (PrintFormat.GridCell)row.cellSet.elementAt(j2 + l2);
                        if (flag) {
                            i2 = l1;
                        }
                        double[] dArray = this.gridCellPrintWidth[k1];
                        int n = i2;
                        dArray[n] = dArray[n] + col2.width;
                        flag = i2 < k2 && this.colDupIndex < col1.duptimes - 1 && l2 == l - 1 && gridcell != null ? (gridcell.options & PrintFormat.FormulaCell.cellMergeRight) == 0 : (gridcell1.options & PrintFormat.FormulaCell.cellMergeRight) == 0;
                        this.gridCellPrintRightLine[k1][l1] = flag;
                        ++l1;
                        if (l2 == l - 1 && this.colDupIndex == col1.duptimes - 1) {
                            gridcell = gridcell1;
                        }
                        ++l2;
                    }
                    ++this.colDupIndex;
                }
                j2 += l;
            }
            ++k1;
        }
    }

    public static int countGroupColumns(PrintFormat printformat, int i) {
        int j = 1;
        int k = printformat.colSet.size();
        int l = i + 1;
        while (l < k) {
            PrintFormat.Col col = (PrintFormat.Col)printformat.colSet.elementAt(l);
            if ((col.options & PrintFormat.Col.colGroupToLeft) == 0) break;
            ++j;
            ++l;
        }
        return j;
    }

    private void printPageHeader(boolean flag) throws PrintFormat.PrintFormatErrorException {
        Print.assert0(!this.pageHeaderPrinted);
        if (this.printEnd || this.printingPage == null) {
            return;
        }
        this.format.initFreeCellPrintRect();
        if (flag) {
            this.findColumnDupTimes();
            this.findGridCellPrintWidth();
        }
        int i = this.format.rowSet.size();
        int j = 0;
        while (j < i) {
            PrintFormat.Row row = (PrintFormat.Row)this.format.rowSet.elementAt(j);
            if ((row.options & PrintFormat.Row.rowGroupBgn) != 0) break;
            this.doPrintRow(row, j, null, this.tableDataTotalTo);
            ++j;
        }
        this.pageHeaderPrinted = true;
        this.pageFooterPrinted = false;
        this.rowsPrintedInPage = 0;
        this.detailRowsPrintedInPage = 0;
    }

    public void setPageCanceled(boolean flag) {
        this.pageCanceled = flag;
    }

    private void printPageFooter() throws PrintFormat.PrintFormatErrorException {
        this.printPageFooter(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void printPageFooter(boolean flag) throws PrintFormat.PrintFormatErrorException {
        int i;
        block11: {
            this.pageCanceled = false;
            i = this.format.rowSet.size();
            if ((this.format.options & 1) == 0) break block11;
            this.printingEmptyRow = true;
            try {
                int j = Print.findFirstDetailRow(this.format);
                while ((double)this.printRectHeight - this.yAt - this.heightPageFooter >= this.heightDetailRows) {
                    double d = this.yAt;
                    int i1 = j;
                    while (i1 < i) {
                        PrintFormat.Row row1 = (PrintFormat.Row)this.format.rowSet.elementAt(i1);
                        this.doPrintRow(row1, i1, null, null);
                        if ((row1.options & PrintFormat.Row.rowGroupEnd) != 0) break;
                        ++i1;
                    }
                    if (!(this.yAt <= d + 1.0)) continue;
                    break;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.printingEmptyRow = false;
                throw throwable;
            }
            {
                Object var8_10 = null;
                this.printingEmptyRow = false;
            }
        }
        int k = (int)((double)this.printRectHeight - this.heightPageFooter);
        int l = Print.findFirstFooterRow(this.format);
        while (true) {
            if (l >= i) {
                if (flag) {
                    this.logicalPagePrepared = false;
                }
                this.pageFooterPrinted = true;
                if (this.pageCanceled) {
                    this.nextLogicalPage(false);
                }
                return;
            }
            PrintFormat.Row row = (PrintFormat.Row)this.format.rowSet.elementAt(l);
            if ((row.options & PrintFormat.Row.rowPrintAtPageBottom) != 0 && this.yAt < (double)k) {
                this.yAt = k;
            }
            this.doPrintRow(row, l, null, this.tableDataTotalTo);
            if ((row.options & PrintFormat.Row.rowHideWhenPrinting) == 0) {
                k = (int)((double)k + row.height);
            }
            ++l;
        }
    }

    private void doPrintFreeCell(int i, double d, double d1) {
        int j = this.format.rowSet.size();
        int k = this.format.freeCellSet.size();
        Print.findRowHeight(this.format, i, this.tmpDouble2);
        double d2 = this.tmpDouble2[0];
        double d3 = this.tmpDouble2[1];
        if (i <= 0) {
            d2 = 0.0;
        }
        if (i >= j - 1) {
            d3 = 32767.0;
        }
        int l = 0;
        while (l < k) {
            PrintFormat.Cell cell = (PrintFormat.Cell)this.format.freeCellSet.elementAt(l);
            if ((cell.flagsAtPrinting & 3) != 3) {
                int i1 = cell.r.y;
                int j1 = cell.r.x;
                int k1 = cell.r.y + cell.r.height;
                int l1 = cell.r.x + cell.r.width;
                int i2 = 0;
                if ((double)i1 >= d2 && (double)i1 <= d3) {
                    cell.printRect.x = (int)(d + (double)j1);
                    cell.printRect.y = (int)(d1 + (this.hideRow ? 0.0 : (double)i1 - d2));
                    cell.flagsAtPrinting |= 1;
                    i2 |= 1;
                }
                if ((double)k1 >= d2 && (double)k1 <= d3) {
                    cell.printRect.width = (int)(d + (double)l1) - cell.printRect.x;
                    cell.printRect.height = (int)(d1 + (this.hideRow ? 0.0 : (double)k1 - d2)) - cell.printRect.y;
                    cell.flagsAtPrinting |= 2;
                    i2 |= 2;
                }
                if (!(cell.flagsAtPrinting != 3 || this.hideRow && i2 == 3)) {
                    cell.printCell(this, this.printingPage, null);
                }
                if (cell.flagsAtPrinting == 3) {
                    cell.flagsAtPrinting &= ~i2;
                }
            }
            ++l;
        }
    }

    private static final int totalHashKey(int i, int j) {
        return i * 10000 + j;
    }

    private void setTotalTo(Hashtable hashtable, Object obj, int i, int j, int k) {
        if (hashtable == null) {
            return;
        }
        int l = this.format.rowSet.size();
        int i1 = 0;
        while (i1 < l) {
            block9: {
                Integer integer;
                PrintFormat.GridCell gridcell;
                block10: {
                    int j1;
                    PrintFormat.Row row = (PrintFormat.Row)this.format.rowSet.elementAt(i1);
                    int n = j1 = i < 0 ? -i : i;
                    if (row.groupTag != j1 + 1 && row.groupTag != -(j1 + 1) && (j1 != 0 || row.groupTag != 255 && row.groupTag != -255)) break block9;
                    gridcell = (PrintFormat.GridCell)row.cellSet.elementAt(j);
                    if (gridcell.totalType <= 0) break block9;
                    integer = new Integer(Print.totalHashKey(i1, k));
                    Object obj1 = hashtable.get(integer);
                    if (gridcell.totalType != 1) break block10;
                    if (!(obj instanceof Number)) break block9;
                    if (!(obj1 instanceof Number)) {
                        hashtable.put(integer, obj);
                    } else {
                        try {
                            Class class1 = Type.matchNumberType(obj1.getClass(), obj.getClass());
                            hashtable.put(integer, Tac.valueAdd((Number)obj1, (Number)obj, class1));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (gridcell.totalType == 2 && obj != null) {
                    hashtable.put(integer, obj);
                }
            }
            ++i1;
        }
    }

    private static final int findReportRowNumber(Vector vector, PrintFormat.Row row, int i) {
        while (i < vector.size()) {
            PrintFormat.Col col = (PrintFormat.Col)vector.elementAt(i);
            if ((col.options & PrintFormat.Col.colLineNo) != 0) {
                PrintFormat.GridCell gridcell = (PrintFormat.GridCell)row.cellSet.elementAt(i);
                try {
                    return Integer.parseInt(gridcell.text);
                }
                catch (Exception exception) {
                    break;
                }
            }
            ++i;
        }
        return 0;
    }

    public void closeCachedData() {
        super.closeCachedData();
        this.cacheReportRowText = null;
    }

    protected String findReportRowText(String s, int i) {
        String s1;
        if (s == null) {
            return null;
        }
        if (this.cacheReportRowText == null) {
            this.cacheReportRowText = new Hashtable();
        }
        if (this.cacheReportRowText.get(s1 = String.valueOf(s) + ".0") == null) {
            this.cacheReportRowText.put(s1, "");
            try {
                Object[][] aobj = JDBC.sqlSelect3("select rptrowid,rowtext from rptrow where rptid='" + s + "'");
                if (aobj != null) {
                    int j = 0;
                    while (j < aobj.length) {
                        if (aobj[j][1] != null && aobj[j][0] != null) {
                            this.cacheReportRowText.put(String.valueOf(s) + '.' + aobj[j][0], aobj[j][1]);
                        }
                        ++j;
                    }
                }
            }
            catch (SQLException sqlexception) {
                sqlexception.printStackTrace(Message.out);
            }
        }
        return (String)this.cacheReportRowText.get(String.valueOf(s) + '.' + i);
    }

    public final int getColDupIndex() {
        return this.colDupIndex;
    }

    private void doPrintGridCell(PrintFormat.Row row, int i, PrintFormat.Col col, int j, PrintFormat.GridCell gridcell, int k, int l, Hashtable hashtable, Hashtable hashtable1) throws PrintFormat.PrintFormatErrorException {
        double d = (double)this.printRectX + this.xAt;
        double d1 = (double)this.printRectY + this.yAt;
        double d2 = row.height;
        double d3 = col.width;
        boolean flag = (col.options & PrintFormat.Col.colHideWhenPrinting) != 0;
        int i1 = col.mapRptdataType;
        if ((col.options & PrintFormat.Col.colLineNo) != 0) {
            try {
                this.defaultReportRow = Integer.parseInt(gridcell.text);
            }
            catch (Exception exception) {
                this.defaultReportRow = 0;
            }
        }
        if (!this.hideRow && !flag && j > 0 && i < this.format.rowSet.size() - 1 && (gridcell.options & PrintFormat.FormulaCell.cellMergeBottom) == 0) {
            this.printingPage.addLine(new Rectangle((int)d, (int)(d1 + d2), (int)d3, 0), gridcell.blineWidth << 8 | gridcell.blineStyle, gridcell.blineColor);
        }
        if (!this.hideRow && !flag && i > 0 && i < this.format.rowSet.size() - 1 && this.gridCellPrintRightLine[i][k]) {
            this.printingPage.addLine(new Rectangle((int)(d + d3), (int)d1, 0, (int)d2), gridcell.rlineWidth << 8 | gridcell.rlineStyle, gridcell.rlineColor);
        }
        if (!(this.hideRow && (row.options & PrintFormat.Row.rowCellFormulaExecuteIfHide) == 0 || (gridcell.options & PrintFormat.FormulaCell.cellBeMerged) != 0)) {
            boolean flag1;
            gridcell.printRect = new Rectangle((int)d, (int)d1, 0, 0);
            if (!this.hideRow && !flag) {
                this.findPrintRect(gridcell.printRect, i, j, k);
            }
            Object obj = null;
            if (hashtable1 != null) {
                Integer integer = new Integer(Print.totalHashKey(i, k));
                obj = hashtable1.get(integer);
                Print.assert0(!(obj instanceof DelayedCell));
            }
            boolean bl = flag1 = (gridcell.options & PrintFormat.FormulaCell.cellIsStaticText) != 0 && (gridcell.text == null || gridcell.text.length() == 0) && i1 > 0;
            if (flag1) {
                int j1 = i1 == 1 ? Print.findReportRowNumber(this.format.colSet, row, j + 1) : this.defaultReportRow;
                gridcell.text = this.findReportRowText(this.defaultReportId, j1);
            }
            obj = gridcell.printCell(this, this.printingPage, obj);
            if (flag1) {
                gridcell.text = null;
            }
            if (obj instanceof DelayedCell) {
                ((DelayedCell)obj).colIndex = j;
                ((DelayedCell)obj).atCol = k;
                hashtable1.put(new Integer(-Print.totalHashKey(i, k)), obj);
            } else if (this.enableTotal) {
                this.setTotalTo(hashtable, obj, row.groupTag, j, k);
                if (row.groupTag == 0) {
                    this.setTotalTo(this.tableDataTotalTo, obj, row.groupTag, j, k);
                }
            }
        }
        if (!flag) {
            this.xAt += col.width;
        }
    }

    private void doPrintRow(PrintFormat.Row row, int i, Hashtable hashtable, Hashtable hashtable1) throws PrintFormat.PrintFormatErrorException {
        this.groupTag = row.groupTag;
        this.hideRow = (row.options & PrintFormat.Row.rowHideWhenPrinting) != 0;
        boolean bl = this.autoReheight = (row.options & PrintFormat.Row.rowAutoReheight) != 0;
        if (!this.printingEmptyRow) {
            this.enableTotal = true;
            if ((row.options & PrintFormat.Row.rowGroupBgn) != 0 && Print.isDetailRow(this.format, i)) {
                this.onPrintDetailRow();
            }
            this.findExpr(row.addrStartFormula, row.startFormula);
        }
        if (this.hideRow) {
            this.autoReheight = false;
        }
        Print.assert0(this.gridCellPrintWidth != null && this.gridCellPrintWidth.length == this.format.rowSet.size());
        double d = row.height;
        double d1 = this.printRectX;
        double d2 = (double)this.printRectY + this.yAt;
        this.xAt = 0.0;
        int j = 0;
        this.doPrintFreeCell(i, this.printRectX, (double)this.printRectY + this.yAt);
        int k = this.format.colSet.size();
        int i1 = 0;
        while (i1 < k) {
            PrintFormat.Col col = (PrintFormat.Col)this.format.colSet.elementAt(i1);
            int l = Print.countGroupColumns(this.format, i1);
            Print.assert0(l >= 1);
            this.colDupIndex = 0;
            while (this.colDupIndex < col.duptimes) {
                int j1 = 0;
                while (j1 < l) {
                    PrintFormat.Col col1 = (PrintFormat.Col)this.format.colSet.elementAt(i1 + j1);
                    PrintFormat.GridCell gridcell = (PrintFormat.GridCell)row.cellSet.elementAt(i1 + j1);
                    this.defaultReportCol = col1.mapRptdataCol;
                    this.doPrintGridCell(row, i, col1, i1 + j1, gridcell, j++, (this.colDupIndex != 0 ? 0 : 1) | (this.colDupIndex != col.duptimes - 1 ? 0 : 2) | (j1 != 0 ? 0 : 4) | (j1 != l - 1 ? 0 : 8), hashtable, hashtable1);
                    ++j1;
                }
                ++this.colDupIndex;
            }
            i1 += l;
        }
        if (this.autoReheight) {
            int l1;
            boolean flag = this.hideRow;
            int k1 = this.groupTag;
            while ((int)d < (l1 = this.printingPage.resetRowHeight((int)((double)this.printRectY + this.yAt), (int)d))) {
                int i2 = (int)((double)this.printRectHeight - this.yAt - this.heightPageFooter);
                d = l1;
                if ((double)i2 >= d) continue;
                Vector vector = this.printingPage.removeRemainingPart((int)((double)this.printRectY + this.yAt), i2, (row.options & PrintFormat.Row.rowNoSplitForReheight) != 0);
                if (vector == null || vector.isEmpty()) {
                    d = i2;
                    break;
                }
                this.yAt += (double)i2;
                this.printPageFooter();
                this.prepareLogicalPage(true, false);
                d = 0.0;
                int j2 = 0;
                while (j2 < vector.size()) {
                    PrintCell printcell = (PrintCell)vector.elementAt(j2);
                    printcell.y += (int)((double)this.printRectY + this.yAt);
                    this.printingPage.addPrintCell(printcell);
                    ++j2;
                }
            }
            this.autoReheight = true;
            this.hideRow = flag;
            this.groupTag = k1;
        }
        if (!this.hideRow) {
            this.yAt += d;
        }
        ++this.rowsPrintedInPage;
        if (Print.isDetailRow(this.format, i)) {
            ++this.detailRowsPrintedInPage;
        }
    }

    private void printRow(PrintFormat.Row row, int i, Hashtable hashtable, Hashtable hashtable1) throws PrintFormat.PrintFormatErrorException {
        boolean flag1;
        boolean flag = (row.options & PrintFormat.Row.rowHideWhenPrinting) != 0;
        boolean bl = flag1 = (row.options & PrintFormat.Row.rowAutoReheight) != 0;
        if ((!flag && (double)this.printRectHeight - this.yAt - this.heightPageFooter < row.height || (row.options & PrintFormat.Row.rowNewPage) != 0) && this.rowsPrintedInPage > 0) {
            this.printPageFooter();
        }
        this.prepareLogicalPage(true, false);
        this.doPrintRow(row, i, hashtable, hashtable1);
    }

    public int setRwObject(int i, Object obj, boolean flag) {
        if ((i = super.setRwObject(i, obj, flag)) == 0) {
            this.printData = obj;
            this.tagToRowGetData = 0;
        }
        return i;
    }

    public void setPrintData(int i) {
        this.tagToRowGetData = i;
        this.printData = this.getRwObject(this.tagToRowGetData);
    }

    private boolean prepareRowData() {
        Print.assert0(this.groupStyle);
        if (this.endLoadRow) {
            this.rowLoaded = false;
            return false;
        }
        if (!this.rowLoaded) {
            this.endLoadRow = !(this.rowLoaded = this.loadRow(this.currentRow++));
        }
        return this.rowLoaded;
    }

    public boolean loadNextRow() {
        return this.loadRow(this.currentRow++);
    }

    protected boolean loadRow(int i) {
        if (!this.printCurrentRowOnly) {
            Print.assert0(this.groupStyle);
            this.rowGetData = i;
        }
        if (this.printData == null) {
            return false;
        }
        return this.doLoadRow(i);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doLoadRow(int i) {
        try {
            if (this.printData instanceof DataSet) {
                try {
                    if (this.loopMasterDataSet != null) {
                        Print.assert0(!this.printCurrentRowOnly);
                        if (this.loopMasterDataSet.getRowCount() <= 0) {
                            return false;
                        }
                        if (this.atMasterTableRow < 0) {
                            Print.assert0(i == 0);
                            this.countRowsForPrevMaster = 0;
                            this.atMasterTableRow = 0;
                            this.loopMasterDataSet.goToRow(0);
                        }
                        while (true) {
                            this.rowGetData = i - this.countRowsForPrevMaster;
                            int j = ((DataSet)this.printData).getRowCount();
                            if (this.rowGetData < j) {
                                return true;
                            }
                            int l = this.loopMasterDataSet.getRowCount();
                            if (++this.atMasterTableRow >= l) {
                                return false;
                            }
                            this.loopMasterDataSet.goToRow(this.atMasterTableRow);
                            this.countRowsForPrevMaster += j;
                        }
                    }
                }
                catch (DataSetException datasetexception) {
                    Message.printException(datasetexception, true);
                    return false;
                }
                if (i >= ((DataSet)this.printData).getRowCount()) {
                    if (i > 0) return false;
                    if (!this.forcePrintIfEmptyData) {
                        return false;
                    }
                }
                if (!this.printCurrentRowOnly) return true;
                if (i != 0) return false;
                return true;
            }
            if (this.printData instanceof Table) {
                if (i >= ((Table)this.printData).getRowCount()) {
                    if (i != 0) return false;
                    if (!this.forcePrintIfEmptyData) return false;
                }
                if (!this.printCurrentRowOnly) return true;
                if (i != 0) return false;
                return true;
            }
            if (!(this.printData instanceof ResultSet)) {
                if (!(this.printData instanceof Object[])) return false;
                if (i >= ((Object[])this.printData).length) return false;
                return true;
            }
            int k = this.indexOfRwObject(this.printData);
            if (k >= 0) {
                this.clearResultSetBufferedValue(k);
            }
            if (((ResultSet)this.printData).next()) return true;
            if (i != 0) return false;
            if (this.forcePrintIfEmptyData) return true;
            return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static final int inch72ndsToPixcel(double d) {
        return (int)d;
    }

    public static final double pixcelToInch72nds(double d) {
        return d;
    }

    private void clearCurrentLogicalPage() {
        if (this.printingPage != null) {
            this.printingPage.removeFromPoint(this.printRectX, this.printRectY);
        }
    }

    private void prepareLogicalPage(boolean flag, boolean flag1) throws PrintFormat.PrintFormatErrorException {
        if (!this.logicalPagePrepared) {
            this.nextLogicalPage(true);
        }
        if (flag && !this.pageHeaderPrinted) {
            this.printPageHeader(flag1);
        }
    }

    private void nextLogicalPage(boolean flag) {
        if (!flag) {
            this.clearCurrentLogicalPage();
            this.logicalPagePrepared = true;
            this.pageHeaderPrinted = false;
            this.yAt = 0.0;
            return;
        }
        if (this.printingPage != null) {
            if (++this.splitPageCol >= this.splitCols) {
                this.splitPageCol = 0;
                ++this.splitPageRow;
            }
            if (this.splitPageRow >= this.splitRows) {
                if (this.printingPage.cellSet.size() > 0) {
                    this.pages.addElement(this.printingPage);
                }
                this.printingPage = null;
            }
        }
        if (this.printingPage == null) {
            this.splitPageCol = 0;
            this.splitPageRow = 0;
            ++this.pagePhysicalNumber;
            ++this.totalPagePhysicalNumber;
            if (this.pagePhysicalNumberFrom > 0 && this.pagePhysicalNumberTo > 0 && this.totalPagePhysicalNumber > this.pagePhysicalNumberTo) {
                this.printEnd = true;
                this.printingPage = null;
                return;
            }
            this.printingPage = new Page();
            this.printingPage.width = this.pageWidthInPixcel;
            this.printingPage.height = this.pageHeightInPixcel;
        }
        this.printRectWidth = this.pageWidthInPixcel / this.splitCols;
        this.printRectHeight = this.pageHeightInPixcel / this.splitRows;
        this.guessMaxDetailPageRows = this.heightDetailRows <= 0.0 ? 0 : (int)(((double)this.printRectHeight - this.heightPageHeader - this.heightPageFooter) / this.heightDetailRows);
        this.printRectX = this.splitPageCol * this.pageWidthInPixcel / this.splitCols;
        this.printRectY = this.splitPageRow * this.pageHeightInPixcel / this.splitRows;
        this.logicalPagePrepared = true;
        this.yAt = 0.0;
        ++this.pageLogicalNumber;
        ++this.totalPageLogicalNumber;
        this.pageHeaderPrinted = false;
    }

    public int getNumberOfPages() {
        return this.pages.size();
    }

    public Vector getPages() {
        return this.pages;
    }

    public String getPageContent(int i) {
        return null;
    }

    public int getOrientation() {
        return this.pageFormat != null ? this.pageFormat.getOrientation() : 0;
    }

    public double getPageWidth() {
        return this.pageFormat != null ? this.pageFormat.getPaper().getWidth() : 0.0;
    }

    public double getPageHeight() {
        return this.pageFormat != null ? this.pageFormat.getPaper().getHeight() : 0.0;
    }

    public boolean printLandScape() {
        if (this.format == null) {
            return this.printLandScape;
        }
        return (this.format.options & PrintFormat.printLandScape) != 0;
    }

    public int printPage(Graphics g, int i) {
        return this.printPage(g, i, this.printLandScape(), 100);
    }

    public int printPage(Graphics g, int i, boolean flag, int j) {
        if (i < 0 || i >= this.pages.size()) {
            return 1;
        }
        BasicStroke basicstroke = new BasicStroke(0.0f);
        ((Graphics2D)g).setStroke(basicstroke);
        if (flag) {
            ((Graphics2D)g).rotate(Math.toRadians(90.0));
            ((Graphics2D)g).translate(0.0, -this.getPageWidth());
        }
        ((Page)this.pages.elementAt(i)).paint(g, j);
        return 0;
    }

    public int print(Graphics g, PageFormat pageformat, int i) throws PrinterException {
        return this.printPage(g, i);
    }

    public void removeAllPages() {
        this.contentsIndex = null;
        this.endPreparePrint();
        this.pages.removeAllElements();
    }

    public void preview(String s) {
        this.endPreparePrint();
        this.printContentsIndex(-1, null);
        PreviewFrame.preview(s != null ? s : "\u6253\u5370\u9884\u89c8", this);
    }

    public JFrame preview(JFrame jframe, String s) {
        this.endPreparePrint();
        this.printContentsIndex(-1, null);
        return PreviewFrame.preview(jframe, s != null ? s : "\u6253\u5370\u9884\u89c8", this, true);
    }

    public DialogPanel createPreviewDialogPanel(Component component, String s) {
        this.endPreparePrint();
        this.editable = 1;
        return PreviewFrame.createDialogPanel(component, s != null ? s : "\u6253\u5370\u9884\u89c8", this);
    }

    public Printable getPrintable(int i) throws IndexOutOfBoundsException {
        return this;
    }

    public PageFormat getPageFormat(int i) throws IndexOutOfBoundsException {
        return this.pageFormat;
    }

    public void print() throws PrinterException {
        this.print(true);
    }

    public void print(boolean flag) throws PrinterException {
        this.endPreparePrint();
        this.printContentsIndex(-1, null);
        this.printerJob.setPrintable(this, this.pageFormat);
        this.printerJob.setPageable(this);
        if (!flag || this.printerJob.printDialog()) {
            this.printerJob.print();
        }
    }

    public void printSubTable(String s) {
        this.printSubTable(this.prepareSubTable(s));
    }

    public void printSubTable(Print print1) {
        if (print1 != null && this.printingPage != null && this.inPritingCell != null) {
            print1.endPreparePrint();
            if (print1.pages.isEmpty()) {
                return;
            }
            Page page = (Page)print1.pages.elementAt(0);
            int i = 0;
            int j = 0;
            int k = 0;
            while (k < page.cellSet.size()) {
                PrintCell printcell = (PrintCell)page.cellSet.elementAt(k);
                printcell.x += this.inPritingCell.printRect.x - 3;
                printcell.y += this.inPritingCell.printRect.y - 3;
                this.printingPage.addPrintCell(printcell);
                int l = printcell.x + printcell.width;
                int i1 = printcell.y + printcell.height;
                if (i < l) {
                    i = l;
                }
                if (j < i1) {
                    j = i1;
                }
                ++k;
            }
            Rectangle rectangle = new Rectangle(this.inPritingCell.printRect.x, this.inPritingCell.printRect.y, i - this.inPritingCell.printRect.x, j - this.inPritingCell.printRect.y);
            this.printingPage.addPrintCell(new VirtualPrintCell(rectangle, 1));
        }
    }

    public void addPagesFrom(Print print1) {
        if (print1 == null) {
            return;
        }
        this.endPreparePrint();
        print1.endPreparePrint();
        this.pages.addAll(print1.pages);
    }

    public void addContentsIndexItem(Hashtable hashtable) {
        if (this.contentsIndex == null) {
            this.contentsIndex = new Vector();
        }
        this.contentsIndex.add(hashtable);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void printContentsIndex(int i, String s) {
        if (this.contentsIndex == null) return;
        if (this.contentsIndex.size() == 0) {
            return;
        }
        try {
            if (i < 0) {
                i = this.currentSysid;
            }
            if (i < 0) {
                try {
                    i = ErpdataConfig.currentConfig.idSystem;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (s == null) {
                s = this.defaultContentsIndexPrtfmtName;
            }
            Print print1 = new Print();
            print1.setRwObject(this.contentsIndex.toArray(new Hashtable[this.contentsIndex.size()]));
            print1.pageFormat = this.pageFormat;
            if (!print1.loadFromDef(i, 1, s)) {
                Object var5_5 = null;
                this.contentsIndex = null;
                return;
            }
            try {
                print1.preparePrint();
            }
            catch (PrintFormat.PrintFormatErrorException printformaterrorexception) {
                Message.printException(printformaterrorexception, MainApp.isDebug);
            }
            this.contentsIndex = null;
            this.addPagesFrom(print1);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.contentsIndex = null;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.contentsIndex = null;
            return;
        }
    }

    protected Print prepareSubTable(String s) {
        return null;
    }

    public void printSqlSubTable(String s, String s1, String s2) {
        Print print1 = new Print();
        print1.setRwObjectFromSql(s2, s1);
        if (!print1.loadFromDef(ErpdataConfig.getCurrentIdSystem(), 1, s)) {
            return;
        }
        try {
            print1.preparePrint();
        }
        catch (PrintFormat.PrintFormatErrorException printformaterrorexception) {
            Message.printException(printformaterrorexception, MainApp.isDebug);
            return;
        }
        this.printSubTable(print1);
    }

    public void setEMailAccountInfo(String[] as) {
        this.emailAccountInfo = as;
    }

    public String[] getEMailAccountInfo() {
        return this.emailAccountInfo;
    }

    public void setInterposeTac(Tac tac) {
        this.tnterposeTac = tac;
    }

    public Tac getInterposeTac() {
        return this.tnterposeTac;
    }

    public void setEditable(int i) {
        this.editable = i;
    }

    public void startEditCell(PreviewView previewview, int i, int j, int k, int l, int i1) {
        int byte0;
        int j1;
        if (this.editable == 0 || this.pages == null || i < 0 || i >= this.pages.size()) {
            return;
        }
        Page page = (Page)this.pages.elementAt(i);
        PrintCell printcell = page.atCell(j - k, l - i1);
        if (this.cellAtachEditTextComponent != printcell) {
            this.stopEditCell(previewview);
        }
        if (!(printcell instanceof TextCell) || this.textComponent != null) {
            return;
        }
        this.cellAtachEditTextComponent = printcell;
        if ((((TextCell)this.cellAtachEditTextComponent).format & 0x80) != 0) {
            this.textComponent = new JTextArea();
            j1 = 1;
            byte0 = 2;
        } else {
            this.textComponent = new JTextField();
            if ((((TextCell)this.cellAtachEditTextComponent).format & 0x1000) != 0) {
                ((JTextField)this.textComponent).setHorizontalAlignment(0);
            } else if ((((TextCell)this.cellAtachEditTextComponent).format & 0x2000) != 0) {
                ((JTextField)this.textComponent).setHorizontalAlignment(4);
            }
            j1 = 0;
            byte0 = 0;
        }
        previewview.add(this.textComponent);
        this.textComponent.setFont(((TextCell)this.cellAtachEditTextComponent).font);
        this.textComponent.setText(((TextCell)this.cellAtachEditTextComponent).text);
        this.textComponent.setBounds(this.cellAtachEditTextComponent.x + k + j1, this.cellAtachEditTextComponent.y + i1 + byte0, this.cellAtachEditTextComponent.width - j1, this.cellAtachEditTextComponent.height - byte0);
        this.textComponent.requestFocus();
    }

    public void startEditCell(PreviewView previewview, int i, PrintCell printcell, int j, int k) {
        int byte0;
        int l;
        if (this.editable == 0 || this.pages == null || i < 0 || i >= this.pages.size()) {
            return;
        }
        Page page = (Page)this.pages.elementAt(i);
        if (this.cellAtachEditTextComponent != printcell) {
            this.stopEditCell(previewview);
        }
        if (!(printcell instanceof TextCell) || this.textComponent != null) {
            return;
        }
        this.cellAtachEditTextComponent = printcell;
        if ((((TextCell)this.cellAtachEditTextComponent).format & 0x80) != 0) {
            this.textComponent = new JTextArea();
            l = 1;
            byte0 = 2;
        } else {
            this.textComponent = new JTextField();
            if ((((TextCell)this.cellAtachEditTextComponent).format & 0x1000) != 0) {
                ((JTextField)this.textComponent).setHorizontalAlignment(0);
            } else if ((((TextCell)this.cellAtachEditTextComponent).format & 0x2000) != 0) {
                ((JTextField)this.textComponent).setHorizontalAlignment(4);
            }
            l = 0;
            byte0 = 0;
        }
        previewview.add(this.textComponent);
        this.textComponent.setFont(((TextCell)this.cellAtachEditTextComponent).font);
        this.textComponent.setText(((TextCell)this.cellAtachEditTextComponent).text);
        this.textComponent.setBounds(this.cellAtachEditTextComponent.x + j + l, this.cellAtachEditTextComponent.y + k + byte0, this.cellAtachEditTextComponent.width - l, this.cellAtachEditTextComponent.height - byte0);
        this.textComponent.requestFocus();
    }

    public boolean isEditing() {
        return this.textComponent != null && this.textComponent.isVisible();
    }

    public void stopEditCell(PreviewView previewview) {
        if (this.textComponent != null && previewview != null) {
            previewview.remove(this.textComponent);
            String s = Utilities.trimRight(this.textComponent.getText());
            if (s != null && !s.equals(((TextCell)this.cellAtachEditTextComponent).text)) {
                ((TextCell)this.cellAtachEditTextComponent).text = s;
                if (previewview.offGraphics != null) {
                    previewview.offGraphics.setColor(Color.white);
                    previewview.offGraphics.fillRect(this.cellAtachEditTextComponent.x + 1, this.cellAtachEditTextComponent.y + 1, this.cellAtachEditTextComponent.width - 1, this.cellAtachEditTextComponent.height - 1);
                    this.cellAtachEditTextComponent.paint(previewview.offGraphics, previewview.getDrawScale());
                }
            }
            this.textComponent = null;
            this.cellAtachEditTextComponent = null;
            previewview.repaint();
        }
    }

    public void putValue(KeyValuePutter keyvalueputter) {
        if (keyvalueputter == null) {
            return;
        }
        int i = 0;
        while (i < this.pages.size()) {
            Page page = (Page)this.pages.elementAt(i);
            int j = 0;
            while (j < page.cellSet.size()) {
                PrintCell printcell = (PrintCell)page.cellSet.elementAt(j);
                if (printcell instanceof TextCell && ((TextCell)printcell).id != null) {
                    keyvalueputter.putValue(((TextCell)printcell).id, ((TextCell)printcell).text);
                }
                ++j;
            }
            ++i;
        }
    }

    public void getValue(KeyValueGetter keyvaluegetter) {
        if (keyvaluegetter == null) {
            return;
        }
        int i = 0;
        while (i < this.pages.size()) {
            Page page = (Page)this.pages.elementAt(i);
            int j = 0;
            while (j < page.cellSet.size()) {
                Object obj;
                PrintCell printcell = (PrintCell)page.cellSet.elementAt(j);
                if (printcell instanceof TextCell && ((TextCell)printcell).id != null && (obj = keyvaluegetter.getValue(((TextCell)printcell).id)) instanceof String) {
                    ((TextCell)printcell).text = (String)obj;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void previewForInputStream(InputStream inputstream) throws IOException {
        Print print1 = new Print();
        print1.load(inputstream);
        print1.preview(print1.title);
    }

    public void load(InputStream inputstream) throws IOException {
        this.pages.removeAllElements();
        DataInputStream datainputstream = new DataInputStream(inputstream);
        byte byte0 = datainputstream.readByte();
        if (byte0 > 1) {
            throw new RuntimeException("\u7248\u672c");
        }
        this.title = datainputstream.readUTF();
        String s = datainputstream.readUTF();
        String s1 = datainputstream.readUTF();
        this.editable = datainputstream.readInt();
        PageRead pageread = new PageRead(datainputstream);
        if (s.length() > 0) {
            // empty if block
        }
        if (s1.length() > 0) {
            // empty if block
        }
        pageread.readPages(this);
    }

    public void loadFormDB(String s, String s1) {
        if (s == null || s1 == null) {
            return;
        }
        this.saveID = s;
        this.saveFmtnm = s1;
        try {
            String s2 = "select vsave from prtsave where id='" + s + "' and fmt='" + s1 + "' and (nm=' ' or nm='')";
            System.out.println(s2);
            Object obj = JDBC.sqlSelect1(s2);
            System.out.println("o=" + obj + ",");
            if (obj instanceof byte[]) {
                this.load(new ByteArrayInputStream((byte[])obj));
            } else if (obj instanceof InputStream) {
                this.load((InputStream)obj);
            }
        }
        catch (Throwable throwable) {
            Message.printException(throwable, MainApp.isDebug);
        }
    }

    public static void previewFormDB(String s, String s1) {
        Print.previewFormDB(s, s1, -1);
    }

    public static void previewFormDB(String s, String s1, int i) {
        Print.previewFormDB(s, s1, null, null, i);
    }

    public static void previewFormDB(String s, String s1, String s2, String[][] as, int i) {
        try {
            if (s == null) {
                return;
            }
            if (s1 == null) {
                String s3 = "select fmt from prtsave where id='" + s + "' and (nm=' ' or nm='')";
                Object[][] aobj = JDBC.sqlSelect3(s3);
                int j = s.indexOf(46);
                Vector<Object[]> vector = new Vector<Object[]>();
                if (s2 != null && as != null && as.length > 0 && j > 0) {
                    String s5 = s.substring(0, j);
                    String s4 = "select " + as[0][0];
                    int l = 1;
                    while (l < as.length) {
                        s4 = String.valueOf(s4) + "," + as[l][0];
                        ++l;
                    }
                    Object[][] aobj1 = JDBC.sqlSelect3(s4 = String.valueOf(s4) + " from " + s5 + " where " + s2 + "='" + s.substring(j + 1) + "'");
                    if (aobj1 != null && aobj1.length == 1) {
                        if (aobj1[0].length != as.length) {
                            throw new RuntimeException();
                        }
                        int k1 = 0;
                        while (k1 < as.length) {
                            if (aobj1[0][k1] != null) {
                                vector.addElement(new Object[]{as[k1][0], as[k1][1], aobj1[0][k1]});
                            }
                            ++k1;
                        }
                    }
                }
                int k = aobj != null ? aobj.length : 0;
                int i1 = vector.size();
                if (i1 > 0) {
                    Object[][] aobj2 = aobj;
                    aobj = new Object[k + i1][];
                    if (k > 0) {
                        System.arraycopy(aobj2, 0, aobj, 0, k);
                    }
                    int l1 = 0;
                    while (l1 < i1) {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = ((Object[])vector.elementAt(l1))[1];
                        aobj[k + l1] = objectArray;
                        ++l1;
                    }
                }
                if (aobj == null || aobj.length == 0) {
                    return;
                }
                int j1 = -1;
                if (aobj.length == 1) {
                    j1 = 0;
                    s1 = (String)aobj[0][0];
                } else {
                    String[] as1 = new String[aobj.length];
                    int i2 = 0;
                    while (i2 < aobj.length) {
                        as1[i2] = (String)aobj[i2][0];
                        ++i2;
                    }
                    int j2 = DialogPanel.askChoice("\u9009\u62e9", as1);
                    if (j2 < 0) {
                        return;
                    }
                    j1 = j2;
                    s1 = (String)aobj[j1][0];
                }
                if (j1 >= k) {
                    Object obj = ((Object[])vector.elementAt(j1 - k))[2];
                    ExtObject snextobject = new ExtObject();
                    snextobject.fromObject(obj);
                    snextobject.browseExtObject();
                    return;
                }
            }
            Print print1 = new Print();
            print1.loadFormDB(s, s1);
            if (i >= 0) {
                print1.editable = i;
            }
            print1.preview(print1.title);
        }
        catch (Throwable throwable) {
            Message.printException(throwable, MainApp.isDebug);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void previewForFileSave() throws IOException {
        FileDialog filedialog = new FileDialog(MainApp.getMainAppFrame(), "\u6587\u4ef6", 0);
        filedialog.show();
        String s = filedialog.getFile();
        if (s == null) {
            return;
        }
        File file = new File(filedialog.getDirectory(), s);
        FileInputStream fileinputstream = null;
        try {
            fileinputstream = new FileInputStream(file);
            Print.previewForInputStream(fileinputstream);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                fileinputstream.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (Throwable throwable) {
            return;
        }
        fileinputstream.close();
    }

    public static class BackWriteAbleTextCell
    extends TextCell {
        Object[] bufferedObject = new Object[4];

        public BackWriteAbleTextCell(String s, Rectangle rectangle, String s1, Font font, Color color, int i, int j, Object[] aobj) {
            super(s, rectangle, s1, font, color, i, j);
            if (aobj != null) {
                Print.assert0(aobj.length == this.bufferedObject.length);
                System.arraycopy(aobj, 0, this.bufferedObject, 0, this.bufferedObject.length);
            }
        }
    }

    public static class BoolCell
    extends PrintCell {
        public void paint(Graphics g, int i) {
            if (i == 100) {
                TableColumn.drawBooleanValue(g, this.x, this.y, this.width, this.height, true, null);
            } else {
                TableColumn.drawBooleanValue(g, this.x * i / 100, this.y * i / 100, this.width * i / 100, this.height * i / 100, true, null);
            }
        }

        public BoolCell(Rectangle rectangle) {
            super(rectangle);
        }
    }

    public static class DelayedCell
    extends PrintCell {
        Page page;
        PrintFormat.GridCell cell;
        boolean enableTotal;
        int colIndex;
        int atCol;

        public void paint(Graphics g, int i) {
        }

        public DelayedCell(Rectangle rectangle) {
            super(rectangle);
        }
    }

    public static class GraphCell
    extends PrintCell
    implements ImageObserver {
        Object graphObject;
        private boolean paintLock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void paint(Graphics g, int i) {
            if (this.graphObject instanceof Chart) {
                int j = this.x * i / 100;
                int k = this.y * i / 100;
                int l = this.width * i / 100;
                int i1 = this.height * i / 100;
                Dimension dimension = ((Chart)this.graphObject).getSize();
                try {
                    ((Chart)this.graphObject).setSize(this.getSize());
                    ((Chart)this.graphObject).paint(g.create(j, k, l, i1));
                }
                catch (Throwable throwable) {
                    Object var8_15 = null;
                    ((Chart)this.graphObject).setSize(dimension);
                    throw throwable;
                }
                {
                    Object var8_16 = null;
                    ((Chart)this.graphObject).setSize(dimension);
                    return;
                }
            }
            if (!(this.graphObject instanceof Image)) return;
            if (this.width <= 0) return;
            if (this.height <= 0) return;
            GraphCell graphCell = this;
            synchronized (graphCell) {
                Graphics g1 = g;
                Image image = (Image)this.graphObject;
                this.paintLock = true;
                int j1 = image.getWidth(this);
                if (j1 == -1) {
                    try {
                        while (this.paintLock) {
                            this.wait();
                        }
                    }
                    catch (Exception dimension) {
                        // empty catch block
                    }
                    j1 = image.getWidth(null);
                }
                this.paintLock = true;
                int k1 = image.getHeight(this);
                if (k1 == -1) {
                    try {
                        while (this.paintLock) {
                            this.wait();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    k1 = image.getHeight(null);
                }
                double d = 1.0;
                boolean flag = false;
                if (this.width < j1 || this.height < k1) {
                    double d1 = (double)this.height / (double)k1;
                    double d2 = (double)this.width / (double)j1;
                    d = d1 >= d2 ? d2 : d1;
                    flag = true;
                }
                if (i != 100 || flag) {
                    g1 = g.create();
                    ((Graphics2D)g1).scale(d * (double)i / 100.0, d * (double)i / 100.0);
                }
                this.paintLock = true;
                if (g1.drawImage(image, this.x, this.y, this)) return;
                try {
                    while (this.paintLock) {
                        this.wait();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                g1.drawImage((Image)this.graphObject, this.x, this.y, null);
                return;
            }
        }

        public synchronized boolean imageUpdate(Image image, int i, int j, int k, int l, int i1) {
            if ((i & 0xA0) != 0) {
                this.paintLock = false;
                this.notifyAll();
            }
            return (i & 0xA0) == 0;
        }

        public GraphCell(Rectangle rectangle, Object obj) {
            super(rectangle);
            this.graphObject = obj;
        }
    }

    public static class LineCell
    extends PrintCell {
        int penStyle;

        public void paint(Graphics g, int i) {
            AwtUtil.drawLine(g, this.x * i / 100, this.y * i / 100, (this.x + this.width) * i / 100, (this.y + this.height) * i / 100, this.color != null ? this.color : Color.black, this.penStyle & 0xFF, this.penStyle >> 8);
        }

        public LineCell(Rectangle rectangle, int i, Color color) {
            super(rectangle);
            this.penStyle = i;
            this.color = color;
        }
    }

    public static class Page {
        public final Vector cellSet = new Vector();
        int width;
        int height;
        public int defaultRuleUnit = MainApp.getAppIntOption(90, 2);

        void removeFromPoint(int i, int j) {
            int k = 0;
            while (k < this.cellSet.size()) {
                PrintCell printcell = (PrintCell)this.cellSet.elementAt(k);
                if (printcell.x >= i && printcell.y >= j) {
                    this.cellSet.removeElementAt(k);
                    continue;
                }
                ++k;
            }
        }

        LineCell addLine(Rectangle rectangle, int i, Color color) {
            if ((i & 0xFF) == 0 || i >> 8 == 0 || color != null && color.equals(Color.white)) {
                return null;
            }
            int j = this.cellSet.size();
            int k = rectangle.x;
            int l = rectangle.y;
            int i1 = rectangle.x + rectangle.width;
            int j1 = rectangle.y + rectangle.height;
            if (k == i1) {
                int k1 = 0;
                while (k1 < j) {
                    PrintCell printcell = (PrintCell)this.cellSet.elementAt(k1);
                    if (printcell instanceof LineCell) {
                        LineCell linecell1 = (LineCell)printcell;
                        if (linecell1.penStyle == i && Print.objectEquals(linecell1.color, color) && linecell1.width == 0 && k == linecell1.x) {
                            int i2 = Print.min(linecell1.y, linecell1.y + linecell1.height);
                            int k2 = Print.max(linecell1.y, linecell1.y + linecell1.height);
                            int i3 = Print.min(l, j1);
                            int k3 = Print.max(l, j1);
                            if (k3 >= i2 && i3 <= k2) {
                                linecell1.y = Print.min(i2, i3);
                                linecell1.height = Print.max(k2, k3) - linecell1.y;
                                return linecell1;
                            }
                        }
                    }
                    ++k1;
                }
            }
            if (l == j1) {
                int l1 = 0;
                while (l1 < j) {
                    PrintCell printcell1 = (PrintCell)this.cellSet.elementAt(l1);
                    if (printcell1 instanceof LineCell) {
                        LineCell linecell2 = (LineCell)printcell1;
                        if (linecell2.penStyle == i && Print.objectEquals(linecell2.color, color) && linecell2.height == 0 && l == linecell2.y) {
                            int j2 = Print.min(linecell2.x, linecell2.x + linecell2.width);
                            int l2 = Print.max(linecell2.x, linecell2.x + linecell2.width);
                            int j3 = Print.min(k, i1);
                            int l3 = Print.max(k, i1);
                            if (l3 >= j2 && j3 <= l2) {
                                linecell2.x = Print.min(j2, j3);
                                linecell2.width = Print.max(l2, l3) - linecell2.x;
                                return linecell2;
                            }
                        }
                    }
                    ++l1;
                }
            }
            LineCell linecell = new LineCell(rectangle, i, color);
            this.addPrintCell(linecell);
            return linecell;
        }

        void addPrintCell(PrintCell printcell) {
            if (printcell != null && (printcell.width > 0 || printcell.height > 0)) {
                if (printcell instanceof GraphCell) {
                    this.cellSet.insertElementAt(printcell, 0);
                } else {
                    this.cellSet.addElement(printcell);
                }
            }
        }

        TextCell addText(String s, Rectangle rectangle, String s1, Font font, Color color, int i, int j) {
            TextCell textcell = new TextCell(s, rectangle, s1, font, color, i, j);
            this.addPrintCell(textcell);
            return textcell;
        }

        void addBackWriteAbleText(String s, Rectangle rectangle, String s1, Font font, Color color, int i, int j, Object[] aobj) {
            this.addPrintCell(new BackWriteAbleTextCell(s, rectangle, s1, font, color, i, j, aobj));
        }

        void addBool(Rectangle rectangle) {
            this.addPrintCell(new BoolCell(rectangle));
        }

        void addGraph(Rectangle rectangle, Object obj) {
            this.addPrintCell(new GraphCell(rectangle, obj));
        }

        private void paintRule(Graphics g) {
            int i = this.defaultRuleUnit;
            if (i <= 0) {
                return;
            }
            double d = (double)i * 3.937007874015748 * 72.0 / 100.0;
            g.setColor(Color.lightGray);
            int j = 1;
            while ((double)j * d < (double)this.width) {
                g.drawLine((int)((double)j * d), 0, (int)((double)j * d), this.height);
                ++j;
            }
            int k = 1;
            while ((double)k * d < (double)this.height) {
                g.drawLine(0, (int)((double)k * d), this.width, (int)((double)k * d));
                ++k;
            }
        }

        public void paint(Graphics g, int i) {
            this.paintRule(g);
            int j = this.cellSet.size();
            int k = 0;
            while (k < j) {
                ((PrintCell)this.cellSet.elementAt(k)).paint(g, i);
                ++k;
            }
        }

        int resetRowHeight(int i, int j) {
            int k = this.cellSet.size();
            int l = 0;
            int i1 = 0;
            while (i1 < k) {
                PrintCell printcell = (PrintCell)this.cellSet.elementAt(i1);
                if (printcell.y == i && printcell instanceof VirtualPrintCell && (((VirtualPrintCell)printcell).flags & 1) != 0) {
                    if (l < printcell.height) {
                        l = printcell.height;
                    }
                } else if (printcell instanceof TextCell) {
                    int k1;
                    TextCell textcell = (TextCell)printcell;
                    if (textcell.y == i && (textcell.format & 0x80) != 0 && l < (k1 = textcell.findPaintHeight())) {
                        l = k1;
                    }
                }
                ++i1;
            }
            if (l > j) {
                int j1 = 0;
                while (j1 < k) {
                    PrintCell printcell1 = (PrintCell)this.cellSet.elementAt(j1);
                    if (printcell1 instanceof TextCell) {
                        TextCell textcell1 = (TextCell)printcell1;
                        if (textcell1.y == i && textcell1.height < l) {
                            textcell1.height = l;
                        }
                    } else if (printcell1 instanceof LineCell) {
                        LineCell linecell = (LineCell)printcell1;
                        if (linecell.width == 0 && linecell.height + linecell.y > i + 1 && linecell.height + linecell.y < i + l) {
                            linecell.height = i + l - linecell.y;
                        } else if (linecell.height == 0 && linecell.y > i + 1 && linecell.y < i + l) {
                            linecell.y = i + l;
                        }
                    }
                    ++j1;
                }
            }
            return l;
        }

        Vector removeRemainingPart(int i, int j, boolean flag) {
            Vector<PrintCell> vector = new Vector<PrintCell>();
            int k = i + j;
            int l = this.cellSet.size();
            int i1 = 0;
            while (i1 < l) {
                PrintCell printcell = (PrintCell)this.cellSet.elementAt(i1);
                boolean flag1 = false;
                if (printcell instanceof TextCell) {
                    TextCell textcell = (TextCell)printcell;
                    if (textcell.y > k + 1) {
                        flag1 = true;
                    } else if (textcell.y + textcell.height > k + 1) {
                        if ((textcell.format & 0x80) == 0) {
                            if (textcell.y > i + 4) {
                                flag1 = true;
                            } else {
                                textcell.height = k - textcell.y;
                            }
                        } else if (flag) {
                            flag1 = true;
                        } else {
                            int j1 = textcell.height;
                            textcell.height = k - textcell.y;
                            String[] as = new String[2];
                            textcell.splitDrawText(textcell.height, as);
                            if (as[0] != null && as[1] != null) {
                                textcell.format |= 0x8000;
                                textcell.text = as[0];
                                TextCell textcell1 = new TextCell(textcell.id, new Rectangle(textcell.x, 0, textcell.width, j1 - textcell.height), as[1], textcell.font, textcell.color, textcell.format, textcell.lineGap);
                                vector.addElement(textcell1);
                            }
                        }
                    }
                } else if (printcell instanceof LineCell) {
                    LineCell linecell = (LineCell)printcell;
                    if (linecell.height == 0 && linecell.y > k) {
                        LineCell linecell1 = new LineCell(new Rectangle(linecell.x, linecell.y - i, linecell.width, 0), linecell.penStyle, linecell.color);
                        vector.addElement(linecell1);
                    } else if (linecell.width == 0 && linecell.y + linecell.height > k) {
                        LineCell linecell2 = new LineCell(new Rectangle(linecell.x, 0, linecell.width, linecell.y + linecell.height - k), linecell.penStyle, linecell.color);
                        vector.addElement(linecell2);
                    }
                    if (linecell.y > k) {
                        linecell.y = k;
                    }
                    if (linecell.y + linecell.height > k) {
                        linecell.height = k - linecell.y;
                    }
                } else if (printcell.y > k + 1) {
                    flag1 = true;
                } else if (printcell.y + printcell.height > k) {
                    printcell.height = k - printcell.y;
                }
                if (flag1) {
                    this.cellSet.removeElementAt(i1);
                    --l;
                    --i1;
                    printcell.y -= i;
                    vector.addElement(printcell);
                }
                ++i1;
            }
            return vector;
        }

        public PrintCell atCell(int i, int j) {
            int k = this.cellSet.size();
            int l = 0;
            while (l < k) {
                PrintCell printcell = (PrintCell)this.cellSet.elementAt(l);
                if (printcell.contains(i, j)) {
                    return printcell;
                }
                ++l;
            }
            return null;
        }
    }

    public static abstract class PrintCell
    extends Rectangle {
        public Color color;
        public int groupTag;

        public abstract void paint(Graphics var1, int var2);

        public PrintCell(Rectangle rectangle) {
            super(rectangle);
        }
    }

    public static class PrintErrorException
    extends Exception {
        public PrintErrorException() {
        }

        public PrintErrorException(String s) {
            super(s);
        }
    }

    public static class TextCell
    extends PrintCell {
        String id;
        public String text;
        public Font font;
        public int format;
        int lineGap;
        public int widthInset;

        public void paint(Graphics g, int i) {
            if (i == 100) {
                AwtUtil.drawText(g, this.text, this, this.widthInset, Print.getFont(this.font), this.color != null ? this.color : Color.black, this.format, this.lineGap, 0, null);
            } else {
                Rectangle rectangle = new Rectangle(this.x * i / 100, this.y * i / 100, this.width * i / 100, this.height * i / 100);
                Font font1 = Print.getFont(this.font);
                font1 = new Font(font1.getName(), font1.getStyle(), font1.getSize() * i / 100);
                AwtUtil.drawText(g, this.text, rectangle, this.widthInset, font1, this.color != null ? this.color : Color.black, this.format, this.lineGap * i / 100, 0, null);
            }
        }

        public int findPaintHeight() {
            return AwtUtil.drawText(null, this.text, this, Print.getFont(this.font), this.color != null ? this.color : Color.black, this.format, this.lineGap);
        }

        public int splitDrawText(int i, String[] as) {
            return AwtUtil.drawText(null, this.text, this, this.widthInset, Print.getFont(this.font), this.color != null ? this.color : Color.black, this.format, this.lineGap, i, as);
        }

        public String toString() {
            return String.valueOf(super.toString()) + ",text=" + this.text;
        }

        public TextCell(String s, Rectangle rectangle, String s1, Font font1, Color color, int i, int j) {
            super(rectangle);
            this.id = s;
            this.text = s1;
            this.font = font1;
            this.color = color;
            this.format = i;
            this.lineGap = j;
        }
    }

    public static class VirtualPrintCell
    extends PrintCell {
        int flags;

        public void paint(Graphics g, int i) {
        }

        public VirtualPrintCell(Rectangle rectangle, int i) {
            super(rectangle);
            this.flags = i;
        }
    }
}

