/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import softcore.print.ColorComboBox;
import softcore.print.LineComboBox;
import softcore.print.PrintFormat;
import softcore.print.PrintFormatDesign;
import softcore.util.Utilities;

final class PrintBar1
extends JToolBar
implements ActionListener {
    JComboBox fontNameCombo = new JComboBox();
    JComboBox fontSizeCombo = new JComboBox();
    ColorComboBox colorCombo = new ColorComboBox();
    LineComboBox lineStyleCombo = new LineComboBox();
    JComboBox lineWidthCombo = new JComboBox();
    PrintFormatDesign ownerPane = null;
    ButtonGroup group = new ButtonGroup();
    public JToggleButton[] buttons = new JToggleButton[7];

    public PrintBar1() {
        Dimension dimension = new Dimension(4, 0);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.fontNameCombo.setToolTipText("\u5b57\u4f53\u540d");
        this.add(this.fontNameCombo);
        Dimension dimension1 = new Dimension(128, 24);
        this.fontNameCombo.setPreferredSize(dimension1);
        this.fontNameCombo.setMaximumSize(dimension1);
        this.fontNameCombo.setMinimumSize(dimension1);
        this.fontNameCombo.addActionListener(this);
        this.fontSizeCombo.setToolTipText("\u5b57\u4f53\u5927\u5c0f");
        this.EnumFontSize();
        this.add(this.fontSizeCombo);
        this.fontSizeCombo.addActionListener(this);
        this.colorCombo.setToolTipText("\u5b57\u4f53\u989c\u8272");
        this.add(this.colorCombo);
        this.colorCombo.addActionListener(this);
        this.addSeparator(dimension);
        this.lineStyleCombo.setToolTipText("\u753b\u7ebf\u98ce\u683c");
        this.add(this.lineStyleCombo);
        this.lineStyleCombo.addActionListener(this);
        int i = 1;
        while (i < 7) {
            this.lineWidthCombo.addItem(String.valueOf(i));
            ++i;
        }
        this.lineWidthCombo.setToolTipText("\u7ebf\u5bbd");
        this.add(this.lineWidthCombo);
        this.lineWidthCombo.addActionListener(this);
        ImageIcon[] aimageicon = new ImageIcon[this.buttons.length];
        String[] as = new String[]{"\u5355\u5143\u4e2d\u663e\u793a\u516c\u5f0f", "\u52a0\u7c97", "\u659c\u4f53", "\u5de6\u5bf9\u9f50", "\u5c45\u4e2d", "\u53f3\u5bf9\u9f50", "\u663e\u793a\u6807\u5c3a"};
        String[] as1 = new String[]{"factshow.gif", "bold.gif", "italic.gif", "Left.gif", "mid.gif", "right.gif", "rule.gif"};
        int j = 0;
        while (j < aimageicon.length) {
            try {
                aimageicon[j] = Utilities.createImageIconFromResource("res/" + as1[j]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++j;
        }
        Dimension dimension2 = new Dimension(26, 26);
        int k = 0;
        while (k < this.buttons.length) {
            this.buttons[k] = new JToggleButton(aimageicon[k], false);
            this.buttons[k].setToolTipText(as[k]);
            this.buttons[k].setMinimumSize(dimension2);
            this.buttons[k].setMaximumSize(dimension2);
            this.buttons[k].setPreferredSize(dimension2);
            this.buttons[k].addActionListener(this);
            this.buttons[k].setRequestFocusEnabled(false);
            if (k <= 1 || k == 3 || k == 6) {
                this.addSeparator(dimension);
            }
            this.add(this.buttons[k]);
            if (k >= 3 && k <= 5) {
                this.group.add(this.buttons[k]);
            }
            ++k;
        }
        this.setEnabled(false);
    }

    public void setOwnerPane(PrintFormatDesign printformatdesign) {
        this.ownerPane = printformatdesign;
    }

    void EnumFontFaceName() {
        if (this.fontNameCombo.getItemCount() == 0) {
            EnumFontThread enumfontthread = new EnumFontThread(this.fontNameCombo);
            enumfontthread.start();
        }
    }

    void EnumFontSize() {
        int i = 4;
        while (i < 72) {
            this.fontSizeCombo.addItem(String.valueOf(i + 2));
            i += 2;
        }
        this.fontSizeCombo.setSelectedItem(new String("16"));
    }

    void responeAligment(int i) {
        int byte0 = 3;
        if ((i & PrintFormat.FormulaCell.cellAlignCenter) > 0) {
            byte0 = 4;
        } else if ((i & PrintFormat.FormulaCell.cellAlignRight) > 0) {
            byte0 = 5;
        }
        int j = 3;
        while (j < 6) {
            this.buttons[byte0].setSelected(j == byte0);
            ++j;
        }
    }

    void responeDisplay(boolean flag) {
        if (flag != this.buttons[0].isSelected()) {
            this.buttons[0].setSelected(flag);
        }
    }

    void indicateFont(Font font) {
        boolean flag = font.isBold();
        if (flag != this.buttons[1].isSelected()) {
            this.buttons[1].setSelected(flag);
        }
        if ((flag = font.isItalic()) != this.buttons[2].isSelected()) {
            this.buttons[2].setSelected(flag);
        }
        this.fontNameCombo.setSelectedItem(font.getFontName());
        int i = font.getSize();
        this.fontSizeCombo.setSelectedItem(String.valueOf(i));
    }

    void indicateColor(Color color) {
        this.colorCombo.setSelectedItem(color);
    }

    void indicateLineStyle(int i) {
        this.lineStyleCombo.setSelectedItem(new Integer(i));
    }

    void indicateLineWidth(int i) {
        this.lineWidthCombo.setSelectedItem(String.valueOf(i));
    }

    int getCurSelLineStyle() {
        Integer integer = (Integer)this.lineStyleCombo.getSelectedItem();
        if (integer != null) {
            return integer;
        }
        return 0;
    }

    int getCurSelLineWidth() {
        String s = (String)this.lineWidthCombo.getSelectedItem();
        int i = 1;
        try {
            i = Integer.parseInt(s);
            if (i < 1) {
                i = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    Color getCurSelColor() {
        return (Color)this.colorCombo.getSelectedItem();
    }

    Font getCurSelFont() {
        Color color = (Color)this.colorCombo.getSelectedItem();
        String s = (String)this.fontNameCombo.getSelectedItem();
        String s1 = (String)this.fontSizeCombo.getSelectedItem();
        int i = Integer.parseInt(s1);
        boolean flag = this.buttons[1].isSelected();
        boolean flag1 = this.buttons[2].isSelected();
        int j = 0;
        if (flag) {
            j |= 1;
        }
        if (flag1) {
            j |= 2;
        }
        return new Font(s, j, i);
    }

    public void actionPerformed(ActionEvent actionevent) {
        JComboBox jcombobox;
        Object obj = actionevent.getSource();
        if (obj == null) {
            return;
        }
        if (obj instanceof JToggleButton) {
            int i = Utilities.objInObjArray(this.buttons, obj);
            switch (i) {
                case 0: {
                    this.ownerPane.setDisplayContent(this.buttons[0].isSelected());
                    break;
                }
                case 1: 
                case 2: {
                    this.ownerPane.setCellFont();
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    int j = 0;
                    if (i == 4) {
                        j = PrintFormat.FormulaCell.cellAlignCenter;
                    } else if (i == 5) {
                        j = PrintFormat.FormulaCell.cellAlignRight;
                    }
                    this.ownerPane.setAlingment(j);
                    break;
                }
                case 6: {
                    this.ownerPane.showRuler(this.buttons[6].isSelected());
                }
            }
        } else if (obj instanceof JComboBox && (jcombobox = (JComboBox)obj).hasFocus()) {
            if (obj instanceof ColorComboBox) {
                this.ownerPane.setCellFont();
            } else if (obj instanceof LineComboBox) {
                this.ownerPane.setLineOption();
            } else if (jcombobox == this.fontNameCombo || jcombobox == this.fontSizeCombo) {
                this.ownerPane.setCellFont();
            } else if (jcombobox == this.lineWidthCombo) {
                this.ownerPane.setLineOption();
            }
        }
    }

    private class EnumFontThread
    extends Thread {
        JComboBox fontList;

        public void run() {
            try {
                GraphicsEnvironment graphicsenvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                Font[] afont = graphicsenvironment.getAllFonts();
                int i = 0;
                while (i < afont.length) {
                    String s = afont[i].getFontName();
                    if (s != null && s.length() > 0) {
                        if (s.charAt(0) < '\u0000' || s.charAt(0) > '\u007f') {
                            this.fontList.insertItemAt(s, 0);
                        } else {
                            this.fontList.addItem(s);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public EnumFontThread(JComboBox jcombobox) {
            this.fontList = jcombobox;
        }
    }
}

