/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyVetoException;
import javax.swing.JLayeredPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import softcore.awt.AwtUtil;
import softcore.print.IDTagPanel;
import softcore.print.PrintBar1;
import softcore.print.PrintBar2;
import softcore.print.PrintFormatDesign;
import softcore.print.PrintScrollPane;
import softcore.util.Constants;
import softcore.util.Message;
import softface.MainFrame;
import softface.mdi.JMDIDesktopPane;
import softface.mdi.JMDIFrame;
import softoperation.finance.erpdata.ErpdataConfig;

public class PrintFormatFrame
extends JMDIFrame
implements InternalFrameListener {
    private PrintBar1 toolBar1 = new PrintBar1();
    private PrintBar2 toolBar2 = new PrintBar2();
    private PrintScrollPane pane = null;
    IDTagPanel tagPanel = null;
    private int defType;
    private int sysId;
    private boolean bRowGroup;
    private int option;

    public PrintFormatFrame(int i, int j, boolean flag, int k) {
        this.defType = j;
        this.sysId = 0;
        this.bRowGroup = flag;
        this.option = k;
        this.pane = new PrintScrollPane(flag);
        this.initial();
    }

    private void initial() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridwidth = 1;
        gridbagconstraints.gridheight = 1;
        gridbagconstraints.gridx = 0;
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.weighty = 0.0;
        gridbagconstraints.insets = Constants.ZEROINSETS;
        gridbagconstraints.anchor = 17;
        gridbagconstraints.fill = 2;
        container.add((Component)this.toolBar1, gridbagconstraints);
        gridbagconstraints.gridy = 1;
        gridbagconstraints.anchor = 17;
        container.add((Component)this.toolBar2, gridbagconstraints);
        this.tagPanel = new IDTagPanel(this.sysId, this.defType, this.option);
        gridbagconstraints.gridy = 2;
        gridbagconstraints.anchor = 17;
        container.add((Component)this.tagPanel, gridbagconstraints);
        gridbagconstraints.gridy = 3;
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.weighty = 1.0;
        gridbagconstraints.anchor = 17;
        gridbagconstraints.fill = 1;
        container.add((Component)this.pane, gridbagconstraints);
        this.addInternalFrameListener(this);
        PrintFormatDesign printformatdesign = this.pane.getMainPane();
        if (printformatdesign != null) {
            this.toolBar1.setOwnerPane(printformatdesign);
            this.toolBar2.setOwnerPane(printformatdesign);
            printformatdesign.setToolBar(this.toolBar1, this.toolBar2);
            this.tagPanel.setOwnerDesign(printformatdesign);
            printformatdesign.setMainPanel(this.tagPanel);
        }
    }

    public void internalFrameOpened(InternalFrameEvent internalframeevent) {
    }

    public void internalFrameClosing(InternalFrameEvent internalframeevent) {
    }

    public void internalFrameClosed(InternalFrameEvent internalframeevent) {
    }

    public void internalFrameIconified(InternalFrameEvent internalframeevent) {
    }

    public void internalFrameDeiconified(InternalFrameEvent internalframeevent) {
    }

    public void internalFrameActivated(InternalFrameEvent internalframeevent) {
        this.restoreSubcomponentFocus();
    }

    public void internalFrameDeactivated(InternalFrameEvent internalframeevent) {
        this.restoreSubcomponentFocus();
    }

    public void doDefaultCloseAction() {
        if (this.tagPanel.canCloseFrame()) {
            try {
                this.setClosed(true);
                this.setVisible(false);
                this.setSelected(false);
                this.pane.pane.clear();
                this.dispose();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public static void doDesign() {
        ErpdataConfig sndataconfig = ErpdataConfig.getCurrentConfig();
        if (sndataconfig != null) {
            PrintFormatFrame.doCustomDesign(null, sndataconfig.idSystem, 1, true, 1);
        }
    }

    public static void doDesignForType8() {
        ErpdataConfig sndataconfig = ErpdataConfig.getCurrentConfig();
        if (sndataconfig != null) {
            PrintFormatFrame.doCustomDesign(null, sndataconfig.idSystem, 8, false, 0);
        }
    }

    public static void openFormat(int i, String s) {
        if (i < 0) {
            i = ErpdataConfig.getCurrentConfig().idSystem;
        }
        PrintFormatFrame.doCustomDesign(s, i, 1, true, 1);
    }

    public static void doOwnerDesign() {
        ErpdataConfig sndataconfig = ErpdataConfig.getCurrentConfig();
        if (sndataconfig != null) {
            PrintFormatFrame.doCustomDesign(null, sndataconfig.idSystem, 1, true, 0);
        }
    }

    public static void doDesignAll() {
        PrintFormatFrame.doCustomDesign(null, -1, 1, true, 0);
    }

    public static void designReportFormat() {
        int i = 1;
        PrintFormatFrame.doCustomDesign(null, i, 3, false, 1);
    }

    private static void doCustomDesign(String s, int i, int j, boolean flag, int k) {
        ErpdataConfig sndataconfig = ErpdataConfig.getCurrentConfig();
        if (sndataconfig != null) {
            PrintFormatFrame printformatframe = new PrintFormatFrame(i, j, flag, k);
            JMDIDesktopPane appdesktoppane = MainFrame.getDesktopPane();
            if (appdesktoppane == null) {
                return;
            }
            printformatframe.pack();
            AwtUtil.locateRandom(printformatframe, appdesktoppane);
            appdesktoppane.add((Component)printformatframe, JLayeredPane.PALETTE_LAYER);
            printformatframe.toFront();
            printformatframe.requestFocus();
            printformatframe.setMenu(MainFrame.MenuBar);
            printformatframe.setResizable(true);
            printformatframe.setClosable(true);
            printformatframe.setMaximizable(true);
            printformatframe.setIconifiable(true);
            try {
                printformatframe.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            printformatframe.setVisible(true);
            if (s != null && !printformatframe.tagPanel.openFormat(s)) {
                printformatframe.tagPanel.newForamt(s);
            }
            printformatframe.toolBar1.EnumFontFaceName();
        } else {
            Message.showInformationDialog("\u9519\u8bef", "\u672a\u6253\u5f00\u8d26\u5957!");
        }
    }
}

