/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import softcore.awt.AwtUtil;
import softcore.print.PrintFormat;
import softcore.print.PrintFormatDesign;
import softcore.util.Utilities;

class PrintHRule
extends JComponent
implements MouseListener,
MouseMotionListener {
    PrintFormatDesign pane = null;
    public static int nRuleHeight = 22;
    int resizeState = 0;
    int resizeColumn = -1;
    double oldColWidth = 0.0;
    int resizeXLeft = 0;
    Color ltColor = new Color(164, 164, 164);
    private boolean bAtLine = false;

    public PrintHRule(PrintFormatDesign printformatdesign) {
        this.pane = printformatdesign;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    void drawDragFlag() {
        int i = (int)((double)this.resizeXLeft + this.oldColWidth);
        Graphics g = this.getGraphics();
        g.setXORMode(PrintFormatDesign.xorColor);
        g.drawLine(i, 0, i, this.getSize().height);
        g = this.pane.getGraphics();
        g.setXORMode(PrintFormatDesign.xorColor);
        g.drawLine(i, 0, i, 2000);
    }

    protected void paintComponent(Graphics g) {
        if (this.pane == null) {
            return;
        }
        Dimension dimension = this.getSize();
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, dimension.width, dimension.height);
        Color color = Color.blue;
        Rectangle rectangle = new Rectangle(0, 0, 100, 100);
        g.setColor(Color.lightGray);
        g.drawLine(0, 0, dimension.width, 0);
        g.setColor(Color.white);
        g.drawLine(0, 1, dimension.width, 1);
        g.setColor(Color.gray);
        g.drawLine(0, nRuleHeight - 1, dimension.width, nRuleHeight - 1);
        int i = 0;
        int j = 0;
        while (j <= this.pane.format.gridCols) {
            PrintFormat.Col col = this.pane.format.getColumn(j);
            if (col == null) break;
            rectangle.setBounds(i + 1, 2, (int)(col.width - 2.0), nRuleHeight - 5);
            i = (int)((double)i + col.width);
            g.setColor(Color.gray);
            g.drawLine(i - 1, 1, i - 1, nRuleHeight - 3);
            g.setColor(Color.white);
            g.drawLine(i + 1, 1, i + 1, nRuleHeight - 3);
            if ((col.options & PrintFormat.Col.colSelected) > 0) {
                g.setColor(Color.black);
                g.fillRect(rectangle.x, rectangle.y, rectangle.width, nRuleHeight - 4);
            }
            if (j > 0) {
                ++rectangle.y;
                AwtUtil.drawText(g, Utilities.getExcelCellColName(j - 1), rectangle, PrintFormat.defaultFont, (col.options & PrintFormat.Col.colSelected) <= 0 ? color : Color.white, PrintFormat.FormulaCell.cellAlignCenter | PrintFormat.FormulaCell.cellAlignVCenter, 0);
            }
            ++j;
        }
        if (!this.pane.bShowRuler) {
            return;
        }
        g.setColor(Color.black);
        g.drawLine(0, dimension.height - 1, dimension.width, dimension.height - 1);
        int k = 0;
        while (k < (int)((double)dimension.width / this.pane.cmScale)) {
            int byte0 = 3;
            if (k % 10 == 0) {
                byte0 = 11;
            } else if (k % 5 == 0) {
                byte0 = 7;
            }
            int l = (int)(this.pane.cmScale * (double)k);
            g.drawLine(l, dimension.height - byte0, l, dimension.height - 1);
            if (k > 0 && k % 10 == 0) {
                g.setColor(this.ltColor);
                g.drawString(k / 2 + "cm", l + 1, dimension.height - 4);
                g.setColor(Color.black);
            }
            ++k;
        }
    }

    public void adjustSize() {
        if (this.pane != null) {
            Dimension dimension = this.pane.getSize();
            this.setBounds(0, 0, dimension.width, nRuleHeight);
        }
    }

    int findColIndex(int i) {
        this.bAtLine = false;
        int j = 0;
        int k = 0;
        Enumeration enumeration = this.pane.format.colSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Col col = (PrintFormat.Col)enumeration.nextElement();
            if (i - (j = (int)((double)j + col.width)) <= 1 && i - j >= -1) {
                this.bAtLine = true;
                return k;
            }
            if (i < j) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    void invalidateCol(int i) {
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        rectangle.x = (int)this.pane.format.getColLine(i - 1);
        rectangle.width = (int)this.pane.format.getColLine(i) - rectangle.x;
        this.repaint(rectangle);
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent mouseevent) {
        this.pane.endEdit();
        if (this.resizeColumn >= 0) {
            if (this.resizeState == 1) {
                PrintFormat.Col col = this.pane.format.getColumn(this.resizeColumn);
                this.resizeXLeft = (int)this.pane.format.getColLine(this.resizeColumn - 1);
                this.oldColWidth = (int)col.width;
                this.resizeState = 2;
                this.drawDragFlag();
                return;
            }
            if (this.resizeState == 3) {
                this.resizeState = 4;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseevent) {
        if (this.resizeState == 2) {
            this.resizeState = 1;
            PrintFormat.Col col = this.pane.format.getColumn(this.resizeColumn);
            this.pane.incColWidth(this.resizeColumn, this.oldColWidth - col.width);
            this.drawDragFlag();
            this.repaint();
        } else if (this.resizeState == 4) {
            this.resizeState = 3;
            if (mouseevent.isShiftDown() && mouseevent.isControlDown() && this.pane.pUniqueSelectedCol != null) {
                int i = this.pane.findUniqueSelectedCol();
                int j = this.findColIndex(mouseevent.getX());
                if (j >= 0 && i >= 0 && j != i && JOptionPane.showConfirmDialog(this, "Copy Col?") == 0) {
                    this.pane.setCol(j, i);
                }
                return;
            }
            if (!mouseevent.isControlDown()) {
                this.pane.clearAllSelectedGridCell(true);
            }
            this.pane.selectCol(this.resizeColumn, true);
        }
    }

    public void mouseExited(MouseEvent mouseevent) {
    }

    public void mouseDragged(MouseEvent mouseevent) {
        int i;
        if (this.resizeState == 2 && (i = mouseevent.getX()) > this.resizeXLeft + 2) {
            this.drawDragFlag();
            this.oldColWidth = i - this.resizeXLeft;
            this.drawDragFlag();
            this.repaint(0, 0, 1, 1);
        }
    }

    public void mouseMoved(MouseEvent mouseevent) {
        int i = mouseevent.getX();
        int j = mouseevent.getY();
        if (j >= 1 && j <= nRuleHeight - 2) {
            int k = this.findColIndex(i);
            if (this.bAtLine) {
                if (this.getCursor().getType() != 11) {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                }
                if (this.resizeState != 2) {
                    this.repaint(i, 0, 1, nRuleHeight);
                }
                this.resizeState = 1;
                this.resizeColumn = k;
                return;
            }
            if (k >= 0) {
                if (this.getCursor().getType() != 0) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                this.resizeState = 3;
                this.resizeColumn = k;
                return;
            }
        }
        if (this.getCursor().getType() != 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.resizeState != 0) {
            this.repaint();
        }
        this.resizeState = 0;
        this.resizeColumn = -1;
    }
}

