/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import softcore.awt.AwtUtil;
import softcore.print.PrintFormat;
import softcore.print.PrintFormatDesign;

class PrintVRule
extends JComponent
implements MouseListener,
MouseMotionListener {
    PrintFormatDesign pane = null;
    public static int nVRuleWidth = 32;
    private boolean bAtLine = false;
    int resizeState = 0;
    int resizeRow = -1;
    double oldRowHeight = 0.0;
    int resizeYLeft;

    public PrintVRule(PrintFormatDesign printformatdesign) {
        this.pane = printformatdesign;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    void drawDragFlag() {
        int i = (int)((double)this.resizeYLeft + this.oldRowHeight);
        Graphics g = this.getGraphics();
        g.setXORMode(PrintFormatDesign.xorColor);
        g.drawLine(0, i, this.getSize().width, i);
        g = this.pane.getGraphics();
        g.setXORMode(PrintFormatDesign.xorColor);
        g.drawLine(0, i, 2000, i);
    }

    protected void paintComponent(Graphics g) {
        if (this.pane == null) {
            return;
        }
        Dimension dimension = this.getSize();
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, dimension.width, dimension.height);
        g.setColor(Color.lightGray);
        g.drawLine(0, 0, 0, dimension.height);
        g.setColor(Color.white);
        g.drawLine(1, 0, 1, dimension.height);
        g.setColor(Color.darkGray);
        g.drawLine(nVRuleWidth - 1, 0, nVRuleWidth, dimension.height - 1);
        Rectangle rectangle = new Rectangle(0, 0, nVRuleWidth, dimension.height);
        Vector vector = this.pane.format.rowSet;
        int i = this.pane.format.groupNumber;
        int j = 0;
        int l = 0;
        int[] ai = new int[16];
        int i1 = 0;
        while (i1 < ai.length) {
            ai[i1] = 0;
            ++i1;
        }
        int j1 = 0;
        int k1 = 1;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Row row = (PrintFormat.Row)enumeration.nextElement();
            rectangle.y = j;
            rectangle.height = (int)row.height;
            j += rectangle.height;
            if ((row.options & PrintFormat.Row.rowGroupBgn) > 0) {
                ai[l++] = rectangle.y;
            }
            String s = "";
            if (j1 == 0) {
                s = "\u5934";
            } else if (j1 == this.pane.format.gridRows) {
                s = "\u5c3e";
            } else if (!this.pane.format.bRowGroup && l == i) {
                s = String.valueOf(k1++);
            }
            g.setColor(Color.gray);
            g.drawLine(rectangle.x, j - 1, rectangle.x + rectangle.width - 2, j - 1);
            g.setColor(Color.white);
            g.drawLine(rectangle.x, j + 1, rectangle.x + rectangle.width - 2, j + 1);
            if ((row.options & PrintFormat.Row.rowGroupEnd) > 0) {
                int i2 = 2 + --l * 4;
                g.setColor(PrintFormat.TitleColor);
                if (l < 0) {
                    l = 0;
                }
                g.drawLine(i2, ai[l], rectangle.x + rectangle.width - 3, ai[l]);
                g.drawLine(i2, ai[l] + 1, rectangle.x + rectangle.width - 3, ai[l] + 1);
                g.drawLine(i2, ai[l], i2, j);
                g.drawLine(i2 + 1, ai[l], i2 + 1, j);
                g.drawLine(i2, j, rectangle.x + rectangle.width - 3, j);
                g.drawLine(i2, j + 1, rectangle.x + rectangle.width - 3, j + 1);
            }
            if ((row.options & PrintFormat.Row.rowSelected) > 0) {
                g.setColor(Color.black);
                g.fillRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
            }
            if (s.length() > 0) {
                AwtUtil.drawText(g, s, rectangle, PrintFormat.defaultFont, (row.options & PrintFormat.Row.rowSelected) <= 0 ? PrintFormat.TitleColor : Color.white, PrintFormat.FormulaCell.cellAlignCenter | PrintFormat.FormulaCell.cellAlignVCenter, 0);
            }
            ++j1;
        }
        if (!this.pane.bShowRuler) {
            return;
        }
        g.drawLine(dimension.width - 1, 0, dimension.width, dimension.height - 1);
        int l1 = 0;
        while (l1 < (int)((double)dimension.height / this.pane.cmScale)) {
            int byte0 = 3;
            if (l1 % 10 == 0) {
                byte0 = 11;
            } else if (l1 % 5 == 0) {
                byte0 = 7;
            }
            int k = (int)(this.pane.cmScale * (double)l1);
            g.drawLine(dimension.width - byte0, k, dimension.width - 1, k);
            ++l1;
        }
    }

    public void adjustSize() {
        if (this.pane != null) {
            Dimension dimension = this.pane.getSize();
            this.setBounds(0, 0, nVRuleWidth, dimension.height);
        }
    }

    int findRowIndex(int i) {
        this.bAtLine = false;
        int j = 0;
        int k = 0;
        Enumeration enumeration = this.pane.format.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Row row = (PrintFormat.Row)enumeration.nextElement();
            if (i - (j = (int)((double)j + row.height)) <= 1 && i - j >= -1) {
                this.bAtLine = true;
                return k;
            }
            if (i < j) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    void invalidateRow(int i) {
        if (i >= 0 && i <= this.pane.format.gridRows) {
            Dimension dimension = this.getSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            rectangle.y = (int)this.pane.format.getRowLine(i - 1);
            rectangle.height = (int)this.pane.format.getRowLine(i) - rectangle.y;
            this.repaint(rectangle);
        }
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent mouseevent) {
        this.pane.endEdit();
        if (this.resizeRow >= 0) {
            if (this.resizeState == 1) {
                PrintFormat.Row row = this.pane.format.getRow(this.resizeRow);
                this.oldRowHeight = row.height;
                this.resizeYLeft = (int)this.pane.format.getRowLine(this.resizeRow - 1);
                this.resizeState = 2;
                this.drawDragFlag();
                return;
            }
            if (this.resizeState == 3) {
                this.resizeState = 4;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseevent) {
        if (this.resizeState == 2) {
            this.resizeState = 1;
            PrintFormat.Row row = this.pane.format.getRow(this.resizeRow);
            this.pane.incRowHeight(this.resizeRow, this.oldRowHeight - row.height);
            this.drawDragFlag();
            this.repaint();
        } else if (this.resizeState == 4) {
            this.resizeState = 3;
            boolean flag = mouseevent.isControlDown();
            if (mouseevent.isShiftDown() && flag) {
                int i = this.findRowIndex(mouseevent.getY());
                PrintFormat.Row row1 = this.pane.format.getRow(i);
                if (this.pane.pUniqueSelectedRow != null && row1 != null && this.pane.pUniqueSelectedRow != row1) {
                    if (JOptionPane.showConfirmDialog(this, "Copy Row?") == 0) {
                        this.pane.setRow(i, this.pane.pUniqueSelectedRow);
                    }
                    return;
                }
            }
            if (!flag) {
                this.pane.clearAllSelectedGridCell(true);
            }
            this.pane.selectRow(this.resizeRow, true);
        }
    }

    public void mouseExited(MouseEvent mouseevent) {
    }

    public void mouseDragged(MouseEvent mouseevent) {
        int i;
        if (this.resizeState == 2 && (i = mouseevent.getY()) > this.resizeYLeft + 2) {
            this.drawDragFlag();
            this.oldRowHeight = i - this.resizeYLeft;
            this.drawDragFlag();
            this.repaint(0, 0, 1, 1);
        }
    }

    public void mouseMoved(MouseEvent mouseevent) {
        int i = mouseevent.getX();
        int j = mouseevent.getY();
        if (i >= 2 && i <= nVRuleWidth - 2) {
            int k = this.findRowIndex(j);
            if (this.bAtLine) {
                if (this.getCursor().getType() != 8) {
                    this.setCursor(Cursor.getPredefinedCursor(8));
                }
                if (this.resizeState != 2) {
                    this.repaint(j, 0, 1, nVRuleWidth);
                }
                this.resizeState = 1;
                this.resizeRow = k;
                return;
            }
            if (k >= 0) {
                if (this.getCursor().getType() != 0) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                this.resizeState = 3;
                this.resizeRow = k;
                return;
            }
        }
        if (this.getCursor().getType() != 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.resizeState != 0) {
            this.repaint();
        }
        this.resizeState = 0;
        this.resizeRow = -1;
    }
}

