/*
 * Decompiled with CFR 0.152.
 */
package softcore.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import softcore.swing.OpenSwingUtil;

public class JDayLabel
extends JLabel {
    private static ImageIcon todayIcon = OpenSwingUtil.getOpenSwingImage("today.gif", new ImageIcon());
    Date date = null;
    ImageIcon currentIcon = null;
    final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
    final SimpleDateFormat dayFormat = new SimpleDateFormat("d");

    public JDayLabel(Date date) {
        this(date, true);
    }

    public JDayLabel(Date date, boolean isSmallLabel) {
        this.setPreferredSize(new Dimension(40, 20));
        this.setToolTipText(this.dateFormat.format(date));
        this.date = date;
        if (isSmallLabel) {
            this.setHorizontalAlignment(0);
            this.setText(this.dayFormat.format(date));
            Date d = new Date();
            if (this.dateFormat.format(date).equals(this.dateFormat.format(d))) {
                this.currentIcon = todayIcon;
            }
        } else {
            this.setText("Today:" + this.dateFormat.format(new Date()));
            this.setIcon(todayIcon);
            this.setHorizontalAlignment(2);
        }
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.currentIcon != null && this.isEnabled()) {
            int x = (this.getWidth() - this.currentIcon.getIconWidth()) / 2;
            int y = (this.getHeight() - this.currentIcon.getIconHeight()) / 2;
            this.currentIcon.paintIcon(this, g, x, y);
        }
    }
}

