/*
 * Decompiled with CFR 0.152.
 */
package softcore.table;

import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Variant;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import softcore.table.CodeNameMap;
import softcore.table.CodeNameMapLoadListener;
import softcore.util.JDBC;
import softcore.util.Utilities;

public class CodeNameSortedArray
implements CodeNameMap,
Runnable {
    protected Object[][] a;
    private boolean sorted = true;
    boolean loadCashedData;
    boolean needResort;
    CodeNameMapLoadListener[] listListener;
    private Connection con;
    private String sql;
    public boolean dataLoaded;
    protected int numCols;

    public void setArray(Object[][] aobj, boolean flag) {
        this.a = aobj;
        this.sorted = flag;
        if (aobj != null && aobj.length > 0 && aobj[0] != null) {
            this.numCols = aobj[0].length;
        }
    }

    public int loadFromJdbc(Connection connection, String s) throws SQLException {
        this.sql = s;
        this.con = connection;
        this.a = new Object[0][];
        this.loadCashedData = connection == null || connection == JDBC.getDefaultJdbcConnection();
        Object[][] objectArray = this.a = this.loadCashedData ? JDBC.loadCacheableValues(s) : JDBC.sqlSelect3(connection, s);
        if (this.a != null && this.a.length > 0 && this.a[0] != null) {
            this.numCols = this.a[0].length;
        }
        if (this.needResort || CodeNameSortedArray.needResortForSql(s)) {
            this.resort();
        }
        return this.a != null ? this.a.length : 0;
    }

    public void removeRow1() {
        if (this.a == null || this.a.length <= 1) {
            return;
        }
        String s = (String)this.a[0][0];
        int i = s.length();
        int j = 1;
        while (j < this.a.length) {
            String s1 = (String)this.a[j][0];
            if (s1.length() <= i || !s1.startsWith(s)) {
                return;
            }
            ++j;
        }
        Object[][] aobj = this.a;
        this.a = new Object[this.a.length - 1][];
        System.arraycopy(aobj, 0, this.a, 0, aobj.length);
    }

    private static int parseCountSqlSelect(String s) {
        int j;
        int i;
        block7: {
            block6: {
                s = s.toLowerCase();
                i = s.indexOf("select");
                if (i >= 0) break block6;
                return 0;
            }
            j = s.indexOf("from", i + 6);
            if (j >= 0) break block7;
            return 0;
        }
        try {
            String[] as = new String[256];
            Utilities.parseParameterList("(" + s.substring(i + 6, j) + ")", 0, as);
            int k = 0;
            while (k < as.length) {
                if (as[k] == null) {
                    return k;
                }
                ++k;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    static boolean needResortForSql(String s) {
        return s != null && s.toLowerCase().indexOf("order by") < 0;
    }

    public void synLoadFromJdbc(Connection connection, String s) {
        this.synLoadFromJdbc(connection, s, false);
    }

    public void synLoadFromJdbc(Connection connection, String s, boolean flag) {
        this.numCols = CodeNameSortedArray.parseCountSqlSelect(s);
        boolean bl = this.loadCashedData = connection == null || connection == JDBC.getDefaultJdbcConnection();
        if (connection == null) {
            connection = JDBC.getDefaultJdbcConnection();
        }
        this.sql = s;
        this.con = connection;
        Object[][] objectArrayArray = this.a = flag ? null : new Object[][]{};
        if (!flag) {
            this._synLoadFromJdbc();
        }
    }

    protected void loadForNeed() {
        if (this.a == null && this.sql != null) {
            this.refresh(false);
        }
    }

    public void setNeedResort(boolean flag) {
        this.needResort = flag;
    }

    public void resort() {
        if (this.a != null) {
            Arrays.sort(this.a, new ValueCompare());
        }
        this.sorted = true;
    }

    private void _synLoadFromJdbc() {
        boolean flag = true;
        if (this.con != null && this.con.getClass().getName().indexOf("oracle") >= 0) {
            flag = false;
        }
        if (!flag) {
            this.run();
            return;
        }
        Thread thread2 = new Thread(this);
        thread2.setPriority(1);
        thread2.start();
    }

    public void refresh(boolean flag) {
        try {
            if (flag) {
                this._synLoadFromJdbc();
            } else {
                Object[][] objectArray = this.a = this.loadCashedData ? JDBC.loadCacheableValues(this.sql) : JDBC.sqlSelect3(this.con, this.sql);
                if (this.a != null && this.a.length > 0 && this.a[0] != null) {
                    this.numCols = this.a[0].length;
                }
                if (this.needResort || CodeNameSortedArray.needResortForSql(this.sql)) {
                    this.resort();
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception.getMessage());
        }
    }

    public String linearSearch(Object obj) {
        int i = this.indexLinearSearch(obj);
        return i < 0 ? null : (String)this.a[i][1];
    }

    public int indexLinearSearch(Object obj) {
        this.loadForNeed();
        if (obj == null || this.a == null) {
            return -1;
        }
        int i = 0;
        while (i < this.a.length) {
            if (obj.equals(this.a[i][0])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getNameByCode(Object obj) {
        if (!this.sorted) {
            return this.linearSearch(obj);
        }
        if (obj instanceof String) {
            return this.getNameByStringCode((String)obj);
        }
        if (obj instanceof Number) {
            return this.getNameByIntCode(((Number)obj).intValue());
        }
        return null;
    }

    public int getIndexForCode(Object obj) {
        this.loadForNeed();
        if (!this.sorted) {
            return this.indexLinearSearch(obj);
        }
        if (obj instanceof String) {
            return Utilities.binarySearch(this.a, (String)obj);
        }
        if (obj instanceof Number) {
            return this.getIndexForIntCode(((Number)obj).intValue());
        }
        return -1;
    }

    protected String getNameByStringCode(String s) {
        this.loadForNeed();
        int i = Utilities.binarySearchx(this.a, s);
        return i < 0 ? null : (String)this.a[i][1];
    }

    protected String getNameByIntCode(int i) {
        int j = this.getIndexForIntCode(i);
        return j < 0 ? null : (String)this.a[j][1];
    }

    protected int getIndexForIntCode(int i) {
        this.loadForNeed();
        if (this.a == null) {
            return -1;
        }
        int j = 0;
        int k = this.a.length - 1;
        while (j <= k) {
            int l = (j + k) / 2;
            int i1 = ((Number)this.a[l][0]).intValue() - i;
            if (i1 < 0) {
                j = l + 1;
                continue;
            }
            if (i1 > 0) {
                k = l - 1;
                continue;
            }
            return l;
        }
        return -1;
    }

    public Object[][] getCodeNameAsArray() {
        return this.a;
    }

    public int loadFromDataSet(DataSet dataset) throws DataSetException {
        if (dataset == null) {
            return 0;
        }
        int i = dataset.getRowCount();
        if (i == 0) {
            return 0;
        }
        this.a = new Object[i][];
        dataset.first();
        Variant variant = new Variant();
        int j = 0;
        while (j < i) {
            this.a[j] = new Object[2];
            dataset.getVariant(0, variant);
            this.a[j][0] = variant.getAsObject();
            dataset.getVariant(1, variant);
            this.a[j][1] = variant.getAsObject();
            dataset.next();
            ++j;
        }
        return i;
    }

    public void addCodeNameMapLoadListener(CodeNameMapLoadListener codenamemaploadlistener) {
        int i = this.listListener != null ? this.listListener.length : 0;
        CodeNameMapLoadListener[] acodenamemaploadlistener = this.listListener;
        this.listListener = new CodeNameMapLoadListener[i + 1];
        if (acodenamemaploadlistener != null) {
            System.arraycopy(acodenamemaploadlistener, 0, this.listListener, 0, i);
        }
        this.listListener[i] = codenamemaploadlistener;
    }

    public String getSql() {
        return this.sql;
    }

    public void loadDict(String sql) {
        try {
            if (sql.indexOf("|") < 0) {
                this.a = JDBC.loadCacheableValues(sql);
            } else if (sql.indexOf("|") > 0) {
                String[] s = Utilities.splitString(sql, '|');
                this.a = JDBC.loadCacheableValues(s[0]);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.loadCashedData) {
            try {
                this.a = JDBC.loadCacheableValues(this.sql);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage());
            }
            this.dataLoaded = true;
            return;
        }
        var1_2 = this;
        synchronized (var1_2) {
            var2_3 = this.con;
            synchronized (var2_3) {
                block32: {
                    block29: {
                        System.err.println("start load:" + this.sql);
                        i = 0;
                        statement = null;
                        resultset = null;
                        try {
                            try {
                                this.a = null;
                                this.dataLoaded = false;
                                statement = this.con.createStatement();
                                resultset = statement.executeQuery(this.sql);
                                this.numCols = resultset.getMetaData().getColumnCount();
                                aobj = new Object[16][];
                                block19: while (true) {
                                    if (!resultset.next()) {
                                        if (i > 0) {
                                            this.appendData(aobj, i);
                                        }
                                        break;
                                    }
                                    aobj1 = new Object[this.numCols];
                                    j = 0;
                                    while (true) {
                                        if (j >= this.numCols) {
                                            if (aobj1[0] == null) continue block19;
                                            aobj[i++] = aobj1;
                                            if (i != 16) continue block19;
                                            this.appendData(aobj, 16);
                                            i = 0;
                                            continue block19;
                                        }
                                        aobj1[j] = resultset.getObject(j + 1);
                                        ++j;
                                    }
                                    break;
                                }
                            }
                            catch (SQLException sqlexception) {
                                System.err.println(String.valueOf(sqlexception.getMessage()) + ":" + this.sql + "[roucount=" + ((this.a != null ? this.a.length : 0) + i) + "]");
                                sqlexception.printStackTrace();
                                throw new RuntimeException(sqlexception.getMessage());
                            }
                            var9_13 = null;
                            if (resultset == null) break block29;
                        }
                        catch (Throwable var10_11) {
                            var9_12 = null;
                            if (resultset != null) {
                                try {
                                    resultset.close();
                                }
                                catch (Throwable throwable1) {
                                    throwable1.printStackTrace();
                                }
                            }
                            resultset = null;
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable2.printStackTrace();
                                }
                            }
                            statement = null;
                            this.dataLoaded = true;
                            throw var10_11;
                        }
                        ** try [egrp 5[TRYBLOCK] [4 : 349->359)] { 
lbl75:
                        // 1 sources

                        resultset.close();
                        break block29;
lbl77:
                        // 1 sources

                        catch (Throwable throwable1) {
                            throwable1.printStackTrace();
                        }
                    }
                    resultset = null;
                    if (statement != null) {
                        ** try [egrp 6[TRYBLOCK] [5 : 374->384)] { 
lbl83:
                        // 1 sources

                        statement.close();
                        break block32;
lbl85:
                        // 1 sources

                        catch (Throwable throwable2) {
                            throwable2.printStackTrace();
                        }
                    }
                }
                statement = null;
                this.dataLoaded = true;
            }
            return;
        }
    }

    private void appendData(Object[][] aobj, int i) {
        Object[][] aobj1 = new Object[(this.a != null ? this.a.length : 0) + i][];
        if (this.a != null) {
            System.arraycopy(this.a, 0, aobj1, 0, this.a.length);
        }
        System.arraycopy(aobj, 0, aobj1, this.a != null ? this.a.length : 0, i);
        this.a = aobj1;
    }

    private static class ValueCompare
    implements Comparator {
        public int compare(Object obj, Object obj1) {
            obj = ((Object[])obj)[0];
            if ((obj1 = ((Object[])obj1)[0]) instanceof String) {
                return (obj != null ? obj.toString() : "").compareTo((String)obj1);
            }
            if (obj1 instanceof Number) {
                int i = obj instanceof Number ? ((Number)obj).intValue() : 0;
                return i - ((Number)obj1).intValue();
            }
            if (obj1 == null) {
                return obj != null ? 1 : 0;
            }
            throw new RuntimeException("o2=" + obj1);
        }

        private ValueCompare() {
        }
    }
}

