/*
 * Decompiled with CFR 0.152.
 */
package softcore.table;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.SortDescriptor;
import com.borland.dx.dataset.Variant;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import softcore.table.TableCellDataAccess;
import softcore.table.TableColumn;
import softcore.util.Utilities;

public class CrossTableCellDataAccess
implements TableCellDataAccess {
    DataSet surceDataSet;
    String[] columns;
    Object[] values;
    String nameDataColumn;
    int dataColumnBit = -1;
    public boolean binarySeek;
    private DataRow rwData;
    private final Variant tmpVariant = new Variant();

    public String[] getColumns() {
        return this.columns;
    }

    public CrossTableCellDataAccess(DataSet dataset, String[] as, Object[] aobj, String s, int i) {
        String[] as1;
        if (aobj.length != as.length) {
            throw new IllegalArgumentException();
        }
        this.surceDataSet = dataset;
        this.columns = as;
        this.values = aobj;
        this.nameDataColumn = s;
        this.dataColumnBit = i;
        SortDescriptor sortdescriptor = dataset.getSort();
        String[] stringArray = as1 = sortdescriptor != null ? sortdescriptor.getKeys() : null;
        if (as1 != null && as1.length == as.length) {
            int j = 0;
            while (j < as1.length && as1[j].equalsIgnoreCase(as[j])) {
                ++j;
            }
            this.binarySeek = j == as1.length;
        }
    }

    public CrossTableCellDataAccess(DataSet dataset, String[] as, Object[] aobj, String s) {
        this(dataset, as, aobj, s, -1);
    }

    private String getValueFromCellId(String s, int i) {
        int j = s.indexOf(123);
        if (j < 0) {
            return null;
        }
        int k = s.indexOf(125, j);
        return Utilities.subSplitString(s.substring(j + 1, k), ',', i);
    }

    public Object[] forEachColumns(DataRow datarow, DataSet dataset, DataSet dataset1, int i, TableColumn tablecolumn) throws DataSetException {
        Object[] aobj = new Object[this.columns.length];
        int j = 0;
        while (j < this.columns.length) {
            Variant variant;
            if (this.values[j] instanceof Variant) {
                variant = (Variant)this.values[j];
            } else if (this.values[j] instanceof String) {
                variant = this.tmpVariant;
                if (i >= 0) {
                    dataset1.getVariant((String)this.values[j], i, variant);
                } else {
                    dataset1.getVariant((String)this.values[j], variant);
                }
            } else if (this.values[j] instanceof Integer) {
                int k = (Integer)this.values[j];
                String s = this.getValueFromCellId(tablecolumn.cellId, k);
                if (s == null) {
                    throw new IllegalArgumentException();
                }
                Column column = this.surceDataSet.getColumn(this.columns[j]);
                int l = column.getDataType();
                Object obj = Utilities.parseStringFromVariantType(s, l);
                if (obj == null) {
                    throw new IllegalArgumentException();
                }
                variant = this.tmpVariant;
                variant.setAsObject(obj, l);
            } else {
                throw new IllegalArgumentException();
            }
            try {
                aobj[j] = variant.getAsObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (datarow != null) {
                Utilities.toCompatibleVariant((ReadRow)datarow, j, variant);
                datarow.setVariant(j, variant);
            }
            if (dataset != null) {
                Utilities.toCompatibleVariant((ReadRow)dataset, this.columns[j], variant);
                dataset.setVariant(this.columns[j], variant);
            }
            ++j;
        }
        return aobj;
    }

    boolean locate(DataSet dataset, int i, TableColumn tablecolumn) throws DataSetException {
        if (this.binarySeek) {
            Object[] aobj = this.forEachColumns(null, null, dataset, i, tablecolumn);
            return Utilities.seekDataSet(this.surceDataSet, this.columns, aobj);
        }
        if (this.rwData == null) {
            this.rwData = new DataRow(this.surceDataSet, this.columns);
        }
        this.forEachColumns(this.rwData, null, dataset, i, tablecolumn);
        return this.surceDataSet.locate((ReadRow)this.rwData, 32);
    }

    public boolean getTableCellData(DataSet dataset, int i, TableColumn tablecolumn, Variant variant) throws DataSetException {
        if (!this.locate(dataset, i, tablecolumn)) {
            variant.setAssignedNull();
        } else if (this.nameDataColumn == null) {
            variant.setBoolean(true);
        } else {
            this.surceDataSet.getVariant(this.nameDataColumn, variant);
            if (this.dataColumnBit >= 0) {
                int j = variant.getAsInt();
                variant.setBoolean((j & 1 << this.dataColumnBit) != 0);
            }
        }
        return true;
    }

    public boolean setTableCellData(DataSet dataset, TableColumn tablecolumn, Variant variant) throws DataSetException {
        if (!this.locate(dataset, -1, tablecolumn)) {
            this.surceDataSet.insertRow(false);
            this.forEachColumns(null, this.surceDataSet, dataset, -1, tablecolumn);
        }
        Column column = this.surceDataSet.getColumn(this.nameDataColumn);
        int i = column.getDataType();
        Object obj = variant.getAsObject();
        if (this.dataColumnBit >= 0) {
            this.surceDataSet.getVariant(this.nameDataColumn, variant);
            int j = variant.getAsInt();
            j = obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue() ? (j |= 1 << this.dataColumnBit) : (j &= ~(1 << this.dataColumnBit));
            if (i == 2) {
                variant.setByte((byte)j);
            } else if (i == 3) {
                variant.setShort((short)j);
            } else if (i == 10) {
                variant.setBigDecimal(new BigDecimal((double)j));
            } else {
                variant.setInt(j);
            }
        }
        if (i == 12) {
            if (obj instanceof String) {
                variant.setInputStream((InputStream)new ByteArrayInputStream(((String)obj).getBytes()));
            } else if (obj instanceof byte[]) {
                variant.setInputStream((InputStream)new ByteArrayInputStream((byte[])obj));
            }
        }
        this.surceDataSet.setVariant(this.nameDataColumn, variant);
        this.surceDataSet.post();
        return true;
    }
}

