/*
 * Decompiled with CFR 0.152.
 */
package softcore.table;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.LoadListener;
import com.borland.dx.dataset.MasterLinkDescriptor;
import com.borland.dx.dataset.ReadWriteRow;
import com.borland.dx.dataset.SortDescriptor;
import com.borland.dx.sql.dataset.Database;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import softcore.awt.ScrollBarPanel;
import softcore.table.DataSetAccess;
import softcore.table.Table;
import softcore.tac.Tac;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softface.MainFrame;
import softface.mdi.JMDIDesktopPane;
import softface.mdi.JMDIFrame;

public class DataWindow
implements InternalFrameListener,
ItemListener {
    protected Connection connection;
    protected Database database;
    protected Vector allDataSet = new Vector();
    protected Vector allTable = new Vector();
    DataWindowFrame frame;
    private static Class defaultDataWindowClass;
    protected Dictionary displaynameMap;
    protected DataSetAccess dataSetAccess;
    public JCheckBox lockCheckBox;
    Component firstFocus;
    Component focusOnDeactivated;
    public int closeLock;
    static /* synthetic */ Class class$0;

    public void internalFrameOpened(InternalFrameEvent internalframeevent) {
    }

    public void internalFrameClosing(InternalFrameEvent internalframeevent) {
    }

    public void internalFrameClosed(InternalFrameEvent internalframeevent) {
        this.close();
        this.onWindowClosed();
    }

    public void internalFrameIconified(InternalFrameEvent internalframeevent) {
    }

    public void internalFrameDeiconified(InternalFrameEvent internalframeevent) {
    }

    public void internalFrameActivated(InternalFrameEvent internalframeevent) {
        if (internalframeevent.getSource() == this.frame) {
            this.showLockCheckBox(true);
        }
        if (internalframeevent.getSource() == this.frame) {
            this.frame.restoreSubcomponentFocus();
            if (this.focusOnDeactivated != null && this.frame.isAncestorOf(this.focusOnDeactivated)) {
                this.focusOnDeactivated.requestFocus();
            } else if (this.firstFocus != null) {
                this.firstFocus.requestFocus();
            }
        }
    }

    public void internalFrameDeactivated(InternalFrameEvent internalframeevent) {
        if (this.lockCheckBox != null) {
            this.lockCheckBox.setVisible(false);
        }
        if (internalframeevent.getSource() == this.frame) {
            this.frame.restoreSubcomponentFocus();
            Component component = this.frame.getFocusOwner();
            if (component != null && this.frame.isAncestorOf(component)) {
                this.focusOnDeactivated = component;
            }
            return;
        }
    }

    public DataWindow() {
        this((Connection)null);
    }

    public DataWindow(Connection connection1) {
        System.gc();
        if (connection1 == null) {
            connection1 = JDBC.getDefaultJdbcConnection();
        }
        this.connection = connection1;
        this.database = new Database(connection1);
        this.database.setIdentifierQuoteChar('\u0000');
        try {
            if (connection1 != null && connection1.getMetaData().getDatabaseProductName().indexOf("Oracle") >= 0) {
                this.database.setUseSetObjectForStreams(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.addLockCheckbox();
    }

    private void addLockCheckbox() {
        if (MainFrame.getAppToolBar() != null) {
            this.lockCheckBox = new JCheckBox("\u7f16\u8f91\u7981\u6b62", MainFrame.getAppIntOption(90, 8) == 1);
            this.lockCheckBox.setFont(new Font("Dialog", 0, 12));
            Dimension dimension = this.lockCheckBox.getPreferredSize();
            dimension.height = 24;
            this.lockCheckBox.setPreferredSize(dimension);
            this.lockCheckBox.setRequestFocusEnabled(false);
            this.lockCheckBox.setVisible(false);
            this.lockCheckBox.addItemListener(this);
            MainFrame.getAppToolBar().add(this.lockCheckBox);
        }
    }

    public void itemStateChanged(ItemEvent itemevent) {
        if (itemevent.getSource() == this.lockCheckBox) {
            try {
                MainFrame.getAppToolBar().updateDatasetButtonEnabledState();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public DataWindow(Database database1) {
        this.database = database1;
        if (database1 != null) {
            database1.setIdentifierQuoteChar('\u0000');
        }
        try {
            this.connection = database1.getJdbcConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addLockCheckbox();
    }

    protected void onWindowOpened() {
    }

    protected void onWindowClosed() {
    }

    public static void setDefaultDataWindowClass(Class class1) {
        defaultDataWindowClass = class1;
    }

    public static DataWindow newDefaultDataWindow() {
        if (defaultDataWindowClass == null) {
            return new DataWindow();
        }
        try {
            return (DataWindow)defaultDataWindowClass.newInstance();
        }
        catch (Exception exception) {
            return new DataWindow();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addDisplaynameMapFromSql(String s, String s1) {
        if (s1 == null) {
            s1 = "";
        }
        try {
            Connection connection1 = this.database.getJdbcConnection();
            if (connection1 == null) {
                return;
            }
            if (this.displaynameMap == null) {
                this.displaynameMap = new Hashtable();
            }
            Statement statement = connection1.createStatement();
            try {
                ResultSet resultset = statement.executeQuery(s);
                try {
                    while (resultset.next()) {
                        String s2 = (String.valueOf(s1) + resultset.getObject(1)).toLowerCase();
                        Object obj = resultset.getObject(2);
                        this.displaynameMap.put(s2, obj);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    resultset.close();
                    throw throwable;
                }
                {
                    Object var8_11 = null;
                    resultset.close();
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                statement.close();
                throw throwable;
            }
            {
                Object var10_14 = null;
                statement.close();
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDisplaynameMap(Dictionary dictionary) {
        this.displaynameMap = dictionary;
    }

    public void addDisplaynameMapFromTablename(String s) {
    }

    public Object[][] getTableColumnType(String s) throws SQLException {
        return null;
    }

    public String[] getTablePrimaryKey(String s) throws SQLException {
        return s != null ? JDBC.getTablePrimaryKey(this.connection, s) : null;
    }

    public String[] getTableNotNullColumn(String s) throws SQLException {
        return null;
    }

    public SortDescriptor getTableSortDescriptor(String s) throws SQLException {
        String[] as = this.getTablePrimaryKey(s);
        return as != null ? new SortDescriptor(null, as, null, true, as.length == 1, null) : null;
    }

    public void removeAllDataSet() {
        while (this.allDataSet.size() > 0) {
            Object obj = this.allDataSet.elementAt(0);
            this.removeDataSet((DataSet)obj);
        }
    }

    public void removeAllTable() {
        while (this.allTable.size() > 0) {
            Object obj = this.allTable.elementAt(0);
            this.removeTable((Table)obj);
        }
    }

    public void close() {
        if (this.dataSetAccess instanceof Table) {
            ((Table)this.dataSetAccess).onClosed();
            this.dataSetAccess = null;
        }
        this.firstFocus = null;
        this.focusOnDeactivated = null;
        this.removeAllDataSet();
        this.removeAllTable();
        this.setDataSetAccess(null);
        if (MainFrame.getAppToolBar() != null && this.lockCheckBox != null) {
            try {
                MainFrame.getAppToolBar().remove(this.lockCheckBox);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void addDataSet(DataSet dataset) {
        if (!this.allDataSet.contains(dataset)) {
            this.allDataSet.addElement(dataset);
        }
    }

    public DataSet findDataSet(String s) {
        s = JDBC.sqlNormalize(s);
        int i = 0;
        while (i < this.allDataSet.size()) {
            String s1;
            QueryDescriptor querydescriptor;
            DataSet dataset = (DataSet)this.allDataSet.elementAt(i);
            if (dataset instanceof QueryDataSet && (querydescriptor = ((QueryDataSet)dataset).getQuery()) != null && (s1 = JDBC.sqlNormalize(querydescriptor.getQueryString())) != null && s.equals(s1)) {
                return dataset;
            }
            ++i;
        }
        return null;
    }

    public void removeDataSet(DataSet dataset) {
        if (this.allDataSet.contains(dataset)) {
            this.allDataSet.removeElement(dataset);
            try {
                if (MainFrame.getAppToolBar().getFocusedDataSet() == dataset) {
                    MainFrame.getAppToolBar().setDataSetAccess(null);
                }
                dataset.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addTable(Table table) {
        if (!this.allTable.contains(table)) {
            this.allTable.addElement(table);
            table.lockEditCheckBox();
        }
    }

    public void removeTable(Table table) {
        if (this.allTable.contains(table)) {
            try {
                if (MainFrame.getAppToolBar().getDataSetAccess() == table) {
                    MainFrame.getAppToolBar().setDataSetAccess(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.allTable.removeElement(table);
            table.setDataSet(null);
        }
    }

    public void setDataSetAccess(DataSetAccess datasetaccess) {
        this.dataSetAccess = datasetaccess;
    }

    public DataSetAccess getDataSetAccess() {
        return this.dataSetAccess;
    }

    public QueryDataSet openQueryDataSet(String s) throws DataSetException {
        return this.openQueryDataSet(new OpenQueryDataSetDescriptor(s));
    }

    public QueryDataSet openQueryDataSet(String s, boolean flag) throws DataSetException {
        OpenQueryDataSetDescriptor openquerydatasetdescriptor = new OpenQueryDataSetDescriptor(s);
        openquerydatasetdescriptor.asynchronousExecution = flag;
        return this.openQueryDataSet(openquerydatasetdescriptor);
    }

    public QueryDataSet openQueryDataSet(String s, boolean flag, MasterLinkDescriptor masterlinkdescriptor) throws DataSetException {
        OpenQueryDataSetDescriptor openquerydatasetdescriptor = new OpenQueryDataSetDescriptor(s);
        openquerydatasetdescriptor.asynchronousExecution = flag;
        openquerydatasetdescriptor.masterLinkDescriptor = masterlinkdescriptor;
        return this.openQueryDataSet(openquerydatasetdescriptor);
    }

    public QueryDataSet openQueryDataSet(String s, boolean flag, MasterLinkDescriptor masterlinkdescriptor, Column[] acolumn) throws DataSetException {
        OpenQueryDataSetDescriptor openquerydatasetdescriptor = new OpenQueryDataSetDescriptor(s);
        openquerydatasetdescriptor.asynchronousExecution = flag;
        openquerydatasetdescriptor.masterLinkDescriptor = masterlinkdescriptor;
        openquerydatasetdescriptor.moreColumns = acolumn;
        return this.openQueryDataSet(openquerydatasetdescriptor);
    }

    public QueryDataSet openQueryDataSet(Database database1, String s, ReadWriteRow readwriterow, boolean flag, boolean flag1, MasterLinkDescriptor masterlinkdescriptor, Column[] acolumn, boolean flag2) throws DataSetException {
        OpenQueryDataSetDescriptor openquerydatasetdescriptor = new OpenQueryDataSetDescriptor(s);
        openquerydatasetdescriptor.database = database1;
        openquerydatasetdescriptor.parameters = readwriterow;
        openquerydatasetdescriptor.executeOnOpen = flag;
        openquerydatasetdescriptor.asynchronousExecution = flag1;
        openquerydatasetdescriptor.masterLinkDescriptor = masterlinkdescriptor;
        openquerydatasetdescriptor.moreColumns = acolumn;
        openquerydatasetdescriptor.registerForClose = flag2;
        return this.openQueryDataSet(openquerydatasetdescriptor);
    }

    public QueryDataSet openQueryDataSet(OpenQueryDataSetDescriptor openquerydatasetdescriptor) throws DataSetException {
        if (openquerydatasetdescriptor.database == null) {
            openquerydatasetdescriptor.database = this.database;
        }
        openquerydatasetdescriptor.database.setUseSpacePadding(true);
        if (openquerydatasetdescriptor.dataSet == null) {
            openquerydatasetdescriptor.dataSet = new QueryDataSet();
        }
        if (openquerydatasetdescriptor.masterLinkDescriptor != null) {
            openquerydatasetdescriptor.dataSet.setMasterLink(openquerydatasetdescriptor.masterLinkDescriptor);
        }
        if (openquerydatasetdescriptor.query != null) {
            int i;
            if (openquerydatasetdescriptor.dataSet.isOpen()) {
                openquerydatasetdescriptor.dataSet.close();
            }
            if ((i = openquerydatasetdescriptor.loadOptions) == 0 && openquerydatasetdescriptor.asynchronousExecution) {
                i |= 1;
            }
            QueryDescriptor querydescriptor = new QueryDescriptor(openquerydatasetdescriptor.database, openquerydatasetdescriptor.query, openquerydatasetdescriptor.parameters, openquerydatasetdescriptor.executeOnOpen, i);
            openquerydatasetdescriptor.dataSet.setQuery(querydescriptor);
            if (openquerydatasetdescriptor.moreColumns != null) {
                openquerydatasetdescriptor.dataSet.setColumns(openquerydatasetdescriptor.moreColumns);
            }
            if (openquerydatasetdescriptor.tableName != null) {
                openquerydatasetdescriptor.dataSet.setTableName(openquerydatasetdescriptor.tableName);
            }
            if (openquerydatasetdescriptor.parameters == null || !(openquerydatasetdescriptor.parameters instanceof DataSet) || ((DataSet)openquerydatasetdescriptor.parameters).isOpen() && ((DataSet)openquerydatasetdescriptor.parameters).getRowCount() > 0) {
                if (openquerydatasetdescriptor.loadListener != null) {
                    openquerydatasetdescriptor.dataSet.addLoadListener(openquerydatasetdescriptor.loadListener);
                }
                try {
                    openquerydatasetdescriptor.dataSet.open();
                }
                catch (DataSetException datasetexception) {
                    datasetexception.printStackTrace();
                    throw new DataSetException(datasetexception.getErrorCode(), String.valueOf(datasetexception.getMessage()) + ":" + openquerydatasetdescriptor.query, (Throwable)datasetexception);
                }
            }
        }
        this.initDataSet(openquerydatasetdescriptor);
        return openquerydatasetdescriptor.dataSet;
    }

    private void initDataSet(OpenQueryDataSetDescriptor openquerydatasetdescriptor) throws DataSetException {
        if (openquerydatasetdescriptor.registerForClose) {
            this.addDataSet((DataSet)openquerydatasetdescriptor.dataSet);
        }
        if (openquerydatasetdescriptor.notNullColumns == null && openquerydatasetdescriptor.tableName != null) {
            try {
                openquerydatasetdescriptor.notNullColumns = this.getTableNotNullColumn(openquerydatasetdescriptor.tableName);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        Column[] acolumn = openquerydatasetdescriptor.dataSet.getColumns();
        if (openquerydatasetdescriptor.seekKeys == null && openquerydatasetdescriptor.tableName != null) {
            try {
                openquerydatasetdescriptor.seekKeys = this.getTablePrimaryKey(openquerydatasetdescriptor.tableName);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (acolumn != null) {
            int i = 0;
            while (i < acolumn.length) {
                if (openquerydatasetdescriptor.seekKeys != null) {
                    boolean flag = Utilities.findAtStringArrayNoCase(openquerydatasetdescriptor.seekKeys, acolumn[i].getColumnName()) >= 0;
                    acolumn[i].setRowId(flag);
                    acolumn[i].setSearchable(flag);
                } else {
                    acolumn[i].setSearchable(acolumn[i].isRowId());
                }
                if (this.displaynameMap != null) {
                    Object obj;
                    String s = acolumn[i].getTableName();
                    if (s == null) {
                        s = openquerydatasetdescriptor.tableName;
                    }
                    if ((obj = this.displaynameMap.get((String.valueOf(s) + '.' + acolumn[i].getColumnName()).toLowerCase())) != null) {
                        acolumn[i].setCaption(obj.toString());
                    }
                }
                ++i;
            }
        }
    }

    public void registerDataSet(DataSet dataset, MasterLinkDescriptor masterlinkdescriptor, boolean flag) throws DataSetException {
        Column[] acolumn;
        if (dataset == null) {
            return;
        }
        if (masterlinkdescriptor != null) {
            dataset.setMasterLink(masterlinkdescriptor);
        }
        if (flag) {
            this.addDataSet(dataset);
        }
        if ((acolumn = dataset.getColumns()) != null) {
            int i = 0;
            while (i < acolumn.length) {
                Object obj;
                if (this.displaynameMap != null && (obj = this.displaynameMap.get((String.valueOf(acolumn[i].getTableName()) + '.' + acolumn[i].getColumnName()).toLowerCase())) != null) {
                    acolumn[i].setCaption(obj.toString());
                }
                ++i;
            }
        }
    }

    public void showLockCheckBox(boolean flag) {
        if (this.lockCheckBox != null) {
            if (this.lockCheckBox.getParent() != null) {
                Component[] acomponent = this.lockCheckBox.getParent().getComponents();
                int i = 0;
                while (i < acomponent.length) {
                    if (acomponent[i] instanceof JCheckBox && "\u7f16\u8f91\u7981\u6b62".equals(((JCheckBox)acomponent[i]).getLabel())) {
                        acomponent[i].setVisible(acomponent[i] == this.lockCheckBox);
                    }
                    ++i;
                }
            }
            this.lockCheckBox.setVisible(true);
        }
    }

    public void saveChanges() {
        if (this.dataSetAccess != null) {
            this.dataSetAccess.save();
        }
    }

    protected boolean onUnsavedExit() {
        int i = 0;
        while (i < this.allTable.size()) {
            Table table = (Table)this.allTable.elementAt(i);
            if (!table.onUnsavedExit()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isClosable() {
        if (this.closeLock > 0) {
            return false;
        }
        if (this.dataSetAccess instanceof Table) {
            Object obj;
            if (!((Table)this.dataSetAccess).isClosable()) {
                return false;
            }
            Tac tac = ((Table)this.dataSetAccess).getInterposeTac();
            Object object = obj = tac != null ? tac.callProc("isWindowClosable", null) : null;
            if (obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
                return false;
            }
        }
        try {
            if (this.dataSetAccess == null || !this.dataSetAccess.isSaveable()) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        int i = Message.showQuestionDialog("\u5b58\u76d8\u786e\u8ba4", "\u6570\u636e\u672a\u5b58\u76d8,\n\u662f\u5426\u5b58\u76d8?\n");
        if (i == 0) {
            try {
                this.saveChanges();
            }
            catch (Exception exception1) {
                Message.showInformationDialog("\u6570\u636e\u5b58\u76d8", "\u6570\u636e\u5b58\u76d8\u5931\u8d25:\n" + exception1.getMessage());
                return false;
            }
            return !this.dataSetAccess.isSaveable();
        }
        return i == 1 && Message.showQuestionDialog("\u5b58\u76d8\u786e\u8ba4", "\u6570\u636e\u672a\u5b58\u76d8,\n\u653e\u5f03\u5b58\u76d8\u9000\u51fa?\n") == 0 && this.onUnsavedExit();
    }

    public JInternalFrame createSqlInternalFrame(String s, JComponent jcomponent, JComponent[] ajcomponent, Table table) throws DataSetException {
        JMDIDesktopPane jMDIDesktopPane = MainFrame.getDesktopPane();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("softcore.table.DataWindow$DataWindowFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.frame = (DataWindowFrame)jMDIDesktopPane.createInternalFrame(s, jcomponent, (Class)clazz);
        this.frame.setDataWindow(this);
        this.frame.setBackground(Color.white);
        try {
            this.frame.setMaximum(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ajcomponent != null) {
            int i = 0;
            while (i < ajcomponent.length) {
                if (ajcomponent[i] != null && ajcomponent[i] instanceof Table) {
                    this.addTable((Table)ajcomponent[i]);
                    if (table != null && table != (Table)ajcomponent[i]) {
                        table.addTableListener((Table)ajcomponent[i]);
                    }
                }
                ++i;
            }
            if (ajcomponent.length > 0) {
                this.firstFocus = ajcomponent[0];
                this.firstFocus.requestFocus();
            }
        }
        this.setDataSetAccess(table);
        this.onWindowOpened();
        return this.frame;
    }

    public JInternalFrame createSqlInternalFrame(String s, JComponent jcomponent, JComponent[] ajcomponent) throws DataSetException {
        return this.createSqlInternalFrame(s, jcomponent, ajcomponent, null);
    }

    public JInternalFrame createSqlInternalFrame(String s, Table table) throws DataSetException {
        this.dataSetAccess = table;
        return this.createSqlInternalFrame(s, new ScrollBarPanel(table, 3), new Table[]{table}, table);
    }

    public static JInternalFrame createSqlInternalFrame(DataWindow datawindow, String s, Connection connection1, Table table) throws DataSetException {
        if (datawindow == null) {
            datawindow = new DataWindow(connection1);
        }
        table.openQueryDataSet(datawindow);
        return datawindow.createSqlInternalFrame(s, table);
    }

    public static JInternalFrame createSqlInternalFrame(DataWindow datawindow, String s, Connection connection1, JComponent jcomponent, JComponent[] ajcomponent, Table table) throws DataSetException {
        if (datawindow == null) {
            datawindow = new DataWindow(connection1);
        }
        if (ajcomponent != null) {
            int i = 0;
            while (i < ajcomponent.length) {
                if (ajcomponent[i] != null && ajcomponent[i] instanceof Table) {
                    ((Table)ajcomponent[i]).openQueryDataSet(datawindow);
                }
                ++i;
            }
        }
        return datawindow.createSqlInternalFrame(s, jcomponent, ajcomponent, table);
    }

    public static JInternalFrame createSqlInternalFrame(DataWindow datawindow, String s, Connection connection1, JComponent jcomponent, JComponent[] ajcomponent) throws DataSetException {
        return DataWindow.createSqlInternalFrame(datawindow, s, connection1, jcomponent, ajcomponent, null);
    }

    protected void finalize() throws Throwable {
        if (MainFrame.getAppToolBar() != null && this.lockCheckBox != null) {
            try {
                MainFrame.getAppToolBar().remove(this.lockCheckBox);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class DataWindowFrame
    extends JMDIFrame
    implements FocusListener,
    PropertyChangeListener {
        DataWindow dataWindow;

        public void setDataWindow(DataWindow datawindow) {
            if (this.dataWindow == datawindow) {
                return;
            }
            if (this.dataWindow != null) {
                this.removeInternalFrameListener(this.dataWindow);
                this.removePropertyChangeListener(this);
            }
            this.dataWindow = datawindow;
            if (this.dataWindow != null) {
                this.addInternalFrameListener(this.dataWindow);
                this.addPropertyChangeListener(this);
            }
        }

        public DataWindow getDataWindow() {
            return this.dataWindow;
        }

        public void doDefaultCloseAction() {
            if (this.dataWindow == null || this.dataWindow.isClosable()) {
                try {
                    this.setClosed(true);
                    this.setVisible(false);
                    this.setSelected(false);
                    this.dispose();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public void setClosed(boolean flag) throws PropertyVetoException {
            super.setClosed(flag);
            if (flag) {
                if (this.dataWindow != null) {
                    this.dataWindow.close();
                }
                this.setDataWindow(null);
            }
        }

        public void focusGained(FocusEvent focusevent) {
        }

        public void focusLost(FocusEvent focusevent) {
        }

        public DataWindowFrame() {
            this.addFocusListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertychangeevent) {
            if (propertychangeevent.getPropertyName().equals("maximum")) {
                this.onMaximizeMinimize();
            } else if (propertychangeevent.getPropertyName().equals("selected")) {
                this.onSelect();
            }
        }

        public void onMaximizeMinimize() {
            if (this.borderNormal == null) {
                this.borderNormal = this.getBorder();
            }
            if (this.isMaximum) {
                if (!this.borderNone) {
                    JInternalFrame[] ajinternalframe = this.getDesktopPane().getAllFrames();
                    int i22 = 0;
                    while (i22 < ajinternalframe.length) {
                        if (ajinternalframe[i22] != this) {
                            try {
                                ajinternalframe[i22].setMaximum(true);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++i22;
                    }
                    try {
                        this.setSelected(true);
                    }
                    catch (Exception i22) {
                        // empty catch block
                    }
                    this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
                    this.borderNone = true;
                    ((BasicInternalFrameUI)this.getUI()).getNorthPane().setPreferredSize(new Dimension(0, 0));
                    if (this.menu != null) {
                        this.menu.setMaximizedFrame(this);
                    }
                }
            } else if (!this.isMaximum && this.borderNone) {
                this.setNormalSize(this.getSize());
                JInternalFrame[] ajinternalframe1 = this.getDesktopPane().getAllFrames();
                int j = 0;
                while (j < ajinternalframe1.length) {
                    if (ajinternalframe1[j] != this) {
                        try {
                            ajinternalframe1[j].setMaximum(false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++j;
                }
                this.borderNone = false;
                ((BasicInternalFrameUI)this.getUI()).getNorthPane().setPreferredSize(new Dimension(this.getNormalSize().width, 23));
                this.setPreferredSize(this.getNormalSize());
                this.setSize(this.getNormalSize());
                this.setBorder(this.borderNormal);
                if (this.menu != null) {
                    this.menu.setMaximizedFrame(null);
                }
                try {
                    this.setSelected(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void onSelect() {
            if (this.isMaximum && this.menu != null) {
                this.menu.setMaximizedFrame(this);
            }
        }
    }

    public static class OpenQueryDataSetDescriptor {
        public QueryDataSet dataSet;
        public Database database;
        public String query;
        public String tableName;
        public ReadWriteRow parameters;
        public boolean executeOnOpen = true;
        public boolean asynchronousExecution = true;
        public int loadOptions;
        public MasterLinkDescriptor masterLinkDescriptor;
        public Column[] moreColumns;
        public boolean registerForClose = true;
        public String[] seekKeys;
        public String[] notNullColumns;
        public Column[] columns;
        public LoadListener loadListener;
        public String[] defaultValueColumns;
        public Object[] defaultValues;
        public boolean setNonNullColumnDefaultValue;

        public OpenQueryDataSetDescriptor() {
        }

        public OpenQueryDataSetDescriptor(String s) {
            this.query = s;
        }
    }
}

