/*
 * Decompiled with CFR 0.152.
 */
package softcore.table;

import com.borland.dx.dataset.DataSetException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Dictionary;
import softcore.table.Table;
import softcore.table.TableColumn;
import softface.MainFrame;
import softface.mdi.JMDIDesktopPane;

public class GridTable
extends Table {
    protected int topFixedRows = 2;
    protected int bottomFixedRows;
    protected int fixedColumnsWidth = 0;
    public int rowHeight;
    protected boolean autoColumnResizable;
    protected boolean columnResizable = true;
    private boolean forceUnhandleNavigationEvent;
    private int resizeColumnState;
    private int resizeColumn;
    private int resizeXLeft;
    private int oldcolDisplayWidth;
    private boolean bDrawLineNo;
    private Color color1 = new Color(240, 240, 240);
    private Color color2 = new Color(204, 204, 255);
    protected int drawedSelectedRow = -1;
    protected int drawedSelectedCol = -1;
    private static String[] tmpCaptionList = new String[8];

    public int getTopFixedRows() {
        return this.topFixedRows;
    }

    public int getBottomFixedRows() {
        return this.bottomFixedRows;
    }

    public int getLeftFixedColumns() {
        return this.leftFixedColumns;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getFixedColumnsWidth() {
        return this.fixedColumnsWidth;
    }

    public void setBottomFixedRows(int i) {
        this.bottomFixedRows = i;
        this.loadCellValueBeforeRowChanged = true;
    }

    public void setLeftFixedColumns(int i) {
        this.leftFixedColumns = i;
    }

    public void setRowHeight(int i) {
        this.rowHeight = i;
    }

    public void setAutoColumnResizable(boolean flag) {
        this.autoColumnResizable = flag;
        this.scrollDisable = flag ? (this.scrollDisable |= 1) : (this.scrollDisable &= 0xFFFFFFFE);
    }

    public GridTable() {
        this.leftFixedColWidth = 8;
    }

    public void updateScrollbar() {
        Dimension dimension = this.getSize();
        if (this.vScrollbar != null && this.rowHeight > 0) {
            int i = dimension.height / this.rowHeight - (this.topFixedRows + this.bottomFixedRows);
            if (i < 1) {
                i = 1;
            }
            this.vScrollbar.setValues(this.yPosition, i, 0, this.getRowCount() + i);
        }
        if (this.hScrollbar != null && this.tableColumns != null) {
            this.hScrollbar.setEnabled(true);
            this.hScrollbar.setValues(this.xPosition, 1, 0, this.tableColumns.length - this.leftFixedColumns);
        }
    }

    public void updateScrollbar(int i) {
        if (!this.hasFocusOrSubComponentHasFocus()) {
            return;
        }
        Dimension dimension = this.getSize();
        if ((i & 1) != 0 && this.vScrollbar != null && this.rowHeight > 0) {
            int j = dimension.height / this.rowHeight - (this.topFixedRows + this.bottomFixedRows);
            if (j < 1) {
                j = 1;
            }
            this.vScrollbar.setEnabled(true);
            this.vScrollbar.setValues(this.yPosition, j, 0, this.getRowCount() + j);
        }
        if ((i & 2) != 0 && this.hScrollbar != null && this.tableColumns != null) {
            this.hScrollbar.setEnabled(true);
            this.hScrollbar.setValues(this.xPosition, 1, 0, this.tableColumns.length - this.leftFixedColumns);
        }
    }

    public final void findLeftFixedColumnsWidth() {
        this.fixedColumnsWidth = 0;
        if (this.tableColumns == null) {
            return;
        }
        int i = this.tableColumns.length;
        int j = 0;
        while (j < this.leftFixedColumns && j < i) {
            TableColumn tablecolumn = this.tableColumns[j];
            this.fixedColumnsWidth += (tablecolumn.options & 1) != 0 ? 0 : tablecolumn.width;
            ++j;
        }
    }

    private static final int fitColumnIncWidth(int i, int j) {
        return j == 0 || i + j >= 1 ? j : 1 - i;
    }

    public final int sizeColumnsToFit(int i) {
        if (!this.autoColumnResizable || this.tableColumns == null) {
            return 0;
        }
        int j = this.tableColumns.length;
        if (i >= j) {
            return 0;
        }
        int k = this.findColumnAtX(j - 1) + ((this.tableColumns[j - 1].options & 1) == 0 ? this.tableColumns[j - 1].width : 0);
        int l = this.getSize().width - k - this.rightFixedColWidth;
        if (l == 0) {
            return 0;
        }
        double d = 0.0;
        int i1 = 0;
        int j1 = 0;
        int k1 = 0;
        int l1 = i;
        while (l1 < j) {
            if ((this.tableColumns[l1].options & 1) == 0) {
                k1 = l1;
                d += this.tableColumns[l1].autoResizeWeight;
                j1 += this.tableColumns[l1].width;
                ++i1;
            }
            ++l1;
        }
        if (i1 == 0) {
            return 0;
        }
        double d1 = l;
        int i2 = 0;
        int j2 = i;
        while (j2 <= k1) {
            if ((this.tableColumns[j2].options & 1) == 0) {
                int k2;
                double d2 = this.tableColumns[j2].autoResizeWeight;
                double d3 = d;
                if (d3 == 0.0) {
                    d3 = j1;
                    d2 = this.tableColumns[j2].width;
                }
                if (d3 == 0.0) {
                    d3 = i1;
                    d2 = 1.0;
                }
                if ((k2 = GridTable.fitColumnIncWidth(this.tableColumns[j2].width, (int)(d2 * d1 / d3))) != 0) {
                    this.tableColumns[j2].width += k2;
                    l -= k2;
                    ++i2;
                }
            }
            ++j2;
        }
        TableColumn.findXPosition(this.tableColumns);
        this.findLeftFixedColumnsWidth();
        return i2;
    }

    public void reshape(int i, int j, int k, int l) {
        boolean flag = this.getWidth() != k;
        super.reshape(i, j, k, l);
        if (flag) {
            this.sizeColumnsToFit(0);
        }
    }

    public final Dimension findMaxPosition() {
        Dimension dimension = this.getSize();
        int i = this.rowHeight > 0 ? dimension.height / this.rowHeight - (this.topFixedRows + this.bottomFixedRows) : 1;
        this.maxPosition.height = this.getRowCount() - (i < 2 ? 1 : 2);
        if (this.maxPosition.height < 0) {
            this.maxPosition.height = 0;
        }
        int j = this.tableColumns != null ? this.tableColumns.length : 0;
        i = 0;
        int k = dimension.width - this.leftFixedColWidth - this.fixedColumnsWidth;
        int l = j - 1;
        while (l >= this.leftFixedColumns) {
            int i1;
            TableColumn tablecolumn = this.tableColumns[l];
            int n = i1 = (tablecolumn.options & 1) != 0 ? 0 : tablecolumn.width;
            if ((k -= i1) < 0) break;
            ++i;
            --l;
        }
        if (i <= 0) {
            i = 1;
        }
        this.maxPosition.width = j - this.leftFixedColumns - i;
        if (this.maxPosition.width < 0) {
            this.maxPosition.width = 0;
        }
        return this.maxPosition;
    }

    public int posEnsureSelectedCellVisible() {
        int k;
        int i = this.yPosition;
        int j = this.getRowSelected();
        Dimension dimension = this.getSize();
        if (this.rowHeight > 0 && (k = dimension.height / this.rowHeight - (this.topFixedRows + this.bottomFixedRows)) > 0 && j >= 0) {
            if (j > i + k - 1) {
                i = j - k + (k >> 1 <= 1 ? 1 : k >> 1);
            }
            if (j < i) {
                i = j;
            }
        }
        int l = this.xPosition;
        if (this.colSelected >= this.leftFixedColumns && this.tableColumns != null) {
            l += this.leftFixedColumns;
            while (l < this.colSelected && this.leftFixedColWidth + this.fixedColumnsWidth + (this.tableColumns[this.colSelected].left - this.tableColumns[l].left) + this.tableColumns[this.colSelected].width > dimension.width) {
                ++l;
            }
            if (this.colSelected < l) {
                l = this.colSelected;
            }
            l -= this.leftFixedColumns;
        }
        return i << 16 | l;
    }

    public void configColumns(Dictionary dictionary) {
        super.configColumns(dictionary);
        if (this.tableColumns != null) {
            int i = 0;
            while (i < this.tableColumns.length) {
                this.tableColumns[i].height = this.rowHeight;
                ++i;
            }
        }
    }

    public void initial(Dictionary dictionary) {
        Font font = new Font("Dialog", 0, 14);
        if (this.rowHeight == 0) {
            this.rowHeight = this.getFontMetrics(font).getHeight();
        }
        super.initial(dictionary);
        this.onSelectedCellChanged(-1, -1);
    }

    public void refreshPaint() {
        super.refreshPaint();
        TableColumn.findXPosition(this.tableColumns);
        this.findLeftFixedColumnsWidth();
    }

    protected boolean showDropdownButton() {
        if (this.tableColumns != null && this.colSelected >= 0 && this.colSelected < this.tableColumns.length) {
            boolean flag;
            int i = this.getRowSelected();
            TableColumn tablecolumn = this.tableColumns[this.colSelected];
            boolean bl = flag = i >= this.yPosition && (tablecolumn.options & 0x2000000) != 0 && this.hasFocusOrSubComponentHasFocus() && ((tablecolumn.options & 0x100) == 0 && (this.rwFlags & 1) == 0 || (tablecolumn.options & 0x8000000) != 0);
            if (flag) {
                Dimension dimension = this.getSize();
                int j = this.topFixedRows * this.rowHeight + (i - this.yPosition) * this.rowHeight;
                if (j >= dimension.height - this.bottomFixedRows * this.rowHeight) {
                    flag = false;
                } else {
                    int k = this.findColumnAtX(this.colSelected);
                    if (k < this.leftFixedColWidth || k >= dimension.width) {
                        flag = false;
                    } else {
                        this.dropdownButton.setBounds(k + this.tableColumns[this.colSelected].width - 16, j + 1, 16, this.rowHeight - 1);
                    }
                }
            }
            this.dropdownButton.setVisible(flag);
        }
        return this.dropdownButton.isVisible();
    }

    protected void onSelectedCellChanged(int i, int j) {
        if (i < 0) {
            i = this.drawedSelectedRow;
        }
        if (j < 0) {
            j = this.drawedSelectedCol;
        }
        this.stopEdit();
        int k = this.posEnsureSelectedCellVisible();
        if (k != (this.yPosition << 16 | this.xPosition) && this.scrollTo(k & 0xFFFF, k >> 16) != 0) {
            return;
        }
        this.dropdownButton.setVisible(false);
        this.setEditorInvisible();
        if (this.offGraphics != null) {
            int l = this.getRowSelected();
            if ((this.flagSelectedOptions & 0xF0) != 0) {
                if (this.tableColumns != null) {
                    int i1 = 0;
                    while (i1 < this.tableColumns.length) {
                        if ((this.tableColumns[i1].options & 1) == 0) {
                            this.drawCell(this.offGraphics, i, i1);
                            this.drawCell(this.offGraphics, l, i1);
                        }
                        ++i1;
                    }
                }
            } else {
                this.drawCell(this.offGraphics, i, j);
                this.drawCell(this.offGraphics, l, this.colSelected);
            }
            if (l != i) {
                this.drawSelectedMark(i);
                this.drawSelectedMark(l);
            }
        }
        this.repaint();
    }

    protected void onRowNavigated(boolean flag) {
        super.onRowNavigated(flag);
        if (!this.forceUnhandleNavigationEvent) {
            this.onSelectedCellChanged(-1, -1);
        }
    }

    private void gotoRelativeRow(int i, boolean flag) {
        int j = this.colSelected;
        int k = this.getRowSelected();
        int l = this.getRowSelected() + i;
        if (l == k) {
            return;
        }
        int i1 = this.getRowCount();
        if (l >= i1) {
            l = i1 - 1;
        }
        if (l < 0) {
            l = 0;
        }
        if (l != k && !this.dataSetNavigateAble()) {
            return;
        }
        try {
            this.dataSet.goToRow(l);
        }
        catch (DataSetException dataSetException) {
            // empty catch block
        }
        if (!(flag || j == this.colSelected && k == this.getRowSelected())) {
            this.onSelectedCellChanged(k, j);
        }
    }

    private void toBottomNeighbourComponent() {
        Component component = this.getNeighbourComponent(3);
        if (component == null) {
            return;
        }
        if (component instanceof Table) {
            try {
                ((Table)component).postPendingValue();
                ((Table)component).toFirstColSelected();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        component.requestFocus();
    }

    public void getSelectedCellEditRect(int[] ai, boolean flag) {
        ai[3] = 0;
        ai[2] = 0;
        ai[1] = 0;
        ai[0] = 0;
        int i = this.getRowSelected();
        if (i < this.yPosition) {
            return;
        }
        int j = this.tableColumns.length;
        if (this.colSelected > this.leftFixedColumns && this.colSelected < this.leftFixedColumns + this.xPosition || this.colSelected >= j || this.colSelected < 0) {
            return;
        }
        TableColumn tablecolumn = this.tableColumns[this.colSelected];
        if ((tablecolumn.options & 1) != 0) {
            return;
        }
        Dimension dimension = this.getSize();
        int k = this.topFixedRows * this.rowHeight + (i - this.yPosition) * this.rowHeight;
        if (k + (this.rowHeight >> 1) >= dimension.height) {
            return;
        }
        int l = this.findColumnAtX(this.colSelected);
        if (l >= this.leftFixedColWidth && l < dimension.width) {
            ai[0] = l;
            ai[1] = k;
            ai[2] = tablecolumn.width - (!this.dropdownButton.isVisible() || flag ? -1 : 15);
            ai[3] = this.rowHeight + 1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyPressed(KeyEvent keyevent) {
        block60: {
            if (this.dataSet == null) {
                return;
            }
            int i = keyevent.getKeyCode();
            block25: while (true) {
                switch (i) {
                    default: {
                        break block60;
                    }
                    case 9: {
                        break block25;
                    }
                    case 37: {
                        int j = this.colSelected;
                        int i1 = this.getRowSelected();
                        if (this.editor == this.textField && this.textField.getCaretPosition() > 0 || !this.postPendingValue()) {
                            return;
                        }
                        this.colSelected = TableColumn.prevVisibleColumn(this.tableColumns, j, true);
                        if (this.colSelected < 0 && this.tableColumns != null) {
                            this.colSelected = TableColumn.prevVisibleColumn(this.tableColumns, this.tableColumns.length, true);
                            if (this.colSelected >= 0) {
                                if (!this.dataSetNavigateAble()) {
                                    return;
                                }
                                this.forceUnhandleNavigationEvent = true;
                                try {
                                    this.dataSet.prior();
                                }
                                catch (DataSetException dataSetException) {
                                    // empty catch block
                                }
                                this.forceUnhandleNavigationEvent = false;
                            }
                        }
                        if (j != this.colSelected || i1 != this.getRowSelected()) {
                            this.onSelectedCellChanged(i1, j);
                        }
                        break block60;
                    }
                    case 39: {
                        int jj = this.colSelected;
                        int ii = this.getRowSelected();
                        if (this.editor == this.textField && this.textField.getCaretPosition() < this.textField.getText().length() || !this.postPendingValue()) {
                            return;
                        }
                        this.colSelected = TableColumn.nextVisibleColumn(this.tableColumns, jj, true);
                        if (this.colSelected < 0 && this.tableColumns != null) {
                            this.colSelected = TableColumn.nextVisibleColumn(this.tableColumns, this.tableColumns.length, true);
                            if (this.colSelected >= 0) {
                                if (!this.dataSetNavigateAble()) {
                                    return;
                                }
                                this.forceUnhandleNavigationEvent = true;
                                try {
                                    this.dataSet.prior();
                                }
                                catch (DataSetException dataSetException) {
                                    // empty catch block
                                }
                                this.forceUnhandleNavigationEvent = false;
                            }
                        }
                        if (jj != this.colSelected || ii != this.getRowSelected()) {
                            this.onSelectedCellChanged(ii, jj);
                        }
                        break block60;
                    }
                    case 10: {
                        try {
                            if ((this.tableColumns[this.colSelected].extOptions & 0x20) == 0) break block25;
                            i = 40;
                        }
                        catch (Throwable throwable) {
                            break block25;
                        }
                    }
                    continue block25;
                    case 38: {
                        if (this.inAidInputing() || !this.dataSetNavigateAble() || !this.postPendingValue()) {
                            return;
                        }
                        this.stopEdit();
                        if (this.dataSet.atFirst()) {
                            this.focusNeighbourComponent(1);
                            return;
                        }
                        try {
                            this.dataSet.prior();
                            return;
                        }
                        catch (DataSetException dataSetException) {
                            // empty catch block
                        }
                        return;
                    }
                    case 40: {
                        if (this.inAidInputing() || !this.dataSetNavigateAble() || !this.postPendingValue()) {
                            return;
                        }
                        this.stopEdit();
                        try {
                            if (this.dataSet.atLast() || this.dataSet.isEmpty()) {
                                if (!this.isLastaddable()) return;
                                int l = this.dataSet.getRow();
                                this.dataSet.insertRow(false);
                                if (l != this.dataSet.getRow()) return;
                                this.toBottomNeighbourComponent();
                                return;
                            } else {
                                this.dataSet.next();
                            }
                            return;
                        }
                        catch (DataSetException l) {
                            // empty catch block
                        }
                        return;
                    }
                    case 33: 
                    case 34: {
                        if (this.inAidInputing() || !this.dataSetNavigateAble() || !this.postPendingValue()) {
                            return;
                        }
                        this.stopEdit();
                        if (this.inAidInputing() || this.caseDataSetAccess != null && this.caseDataSetAccess[2] != null) {
                            try {
                                if (keyevent.getKeyCode() == 33) {
                                    this.caseDataSetAccess[2].goPrior();
                                    return;
                                }
                                this.caseDataSetAccess[2].goNext();
                                return;
                            }
                            catch (DataSetException l) {}
                            return;
                        }
                        if (keyevent.isControlDown()) {
                            try {
                                if (keyevent.getKeyCode() == 33) {
                                    if (this.dataSet.atFirst()) {
                                        return;
                                    }
                                    this.goFirst();
                                    return;
                                }
                                this.goLast();
                                return;
                            }
                            catch (Throwable l) {}
                            return;
                        }
                        Dimension dimension = this.getSize();
                        int k1 = dimension.height / this.rowHeight - (this.topFixedRows + this.bottomFixedRows);
                        if (k1 <= 0) {
                            k1 = 1;
                        }
                        if (keyevent.getKeyCode() == 33) {
                            k1 = -k1;
                        }
                        int j2 = this.colSelected;
                        int k2 = this.getRowSelected();
                        this.forceUnhandleNavigationEvent = true;
                        this.gotoRelativeRow(k1, true);
                        this.forceUnhandleNavigationEvent = false;
                        if (j2 == this.colSelected && k2 == this.getRowSelected()) return;
                        this.onSelectedCellChanged(k2, j2);
                        return;
                    }
                }
                break;
            }
            int k = this.colSelected;
            int j1 = this.getRowSelected();
            if (!this.postPendingValue()) {
                return;
            }
            this.colSelected = TableColumn.nextVisibleColumn(this.tableColumns, k, true);
            if (this.colSelected < 0 && this.tableColumns != null) {
                this.colSelected = TableColumn.nextVisibleColumn(this.tableColumns, -1, true);
                if (this.colSelected >= 0) {
                    if (!this.dataSetNavigateAble()) {
                        return;
                    }
                    this.forceUnhandleNavigationEvent = true;
                    try {
                        if (this.dataSet.atLast() || this.dataSet.isEmpty()) {
                            if (this.isLastaddable()) {
                                int l1 = this.dataSet.getRow();
                                this.dataSet.insertRow(false);
                                if (l1 == this.dataSet.getRow()) {
                                    this.toBottomNeighbourComponent();
                                }
                            }
                        } else {
                            int i2 = this.dataSet.getRow();
                            this.dataSet.next();
                            if (i2 == this.dataSet.getRow()) {
                                this.onRowNavigated(false);
                            }
                        }
                    }
                    catch (DataSetException dataSetException) {
                        // empty catch block
                    }
                    this.forceUnhandleNavigationEvent = false;
                }
            }
            if (k != this.colSelected || j1 != this.getRowSelected()) {
                this.onSelectedCellChanged(j1, k);
            }
        }
        super.keyPressed(keyevent);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public int columnAtPoint(int i) {
        if (i <= this.leftFixedColWidth) {
            return -1;
        }
        boolean flag = i < this.leftFixedColWidth + this.fixedColumnsWidth;
        i -= flag ? this.leftFixedColWidth : this.leftFixedColWidth + this.fixedColumnsWidth;
        int j = 0;
        if (flag) {
            j = 0;
            while (j < this.leftFixedColumns - 1) {
                if ((this.tableColumns[j].options & 1) != 0 || i >= this.tableColumns[j].left + this.tableColumns[j].width) {
                    ++j;
                    continue;
                }
                break;
            }
        } else {
            j = this.leftFixedColumns + this.xPosition;
            while (j < this.tableColumns.length) {
                if ((this.tableColumns[j].options & 1) != 0 || i >= this.tableColumns[j].left - this.tableColumns[this.leftFixedColumns + this.xPosition].left + this.tableColumns[j].width) {
                    ++j;
                    continue;
                }
                break;
            }
        }
        return j;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mousePressed(MouseEvent mouseevent) {
        block23: {
            block24: {
                super.mousePressed(mouseevent);
                if ((mouseevent.getModifiers() & 16) == 0) {
                    return;
                }
                if (this.resizeColumnState == 1 && this.resizeColumn >= 0) {
                    this.oldcolDisplayWidth = this.tableColumns[this.resizeColumn].width;
                    this.resizeColumnState = 2;
                    return;
                }
                if (this.resizeColumnState != 0) return;
                if (this.dataSet == null) return;
                if (this.tableColumns == null) {
                    return;
                }
                i = mouseevent.getX();
                j = mouseevent.getY();
                if (j <= this.topFixedRows * this.rowHeight) {
                    return;
                }
                dimension = this.getSize();
                if (j >= dimension.height - this.bottomFixedRows * this.rowHeight) {
                    return;
                }
                k = j / this.rowHeight - this.topFixedRows + this.yPosition;
                if (k < this.getRowCount() || !this.isLastaddable()) break block23;
                if (this.postPendingValue() == false) return;
                if (!this.dataSetNavigateAble()) {
                    return;
                }
                if (k != this.getRowCount()) break block24;
                try {
                    try {
                        ++this.lockDataSetEvent;
                        if (!this.dataSet.isEmpty() && !this.dataSet.atLast()) {
                            this.dataSet.last();
                        }
                    }
                    catch (Exception var6_6) {}
                }
                catch (Throwable var8_9) {
                    var7_11 = null;
                    --this.lockDataSetEvent;
                    throw var8_9;
                }
                {
                    var7_12 = null;
                    --this.lockDataSetEvent;
                    ** GOTO lbl-1000
                }
            }
            try lbl-1000:
            // 2 sources

            {
                this.dataSet.insertRow(false);
                return;
            }
            catch (DataSetException var6_7) {
                // empty catch block
            }
            return;
        }
        if (i <= this.leftFixedColWidth) {
            if (this.rowSelectMode <= 0) return;
            if (k >= this.getRowCount()) return;
            this.setRowMarkSelected(k, this.isRowMarkSelected(k) == false);
            return;
        }
        l = this.columnAtPoint(i);
        i1 = this.getRowSelected();
        if (this.colSelected == l && i1 == k) {
            this.tableColumns[l].top = (k - this.yPosition + this.topFixedRows) * this.rowHeight;
            this.startEdit(mouseevent);
            return;
        }
        if (this.postPendingValue() == false) return;
        if (i1 != k && !this.dataSetNavigateAble()) {
            return;
        }
        j1 = this.colSelected;
        if (l >= 0 && l < this.tableColumns.length) {
            this.colSelected = l;
        }
        if (i1 != k) {
            try {
                this.dataSet.goToRow(k);
            }
            catch (DataSetException var9_14) {
                // empty catch block
            }
        }
        if (j1 != this.colSelected || i1 != this.getRowSelected()) {
            this.onSelectedCellChanged(i1, j1);
        }
        if ((this.tableColumns[this.colSelected].options & 0x40000000) != 0) {
            this.startEdit(mouseevent);
        }
        this.forceRedraw = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseevent) {
        int i;
        if (this.resizeColumnState == 2) {
            this.resizeColumnState = 1;
            if (this.oldcolDisplayWidth != this.tableColumns[this.resizeColumn].width) {
                TableColumn.findXPosition(this.tableColumns);
                this.findLeftFixedColumnsWidth();
                this.sizeColumnsToFit(this.resizeColumn + 1);
                this.scrollTo(-1, -1);
                this.forceRedraw = true;
                this.repaint();
                this.updateScrollbar(2);
            }
        } else if (mouseevent.getClickCount() == 2 && mouseevent.getY() <= this.topFixedRows * this.rowHeight && (i = this.columnAtPoint(mouseevent.getX())) >= 0) {
            this.toggleSortForColumn(i);
        }
    }

    public void mouseExited(MouseEvent mouseevent) {
        if (this.getCursor().getType() != 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.resizeColumnState != 0) {
            this.repaint();
        }
        this.resizeColumnState = 0;
        this.resizeColumn = -1;
    }

    public void mouseDragged(MouseEvent mouseevent) {
        if (this.resizeColumnState == 2) {
            int i = mouseevent.getX();
            if (i < this.resizeXLeft + 1) {
                i = this.resizeXLeft + 1;
            }
            int j = this.tableColumns[this.resizeColumn].width;
            short s = (short)(i - this.resizeXLeft);
            this.tableColumns[this.resizeColumn].width = s;
            short word0 = s;
            this.repaint(this.resizeXLeft + Math.min(j, word0), 0, Math.abs(word0 - j) + 1, this.getSize().height);
        }
    }

    public void mouseMoved(MouseEvent mouseevent) {
        int i = mouseevent.getX();
        int j = mouseevent.getY();
        if (j < this.topFixedRows * this.rowHeight) {
            int k = this.tableColumns != null ? this.tableColumns.length : 0;
            Dimension dimension = this.getSize();
            int l = 0;
            int i1 = 0;
            while (i1 < k) {
                int j1;
                if ((i1 < this.leftFixedColumns || i1 >= this.leftFixedColumns + this.xPosition) && (this.tableColumns[i1].options & 1) == 0 && (j1 = this.tableColumns[i1].width) > 0) {
                    this.resizeXLeft = this.findColumnAtX(i1);
                    l = this.resizeXLeft + j1;
                    if (l >= i - 1) break;
                }
                ++i1;
            }
            if (i1 < k && l <= i + 1 && this.columnResizable) {
                if (this.getCursor().getType() != 11) {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                }
                if (this.resizeColumnState != 2) {
                    this.repaint(l, 0, 1, this.topFixedRows * this.rowHeight);
                }
                this.resizeColumnState = 1;
                this.resizeColumn = i1;
                return;
            }
        }
        if (this.getCursor().getType() != 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.resizeColumnState != 0) {
            this.repaint();
        }
        this.resizeColumnState = 0;
        this.resizeColumn = -1;
    }

    protected void findDefaultPreferredSize() {
        if (this.tableColumns != null && this.tableColumns.length > 0) {
            int i = this.leftFixedColWidth + this.tableColumns[this.tableColumns.length - 1].left + this.tableColumns[this.tableColumns.length - 1].width + 6;
            if (i < 400) {
                i = 400;
            } else {
                Dimension dimension;
                JMDIDesktopPane appdesktoppane = MainFrame.getDesktopPane();
                Dimension dimension2 = dimension = appdesktoppane == null ? this.getToolkit().getScreenSize() : appdesktoppane.getSize();
                if (i > dimension.width - 32 && (i = dimension.width - 32) < 64) {
                    i = 64;
                }
            }
            this.preferredSize.setSize(i, (this.topFixedRows + 16 + this.bottomFixedRows) * this.rowHeight);
        } else {
            this.preferredSize.setSize(400, (this.topFixedRows + 16 + this.bottomFixedRows) * this.rowHeight);
        }
        super.findDefaultPreferredSize();
    }

    public void setDrawLineNo(boolean flag) {
        this.bDrawLineNo = flag;
        if (this.leftFixedColWidth < 32) {
            this.leftFixedColWidth = 32;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void drawCell(Graphics g, int i, int j) {
        try {
            int i1;
            int l;
            TableColumn tablecolumn;
            block16: {
                block14: {
                    block15: {
                        if (this.dataSet == null) break block14;
                        if (this.tableColumns != null) break block15;
                        break block14;
                    }
                    if (i < this.yPosition) break block14;
                    int k = this.tableColumns.length;
                    if (j >= this.leftFixedColumns && j < this.leftFixedColumns + this.xPosition || j >= k) break block14;
                    tablecolumn = this.tableColumns[j];
                    if ((tablecolumn.options & 1) != 0) break block14;
                    Dimension dimension = this.getSize();
                    l = this.topFixedRows * this.rowHeight + (i - this.yPosition) * this.rowHeight;
                    if (l < dimension.height && (i1 = this.findColumnAtX(j)) >= this.leftFixedColWidth && i1 < dimension.width) break block16;
                }
                Object var16_4 = null;
                this.inDrawingRow = -1;
                return;
            }
            try {
                Color color3;
                Color color4;
                Color color;
                boolean flag1;
                boolean flag;
                Object obj = i >= this.getRowCount() ? null : tablecolumn.getDataSetValueAt(this.dataSet, i);
                int j1 = this.getRowSelected();
                boolean bl = flag = j == this.colSelected && j1 == i;
                if (flag && this.editingValue != null) {
                    obj = this.editingValue;
                }
                boolean bl2 = flag1 = (tablecolumn.options & 0x400000) != 0 && !flag && i > this.yPosition && this.equalsPrevRow(obj, i, tablecolumn);
                if (flag1) {
                    g.setColor(this.color1);
                    g.drawLine(i1, l, i1 + tablecolumn.width, l);
                }
                if ((color = this.getCellColor(i, tablecolumn)) == null) {
                    color = this.getForeground();
                }
                if ((color4 = (color3 = this.getCellBackground(i, tablecolumn))) == null) {
                    color4 = j1 != i || !this.hasFocusOrSubComponentHasFocus() ? this.getBackground() : this.color2;
                }
                this.inDrawingRow = i;
                tablecolumn.paint(g, i1, l, tablecolumn.width - (!flag || !this.showDropdownButton() ? 0 : 16), this.rowHeight, flag1 ? null : obj, g.getFontMetrics(), 2 | this.blueCellPaintOption(flag, j1 == i, this.isRowMarkSelected(i)), color4, color, color3);
                if (flag) {
                    this.drawedSelectedCol = j;
                    this.drawedSelectedRow = i;
                    this.moveEditor();
                }
            }
            catch (Exception exception) {}
            Object var16_6 = null;
            this.inDrawingRow = -1;
            return;
        }
        catch (Throwable throwable) {
            Object var16_5 = null;
            this.inDrawingRow = -1;
            throw throwable;
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.resizeColumnState >= 1) {
            int i = this.resizeXLeft + this.tableColumns[this.resizeColumn].width;
            g.setColor(Color.blue);
            g.drawLine(i, 0, i, this.resizeColumnState != 2 ? this.topFixedRows * this.rowHeight : this.getSize().height);
        }
    }

    protected final int findColumnAtX(int i) {
        return i >= this.leftFixedColumns ? this.leftFixedColWidth + this.fixedColumnsWidth + (this.tableColumns[i].left - this.tableColumns[this.leftFixedColumns + this.xPosition].left) : this.leftFixedColWidth + this.tableColumns[i].left;
    }

    void paintRowSeledMark(int i, boolean flag) {
        this.offGraphics.setColor(Color.lightGray);
        this.offGraphics.fillRect(1, i + 1, this.leftFixedColWidth - 2, this.rowHeight - 2);
        if (flag) {
            this.offGraphics.setColor(Color.black);
            int j = this.leftFixedColWidth - 2;
            if (j < 1) {
                j = 1;
            } else if (j > 8) {
                j = 8;
            }
            int k = this.leftFixedColWidth - j >> 1;
            if (k < 1) {
                k = 1;
            }
            int l = i + this.rowHeight / 2;
            int i1 = (this.rowHeight - 2) / 2;
            if (i1 > j) {
                i1 = j;
            }
            this.offGraphics.fillPolygon(new int[]{k, k + j, k}, new int[]{l - i1, l, l + i1}, 3);
        }
        this.drawLineNo(i);
    }

    void drawLineNo(int i) {
        if (!this.bDrawLineNo) {
            return;
        }
        this.offGraphics.setColor(Color.black);
        FontMetrics fontmetrics = this.offGraphics.getFontMetrics();
        int j = fontmetrics.getAscent();
        int k = (i - this.topFixedRows * this.rowHeight) / this.rowHeight + this.yPosition;
        String s = "" + (k + 1);
        int l = fontmetrics.stringWidth(s);
        this.offGraphics.drawString(s, (this.leftFixedColWidth - l) / 2, i + (this.rowHeight + j) / 2);
    }

    public void drawRow(int i) {
        if (this.offGraphics != null) {
            int j = this.topFixedRows * this.rowHeight + (i - this.yPosition) * this.rowHeight;
            this.paintRowSeledMark(j, i == this.getRowSelected());
            if (this.isRowMarkSelected(i)) {
                TableColumn.drawBooleanValue(this.offGraphics, 1, j, this.leftFixedColWidth, this.rowHeight, true, null);
            }
        }
        super.drawRow(i);
    }

    protected void drawSelectedMark(int i) {
        if (this.offGraphics != null) {
            int j = this.topFixedRows * this.rowHeight + (i - this.yPosition) * this.rowHeight;
            this.paintRowSeledMark(j, i == this.getRowSelected());
            if (this.isRowMarkSelected(i)) {
                TableColumn.drawBooleanValue(this.offGraphics, 1, j, this.leftFixedColWidth, this.rowHeight, true, null);
            }
        }
    }

    private void drawCaptionCell(FontMetrics fontmetrics, TableColumn.CaptionCell captioncell, int i, int j, int k, int l, int i1, int j1) {
        if (captioncell.mergedBy != null) {
            return;
        }
        if (captioncell.splitedText != null) {
            this.drawCaptionCell(fontmetrics, captioncell.splitedText, i, j, captioncell.drawWidth - l, k, i1, j1);
        } else if (captioncell.subCell != null) {
            int k1 = captioncell.subCell.length;
            int l1 = 0;
            int i2 = 0;
            while (i2 < k1) {
                int j2 = captioncell.subCell[i2].drawRows;
                if (i2 == k1 - 1) {
                    j2 = k - l1;
                }
                this.drawCaptionCell(fontmetrics, captioncell.subCell[i2], i, j + l1 * this.rowHeight, j2, l, i1, j1);
                l1 += j2;
                ++i2;
            }
        }
    }

    private void drawCaptionCell(FontMetrics fontmetrics, String[] as, int i, int j, int k, int l, int i1, int j1) {
        int k1 = l * this.rowHeight;
        if (i + k > j1) {
            k = j1 - i;
        }
        if (as != null && as.length > 0 && k > 1 && l > 0) {
            int l1 = as.length;
            if (l1 == 1) {
                int i2 = fontmetrics.stringWidth(as[0]);
                int k2 = (k - i2) / 2;
                if (k2 < 0) {
                    k2 = 0;
                }
                this.offGraphics.drawString(as[0], i + k2, j + (k1 + i1) / 2);
            } else {
                int j2 = 0;
                while (j2 < as.length) {
                    int l2 = k1 / l1;
                    int i3 = fontmetrics.stringWidth(as[j2]);
                    if (k >= i3) {
                        this.offGraphics.drawString(as[j2], i + (k - i3) / 2, j + j2 * l2 + (l2 + i1) / 2);
                    }
                    ++j2;
                }
            }
        }
        Color color = this.offGraphics.getColor();
        this.offGraphics.setColor(Color.gray);
        this.offGraphics.drawLine(i, j + k1, i + k, j + k1);
        if (k >= 1) {
            this.offGraphics.drawLine(i + k, j, i + k, j + k1);
        }
        this.offGraphics.setColor(Color.white);
        this.offGraphics.drawLine(i, j + k1 + 1, i + k, j + k1 + 1);
        if (k >= 1) {
            this.offGraphics.drawLine(i + k + 1, j + 1, i + k + 1, j + k1);
        }
        this.offGraphics.setColor(color);
    }

    protected void draw() {
        Dimension dimension = this.getSize();
        if (this.offDimension == null || this.offDimension.width != dimension.width || this.offDimension.height != dimension.height) {
            this.offDimension = dimension;
            this.offImage = this.createImage(dimension.width, dimension.height);
            if (this.offImage == null) {
                this.offDimension = null;
                return;
            }
            this.offGraphics = this.offImage.getGraphics();
        }
        if (this.tableColumns == null) {
            return;
        }
        Color color = this.getBackground();
        Color color3 = this.getForeground();
        Color colorL = Color.gray;
        if (color3 == null) {
            color3 = Color.black;
        }
        Font font = new Font("Dialog", 0, 14);
        this.offGraphics.setFont(font);
        this.offGraphics.setColor(color);
        this.offGraphics.fillRect(0, 0, dimension.width, dimension.height);
        int i = this.tableColumns.length;
        FontMetrics fontmetrics = this.offGraphics.getFontMetrics();
        int j = fontmetrics.getAscent();
        this.topFixedRows = this.findTopFixedRows(fontmetrics);
        int k = this.findColumnAtX(i - 1) + ((this.tableColumns[i - 1].options & 1) == 0 ? this.tableColumns[i - 1].width : 0);
        this.offGraphics.setColor(new Color(247, 239, 231));
        this.offGraphics.fillRect(0, 0, this.leftFixedColWidth + 1, dimension.height + 1);
        this.offGraphics.fillRect(0, 0, k + 1, this.topFixedRows * this.rowHeight - 1 + 1);
        this.offGraphics.setColor(colorL);
        int l = this.topFixedRows * this.rowHeight;
        int i1 = this.topFixedRows * this.rowHeight;
        while (i1 < dimension.height) {
            this.offGraphics.drawLine(1, i1, k, i1);
            if (this.leftFixedColWidth > 1) {
                this.offGraphics.setColor(Color.lightGray);
                this.offGraphics.drawLine(1, i1 + 1, this.leftFixedColWidth, i1 + 1);
                this.offGraphics.setColor(colorL);
            }
            i1 += this.rowHeight;
        }
        int j1 = 0;
        while (j1 < i) {
            TableColumn tablecolumn = this.tableColumns[j1];
            if ((j1 < this.leftFixedColumns || j1 >= this.leftFixedColumns + this.xPosition) && (tablecolumn.options & 1) == 0) {
                int l1 = this.findColumnAtX(j1);
                if (l1 >= dimension.width) break;
                int j2 = j1 != 0 && j1 != this.leftFixedColumns + this.xPosition ? l : 0;
                this.offGraphics.setColor(colorL);
                this.offGraphics.drawLine(l1, j2, l1, dimension.height);
                if (j2 == 0) {
                    this.offGraphics.setColor(Color.lightGray);
                    this.offGraphics.drawLine(l1 + 1, j2 + 1, l1 + 1, this.topFixedRows * this.rowHeight);
                }
                if (tablecolumn.captionCell != null) {
                    Color color4 = tablecolumn.captionColor != null ? tablecolumn.captionColor : ((tablecolumn.options & 0x8000) == 0 && (tablecolumn.extOptions & 1) == 0 ? ((tablecolumn.options & 0x100) == 0 ? color3 : Color.BLACK) : Color.blue);
                    this.offGraphics.setColor(color4);
                    this.drawCaptionCell(fontmetrics, this.tableColumns[j1].captionCell, l1, 0, this.topFixedRows, 0, j, dimension.width);
                }
            }
            ++j1;
        }
        this.offGraphics.setColor(color3);
        this.offGraphics.drawLine(k, 0, k, dimension.height);
        if (this.dataSet == null) {
            return;
        }
        int k1 = this.getRowCount();
        int i2 = this.getRowSelected();
        this.dropdownButton.setVisible(false);
        this.setEditorInvisible();
        int k2 = this.yPosition;
        int l2 = this.topFixedRows * this.rowHeight;
        while (k2 < k1 && l2 < dimension.height - this.bottomFixedRows * this.rowHeight) {
            this.inDrawingRow = k2;
            boolean flag = this.isRowMarkSelected(k2);
            this.drawLineNo(l2);
            if (k2 == i2) {
                this.paintRowSeledMark(l2, true);
                this.offGraphics.setColor(color3);
            }
            if (flag) {
                TableColumn.drawBooleanValue(this.offGraphics, 1, l2, this.leftFixedColWidth, this.rowHeight, true, null);
            }
            int j3 = 0;
            while (j3 < i) {
                if ((j3 < this.leftFixedColumns || j3 >= this.leftFixedColumns + this.xPosition) && (this.tableColumns[j3].options & 1) == 0) {
                    int l3 = this.findColumnAtX(j3);
                    if (l3 >= dimension.width) break;
                    TableColumn tablecolumn1 = this.tableColumns[j3];
                    int l4 = tablecolumn1.width;
                    if (l4 > 1) {
                        boolean flag2;
                        Color color6;
                        Color color7;
                        Color color5;
                        boolean flag1;
                        Object obj = tablecolumn1.getDataSetValueAt(this.dataSet, k2);
                        boolean bl = flag1 = j3 == this.colSelected && k2 == i2;
                        if (flag1 && this.editingValue != null) {
                            obj = this.editingValue;
                        }
                        if ((color5 = this.getCellColor(k2, tablecolumn1)) == null) {
                            color5 = color3;
                        }
                        if ((color7 = (color6 = this.getCellBackground(k2, tablecolumn1))) == null) {
                            Color color2 = color7 = i2 != k2 || !this.hasFocusOrSubComponentHasFocus() ? color : this.color2;
                            if (color7 == this.color2) {
                                color6 = this.color2;
                            }
                        }
                        boolean bl2 = flag2 = (tablecolumn1.options & 0x400000) != 0 && k2 > this.yPosition && !flag1 && this.equalsPrevRow(obj, k2, tablecolumn1);
                        if (flag2) {
                            this.offGraphics.setColor(this.color1);
                            this.offGraphics.drawLine(l3, l2, l3 + tablecolumn1.width, l2);
                        }
                        tablecolumn1.paint(this.offGraphics, l3, l2, l4 - (!flag1 || !this.showDropdownButton() ? 0 : 16), this.rowHeight, flag2 ? null : obj, fontmetrics, this.blueCellPaintOption(flag1, i2 == k2, flag) | (color6 != null ? 2 : 0), color7, color5, color6);
                        if (flag1) {
                            this.drawedSelectedCol = j3;
                            this.drawedSelectedRow = k2;
                            this.moveEditor();
                        }
                    }
                }
                ++j3;
            }
            l2 += this.rowHeight;
            ++k2;
        }
        if (this.bottomFixedRows > 0) {
            this.inDrawingRow = -2;
            this.offGraphics.setColor(Color.lightGray);
            int i3 = dimension.height - this.bottomFixedRows * this.rowHeight;
            this.offGraphics.fillRect(1, i3, k, dimension.height);
            this.offGraphics.setColor(color3);
            int k3 = 0;
            while (k3 < i) {
                if ((k3 < this.leftFixedColumns || k3 >= this.leftFixedColumns + this.xPosition) && (this.tableColumns[k3].options & 1) == 0) {
                    int i4 = this.findColumnAtX(k3);
                    if (i4 >= dimension.width) break;
                    this.offGraphics.drawLine(i4, i3 + 1, i4, dimension.height);
                }
                ++k3;
            }
            this.offGraphics.drawLine(k, 0, k, dimension.height);
            int k4 = 0;
            while (k4 < this.bottomFixedRows) {
                int j4 = dimension.height - (this.bottomFixedRows - k4) * this.rowHeight;
                this.offGraphics.drawLine(1, j4, k, j4);
                int i5 = 0;
                while (i5 < i) {
                    if ((i5 < this.leftFixedColumns || i5 >= this.leftFixedColumns + this.xPosition) && (this.tableColumns[i5].options & 1) == 0) {
                        Object obj1;
                        int j5 = this.findColumnAtX(i5);
                        if (j5 >= dimension.width) break;
                        TableColumn tablecolumn2 = this.tableColumns[i5];
                        int k5 = tablecolumn2.width;
                        if (k5 > 1 && (obj1 = tablecolumn2.getBottomValue(k4)) != null) {
                            tablecolumn2.paint(this.offGraphics, j5, j4, k5, this.rowHeight, obj1, fontmetrics, 8, null, color3, null);
                        }
                    }
                    ++i5;
                }
                ++k4;
            }
        }
        this.inDrawingRow = -1;
    }

    private static final boolean objEquals(Object obj, Object obj1) {
        return obj == obj1 || obj != null && obj.equals(obj1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean equalsPrevRow(Object obj, int i, TableColumn tablecolumn) {
        String s1;
        String s;
        int j = this.inDrawingRow;
        try {
            this.inDrawingRow = i;
            s = tablecolumn.toString(obj, false, true);
            obj = tablecolumn.getDataSetValueAt(this.dataSet, i - 1);
            this.inDrawingRow = i - 1;
            s1 = tablecolumn.toString(obj, false, true);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.inDrawingRow = j;
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.inDrawingRow = j;
            return GridTable.objEquals(s, s1);
        }
    }
}

