/*
 * Decompiled with CFR 0.152.
 */
package softcore.table;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import softcore.table.CodeNameMap;
import softcore.table.Table;

public class PopupListAidInputer
extends JPopupMenu
implements KeyListener,
MouseListener,
MouseMotionListener {
    protected final JList list = new JList(new DefaultListModel());
    protected final JScrollPane scroller = new JScrollPane(this.list);
    int minWidth;
    int x;
    int y;
    int h;
    private int itemCount;
    private Table table;

    public PopupListAidInputer() {
        this.add(this.scroller);
        this.list.setVisibleRowCount(16);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(this);
        this.list.addMouseMotionListener(this);
        this.list.addKeyListener(this);
    }

    public void doLayout() {
        this.scroller.setSize(this.getSize());
    }

    public void setMinWidth(int i) {
        this.minWidth = i;
    }

    public Dimension getPreferredSize() {
        DefaultListModel defaultlistmodel = (DefaultListModel)this.list.getModel();
        Dimension dimension = this.list.getPreferredSize();
        dimension.height += 4;
        if (dimension.height > 288) {
            dimension.height = 288;
        }
        dimension.width = dimension.width + (defaultlistmodel.size() < this.list.getVisibleRowCount() ? 4 : 16);
        if (dimension.width < this.minWidth) {
            dimension.width = this.minWidth;
        }
        return dimension;
    }

    public void setAt(int i, int j, int k) {
        this.x = i;
        this.y = j;
        this.h = k;
    }

    public int addItems(String[] as, String s) {
        DefaultListModel defaultlistmodel = (DefaultListModel)this.list.getModel();
        try {
            defaultlistmodel.removeAllElements();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int i = 0;
        while (i < as.length) {
            defaultlistmodel.addElement(as[i]);
            ++i;
        }
        if (s != null) {
            this.list.setSelectedValue(s, true);
        }
        this.itemCount = defaultlistmodel.size();
        return this.itemCount;
    }

    public int addItems(CodeNameMap codenamemap, String s) {
        int i;
        DefaultListModel defaultlistmodel = (DefaultListModel)this.list.getModel();
        try {
            defaultlistmodel.removeAllElements();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[][] aobj = codenamemap.getCodeNameAsArray();
        if (aobj == null) {
            return 0;
        }
        if (s != null && (i = s.indexOf(58)) >= 0) {
            s = s.substring(0, i);
        }
        int j = -1;
        int k = 0;
        while (k < aobj.length) {
            Object obj1;
            Object obj = aobj[k][0];
            if (obj.equals(s)) {
                j = k;
            }
            if ((obj1 = aobj[k][1]) == null || obj == obj1) {
                defaultlistmodel.addElement(obj.toString());
            } else {
                defaultlistmodel.addElement(String.valueOf(obj.toString()) + ':' + obj1);
            }
            ++k;
        }
        if (j >= 0) {
            this.list.setSelectedIndex(j);
        }
        this.itemCount = defaultlistmodel.size();
        return this.itemCount;
    }

    public void doAidInput(Table table1, String s) {
        this.table = table1;
        Dimension dimension = this.getPreferredSize();
        Dimension dimension1 = Toolkit.getDefaultToolkit().getScreenSize();
        Point point = table1.getLocationOnScreen();
        if (point.y + this.y + dimension.height >= dimension1.height) {
            int i = this.y - this.h - dimension.height;
            if (point.y + i < 0) {
                i = -point.y;
            }
            this.show(table1, this.x, i);
        } else {
            this.show(table1, this.x, this.y);
        }
        this.list.requestFocus();
    }

    private void putbackSelectedValue() {
        Object obj = this.list.getSelectedValue();
        this.table.setEditingValue(obj, false);
    }

    public void keyTyped(KeyEvent keyevent) {
    }

    public void keyPressed(KeyEvent keyevent) {
        if (keyevent.getKeyCode() == 10) {
            this.putbackSelectedValue();
            this.setVisible(false);
        } else if (keyevent.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
    }

    public void keyReleased(KeyEvent keyevent) {
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent mouseevent) {
        this.putbackSelectedValue();
        this.setVisible(false);
    }

    public void mouseReleased(MouseEvent mouseevent) {
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent mouseevent) {
    }

    public void mouseDragged(MouseEvent mouseevent) {
    }

    public void mouseMoved(MouseEvent mouseevent) {
        int i = this.list.locationToIndex(mouseevent.getPoint());
        if (i >= 0 && i < this.itemCount) {
            this.list.setSelectedIndex(i);
        }
    }
}

