/*
 * Decompiled with CFR 0.152.
 */
package softcore.table;

import java.awt.FontMetrics;
import softcore.table.RecordTable;
import softcore.table.Table;
import softcore.table.TableCellLayout;
import softcore.table.TableColumn;

public class TableCellFlowLayout
implements TableCellLayout {
    public int leftMargin = 6;
    public int rightMargin = 6;
    public int topMargin = 6;
    public int rowHeight;
    public int cellGap = 5;
    public int cellCaptionGap = 4;
    public int layoutWidth;
    public boolean widthResizable;
    public boolean removeFromTable;
    protected int[] flowLayoutNewlineCells;
    public boolean disabled;

    public void setFlowLayoutNewlineCells(int[] ai) {
        this.flowLayoutNewlineCells = ai;
    }

    protected int gapOfFlowLayoutNewlineCell(int i) {
        if (this.flowLayoutNewlineCells != null) {
            int j = 0;
            while (j < this.flowLayoutNewlineCells.length) {
                if (this.flowLayoutNewlineCells[j] == i) {
                    return this.flowLayoutNewlineCells[j + 1];
                }
                j += 2;
            }
        }
        return -1;
    }

    private static void widthFill(TableColumn[] atablecolumn, int i, int j, int k) {
        while (j >= i && (atablecolumn[j].options & 1) != 0) {
            --j;
        }
        if (j < i) {
            return;
        }
        int l = k - (atablecolumn[j].left + atablecolumn[j].width);
        System.out.println(atablecolumn[j].width);
        int i1 = l;
        if (i1 > 1 && j > i) {
            int j1 = 0;
            int k1 = i;
            while (k1 <= j) {
                j1 += atablecolumn[k1].width;
                ++k1;
            }
            if (j1 > 0) {
                int l1 = i;
                while (l1 < j) {
                    int cfr_ignored_0 = atablecolumn[l1].options;
                    ++l1;
                }
            }
        }
        if (i1 > 0) {
            atablecolumn[j].left += l - i1;
            atablecolumn[j].width += i1;
        }
    }

    public void layoutTableCells(Table table) {
        int j;
        TableColumn[] atablecolumn = table.tableColumns;
        if (this.disabled || atablecolumn == null || !table.isColumnsConfiged()) {
            return;
        }
        FontMetrics fontmetrics = table.getFontMetrics(table.getFont());
        int i = this.rowHeight;
        if (i == 0 && (i = fontmetrics.getHeight() + 2) < 18) {
            i = 18;
        }
        int n = j = this.layoutWidth <= 0 ? table.getSize().width - this.rightMargin : this.layoutWidth;
        if (j <= 0) {
            return;
        }
        int k = this.leftMargin;
        int l = this.topMargin;
        int i1 = 0;
        int j1 = 0;
        while (j1 < atablecolumn.length) {
            int k1 = this.gapOfFlowLayoutNewlineCell(j1);
            if (k1 >= 0) {
                l += k1 + (k != this.leftMargin ? i : 0);
                k = this.leftMargin;
            }
            atablecolumn[j1].captionPosition = 2;
            if ((atablecolumn[j1].options & 1) == 0) {
                if (atablecolumn[j1].captionGap == 0) {
                    atablecolumn[j1].captionGap = this.cellCaptionGap;
                }
                int i2 = fontmetrics.stringWidth(atablecolumn[j1].displayCaption) + atablecolumn[j1].captionGap;
                if (atablecolumn[j1].captionWidth > 0) {
                    i2 = atablecolumn[j1].captionWidth + atablecolumn[j1].captionGap;
                }
                int j2 = i2 + atablecolumn[j1].width;
                if (k > this.leftMargin && k + j2 > j) {
                    k = this.leftMargin;
                    l += i;
                }
                atablecolumn[j1].top = l;
                atablecolumn[j1].left = k + i2;
                if (this.widthResizable && k == this.leftMargin) {
                    TableCellFlowLayout.widthFill(atablecolumn, i1, j1 - 1, j);
                    i1 = j1;
                }
                k += j2 + this.cellGap;
            }
            ++j1;
        }
        TableCellFlowLayout.widthFill(atablecolumn, i1, atablecolumn.length - 1, j);
        if (this.removeFromTable && table instanceof RecordTable && ((RecordTable)table).getTableCellLayout() == this) {
            this.disabled = true;
            int l1 = 0;
            while (l1 < atablecolumn.length) {
                atablecolumn[l1].dockAlign = 0;
                atablecolumn[l1].dockY = atablecolumn[l1].top;
                atablecolumn[l1].dockX = atablecolumn[l1].left;
                ++l1;
            }
        }
    }
}

