/*
 * Decompiled with CFR 0.152.
 */
package softcore.table;

import java.awt.FontMetrics;
import softcore.table.Table;
import softcore.table.TableCellLayout;
import softcore.table.TableColumn;

public class TableCellGridLayout
implements TableCellLayout {
    int[] gridWidths;
    int leftMargin;
    int topMargin;
    int colGap;

    public TableCellGridLayout(int[] ai, int i, int j, int k) {
        this.gridWidths = ai;
        this.leftMargin = i;
        this.topMargin = j;
        this.colGap = k;
    }

    public TableCellGridLayout(int[] ai) {
        this(ai, 4, 4, 6);
    }

    public void layoutTableCells(Table table) {
        TableColumn[] atablecolumn;
        FontMetrics fontmetrics = table.getFontMetrics(table.getFont());
        int i = fontmetrics.getHeight() + 2;
        if (i < 18) {
            i = 18;
        }
        if ((atablecolumn = table.tableColumns) == null || this.gridWidths == null || this.gridWidths.length < 2) {
            return;
        }
        int j = 0;
        int k = 0;
        int l = this.leftMargin;
        int i1 = 0;
        while (i1 < atablecolumn.length) {
            if ((atablecolumn[i1].options & 1) == 0) {
                if (j >= this.gridWidths.length) {
                    j = 0;
                    l = this.leftMargin;
                    ++k;
                }
                atablecolumn[i1].captionPosition = 2;
                atablecolumn[i1].top = this.topMargin + k * (i + 2);
                atablecolumn[i1].left = l + this.gridWidths[j];
                atablecolumn[i1].width = this.gridWidths[j + 1];
                atablecolumn[i1].height = i;
                atablecolumn[i1].captionWidth = this.gridWidths[j];
                l += this.gridWidths[j] + this.gridWidths[j + 1] + this.colGap;
                j += 2;
            }
            ++i1;
        }
    }
}

