/*
 * Decompiled with CFR 0.152.
 */
package softcore.table;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import softcore.table.Table;
import softcore.table.TableCellEditor;
import softcore.table.TableCellRenderer;
import softcore.table.TableColumn;
import softcore.util.Utilities;

public class TextAreaEditor
extends JScrollPane
implements TableCellRenderer,
TableCellEditor {
    final JTextArea textArea = new JTextArea();
    final JTextArea renderer = new JTextArea();
    boolean inEditing;
    static int[] keysUnTraversable = new int[]{37, 39, 10, 9, 38, 40, 39, 35, 36, 127};

    public TextAreaEditor() {
        this.setBorder(BorderFactory.createLineBorder(Color.blue));
        this.setViewportView(this.textArea);
    }

    public JComponent getTableCellRenderer(Table table, Object obj, TableColumn tablecolumn, boolean flag, boolean flag1) {
        if (table.getTableCellEditor() == this || this.inEditing) {
            return null;
        }
        this.renderer.setFont(table.getFont());
        if (obj instanceof InputStream) {
            try {
                InputStream inputstream = (InputStream)obj;
                obj = Utilities.getTextFromInputStream(inputstream);
                inputstream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.renderer.setText(obj != null ? obj.toString() : "");
        return this.renderer;
    }

    public JComponent startTableCellEditor(Table table, Object obj, TableColumn tablecolumn) {
        if (this.inEditing) {
            return this;
        }
        this.textArea.setFont(table.getFont());
        this.textArea.setText(obj != null ? obj.toString() : "");
        this.textArea.addFocusListener(table);
        this.textArea.addKeyListener(table);
        this.textArea.getDocument().addDocumentListener(table);
        this.inEditing = true;
        return this;
    }

    public JComponent getTableCellEditor() {
        return this.inEditing ? this : null;
    }

    public JComponent getFocusRequestComponent() {
        return this.textArea;
    }

    public void endTableCellEditor(Table table) {
        this.textArea.removeFocusListener(table);
        this.textArea.removeKeyListener(table);
        this.textArea.getDocument().removeDocumentListener(table);
        this.inEditing = false;
    }

    public Object getEditingValue() {
        return this.textArea.getText();
    }

    public void setEditingValue(Object obj, boolean flag) {
        if (flag) {
            this.textArea.replaceSelection(obj != null ? obj.toString() : null);
        } else {
            this.textArea.setText(obj != null ? obj.toString() : null);
            this.textArea.setCaretPosition(0);
        }
    }

    public boolean isModified(Object obj) {
        return !this.textArea.getText().equals(obj);
    }

    public boolean keyUnTraversable(int i, int j) {
        if (j >= 32 && j < 65535) {
            return true;
        }
        int k = 0;
        while (k < keysUnTraversable.length) {
            if (i == keysUnTraversable[k]) {
                return true;
            }
            ++k;
        }
        return false;
    }
}

