/*
 * Decompiled with CFR 0.152.
 */
package softcore.util;

import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.TableDataSet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import softcore.awt.DialogPanel;
import softcore.awt.JTextFieldA;
import softcore.table.DataWindow;
import softcore.table.GridTable;
import softcore.table.Table;
import softcore.util.AidInputer;
import softcore.util.JdbcUpdateRecord;
import softcore.util.Utilities;
import softoperation.finance.erpdata.Erpdata;

public class CalendarTable
extends GridTable
implements ItemListener,
AidInputer,
DocumentListener {
    final JTextFieldA yearTextField = new JTextFieldA("" + Utilities.yearRightNow, 6, 3, null);
    final JTextFieldA monthTextField = new JTextFieldA("" + Utilities.monthRightNow, 5, 3, null);
    int col0;
    Hashtable data = new Hashtable();
    int selectYear;
    int selectMonth;
    int selectDay;
    public boolean setHolidayAble = true;
    DialogPanel calendarDialog;

    public CalendarTable() throws DataSetException {
        this(0, 0, 0, 0, 0);
    }

    public CalendarTable(int i, int j, int k, int l, int i1) throws DataSetException {
        if (i == 0) {
            i = 1900;
        }
        if (j == 0) {
            j = DialogPanel.limitYear;
        }
        if (k <= 0) {
            k = Utilities.yearRightNow;
        }
        if (l <= 0) {
            l = Utilities.monthRightNow;
        }
        if (i1 <= 0) {
            i1 = Utilities.dayRightNow;
        }
        if (i > k) {
            i = k;
        }
        if (j < k) {
            j = k;
        }
        this.yearTextField.getDocument().addDocumentListener(this);
        this.yearTextField.setSpinRange(i, j);
        this.yearTextField.setEditable(false);
        this.monthTextField.getDocument().addDocumentListener(this);
        this.monthTextField.setSpinRange(1, 12);
        this.monthTextField.setEditable(false);
        TableDataSet tabledataset = new TableDataSet();
        String[] as = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
        int j1 = 0;
        while (j1 < as.length) {
            tabledataset.addColumn("COL" + j1, as[j1], 4);
            ++j1;
        }
        tabledataset.open();
        this.setDataSet((DataSet)tabledataset);
        this.initial();
        int k1 = 0;
        while (k1 < this.tableColumns.length) {
            this.tableColumns[k1].options |= 0x218;
            this.tableColumns[k1].options &= 0xFFFFFFFB;
            ++k1;
        }
        this.replaceTableContent();
        this.toDay(i1);
        this.rwFlags |= 0x3C;
        this.columnResizable = false;
    }

    protected boolean isCurrentColumnTexteditable() {
        return false;
    }

    protected void onSelectedCellChanged(int i, int j) {
        super.onSelectedCellChanged(i, j);
        if (this.colSelected >= 0 && this.colSelected <= 6) {
            int k = 0;
            try {
                k = this.dataSet.getInt(this.colSelected);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.selectDay = k <= 0 ? -k : k;
            this.tableColumns[this.colSelected].setOptions(256, k == 0);
            this.tableColumns[this.colSelected].mapKeys = k != 0 ? new Integer[]{new Integer(k <= 0 ? -k : k), new Integer(k <= 0 ? k : -k)} : null;
            if (this.calendarDialog != null && this.calendarDialog.okButton != null) {
                this.calendarDialog.okButton.setEnabled(k != 0);
            }
        }
    }

    private void toDay(int i) {
        int j = this.getRowSelected();
        int k = this.colSelected;
        if (i == 0) {
            try {
                this.dataSet.first();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.colSelected = 0;
        } else {
            try {
                this.dataSet.goToRow((i - 1 + this.col0) / 7);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.colSelected = (i - 1 + this.col0) % 7;
        }
        this.setFirstColSelected(this.colSelected);
        if (k != this.colSelected || j != this.getRowSelected()) {
            this.onSelectedCellChanged(j, k);
        }
    }

    public void keyPressed(KeyEvent keyevent) {
        if (keyevent.getKeyCode() == 33) {
            this.replaceTableContent(this.selectMonth != 1 ? this.selectYear : this.selectYear - 1, this.selectMonth != 1 ? this.selectMonth - 1 : 12);
            return;
        }
        if (keyevent.getKeyCode() == 34) {
            this.replaceTableContent(this.selectMonth != 12 ? this.selectYear : this.selectYear + 1, this.selectMonth != 12 ? this.selectMonth + 1 : 1);
            return;
        }
        if (keyevent.getKeyCode() == 10 && this.calendarDialog != null) {
            return;
        }
        super.keyPressed(keyevent);
    }

    public void mouseClicked(MouseEvent mouseevent) {
        if (mouseevent.getClickCount() == 2 && this.calendarDialog != null && this.calendarDialog.okButton.isEnabled()) {
            this.calendarDialog.okExit();
        }
    }

    public boolean startEdit(AWTEvent awtevent) {
        if (awtevent instanceof KeyEvent && ((KeyEvent)awtevent).getKeyChar() == ' ' && this.setHolidayAble) {
            int i = 0;
            try {
                i = this.dataSet.getInt(this.colSelected);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (i != 0) {
                try {
                    this.dataSet.setInt(this.colSelected, -i);
                    this.putHolidaysValue(this.selectYear, this.selectMonth, i <= 0 ? -i : i, i > 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    void replaceTableContent() {
        int i = Integer.parseInt(this.yearTextField.getText().trim());
        int j = Integer.parseInt(this.monthTextField.getText().trim());
        this.replaceTableContent(i, j);
    }

    protected int getHolidays(int i, int j) {
        int k;
        Integer integer = new Integer(i << 16 | j);
        int[] ai = (int[])this.data.get(integer);
        if (ai == null) {
            k = Erpdata.getHolidays(i, j);
            this.data.put(integer, new int[]{k, k});
        } else {
            k = ai[1];
        }
        return k;
    }

    private void putHolidaysValue(int i, int j, int k, boolean flag) {
        Integer integer = new Integer(i << 16 | j);
        int[] ai = (int[])this.data.get(integer);
        if (ai != null) {
            ai[1] = flag ? ai[1] | 1 << k - 1 : ai[1] & ~(1 << k - 1);
        } else {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void replaceTableContent(int i, int j) {
        if (i == this.selectYear && j == this.selectMonth) {
            return;
        }
        try {
            try {
                ++this.lockDataSetEvent;
                this.dataSet.deleteAllRows();
                this.selectYear = i;
                this.selectMonth = j;
                if (!("" + i).equals(this.yearTextField.getText())) {
                    this.yearTextField.setText("" + i);
                }
                if (!("" + j).equals(this.monthTextField.getText())) {
                    this.monthTextField.setText("" + j);
                }
                int k = this.getHolidays(i, j);
                GregorianCalendar gregoriancalendar = new GregorianCalendar(i, j - 1, 1);
                int l = 0;
                while (true) {
                    int i1;
                    if ((i1 = gregoriancalendar.get(7)) == 1 || l == 0) {
                        if (this.dataSet.isEditingNewRow()) {
                            try {
                                this.dataSet.post();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.dataSet.insertRow(false);
                    }
                    this.dataSet.setInt(i1 - 1, (k & 1 << l) == 0 ? l + 1 : -(l + 1));
                    if (l == 0) {
                        this.col0 = i1 - 1;
                    }
                    gregoriancalendar.add(6, 1);
                    if (gregoriancalendar.get(2) + 1 == j) {
                        if (this.dataSet.isEditingNewRow()) {
                            try {
                                this.dataSet.post();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++l;
                        continue;
                    }
                    break;
                }
            }
            catch (DataSetException dataSetException) {
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            --this.lockDataSetEvent;
            throw throwable;
        }
        {
            Object var8_14 = null;
            --this.lockDataSetEvent;
            this.toDay(this.selectDay);
        }
        this.refreshPaint();
        try {
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.requestDefaultFocus();
        this.requestFocus();
    }

    public void toDay(int i, int j, int k) {
        this.replaceTableContent(i, j);
        this.toDay(k);
    }

    protected void doSaveChanges() throws DataSetException {
        boolean flag = false;
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            int[] ai = (int[])enumeration.nextElement();
            if (ai[0] == ai[1]) continue;
            flag = true;
        }
        if (flag) {
            JdbcUpdateRecord jdbcupdaterecord = new JdbcUpdateRecord("monthlog");
            Enumeration enumeration1 = this.data.keys();
            while (enumeration1.hasMoreElements()) {
                Integer integer = (Integer)enumeration1.nextElement();
                int[] ai1 = (int[])this.data.get(integer);
                if (ai1[0] == ai1[1]) continue;
                int i = integer >> 16;
                int j = integer & 0xF;
                Hashtable<String, Number> hashtable = new Hashtable<String, Number>();
                hashtable.put("year", new Short((short)i));
                hashtable.put("month", new Short((short)j));
                hashtable.put("holidays", new Integer(ai1[1]));
                try {
                    jdbcupdaterecord.updateRecord(hashtable, true);
                }
                catch (SQLException sqlexception) {
                    sqlexception.printStackTrace();
                    throw new RuntimeException(sqlexception.getMessage());
                }
                ai1[0] = ai1[1];
            }
            jdbcupdaterecord.close();
        }
        super.doSaveChanges();
    }

    public void itemStateChanged(ItemEvent itemevent) {
        this.replaceTableContent();
    }

    public void insertUpdate(DocumentEvent documentevent) {
        this.replaceTableContent();
    }

    public void removeUpdate(DocumentEvent documentevent) {
    }

    public void changedUpdate(DocumentEvent documentevent) {
        this.replaceTableContent();
    }

    public static void defineHolidays() throws DataSetException {
        CalendarTable.calendarWindow("\u5de5\u4f5c\u65e5\u8bbe\u7f6e");
    }

    public static JPanel createCalendarPanel(JPanel jpanel, CalendarTable calendartable) {
        if (jpanel == null) {
            jpanel = new JPanel(new BorderLayout());
        } else {
            jpanel.setLayout(new BorderLayout());
        }
        calendartable.setBorder(BorderFactory.createLoweredBevelBorder());
        JComponent[] jComponentArray = new JComponent[6];
        jComponentArray[0] = calendartable.yearTextField;
        jComponentArray[1] = calendartable.monthTextField;
        JPanel jpanel1 = DialogPanel.createDatePanel(null, jComponentArray, 3, null, 2, 2, 2, 2, 2, 5);
        jpanel1.setBorder(BorderFactory.createLoweredBevelBorder());
        jpanel.add((Component)calendartable, "Center");
        jpanel.add((Component)jpanel1, "North");
        jpanel.doLayout();
        Dimension dimension = new Dimension();
        dimension.width = calendartable.leftFixedColWidth + (calendartable.tableColumns[0].width + 1) * 7 + 1;
        Rectangle rectangle = calendartable.getBounds();
        dimension.height = rectangle.y + (calendartable.rowHeight + 1) * 7 + 1;
        jpanel.setPreferredSize(dimension);
        return jpanel;
    }

    public static void calendarWindow(String s) throws DataSetException {
        CalendarTable calendartable = new CalendarTable();
        JPanel jpanel = CalendarTable.createCalendarPanel(null, calendartable);
        JInternalFrame jinternalframe = DataWindow.createSqlInternalFrame(null, s, null, jpanel, new Table[]{calendartable}, calendartable);
        jinternalframe.pack();
        calendartable.scrollTo(0, 0);
        jinternalframe.setResizable(false);
    }

    public AidInputer createCalendarDialog() {
        this.setHolidayAble = false;
        this.calendarDialog = new DialogPanel();
        CalendarTable.createCalendarPanel(this.calendarDialog, this);
        this.calendarDialog.createDialogParent(null, "\u65e5\u5386", null);
        return this;
    }

    public static AidInputer createAidInputer(int i, int j) {
        try {
            CalendarTable calendartable = new CalendarTable(i, j, 0, 0, 0);
            return calendartable.createCalendarDialog();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception.getMessage());
        }
    }

    public static AidInputer createAidInputer() {
        return CalendarTable.createAidInputer(0, 0);
    }

    public String doAidInput(Component component, String s, int i) {
        if (this.calendarDialog == null) {
            return null;
        }
        int[] ai = new int[6];
        if (s != null && Utilities.parseDate(s, ai)) {
            try {
                this.toDay(ai[0], ai[1], ai[2]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.scrollTo(0, 0);
        if (this.calendarDialog.doShowDialog(this) != 0 || this.selectYear * 16 + this.selectMonth > DialogPanel.limitYear * 16 + DialogPanel.limitMonth) {
            return null;
        }
        return String.valueOf(this.selectYear) + "-" + this.selectMonth + "-" + this.selectDay;
    }
}

